/*
 * Copyright 2020-2025 Yuntu Microelectronics Co., Ltd.
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 * 
 * @file IntTst_Cfg.h
 * @brief 
 * 
 */


#ifndef INTTST_CFG_H
#define INTTST_CFG_H

#ifdef __cplusplus
extern "C"{
#endif

/*==================================================================================================
*                                        INCLUDE FILES
==================================================================================================*/

/*==================================================================================================
*                              SOURCE FILE VERSION INFORMATION
==================================================================================================*/
#define INTTST_VENDOR_ID_CFG                      (180)
#define INTTST_AR_RELEASE_MAJOR_VERSION_CFG       (4)
#define INTTST_AR_RELEASE_MINOR_VERSION_CFG       (4)
#define INTTST_AR_RELEASE_REVISION_VERSION_CFG    (0)
#define INTTST_SW_MAJOR_VERSION_CFG               (2)
#define INTTST_SW_MINOR_VERSION_CFG               (0)
#define INTTST_SW_PATCH_VERSION_CFG               (0)

/*==================================================================================================
 *                          LOCAL TYPEDEFS (STRUCTURES, UNIONS, ENUMS)
==================================================================================================*/

/*==================================================================================================
*                                       DEFINITIONS AND MACROS
==================================================================================================*/

/* @brief Total number of INTM channels. */
#define FEATURE_INTTST_CHANNELS                    (4U)

/**
* @brief Define precompile support.
* @details Define precompile support if VARIANT-PRE-COMPILE or VARIANT-LINK-TIME is selected and number of variant <=1.
*/
#define INTTST_PRECOMPILE_SUPPORT                  (STD_ON)

/**
 * @brief        Switches the Production Error Detection and Notification ON.
 * @implements  INTTST_DEV_ERROR_DETECT_define, INTTST_VERSION_INFO_API_define 
 *
 */
#define INTTST_DEV_ERROR_DETECT                    (STD_ON)

#define INTTST_VERSION_INFO_API                    (STD_OFF)

/**
* @brief Support for SchM: sync/atomic operations, global interrupt disable/enable.
*        If this parameter has been configured to 'STD_ON', the MCAL driver code supports sync/atomic operations for key resource protection.
*        If it is enabled, all the SchM codes in MCAL IntTst driver codes will work and support sync/atomic operation with CPU global interrupt enable/disable for key resource protection. 
*        Disable it can reduce code size, but may cause potential risks when access to some critical resource!
*/
#define INTTST_SCHM_SUPPORT                        (STD_ON) 


#ifdef INTTST_ENABLE_USER_MODE_SUPPORT
#ifndef MCAL_ENABLE_USER_MODE_SUPPORT
#error "Must define MCAL_ENABLE_USER_MODE_SUPPORT if INTTST_ENABLE_USER_MODE_SUPPORT is defined"
#endif
#endif

#define INTTST_CHANNEL_INJECTION_TST_COUNT              (4U)

/* Logic Channel 0 */
#define IntTstConf_IntTstConfig_IntmChannel_ErrorCheckConfig_0             INTM_CHANNEL_0
/* Logic Channel 1 */
#define IntTstConf_IntTstConfig_IntmChannel_ErrorCheckConfig_1             INTM_CHANNEL_1
/* Logic Channel 2 */
#define IntTstConf_IntTstConfig_IntmChannel_ErrorCheckConfig_2             INTM_CHANNEL_2
/* Logic Channel 3 */
#define IntTstConf_IntTstConfig_IntmChannel_ErrorCheckConfig_3             INTM_CHANNEL_3


#ifdef __cplusplus
}
#endif

#endif /* INTTST_CFG_H */

