/*
 * Copyright 2020-2025 Yuntu Microelectronics Co., Ltd.
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 * 
 * @file IntTst_Cfg.c
 * @brief 
 * 
 */


#ifdef __cplusplus
extern "C"
{
#endif

#include "IntTst.h"

/*==================================================================================================
*                              SOURCE FILE VERSION INFORMATION
==================================================================================================*/
#define INTTST_VENDOR_ID_CFG_C                      (180)
#define INTTST_AR_RELEASE_MAJOR_VERSION_CFG_C       (4)
#define INTTST_AR_RELEASE_MINOR_VERSION_CFG_C       (4)
#define INTTST_AR_RELEASE_REVISION_VERSION_CFG_C    (0)
#define INTTST_SW_MAJOR_VERSION_CFG_C               (2)
#define INTTST_SW_MINOR_VERSION_CFG_C               (0)
#define INTTST_SW_PATCH_VERSION_CFG_C               (0)

/*==================================================================================================
                                            FILE VERSION CHECKS
==================================================================================================*/
/* Check if source file and IntTst header file are of the same vendor */
#if (INTTST_VENDOR_ID_CFG_C != INTTST_VENDOR_ID)
#error "IntTst_Cfg.c and IntTst.h have different vendor ids"
#endif

/* Check if source file and IntTst header file are of the same Autosar version */
#if (( INTTST_AR_RELEASE_MAJOR_VERSION_CFG_C != INTTST_AR_RELEASE_MAJOR_VERSION) || \
      ( INTTST_AR_RELEASE_MINOR_VERSION_CFG_C != INTTST_AR_RELEASE_MINOR_VERSION) || \
      ( INTTST_AR_RELEASE_REVISION_VERSION_CFG_C != INTTST_AR_RELEASE_REVISION_VERSION))
#error "AutoSar Version Numbers of IntTst_Cfg.c and IntTst.h are different"
#endif

/* Check if source file and IntTst header file are of the same Software version */
#if (( INTTST_SW_MAJOR_VERSION_CFG_C != INTTST_SW_MAJOR_VERSION) || \
      ( INTTST_SW_MINOR_VERSION_CFG_C != INTTST_SW_MINOR_VERSION) || \
      ( INTTST_SW_PATCH_VERSION_CFG_C != INTTST_SW_PATCH_VERSION))
#error "Software Version Numbers of IntTst_Cfg.c and IntTst.h are different"
#endif

/*==================================================================================================
 *                                          VARIATES
==================================================================================================*/
#define INTTST_START_SEC_CONFIG_DATA_UNSPECIFIED
#include "IntTst_MemMap.h"

/**< Declare the user notification function, it must be implemented by the user */
extern void SafLib_TestError_Notification(uint16 ModuleId);

INTTST_CONST const IntTst_Monitor_ConfigType IntTst_MonitorConfig[4U] = 
{
    {  
        .Channel    = INTM_CHANNEL_0,     /**< The channel 0 of the INTM for the test */
        .IrqNumber = pTMR_Ch0_IRQn,      /**< The IRQ interrupt number of the INTM channel 0 */
        /**<Channel_0 Error Inject configuration*/
        .InjectError = IRQ_LATENCY_ERROR,      /**<  Enable/Disable the IRQ interrupt latency error check */     
    },
    {  
        .Channel    = INTM_CHANNEL_1,     /**< The channel 1 of the INTM for the test */
        .IrqNumber = pTMR_Ch1_IRQn,      /**< The IRQ interrupt number of the INTM channel 1 */
        /**<Channel_1 Error Inject configuration*/
        .InjectError = IRQ_LATENCY_ERROR,      /**<  Enable/Disable the IRQ interrupt latency error check */     
    },
    {  
        .Channel    = INTM_CHANNEL_2,     /**< The channel 2 of the INTM for the test */
        .IrqNumber = pTMR_Ch2_IRQn,      /**< The IRQ interrupt number of the INTM channel 2 */
        /**<Channel_2 Error Inject configuration*/
        .InjectError = IRQ_LATENCY_ERROR,      /**<  Enable/Disable the IRQ interrupt latency error check */     
    },
    {  
        .Channel    = INTM_CHANNEL_3,     /**< The channel 3 of the INTM for the test */
        .IrqNumber = pTMR_Ch3_IRQn,      /**< The IRQ interrupt number of the INTM channel 3 */
        /**<Channel_3 Error Inject configuration*/
        .InjectError = IRQ_LATENCY_ERROR,      /**<  Enable/Disable the IRQ interrupt latency error check */     
    },
};

/* the IntTst config generation */
INTTST_CONST const IntTst_ConfigType IntTst_PreCompileConfig = 
{
    .MonitorCount = 4U, /**< The configured INTM channel monitor number for the test */
    .Monitor       = &IntTst_MonitorConfig[0],  /**< The detailed INTM channel monitor configuration */
    .Notification  = SafLib_TestError_Notification, /**< The user notification function */
};

#define INTTST_STOP_SEC_CONFIG_DATA_UNSPECIFIED
#include "IntTst_MemMap.h"

#ifdef __cplusplus
}
#endif

/* End of file IntTst_Cfg.c */
