/*
 * Copyright 2020-2025 Yuntu Microelectronics Co., Ltd.
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 * 
 * @file undefined
 * @brief 
 * 
 */


#ifdef __cplusplus
extern "C" {
#endif

/*==================================================================================================
 *                                        INCLUDE FILES
==================================================================================================*/
#include "FlsTst.h"

/*==================================================================================================
 *                              SOURCE FILE VERSION INFORMATION
==================================================================================================*/
#define FLSTST_VENDOR_ID_PBCFG_C                      (180)
#define FLSTST_AR_RELEASE_MAJOR_VERSION_PBCFG_C       (4)
#define FLSTST_AR_RELEASE_MINOR_VERSION_PBCFG_C       (4)
#define FLSTST_AR_RELEASE_REVISION_VERSION_PBCFG_C    (0)
#define FLSTST_SW_MAJOR_VERSION_PBCFG_C               (2)
#define FLSTST_SW_MINOR_VERSION_PBCFG_C               (0)
#define FLSTST_SW_PATCH_VERSION_PBCFG_C               (0)

/*==================================================================================================
 *                                      FILE VERSION CHECKS
==================================================================================================*/
/* Check if the file and FlsTst header file are of the same vendor */
#if (FLSTST_VENDOR_ID_PBCFG_C != FLSTST_VENDOR_ID)
#error "FlsTst_PBcfg.c and FlsTst.h have different vendor ids"
#endif

/* Check if the file and FlsTst header file are of the same Autosar version */
#if ((FLSTST_AR_RELEASE_MAJOR_VERSION_PBCFG_C != FLSTST_AR_RELEASE_MAJOR_VERSION) || \
     (FLSTST_AR_RELEASE_MINOR_VERSION_PBCFG_C != FLSTST_AR_RELEASE_MINOR_VERSION) || \
     (FLSTST_AR_RELEASE_REVISION_VERSION_PBCFG_C != FLSTST_AR_RELEASE_REVISION_VERSION))
#error "AutoSar Version Numbers of FlsTst_PBcfg.c and FlsTst.h are different"
#endif

/* Check if the file and FlsTst header file are of the same software version */
#if ((FLSTST_SW_MAJOR_VERSION_PBCFG_C != FLSTST_SW_MAJOR_VERSION) || \
     (FLSTST_SW_MINOR_VERSION_PBCFG_C != FLSTST_SW_MINOR_VERSION) || \
     (FLSTST_SW_PATCH_VERSION_PBCFG_C != FLSTST_SW_PATCH_VERSION))
#error "Software Version Numbers of FlsTst_PBcfg.c and FlsTst.h are different"
#endif

/*=================================================================================================*/
extern void FlsTst_Bgnd_CallBack(void); 
extern void SafLib_TestError_Notification(uint16 ModuleId); 
/*=================================================================================================*/
#define FLSTST_START_SEC_CONFIG_DATA_UNSPECIFIED
#include "FlsTst_MemMap.h"
FLSTST_CONST const FlsTst_BlockConfigType FlsTst_BGndBlocks[5] =
{
    {
        .TestBlockIndex            = 0U,
        .TestBlockBaseAddress      = 0x0U,
        .TestBlockSize             = 0x4000U,
        .NumberOfTestedCells   = FLSTST_NUMBER_OF_TESTED_CELLS,
        .SignatureAddress      = 0x100000U,
        .TestAlgorithm         = FLSTST_8BIT_CRC,
    },
    {
        .TestBlockIndex            = 1U,
        .TestBlockBaseAddress      = 0x0U,
        .TestBlockSize             = 0x4000U,
        .NumberOfTestedCells   = FLSTST_NUMBER_OF_TESTED_CELLS,
        .SignatureAddress      = 0x100004U,
        .TestAlgorithm         = FLSTST_16BIT_CRC,
    },
    {
        .TestBlockIndex            = 2U,
        .TestBlockBaseAddress      = 0x0U,
        .TestBlockSize             = 0x4000U,
        .NumberOfTestedCells   = FLSTST_NUMBER_OF_TESTED_CELLS,
        .SignatureAddress      = 0x100008U,
        .TestAlgorithm         = FLSTST_32BIT_CRC,
    },
    {
        .TestBlockIndex            = 3U,
        .TestBlockBaseAddress      = 0x0U,
        .TestBlockSize             = 0x200U,
        .NumberOfTestedCells   = FLSTST_NUMBER_OF_TESTED_CELLS,
        .SignatureAddress      = 0x10000cU,
        .TestAlgorithm         = FLSTST_16BIT_CRC,
    },
    {
        .TestBlockIndex            = 4U,
        .TestBlockBaseAddress      = 0x0U,
        .TestBlockSize             = 0x400U,
        .NumberOfTestedCells   = FLSTST_NUMBER_OF_TESTED_CELLS,
        .SignatureAddress      = 0x100010U,
        .TestAlgorithm         = FLSTST_16BIT_CRC,
    },
};

FLSTST_CONST const FlsTst_BlockConfigType FlsTst_FGndBlocks[3] =
{
    {
        .TestBlockIndex            = 0U,
        .TestBlockBaseAddress      = 0x0U,
        .TestBlockSize             = 0x4000U,
        .NumberOfTestedCells   = 0U,
        .SignatureAddress      = 0x100014U,
        .TestAlgorithm         = FLSTST_8BIT_CRC,
    },
    {
        .TestBlockIndex            = 1U,
        .TestBlockBaseAddress      = 0x0U,
        .TestBlockSize             = 0x4000U,
        .NumberOfTestedCells   = 0U,
        .SignatureAddress      = 0x100018U,
        .TestAlgorithm         = FLSTST_16BIT_CRC,
    },
    {
        .TestBlockIndex            = 2U,
        .TestBlockBaseAddress      = 0x0U,
        .TestBlockSize             = 0x4000U,
        .NumberOfTestedCells   = 0U,
        .SignatureAddress      = 0x10001cU,
        .TestAlgorithm         = FLSTST_32BIT_CRC,
    },
};

FLSTST_CONST const FlsTst_ConfigType FlsTst_Config = 
{
    .BgndBlkConfig  = FlsTst_BGndBlocks,
    .FgndBlkConfig  = FlsTst_FGndBlocks,
    .MaxBgndBlkNo    = 5U,
    .MaxFgndBlkNo    = 3U,  
    .BgndCompNotifyFuncPtr = FlsTst_Bgnd_CallBack,
    .TestFailedNotifyFuncPtr = SafLib_TestError_Notification,
};

#define FLSTST_STOP_SEC_CONFIG_DATA_UNSPECIFIED
#include "FlsTst_MemMap.h"

#ifdef __cplusplus
}
#endif

/** @} */

