/*
 * Copyright 2020-2025 Yuntu Microelectronics Co., Ltd.
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 * 
 * @file undefined
 * @brief 
 * 
 */


#ifdef __cplusplus
extern "C" {
#endif


#include "FlsTst_Cfg.h"

/*==================================================================================================
*                              SOURCE FILE VERSION INFORMATION
==================================================================================================*/
#define FLSTST_VENDOR_ID_CFG_C                      (180)
#define FLSTST_AR_RELEASE_MAJOR_VERSION_CFG_C       (4)
#define FLSTST_AR_RELEASE_MINOR_VERSION_CFG_C       (4)
#define FLSTST_AR_RELEASE_REVISION_VERSION_CFG_C    (0)
#define FLSTST_SW_MAJOR_VERSION_CFG_C               (2)
#define FLSTST_SW_MINOR_VERSION_CFG_C               (0)
#define FLSTST_SW_PATCH_VERSION_CFG_C               (0)

/*==================================================================================================
                                    FILE VERSION CHECKS
==================================================================================================*/
/* Check if the file and FlsTst_Cfg header file are of the same vendor */
#if (FLSTST_VENDOR_ID_CFG_C != FLSTST_VENDOR_ID_CFG)
#error "FlsTst_Cfg.c and FlsTst_Cfg.h have different vendor ids"
#endif

/* Check if the file and FlsTst_Cfg header file are of the same Autosar version */
#if ((FLSTST_AR_RELEASE_MAJOR_VERSION_CFG_C != FLSTST_AR_RELEASE_MAJOR_VERSION_CFG) || \
     (FLSTST_AR_RELEASE_MINOR_VERSION_CFG_C != FLSTST_AR_RELEASE_MINOR_VERSION_CFG) || \
     (FLSTST_AR_RELEASE_REVISION_VERSION_CFG_C != FLSTST_AR_RELEASE_REVISION_VERSION_CFG))
#error "AutoSar Version Numbers of FlsTst_Cfg.c and FlsTst_Cfg.h are different"
#endif

/* Check if the file and FlsTst_Cfg header file are of the same Software version */
#if ((FLSTST_SW_MAJOR_VERSION_CFG_C != FLSTST_SW_MAJOR_VERSION_CFG) || \
     (FLSTST_SW_MINOR_VERSION_CFG_C != FLSTST_SW_MINOR_VERSION_CFG) || \
     (FLSTST_SW_PATCH_VERSION_CFG_C != FLSTST_SW_PATCH_VERSION_CFG))
#error "Software Version Numbers of FlsTst_Cfg.c and FlsTst_Cfg.h are different"
#endif



/*==================================================================================================*/

#ifdef __cplusplus
}
#endif

