/*
 * Copyright 2020-2025 Yuntu Microelectronics Co., Ltd.
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 * 
 * @file EfmTst_Cfg.h
 * @brief 
 * 
 */


#ifndef EFMTST_CFG_H
#define EFMTST_CFG_H

#ifdef __cplusplus
extern "C" {
#endif

/*==================================================================================================
*                                        INCLUDE FILES
==================================================================================================*/

/*==================================================================================================
*                              SOURCE FILE VERSION INFORMATION
==================================================================================================*/
#define EFMTST_VENDOR_ID_CFG                       (180)
#define EFMTST_AR_RELEASE_MAJOR_VERSION_CFG        (4)
#define EFMTST_AR_RELEASE_MINOR_VERSION_CFG        (4)
#define EFMTST_AR_RELEASE_REVISION_VERSION_CFG     (0)
#define EFMTST_SW_MAJOR_VERSION_CFG                (2)
#define EFMTST_SW_MINOR_VERSION_CFG                (0)
#define EFMTST_SW_PATCH_VERSION_CFG                (0)

/*==================================================================================================
 *                          LOCAL TYPEDEFS  (STRUCTURES, UNIONS, ENUMS)
==================================================================================================*/

/*==================================================================================================
*                                       DEFINITIONS AND MACROS
==================================================================================================*/

/**
* @brief Define precompile support.
* @details Define precompile support if VARIANT-PRE-COMPILE or VARIANT-LINK-TIME is selected and number of variant <=1.
*/
#define EFMTST_PRECOMPILE_SUPPORT                  (STD_ON)

#define EFMTST_DEV_ERROR_DETECT                    (STD_ON)

#define EFMTST_VERSION_INFO_API                    (STD_OFF)

#define EFMTST_ENABLE_WRITE_ENABLE_TEST            (STD_OFF)

#define EFMTST_ENABLE_CMD_UNLOCK_TEST              (STD_ON)

/**
* @brief Support for SchM: sync/atomic operations, global interrupt disable/enable.
*        If this parameter has been configured to 'STD_ON', the MCAL driver code supports sync/atomic operations for key resource protection.
*        If it is enabled, all the SchM codes in MCAL EfmTst driver codes will work and support sync/atomic operation with CPU global interrupt enable/disable for key resource protection. 
*        Disable it can reduce code size, but may cause potential risks when access to some critical resource!
*/
#define EFMTST_SCHM_SUPPORT                        (STD_OFF) 

/**
 * @brief Enable/disable the test for none protected flash sector.
 * 
 */

 #define EFMTST_TEST_NONE_PROTECTED_SECTOR_TEST

#ifdef EFMTST_ENABLE_USER_MODE_SUPPORT
#ifndef MCAL_ENABLE_USER_MODE_SUPPORT
#error "Must define MCAL_ENABLE_USER_MODE_SUPPORT if EFMTST_ENABLE_USER_MODE_SUPPORT is defined"
#endif
#endif

#define EFMTST_TEST_SECTOR_MAX_LENGTH  (1024U)

/* Internal flash block number */
#define EFMTST_INTERNAL_BLOCK_NUM              (3U)

/**
 * @brief          Add/remove the EfmTst Error Notification
 */
#define EFMTST_ERROR_NOTIFICATION                 (STD_ON)

/**
 * @brief  Fls Write enable bit is avariable or not in CTRL
 * 
 */
#define EFMTST_WEBIT_AVAILABLE                     (STD_OFF)

#ifdef __cplusplus
}
#endif

#endif /* End of file EfmTst_Cfg.h*/
