/*
 * Copyright 2020-2025 Yuntu Microelectronics Co., Ltd.
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 * 
 * @file EccTst_Cfg.h
 * @brief 
 * 
 */


#ifndef ECCTST_CFG_H
#define ECCTST_CFG_H

#ifdef __cplusplus
extern "C" {
#endif

/*==================================================================================================
*                                        INCLUDE FILES
==================================================================================================*/
#include "Std_Types.h"

/*==================================================================================================
*                              SOURCE FILE VERSION INFORMATION
==================================================================================================*/
#define ECCTST_VENDOR_ID_CFG                      (180)
#define ECCTST_AR_RELEASE_MAJOR_VERSION_CFG       (4)
#define ECCTST_AR_RELEASE_MINOR_VERSION_CFG       (4)
#define ECCTST_AR_RELEASE_REVISION_VERSION_CFG    (0)
#define ECCTST_SW_MAJOR_VERSION_CFG               (2)
#define ECCTST_SW_MINOR_VERSION_CFG               (0)
#define ECCTST_SW_PATCH_VERSION_CFG               (0)

/*==================================================================================================
 *                          LOCAL TYPEDEFS (STRUCTURES, UNIONS, ENUMS)
==================================================================================================*/

/*==================================================================================================
*                                       DEFINITIONS AND MACROS
==================================================================================================*/

/**
* @brief Define precompile support.
* @details Define precompile support if VARIANT-PRE-COMPILE or VARIANT-LINK-TIME is selected and number of variant <=1.
*/
#define ECCTST_PRECOMPILE_SUPPORT                  (STD_ON)

#define ECCTST_DEV_ERROR_DETECT                    (STD_ON)

#define ECCTST_VERSION_INFO_API                    (STD_OFF)

/**
* @brief Support for SchM: sync/atomic operations, global interrupt disable/enable.
*        If this parameter has been configured to 'STD_ON', the MCAL driver code supports sync/atomic operations for key resource protection.
*        If it is enabled, all the SchM codes in MCAL EccTst driver codes will work and support sync/atomic operation with CPU global interrupt enable/disable for key resource protection. 
*        Disable it can reduce code size, but may cause potential risks when access to some critical resource!
*/
#define ECCTST_SCHM_SUPPORT                        (STD_OFF) 

/**
 * @brief Flash ECC test enable.
 *
 */
#define ECCTST_ENABLE_FLASH_ECC_TEST              (STD_ON)
/**
 * @brief CAN ECC test enable.
 *
 */
#define ECCTST_ENABLE_CAN_ECC_TEST               (STD_ON)
/**
 * @brief Ram ECC test enable.
 *
 */
#define ECCTST_ENABLE_RAM_ECC_TEST               (STD_ON)

/**
 * @brief Total sector number of Flash ECC test configuration .
*/
#define ECCTST_FLASH_ECC_MAX_BLOCK_NUM             (1U)

/**
 * @brief The channel number of can ecc test configuration.
 */
#define ECCTST_CAN_ECC_CHANNEL_NUM             (1U)
/**
 * @brief The can ecc error irq number list
 */
#define CAN_IRQ_NUM_LIST { CAN0_Error_IRQn, CAN1_Error_IRQn, CAN2_Error_IRQn, CAN3_Error_IRQn, CAN4_Error_IRQn, CAN5_Error_IRQn,  }

#define CAN_ENHANCED_RX_FIFO_TESTED             (STD_ON)

/**
 * @brief The region number of ram ecc test configuration.
*/
#define ECCTST_RAM_ECC_MAX_REGION_NUM             (2U)

/**
 * @brief The region name of ram ecc.
*/
typedef enum{
    EMU_SRAM0 = 0U,
    EMU_SRAM1 = 1U,
}RamEcc_RegionNameType;

/**
 * @brief The base address of all emu regions.
*/
#define ECCTST_EMU_SRAM0_BASE_ADDR       (0x1FFF0000U) 

#define ECCTST_EMU_SRAM1_BASE_ADDR       (0x20000000U) 



#ifdef ECCTST_ENABLE_USER_MODE_SUPPORT
#ifndef MCAL_ENABLE_USER_MODE_SUPPORT
#error "Must define MCAL_ENABLE_USER_MODE_SUPPORT if ECCTST_ENABLE_USER_MODE_SUPPORT is defined"
#endif
#endif

#ifdef __cplusplus
}
#endif

#endif

