/*
 * Copyright 2020-2025 Yuntu Microelectronics Co., Ltd.
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 * 
 * @file EccTst_Cfg.c
 * @brief 
 * 
 */


#ifdef __cplusplus
extern "C" {
#endif

#include "EccTst.h"

/*==================================================================================================
*                              SOURCE FILE VERSION INFORMATION
==================================================================================================*/
#define ECCTST_VENDOR_ID_CFG_C                      (180)
#define ECCTST_AR_RELEASE_MAJOR_VERSION_CFG_C       (4)
#define ECCTST_AR_RELEASE_MINOR_VERSION_CFG_C       (4)
#define ECCTST_AR_RELEASE_REVISION_VERSION_CFG_C    (0)
#define ECCTST_SW_MAJOR_VERSION_CFG_C               (2)
#define ECCTST_SW_MINOR_VERSION_CFG_C               (0)
#define ECCTST_SW_PATCH_VERSION_CFG_C               (0)
/*==================================================================================================*/
/*==================================================================================================
 *                                     FILE VERSION CHECKS
==================================================================================================*/
/* Check if source file and ECCTST header file are of the same vendor */
#if (ECCTST_VENDOR_ID_CFG_C != ECCTST_VENDOR_ID)
#error "EccTst_Cfg.c and EccTst.h have different vendor ids"
#endif

/* Check if source file and ECCTST header file are of the same Autosar version */
#if ((ECCTST_AR_RELEASE_MAJOR_VERSION_CFG_C != ECCTST_AR_RELEASE_MAJOR_VERSION) || \
     (ECCTST_AR_RELEASE_MINOR_VERSION_CFG_C != ECCTST_AR_RELEASE_MINOR_VERSION) || \
     (ECCTST_AR_RELEASE_REVISION_VERSION_CFG_C != ECCTST_AR_RELEASE_REVISION_VERSION) \
    )
#error "AutoSar Version Numbers of EccTst_Cfg.c and EccTst.h are different"
#endif

/* Check if source file and ECCTST header file are of the same Software version */
#if ((ECCTST_SW_MAJOR_VERSION_CFG_C != ECCTST_SW_MAJOR_VERSION) || \
     (ECCTST_SW_MINOR_VERSION_CFG_C != ECCTST_SW_MINOR_VERSION) || \
     (ECCTST_SW_PATCH_VERSION_CFG_C != ECCTST_SW_PATCH_VERSION) \
    )
#error "Software Version Numbers of EccTst_Cfg.c and EccTst.h are different"
#endif

/*==================================================================================================
 *                                          VARIATES
==================================================================================================*/
/**************************EccTst Test Failed Callback declaration********************************************/
extern void SafLib_TestError_Notification(uint16 ModuleId);
#define ECCTST_START_SEC_CONFIG_DATA_UNSPECIFIED
#include "EccTst_MemMap.h"

/******************************CanEccTst config struct*********************************************/
ECCTST_CONST const CanEcc_CanBlockType EccTst_CanBlockMessageBuffersConfig[1] =
{
    {
        .InjectionTestEnable            = TRUE,
        .TestInitialData                = 0x55U,
        .TestAddress                    = 0x80,
        .InjectAddress                  = 0x0,
        .InjectionCorrentaleData        = 0x1U,
        .InjectionNonCorrentaleData     = 0x00U,
        .InjectionChecksum              = 0x00U,
    },
};

ECCTST_CONST const CanEcc_CanBlockType EccTst_CanBlockRxIndividualMasksConfig[1] =
{
{
        .InjectionTestEnable            = FALSE,
        .TestInitialData                = 0x55U,
        .TestAddress                    = 0x880,
        .InjectAddress                  = 0x400,
        .InjectionCorrentaleData        = 0x1U,
        .InjectionNonCorrentaleData     = 0x00U,
        .InjectionChecksum              = 0x00U,
    },
};

ECCTST_CONST const CanEcc_CanBlockType EccTst_CanBlockRxFilterIdhitsConfig[1] =
{
{
        .InjectionTestEnable            = FALSE,
        .TestInitialData                = 0x55U,
        .TestAddress                    = 0xa80,
        .InjectAddress                  = 0x500,
        .InjectionCorrentaleData        = 0x1U,
        .InjectionNonCorrentaleData     = 0x00U,
        .InjectionChecksum              = 0x00U,
    },
};

ECCTST_CONST const CanEcc_CanBlockType EccTst_CanBlockRxFilterGlobalMasksConfig[1] =
{
{
        .InjectionTestEnable            = FALSE,
        .TestInitialData                = 0x55U,
        .TestAddress                    = 0xaa0,
        .InjectAddress                  = 0x520,
        .InjectionCorrentaleData        = 0x1U,
        .InjectionNonCorrentaleData     = 0x00U,
        .InjectionChecksum              = 0x00U,
    },
};

ECCTST_CONST const CanEcc_CanBlockType EccTst_CanBlockTxSmbConfig[1] =
{
{
        .InjectionTestEnable            = FALSE,
        .TestInitialData                = 0x55U,
        .TestAddress                    = 0xab0,
        .InjectAddress                  = 0x530,
        .InjectionCorrentaleData        = 0x1U,
        .InjectionNonCorrentaleData     = 0x00U,
        .InjectionChecksum              = 0x00U,
    },
};

ECCTST_CONST const CanEcc_CanBlockType EccTst_CanBlockRxSmbsConfig[1] =
{
{
        .InjectionTestEnable            = FALSE,
        .TestInitialData                = 0x55U,
        .TestAddress                    = 0xac0,
        .InjectAddress                  = 0x540,
        .InjectionCorrentaleData        = 0x1U,
        .InjectionNonCorrentaleData     = 0x00U,
        .InjectionChecksum              = 0x00U,
    },
};


ECCTST_CONST const CanEcc_CanBlockType EccTst_CanBlockRxSmbTimeStampsConfig[1] =
{
{
        .InjectionTestEnable            = FALSE,
        .TestInitialData                = 0x55U,
        .TestAddress                    = 0xc20,
        .InjectAddress                  = 0x608,
        .InjectionCorrentaleData        = 0x1U,
        .InjectionNonCorrentaleData     = 0x00U,
        .InjectionChecksum              = 0x00U,
    },
};

ECCTST_CONST const CanEcc_CanBlockType EccTst_CanBlockHrTimeStampConfig[1] =
{
    {
        .InjectionTestEnable            = FALSE,
        .TestInitialData                = 0x55U,
        .TestAddress                    = 0xc30,
        .InjectAddress                  = 0x610,
        .InjectionCorrentaleData        = 0x1U,
        .InjectionNonCorrentaleData     = 0x00U,
        .InjectionChecksum              = 0x00U,
    },
};

ECCTST_CONST const CanEcc_CanBlockType EccTst_CanBlockEnhancedRxFifoConfig[1] =
{
{
        .InjectionTestEnable            = FALSE,
        .TestInitialData                = 0x55U,
        .TestAddress                    = 0x2000,
        .InjectAddress                  = 0x710,
        .InjectionCorrentaleData        = 0x1U,
        .InjectionNonCorrentaleData     = 0x00U,
        .InjectionChecksum              = 0x00U,
    },
};

ECCTST_CONST const CanEcc_CanBlockType EccTst_CanBlockEnhancedRxFifoFiltersConfig[1] =
{
{
        .InjectionTestEnable            = FALSE,
        .TestInitialData                = 0x55U,
        .TestAddress                    = 0x3000,
        .InjectAddress                  = 0xd50,
        .InjectionCorrentaleData        = 0x1U,
        .InjectionNonCorrentaleData     = 0x00U,
        .InjectionChecksum              = 0x00U,
    },
};

ECCTST_CONST const CanEcc_CanInstType EccTst_CanInstConfig[1] =
{
{
        .EccTstCanHwId                             = 0U,
        .CanMbNumber                               = 64U,
        .CanFDEnable                               = FALSE,
        .CanEnhancedFifoEnable                     = FALSE,
        .CanHrTimeStampValid                       = TRUE,
        .EccTstCanBlockMessageBuffersPtr           = &EccTst_CanBlockMessageBuffersConfig[0],
        .EccTstCanBlockRxIndividualMasksPtr        = &EccTst_CanBlockRxIndividualMasksConfig[0],
        .EccTstCanBlockRxFilterIdhitsPtr           = &EccTst_CanBlockRxFilterIdhitsConfig[0],
        .EccTstCanBlockRxFilterGlobalMasksPtr      = &EccTst_CanBlockRxFilterGlobalMasksConfig[0],
        .EccTstCanBlockTxSmbPtr                    = &EccTst_CanBlockTxSmbConfig[0],
        .EccTstCanBlockRxSmbsPtr                   = &EccTst_CanBlockRxSmbsConfig[0],
        .EccTstCanBlockRxSmbTimeStampsPtr          = &EccTst_CanBlockRxSmbTimeStampsConfig[0],
        .EccTstCanBlockHrTimeStampPtr              = &EccTst_CanBlockHrTimeStampConfig[0],
        .EccTstCanBlockEnhancedRxFifoPtr           = &EccTst_CanBlockEnhancedRxFifoConfig[0],
        .EccTstCanBlockEnhancedRxFifoFiltersPtr    = &EccTst_CanBlockEnhancedRxFifoFiltersConfig[0],
    },
};

ECCTST_CONST const CanEcc_ConfigType EccTst_CanTestConfig =
{
    .EccTstCanInstNum    = 1U,
    .CanEccTestFailedNotification    = SafLib_TestError_Notification,
    .EccTstCanInstPtr    = EccTst_CanInstConfig,
};

#define ECCTST_FLS_BLOCK0_TWOBIT_TEST_ADDR  0x104408U

ECCTST_CONST static const FlsEcc_BlockConfigType FlsEcc_TestBlock[1] =
{
    {
        .BlockIndex = 0U,
        .OneBitTestEn = FALSE,
        .OneBitTestAddr = 0x00000000U,
        .TwoBitTestEn = TRUE,
        .TwoBitTestAddr =  ECCTST_FLS_BLOCK0_TWOBIT_TEST_ADDR,
        .TestDataSize = 8U,
    },
};

ECCTST_CONST static const FlsEcc_ConfigType FlsEcc_TestConfig =
{
    .FlsEccTestFailedNotification = SafLib_TestError_Notification,
    .TestBlockNum = 1,
    .TestBlockPtr = FlsEcc_TestBlock,
};

/******************************************************RamEccTst config struct******************************************************************/
ECCTST_CONST static const RamEcc_ChannelConfigType RamErrorInjectionChannelBuffer[2]=
{
    {
        .RamErrorInjectionChannelId = EMU_SRAM0,
        .RamErrorInjectionAddr = 0x1fff0000U,
        .RamErrInjectionDataBit0L =  0x1U,
        .RamErrInjectionDataBit1L = 0x2U,
        .RamErrInjectionChkBit = 0x1U,
    },
    {
        .RamErrorInjectionChannelId = EMU_SRAM1,
        .RamErrorInjectionAddr = 0x20000000U,
        .RamErrInjectionDataBit0L =  0x1U,
        .RamErrInjectionDataBit1L = 0x4U,
        .RamErrInjectionChkBit = 0x1U,
    },
};

ECCTST_CONST static const RamEcc_ConfigType RamEcc_TestConfig =
{
    .RamErrorInjectionChannelCount = 2,
    .RamEccTestFailedNotification = SafLib_TestError_Notification,
    .RamErrorInjectionChannel = RamErrorInjectionChannelBuffer,
};
/******************************************************************************************************************************************/
ECCTST_CONST const EccTst_ConfigType EccTst_PreCompileConfig =
{
    .FlsEccConfig = &FlsEcc_TestConfig,
    .RamEccConfig = &RamEcc_TestConfig,
    .CanEccConfig = &EccTst_CanTestConfig,
};

#define ECCTST_STOP_SEC_CONFIG_DATA_UNSPECIFIED
#include "EccTst_MemMap.h"

#ifdef __cplusplus
}
#endif

