/*
 * Copyright 2020-2025 Yuntu Microelectronics Co., Ltd.
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 * 
 * @file DmaTst_Cfg.h
 * @brief 
 * 
 */


#ifndef DMATST_CFG_H
#define DMATST_CFG_H

#ifdef __cplusplus
extern "C"{
#endif

/*==================================================================================================
*                                        INCLUDE FILES
==================================================================================================*/
#include "Std_Types.h"

/*==================================================================================================
*                              SOURCE FILE VERSION INFORMATION
==================================================================================================*/
#define DMATST_VENDOR_ID_CFG                      (180)
#define DMATST_AR_RELEASE_MAJOR_VERSION_CFG       (4)
#define DMATST_AR_RELEASE_MINOR_VERSION_CFG       (4)
#define DMATST_AR_RELEASE_REVISION_VERSION_CFG    (0)
#define DMATST_SW_MAJOR_VERSION_CFG               (2)
#define DMATST_SW_MINOR_VERSION_CFG               (0)
#define DMATST_SW_PATCH_VERSION_CFG               (0)

/*==================================================================================================
 *                          LOCAL TYPEDEFS (STRUCTURES, UNIONS, ENUMS)
==================================================================================================*/
/*==================================================================================================
*                                       DEFINITIONS AND MACROS
==================================================================================================*/
/**
* @brief Define precompile support.
* @details Define precompile support if VARIANT-PRE-COMPILE or VARIANT-LINK-TIME is selected and number of variant <=1.
*/
#define DMATST_PRECOMPILE_SUPPORT                  (STD_ON)


/**
 * @brief    Switches the Production Error Detection and Notification ON.
 */
#define DMATST_ENABLE_DEM_REPORT_ERROR_STATUS      (STD_OFF)
/**
 * @brief   Switch to enable the development error detection.
 */
#define DMATST_DEV_ERROR_DETECT                    (STD_ON)
/**
 * @brief   Adds / removes the service DmaTst_GetVersionInfo() from the code.
 */
#define DMATST_VERSION_INFO_API                    (STD_OFF)
/**
 * @brief   Enable DmaTst in Runtime, Call the function DmaTst_MainFunction for start test.
 */
#define DMATST_ENABLE_RUNTIMETEST                  (STD_ON)
/**
* @brief Support for SchM: sync/atomic operations, global interrupt disable/enable.
*        If this parameter has been configured to 'STD_ON', the MCAL driver code supports sync/atomic operations for key resource protection.
*        If it is enabled, all the SchM codes in MCAL DmaTst driver codes will work and support sync/atomic operation with CPU global interrupt
*        enable/disable for key resource protection. 
*        Disable it can reduce code size, but may cause potential risks when access to some critical resource!
*/
#define DMATST_SCHM_SUPPORT                        (STD_ON) 


#ifdef DMATST_ENABLE_USER_MODE_SUPPORT
#ifndef MCAL_ENABLE_USER_MODE_SUPPORT
#error "Must define MCAL_ENABLE_USER_MODE_SUPPORT if DMATST_ENABLE_USER_MODE_SUPPORT is defined"
#endif
#endif

/** @brief DMA channel configured number */
#define DMATST_CHANNEL_ERROR_TST_COUNT              (1U)
/** @brief DMA channel HW number */
#define DMATST_CHANNEL_HW_COUNT                     (16U) 
/** @brief DMA channel error check timeout */   
#define DMATST_ERROR_CHECK_TIMEOUT                  (500U)

#endif
#ifdef __cplusplus
}
#endif
