/*
 * Copyright 2020-2025 Yuntu Microelectronics Co., Ltd.
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 * 
 * @file CrcTst_Cfg.c
 * @brief 
 * 
 */


#ifdef __cplusplus
extern "C" {
#endif

#include "CrcTst.h"

/*==================================================================================================
*                              SOURCE FILE VERSION INFORMATION
==================================================================================================*/
#define CRCTST_VENDOR_ID_CFG_C                      (180)
#define CRCTST_AR_RELEASE_MAJOR_VERSION_CFG_C       (4)
#define CRCTST_AR_RELEASE_MINOR_VERSION_CFG_C       (4)
#define CRCTST_AR_RELEASE_REVISION_VERSION_CFG_C    (0)
#define CRCTST_SW_MAJOR_VERSION_CFG_C               (2)
#define CRCTST_SW_MINOR_VERSION_CFG_C               (0)
#define CRCTST_SW_PATCH_VERSION_CFG_C               (0)

/*==================================================================================================
                                            FILE VERSION CHECKS
==================================================================================================*/
/* Check if source file and CRCTST Configure header file are of the same vendor */
#if (CRCTST_VENDOR_ID_CFG_C != CRCTST_VENDOR_ID_CFG)
#error "CrcTst_Cfg.c and CrcTst_Cfg.h have different vendor ids"
#endif

/* Check if source file and CRCTST Configure header file are of the same Autosar version */
#if (( CRCTST_AR_RELEASE_MAJOR_VERSION_CFG_C != CRCTST_AR_RELEASE_MAJOR_VERSION_CFG) || \
     ( CRCTST_AR_RELEASE_MINOR_VERSION_CFG_C != CRCTST_AR_RELEASE_MINOR_VERSION_CFG) || \
     ( CRCTST_AR_RELEASE_REVISION_VERSION_CFG_C != CRCTST_AR_RELEASE_REVISION_VERSION_CFG))
#error "AutoSar Version Numbers of CrcTst_Cfg.c and CrcTst_Cfg.h are different"
#endif

/* Check if source file and CRCTST Configure header file are of the same Software version */
#if (( CRCTST_SW_MAJOR_VERSION_CFG_C != CRCTST_SW_MAJOR_VERSION_CFG) || \
     ( CRCTST_SW_MINOR_VERSION_CFG_C != CRCTST_SW_MINOR_VERSION_CFG) || \
     ( CRCTST_SW_PATCH_VERSION_CFG_C != CRCTST_SW_PATCH_VERSION_CFG))
#error "Software Version Numbers of CrcTst_Cfg.c and CrcTst_Cfg.h are different"
#endif





/*==================================================================================================
 *                                      GLOBAL CONSTANTS
==================================================================================================*/

#define CRCTST_START_SEC_VAR_CLEARED_32
#include "CrcTst_MemMap.h"
CRCTST_VAR static uint32 CrcTst_BgndRegisterSignature[2];
#define CRCTST_STOP_SEC_VAR_CLEARED_32
#include "CrcTst_MemMap.h"



#define CRCTST_START_SEC_CONFIG_DATA_UNSPECIFIED
#include "CrcTst_MemMap.h"
/* define atomic test runing under back-ground mode*/
CRCTST_CONST static const CrcTst_AtomicConfigType CrcTst_AtomicBackGroundConfig[2] =
{
    {
        (const uint8 *)0x4007c018,/**< Pointer to the data using signature verification */
        (const uint32 *)&CrcTst_BgndRegisterSignature[0]/**< Pointer to the signature */
        
    },
    {
        (const uint8 *)0x4007c01c,/**< Pointer to the data using signature verification */
        (const uint32 *)&CrcTst_BgndRegisterSignature[1]/**< Pointer to the signature */
        
    },
};
#define CRCTST_STOP_SEC_CONFIG_DATA_UNSPECIFIED
#include "CrcTst_MemMap.h"

#define CRCTST_START_SEC_CONFIG_DATA_UNSPECIFIED
#include "CrcTst_MemMap.h"
CRCTST_CONST const CrcTst_ConfigType CrcTst_PreCompileConfig = 
{
#if (CRCTST_CRC_FUNCTION_TEST_ENABLE == STD_ON)
  .FgndErrNotification = SafLib_TestError_Notification,
#endif
#if (CRCTST_REGISTER_INTEGRITY_TEST_ENABLE == STD_ON)
  .BgndConfigNum = 2U, /**< Number of background test configurations. */
  .BgndConfig = CrcTst_AtomicBackGroundConfig, /**< Pointer to the background test configuration.*/
  .BgndRegisterSignatureCaculate = CrcTst_BgndRegisterSignature, /**< Pointer to the register integrity signature when need to caculate in background*/
  .BgndCompleteCallBack = TestCRC_Complete/**< Pointer to the Crc Test completion callback function */
#endif
};
#define CRCTST_STOP_SEC_CONFIG_DATA_UNSPECIFIED
#include "CrcTst_MemMap.h"

#ifdef __cplusplus
}
#endif

