/**
 * @file    CorTst_M33_Cfg.h
 * @version V2.0.0
 *
 * @brief   AUTOSAR CorTst module M33 configuration
 * @details API implementation for CORTST M33 configuration
 *
 * @addtogroup CORTST_MODULE
 * @{
 */
/*==================================================================================================
 *   Project              : YTMicro AUTOSAR 4.4.0 MCAL
 *   Platform             : ARM
 *   Peripheral           : CorTst
 *   Dependencies         : none
 *
 *   Autosar Version      : V4.4.0
 *   Autosar Revision     : ASR_REL_4_4_REV_0000
 *   Autosar Conf.Variant :
 *   SW Version           : V2.0.0
 *
 *   (c) Copyright 2020-2025 Yuntu Microelectronics co.,ltd.
 *   All Rights Reserved.
==================================================================================================*/

#ifndef CORTST_M33_CFG_H
#define CORTST_M33_CFG_H

#ifdef __cplusplus
extern "C" {
#endif

/*==================================================================================================
 *                               SOURCE FILE VERSION INFORMATION
==================================================================================================*/
#define CORTST_M33_VENDOR_ID_CFG                      (180)
#define CORTST_M33_AR_RELEASE_MAJOR_VERSION_CFG       (4)
#define CORTST_M33_AR_RELEASE_MINOR_VERSION_CFG       (4)
#define CORTST_M33_AR_RELEASE_REVISION_VERSION_CFG    (0)
#define CORTST_M33_SW_MAJOR_VERSION_CFG               (2)
#define CORTST_M33_SW_MINOR_VERSION_CFG               (0)
#define CORTST_M33_SW_PATCH_VERSION_CFG               (0)

/*==================================================================================================
 *                                       DEFINES AND MACROS
==================================================================================================*/
#define M33_CST_THREAD  0U
#define M33_CST_HANDLER 1U

/*****************************************************************************
*  Definitions modifiable by a user
*****************************************************************************/
/* Define Cortex-M33 processor operating mode in which M33 CST Library
   will be executed, where:
    M33_CST_THREAD  - Execute M33 CST Library tests from the Thread mode.
    M33_CST_HANDLER - Execute M33 CST Library tests from the Handler mode.
*/
#define M33_CST_EXECUTION_MODE          M33_CST_THREAD

/* Define whether SysTick timer is running or not, where:
   1U - SysTick timer is used by user application or operating system
   0U - SysTick timer is not running
*/
#define M33_CST_SYSTICK_IS_RUNNING      0U

/* When M33_CST_EXECUTION_MODE == M33_CST_HANDLER, define exceptions whose
   priorities are below priority of Handler which is used for M33 CST Library
   execution, where:
   1U - Exception priority is below handler used for CST Library execution
   0U - Exception priority isn't below handler used for CST Library execution

   When configured to (1U) the CST Library will not generate this exception in
   the Handler mode. Note, that these defines have no effect when
   M33_CST_EXECUTION_MODE == M33_CST_THREAD
*/
#define M33_CST_SVC_EXCEPTION_LOW       0U
#define M33_CST_PENDSV_EXCEPTION_LOW    0U
#define M33_CST_SYSTICK_EXCEPTION_LOW   0U

/*****************************************************************************
* Do not modify definitions below !!!
*****************************************************************************/
/* Nested Vector Interrupt (NVIC) registers */
#define M33_ICTR_REG        0xE000E004

/* System Control Block (SCB) registers  */
#define M33_ICSR_REG        0xE000ED04
#define M33_VTOR_REG        0xE000ED08
#define M33_CCR_REG         0xE000ED14
#define M33_SHPR1_REG       0xE000ED18
#define M33_SHPR2_REG       0xE000ED1C
#define M33_SHPR3_REG       0xE000ED20
#define M33_SHCSR_REG       0xE000ED24
#define M33_CFSR_REG        0xE000ED28
#define M33_MMFSR_REG       0xE000ED28
#define M33_BFSR_REG        0xE000ED29
#define M33_UFSR_REG        0xE000ED2A
#define M33_HFSR_REG        0xE000ED2C
#define M33_BFAR_REG        0xE000ED38
#define M33_NVIC_ISER_REG   0xE000E100
#define M33_NVIC_ICER_REG   0xE000E180
#define M33_SYST_CSR        0xE000E010
#define M33_SYST_RVR        0xE000E014
#define M33_SYST_CVR        0xE000E018
#define M33_FPCCR_REG       0xE000EF34
#define M33_FPCAR_REG       0xE000EF38
#define M33_FPDSCR          0xE000EF3C
#define M33_DCCMVAU         0xE000EF64
#define M33_ICIMVAU         0xE000EF58

#define M33_CST_DISABLE_EXTERNAL_INTERRUPTS 1U

#define M33_DEVICE_RESERVED_ADDR    0x40300000

/*==================================================================================================
 *                                        CorTst Enabled Tests
==================================================================================================*/
/* Defines whether CorTstAlu tests are compiled or not */
#define CORTST_M33_ALU_ENABLE       1U
/* Defines whether CorTstBranch tests are compiled or not */
#define CORTST_M33_BRANCH_ENABLE    1U
/* Defines whether CorTstDivider tests are compiled or not */
#define CORTST_M33_DIVIDER_ENABLE   1U
/* Defines whether CorTstFetch tests are compiled or not */
#define CORTST_M33_FETCH_ENABLE     1U
/* Defines whether CorTstForward tests are compiled or not */
#define CORTST_M33_FORWARD_ENABLE   1U
/* Defines whether CorTstFpu tests are compiled or not */
#define CORTST_M33_FPU_ENABLE       1U
/* Defines whether CorTstInterrupt tests are compiled or not */
#define CORTST_M33_INTERRUPT_ENABLE 1U
/* Defines whether CorTstLoadstore tests are compiled or not */
#define CORTST_M33_LOADSTORE_ENABLE 1U
/* Defines whether CorTstMPUTest tests are compiled or not */
#define CORTST_M33_MPU_ENABLE       0U
/* Defines whether CorTstMac tests are compiled or not */
#define CORTST_M33_MAC_ENABLE       1U
/* Defines whether CorTstRegister tests are compiled or not */
#define CORTST_M33_REGISTER_ENABLE  1U
/* Defines whether CorTstSimdsat tests are compiled or not */
#define CORTST_M33_SIMDSAT_ENABLE   1U
/* Defines whether CorTstStatus tests are compiled or not */
#define CORTST_M33_STATUS_ENABLE    1U

/* Number of tests to be executed */
#define CORTST_ATOMIC_TEST_NUM  49U

#ifdef __cplusplus
}
#endif

#endif /* CORTST_M33_CFG_H */

/** @} */

