/*
 * Copyright 2020-2025 Yuntu Microelectronics Co., Ltd.
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 * 
 * @file ClkTst_Cfg.h
 * @brief 
 * 
 */


#ifndef CLKTST_CFG_H
#define CLKTST_CFG_H

#ifdef __cplusplus
extern "C" {
#endif
/*==================================================================================================
*                                        INCLUDE FILES
==================================================================================================*/
/*==================================================================================================
*                              SOURCE FILE VERSION INFORMATION
==================================================================================================*/
#define CLKTST_VENDOR_ID_CFG                      (180)
#define CLKTST_AR_RELEASE_MAJOR_VERSION_CFG       (4)
#define CLKTST_AR_RELEASE_MINOR_VERSION_CFG       (4)
#define CLKTST_AR_RELEASE_REVISION_VERSION_CFG    (0)
#define CLKTST_SW_MAJOR_VERSION_CFG               (2)
#define CLKTST_SW_MINOR_VERSION_CFG               (0)
#define CLKTST_SW_PATCH_VERSION_CFG               (0)

/*==================================================================================================
 *                          LOCAL TYPEDEFS (STRUCTURES, UNIONS, ENUMS)
==================================================================================================*/

/*==================================================================================================
*                                       DEFINITIONS AND MACROS
==================================================================================================*/

/**
* @brief Define precompile support.
* @details Define precompile support if VARIANT-PRE-COMPILE or VARIANT-LINK-TIME is selected and number of variant <=1.
*/
#define CLKTST_PRECOMPILE_SUPPORT                  (STD_ON)

/**
 * @brief        Switches the Production Error Detection and Notification ON.
 * @implements   SPI_DEM_REPORT_ERROR_STATUS_define
 *
 * @ref          ECUC_Spi_00241
 */
#define CLKTST_DEV_ERROR_DETECT                    (STD_ON)
#define CLKTST_VERSION_INFO_API                    (STD_OFF)

/**
 * @brief The number of CMU channels contained in the ClkTst module, which is 0x04U in MD & ME chips.
 */
#define CLKTST_CMU_CHANNEL_NUMS                    (4U)
#define CLKTST_SCU_SUPPORT_PLL                     (STD_ON)

#define SLOWBUS_FREQUENCY                         (96000000U/4U)
#define FIRC_FREQUENCY                            96000000U
#define FXOSC_FREQUENCY                           24000000U
#define SIRC_FREQUENCY                            12000000U
#define PLL_FREQUENCY                             (FXOSC_FREQUENCY*5U)


/**
 * @brief        Pre-compile enable CLKTST_ENABLE_USER_MODE_SUPPORT
 */



#ifdef CLKTST_ENABLE_USER_MODE_SUPPORT
#ifndef MCAL_ENABLE_USER_MODE_SUPPORT
#error "Must define MCAL_ENABLE_USER_MODE_SUPPORT if CLKTST_ENABLE_USER_MODE_SUPPORT is defined"
#endif
#endif

#ifdef __cplusplus
}
#endif
#endif
