/* USER CODE BEGIN Header */
/* you can remove the copyright */
/*
 * Copyright 2020-2025 Yuntu Microelectronics Co., Ltd.
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 *
 * @file main.c
 * @brief
 *
*/

/* USER CODE END Header */
#include "Mcal.h"
/* Includes ------------------------------------------------------------------*/

/* Private includes ----------------------------------------------------------*/
/* USER CODE BEGIN Includes */

#include "StartupTest.h"
#include "RuntimeTest.h"

/* USER CODE END Includes */

/* Private typedef -----------------------------------------------------------*/
/* USER CODE BEGIN PTD */
/* USER CODE END PTD */

/* Private define ------------------------------------------------------------*/
/* USER CODE BEGIN PD */

#define UART_DEBUG_EN

#ifdef UART_DEBUG_EN
#include "printf.h"
#endif

/* USER CODE END PD */

/* Private macro -------------------------------------------------------------*/
/* USER CODE BEGIN PM */

#define WDG_180_INST0_TRIGGER_PERIOD    40U   /* ms */

/* USER CODE END PM */

/* Private variables ---------------------------------------------------------*/
/* USER CODE BEGIN PV */

uint32 FlsTst_FgndErrCnt = 0;
uint32 FlsTst_BgndErrCnt = 0;
uint32 FlsTst_BgndCount = 0;
boolean FlsTst_BgndTaskFlag = FALSE;
uint32 FlsTst_TimerCnt = 0;

boolean FlsTst_DemoAbortEn = FALSE;
boolean FlsTst_DemoSuspendEn = FALSE;
boolean FlsTst_DemoResumeEn = FALSE;
FlsTst_ErrorDetailsType FlsTst_DemoErrorDetails;

/* Flag to indicate if the background RAM test is completed */
volatile boolean RamTstBackGroundCompleted = FALSE;

/* Flag to indicate if the runtime test error occur */
volatile boolean RuntimeTest_ErrorFlag = FALSE;

/* MouduleId for Test Failed */
uint16 ErrorMouduleId = 0U;
/* USER CODE END PV */

/* Private function declare --------------------------------------------------*/
/* USER CODE BEGIN PFDC */

static void Delay_10ms(uint32 DelayCnt);

/* USER CODE END PFDC */
static void Board_Init(void);

/* Private user code ---------------------------------------------------------*/
/* USER CODE BEGIN 0 */

void SafLib_TestError_Notification(uint16 ModuleId)
{
    RuntimeTest_ErrorFlag = TRUE; /* Set the error flag to indicate a test error */
    ErrorMouduleId = ModuleId; /* Store the module ID that caused the error */
#ifdef UART_DEBUG_EN
    if (ModuleId != CLKTST_MODULE_ID)
    {
        PRINTF("SafLib Test Error Notification Entered: ModuleId = %d\r\n", ModuleId);
    }
#endif
    /* stop here for debug purpose */
    // while(1);
    /*TODO: remove the above while(1) and add failure handling code here, such as:
    * 1. enter Safe State of the system, for example: SW reset
    * 2. add SafLib test failure record, such as add UDS DTC
    */
}
/**
 * @brief  Callback function for the Fls test completion.
 *         This function is called when the Fls test is completed.
 *         It can be used to set a flag to indicate that the Fls test is completed.
 */
void FlsTst_ComplteNotification(void)
{
}
/**
 * @brief  Callback function for the CorTst test completion.
 *         This function is called when the CorTst test is completed.
 *         It can be used to handle the result of the CorTst run.
 * @param  ResultOfLastCorTstRun: The result of the last CorTst run, indicating whether it was successful or not.
 */
void CorTst_TestCompletedNotification(CorTst_ErrOkType ResultOfLastCorTstRun)
{
}

/**
 * @brief  Callback function for the background test.
 *         This function is called periodically to check the background test results.
 *         It increments the background test count and checks if the test result is not OK.
 *         If the test result is not OK, it increments the error count and retrieves error details.
 */
void FlsTst_Bgnd_CallBack(void)
{
    FlsTst_TestResultBgndType TempResultBgnd;
    FlsTst_TestSignatureBgndType TempSignatureBgnd;
    /* USER CODE BEGIN Bgnd_CallBack */
    FlsTst_BgndCount++;
    TempResultBgnd = FlsTst_GetTestResultBgnd();
    TempSignatureBgnd =  FlsTst_GetTestSignatureBgnd();
    if ((TempResultBgnd.BgndTestResult == FLSTST_RESULT_NOT_OK) || \
            (TempResultBgnd.BgndTestIntervalId != TempSignatureBgnd.BgndTestIntervalId))
    {
        FlsTst_BgndErrCnt++;
        FlsTst_DemoErrorDetails = FlsTst_GetErrorDetails();
    }
}

/**
 * @brief  Callback function for the RAM test completion.
 *         This function is called when the RAM test is completed.
 *         It sets a flag to indicate that the background RAM test is completed.
 * @param  ModuleId: The ID of the module that completed the RAM test.
 */
void RamTst_CompletedCallback(uint16 ModuleId)
{
    (void)ModuleId; /* Suppress unused parameter warning */
    RamTstBackGroundCompleted = TRUE;
}

/**
 * @brief  Notification function for GPT channel 0.
 *         This function is called when the GPT channel 0 timer expires.
 *         It toggles an LED to indicate that the timer has expired.
 */
void Gpt_Notification_Ptmr_CH0(void)
{
    /* toggle LED for the MCAL Gpt driver test */
    Dio_FlipChannel(DioConf_DioChannel_PTB4);
}

/* USER CODE END 0 */


/**
 * @brief  The application entry point.
 * @retval int
 */
int main(void)
{
    /* USER CODE BEGIN 1 */
    uint32 runtime_test_ctrl_cnt = 0U;
    ClkTst_StartupTest();
    Mcu_Init(&Mcu_Config);
    Mcu_InitClock(0U);
#if (MCU_NO_PLL == STD_OFF)
    while (MCU_PLL_LOCKED != Mcu_GetPllStatus())
    {
        /* Busy wait until the system PLL is locked. */
    }
    Mcu_DistributePllClock();
#endif
    /* the startup tests are executed only once after POR */
    if (MCU_POWER_ON_RESET == Mcu_GetResetReason())
    {
#ifdef UART_DEBUG_EN
        Port_Init(&Port_Config); /* initialize the pinmux for UART */
        CddUart_Init(&CddUart_Config); /*  Initialize the UART */
        if (ErrorMouduleId == CLKTST_MODULE_ID)
        {
            PRINTF("SafLib Startup Test: ClkTst module not pass!\r\n");
            while (1)
            {
                /* ClkTst not pass, stop test*/
            }
        }
        else
        {
            PRINTF("Startup Test: POR Reset\r\n");
        }
#endif
        /* Initialize SafLib modules for startup tests */
        SafLib_StartupTest_Init();
#ifdef UART_DEBUG_EN
        PRINTF("SafLib Startup Test: Start and SafLib initialization finished!\r\n");
#endif
        /* Run SafLib startup tests */
        SafLib_StartupTest_Run();
    }
    /* USER CODE END 1 */ 
    Board_Init();
    /* USER CODE BEGIN 2 */
    /* Initialize the SafLib modules which support the runtime test  */
    RuntimeTest_Init();
#ifdef UART_DEBUG_EN
    PRINTF("SafLib Runtime Test: Start and SafLib initialization finished!\r\n");
#endif
    /*Start the GPT channel 0 for  LED toggle as run alive indication*/
    Gpt_StartTimer(GptConf_GptChannelConfiguration_GptChannelConfiguration_0, 8000000);
    Gpt_EnableNotification(GptConf_GptChannelConfiguration_GptChannelConfiguration_0);
    /* Set the Wdg 180 Inst0 Trigger Condition in order to periodically service the Wdg. */
    Wdg_180_Inst0_SetTriggerCondition(WDG_180_INST0_TRIGGER_PERIOD);
    /* Change the Wdg Mode from SLOW_MODE to FAST_MODE. */
    Wdg_180_Inst0_SetMode(WDGIF_SLOW_MODE); /* timeout = 100ms */
    /* USER CODE END 2 */

    /* Infinite loop */
    /* USER CODE BEGIN WHILE */
    while (1)
    {
        /* USER CODE END WHILE */
        /* USER CODE BEGIN 3 */
        if (0U == runtime_test_ctrl_cnt % 200)
        {
            /* Run the SafLib runtime tests cyclically */
            RuntimeTest_Run();
            if (TRUE == RuntimeTest_ErrorFlag)
            {
                /* If any runtime test error occurs, set the error flag and stop the tests */
                RuntimeTest_ErrorFlag = FALSE; /* Reset the error flag */
#ifdef UART_DEBUG_EN
                PRINTF("The SafLib runtime test is running with at least one error!\r\n");
#endif
            }
            else
            {
#ifdef UART_DEBUG_EN
                PRINTF("The SafLib runtime test is running with no error!\r\n");
#endif
            }
        }
        /* feed watchdog via Gpt Chanel 1 */
        Wdg_180_Inst0_SetTriggerCondition(WDG_180_INST0_TRIGGER_PERIOD);
        /* do something else here, for example the application tasks */
        Delay_10ms(1); /* delay 1ms */
        runtime_test_ctrl_cnt++;
        if (runtime_test_ctrl_cnt >= 1000U)
        {
            runtime_test_ctrl_cnt = 0U;
        }
    }
    /* USER CODE END 3 */
}

static void Board_Init(void)
{
    Platform_Init(NULL_PTR);
    Fls_Init(&Fls_Config);
    Port_Init(&Port_Config);
    CddUart_Init(&CddUart_Config);
    Gpt_Init(&Gpt_Config);
    Wdg_180_Inst0_Init(&Wdg_180_Inst0_Config);
}

/* USER CODE BEGIN 4 */

static void Delay_10ms(uint32 DelayCnt)
{
    uint32 i;
    volatile uint32 j;
    for (i = 0; i < DelayCnt; i++)
    {
        /* Assuming a clock frequency of 120MHz, this will create a delay of approximately 10ms */
        for (j = 0; j < 200000; j++)
        {
            /* Do nothing, just wait */
        }
    }
}

/* USER CODE END 4 */
