/*
* @file    StartupTest.h
*==================================================================================================
*   Project              : YTMicro AUTOSAR 4.4.0 MCAL
*   Platform             : ARM
*   Peripheral           : StartupTest
*   Dependencies         : none
*
*   Autosar Version      : V4.4.0
*   Autosar Revision     : ASR_REL_4_4_REV_0000
*   SW Version           : V1.1.0
*
*   (c) Copyright 2020-2025 Yuntu Microelectronics co.,ltd.
*   All Rights Reserved.
==================================================================================================*/

#ifndef STARTUPTEST_H
#define STARTUPTEST_H

#include "StartupTest.h"
#ifdef __cplusplus
extern "C" {
#endif

/*==================================================================================================
                                              INCLUDE FILES
==================================================================================================*/
#include "Mcal.h"
/*==================================================================================================
                                      HEADER FILE VERSION INFORMATION
==================================================================================================*/
#define STARTUPTEST_VENDOR_ID                     (180)
#define STARTUPTEST_AR_REL_MAJOR_VER              (4)
#define STARTUPTEST_AR_REL_MINOR_VER              (4)
#define STARTUPTEST_AR_REL_REVISION_VER           (0)
#define STARTUPTEST_SW_MAJOR_VER                  (1)
#define STARTUPTEST_SW_MINOR_VER                  (1)
#define STARTUPTEST_SW_PATCH_VER                  (0)
/*==================================================================================================
                                                DEFINES AND MACROS
==================================================================================================*/
/*==================================================================================================
                                                EXTERNAL CONSTANTS
==================================================================================================*/

extern uint32 FlsTst_FgndErrCnt;
extern uint32 FlsTst_BgndErrCnt;
extern uint32 FlsTst_BgndCount;
extern boolean FlsTst_BgndTaskFlag;
extern uint32 FlsTst_TimerCnt0;

extern boolean FlsTst_DemoAbortEn;
extern boolean FlsTst_DemoSuspendEn;
extern boolean FlsTst_DemoResumeEn;
extern FlsTst_ErrorDetailsType FlsTst_DemoErrorDetails;

/*==================================================================================================
                                                ENUMS
==================================================================================================*/
/*==================================================================================================
                                                FUNCTION PROTOTYPES
==================================================================================================*/

void ClkTst_StartupTest(void);
void SafLib_StartupTest_Init(void);
void SafLib_StartupTest_Run(void);
void SafLib_StartupTest_DeInit(void);

#ifdef __cplusplus
}
#endif

#endif /* End of file StartupTest.h */
