/*
* @file    RuntimeTest.h
*==================================================================================================
*   Project              : YTMicro AUTOSAR 4.4.0 MCAL
*   Platform             : ARM
*   Peripheral           : RuntimeTest
*   Dependencies         : none
*
*   Autosar Version      : V4.4.0
*   Autosar Revision     : ASR_REL_4_4_REV_0000
*   SW Version           : V1.1.0
*
*   (c) Copyright 2020-2025 Yuntu Microelectronics co.,ltd.
*   All Rights Reserved.
==================================================================================================*/

#ifndef RUNTIMETEST_H
#define RUNTIMETEST_H

#ifdef __cplusplus
extern "C" {
#endif

/*==================================================================================================
                                              INCLUDE FILES
==================================================================================================*/
#include "Mcal.h"
/*==================================================================================================
                                      HEADER FILE VERSION INFORMATION
==================================================================================================*/
#define RUNTIMETEST_VENDOR_ID                     (180)
#define RUNTIMETEST_AR_REL_MAJOR_VER              (4)
#define RUNTIMETEST_AR_REL_MINOR_VER              (4)
#define RUNTIMETEST_AR_REL_REVISION_VER           (0)
#define RUNTIMETEST_SW_MAJOR_VER                  (1)
#define RUNTIMETEST_SW_MINOR_VER                  (1)
#define RUNTIMETEST_SW_PATCH_VER                  (0)
/*==================================================================================================
                                                DEFINES AND MACROS
==================================================================================================*/
/*==================================================================================================
                                                EXTERNAL CONSTANTS
==================================================================================================*/

extern uint32 FlsTst_FgndErrCnt;
extern uint32 FlsTst_BgndErrCnt;
extern uint32 FlsTst_BgndCount;
extern boolean FlsTst_BgndTaskFlag;
extern uint32 FlsTst_TimerCnt0;

extern boolean FlsTst_DemoAbortEn;
extern boolean FlsTst_DemoSuspendEn;
extern boolean FlsTst_DemoResumeEn;
extern FlsTst_ErrorDetailsType FlsTst_DemoErrorDetails;

/* Flag to indicate if the background RAM test is completed */
extern volatile boolean RamTstBackGroundCompleted;

/*==================================================================================================
                                                ENUMS
==================================================================================================*/
/*==================================================================================================
                                                FUNCTION PROTOTYPES
==================================================================================================*/

void RuntimeTest_Init(void);
void RuntimeTest_Run(void);

#ifdef __cplusplus
}
#endif

#endif /* End of file RuntimeTest.h */
