/*
* @file    SchM_FlsTst.h
*==================================================================================================
*   Project              : YTMicro AUTOSAR 4.4.0 MCAL
*   Platform             : ARM
*   Peripheral           : SchM_FlsTst
*   Dependencies         : none
*
*   Autosar Version      : V4.4.0
*   Autosar Revision     : ASR_REL_4_4_REV_0000
*   SW Version           : V2.0.0
*
*   (c) Copyright 2020-2025 Yuntu Microelectronics co.,ltd.
*   All Rights Reserved.
==================================================================================================*/

#ifndef SCHM_FLSTST_H
#define SCHM_FLSTST_H

#ifdef __cplusplus
extern "C" {
#endif
/*
* @page misra_violations MISRA-C:2012 violations list
* PRQA S 0777 Rule 5.1: External identifiers shall be distinct
* PRQA S 0779 Rule 5.2: Identifiers declared in the same scope and name space shall be distinct
* PRQA S 0787 Rule 5.5: Identifiers shall be distinct from macro names. it's required when "MCAL_SCHM_LITE" is defined
*/
/* MR12 RULE 5.1 VIOLATION: The naming of the functions SchM_Enter and SchM_Exit follows the AUTOSAR_SWS_RTE documentation
* standards but does not comply with M3CM Rule-5.1 (0777).
*/
/* MR12 RULE 5.2 VIOLATION: The naming of the functions SchM_Enter and SchM_Exit follows the AUTOSAR_SWS_RTE documentation
* standards but does not comply with M3CM Rule-5.2 (0779).
*/
/* MR12 RULE 5.5 VIOLATION: The naming of the functions SchM_Enter and SchM_Exit implemented
* with the macro define to reuse the code and reduce size, it's full tested and verified with no risks.
* But it does not comply with M3CM Rule-5.5 (0787).
*/

/* PRQA S 0777,0779,0787 EOF */
/*==================================================================================================
                                              INCLUDE FILES
==================================================================================================*/
#include "FlsTst_Cfg.h"

/*==================================================================================================
                                      HEADER FILE VERSION INFORMATION
==================================================================================================*/
#define SCHM_FLSTST_VENDOR_ID                      (180)
#define SCHM_FLSTST_AR_RELEASE_MAJOR_VERSION       (4)
#define SCHM_FLSTST_AR_RELEASE_MINOR_VERSION       (4)
#define SCHM_FLSTST_AR_RELEASE_REVISION_VERSION    (0)
#define SCHM_FLSTST_SW_MAJOR_VERSION               (2)
#define SCHM_FLSTST_SW_MINOR_VERSION               (0)
#define SCHM_FLSTST_SW_PATCH_VERSION               (0)
/*==================================================================================================
                                                DEFINES AND MACROS
==================================================================================================*/

/* Number of cores id */
#ifndef NUMBER_OF_CORES
#define NUMBER_OF_CORES         (uint8)(1U)
#endif /* NUMBER_OF_CORES */

/*==================================================================================================
                                                EXTERNAL CONSTANTS
==================================================================================================*/
/*==================================================================================================
                                                ENUMS
==================================================================================================*/
/*==================================================================================================
                                                FUNCTION PROTOTYPES
==================================================================================================*/
#if (STD_ON == FLSTST_SCHM_SUPPORT)

#ifdef MCAL_SCHM_LITE
extern void SchM_Enter_FlsTst_FLSTST_EXCLUSIVE_AREA(void);
extern void SchM_Exit_FlsTst_FLSTST_EXCLUSIVE_AREA(void);

#define SchM_Enter_FlsTst_FLSTST_EXCLUSIVE_AREA_00() SchM_Enter_FlsTst_FLSTST_EXCLUSIVE_AREA()
#define SchM_Exit_FlsTst_FLSTST_EXCLUSIVE_AREA_00() SchM_Exit_FlsTst_FLSTST_EXCLUSIVE_AREA()

#define SchM_Enter_FlsTst_FLSTST_EXCLUSIVE_AREA_01() SchM_Enter_FlsTst_FLSTST_EXCLUSIVE_AREA()
#define SchM_Exit_FlsTst_FLSTST_EXCLUSIVE_AREA_01() SchM_Exit_FlsTst_FLSTST_EXCLUSIVE_AREA()

#define SchM_Enter_FlsTst_FLSTST_EXCLUSIVE_AREA_02() SchM_Enter_FlsTst_FLSTST_EXCLUSIVE_AREA()
#define SchM_Exit_FlsTst_FLSTST_EXCLUSIVE_AREA_02() SchM_Exit_FlsTst_FLSTST_EXCLUSIVE_AREA()
#else
extern void SchM_Enter_FlsTst_FLSTST_EXCLUSIVE_AREA_00(void);
extern void SchM_Exit_FlsTst_FLSTST_EXCLUSIVE_AREA_00(void);

extern void SchM_Enter_FlsTst_FLSTST_EXCLUSIVE_AREA_01(void);
extern void SchM_Exit_FlsTst_FLSTST_EXCLUSIVE_AREA_01(void);

extern void SchM_Enter_FlsTst_FLSTST_EXCLUSIVE_AREA_02(void);
extern void SchM_Exit_FlsTst_FLSTST_EXCLUSIVE_AREA_02(void);
#endif /* MCAL_SCHM_LITE */
#else

#define SchM_Enter_FlsTst_FLSTST_EXCLUSIVE_AREA_00()
#define SchM_Exit_FlsTst_FLSTST_EXCLUSIVE_AREA_00()

#define SchM_Enter_FlsTst_FLSTST_EXCLUSIVE_AREA_01()
#define SchM_Exit_FlsTst_FLSTST_EXCLUSIVE_AREA_01()

#define SchM_Enter_FlsTst_FLSTST_EXCLUSIVE_AREA_02()
#define SchM_Exit_FlsTst_FLSTST_EXCLUSIVE_AREA_02()

#endif /* STD_ON == FLSTST_SCHM_SUPPORT */

#ifdef __cplusplus
}
#endif

/** @} */

#endif /* End of file SchM_FlsTst.h */

