/**
 * @file    EccTst_Lld_Reg.h
 * @version
 *
 * @brief   AUTOSAR EccTst module interface
 * @details API implementation for ECCTST driver
 *
 * @addtogroup ECCTST_MODULE
 * @{
 */
/*==================================================================================================
*   Project              : YTMicro AUTOSAR 4.4.0 MCAL
*   Platform             : ARM
*   Peripheral           : EccTst_Lld_Reg
*   Dependencies         : none
*
*   Autosar Version      : V4.4.0
*   Autosar Revision     : ASR_REL_4_4_REV_0000
*   SW Version           : V2.0.0
*
*   (c) Copyright 2020-2025 Yuntu Microelectronics co.,ltd.
*   All Rights Reserved.
==================================================================================================*/

#ifndef ECCTST_LLD_REG_H
#define ECCTST_LLD_REG_H

#ifdef __cplusplus
extern "C" {
#endif

/*==================================================================================================
                                              INCLUDE FILES
==================================================================================================*/
#if (ECCTST_ENABLE_FLASH_ECC_TEST==STD_ON)
#include "pSIP_Efm.h"
#endif
#if (ECCTST_ENABLE_RAM_ECC_TEST==STD_ON)
#include "pSIP_Emu.h"
#endif
#if (ECCTST_ENABLE_CAN_ECC_TEST==STD_ON)
#include "pSIP_Can.h"
#endif
/*==================================================================================================
                                      HEADER FILE VERSION INFORMATION
==================================================================================================*/
#define ECCTST_LLD_REG_VENDOR_ID                     (180)
#define ECCTST_LLD_REG_AR_REL_MAJOR_VER              (4)
#define ECCTST_LLD_REG_AR_REL_MINOR_VER              (4)
#define ECCTST_LLD_REG_AR_REL_REVISION_VER           (0)
#define ECCTST_LLD_REG_SW_MAJOR_VER                  (2)
#define ECCTST_LLD_REG_SW_MINOR_VER                  (0)
#define ECCTST_LLD_REG_SW_PATCH_VER                  (0)
/*==================================================================================================
                                                DEFINES AND MACROS
==================================================================================================*/
/*==================================================================================================
                                                EXTERNAL CONSTANTS
==================================================================================================*/
/*==================================================================================================
                                                ENUMS
==================================================================================================*/
/*==================================================================================================
                                                FUNCTION PROTOTYPES
==================================================================================================*/
#ifdef __cplusplus
}
#endif

#endif /* End of file EccTst_Lld_Reg.h */

/** @} */
