/**
 * @file    CorTst_Data.c
 * @version V2.0.0
 *
 * @brief   AUTOSAR CorTst module data
 * @details API implementation for CORTST data
 *
 * @addtogroup CORTST_MODULE
 * @{
 */
/*==================================================================================================
 *   Project              : YTMicro AUTOSAR 4.4.0 MCAL
 *   Platform             : ARM
 *   Peripheral           : Core
 *   Dependencies         : none
 *
 *   Autosar Version      : V4.4.0
 *   Autosar Revision     : ASR_REL_4_4_REV_0000
 *   Autosar Conf.Variant :
 *   SW Version           : V2.0.0
 *
 *   (c) Copyright 2020-2025 Yuntu Microelectronics co.,ltd.
 *   All Rights Reserved.
==================================================================================================*/

#ifdef __cplusplus
extern "C" {
#endif

/*=================================================================================================
 *                                        INCLUDE FILES
=================================================================================================*/
#include "CorTst_Compiler.h"
#include "CorTst_Data.h"

/*==================================================================================================
 *                               SOURCE FILE VERSION INFORMATION
==================================================================================================*/
#define CORTST_DATA_VENDOR_ID_C                      (180)
#define CORTST_DATA_AR_RELEASE_MAJOR_VERSION_C       (4)
#define CORTST_DATA_AR_RELEASE_MINOR_VERSION_C       (4)
#define CORTST_DATA_AR_RELEASE_REVISION_VERSION_C    (0)
#define CORTST_DATA_SW_MAJOR_VERSION_C               (2)
#define CORTST_DATA_SW_MINOR_VERSION_C               (0)
#define CORTST_DATA_SW_PATCH_VERSION_C               (0)

/*==================================================================================================
 *                                     FILE VERSION CHECKS
==================================================================================================*/
/* CorTst_Data.h version check */
#if (CORTST_DATA_VENDOR_ID_C != CORTST_DATA_VENDOR_ID)
#error "CorTst_Data.c and CorTst_Data.h have different vendor ids"
#endif
#if ((CORTST_DATA_AR_RELEASE_MAJOR_VERSION_C != CORTST_DATA_AR_RELEASE_MAJOR_VERSION) || \
     (CORTST_DATA_AR_RELEASE_MINOR_VERSION_C != CORTST_DATA_AR_RELEASE_MINOR_VERSION) || \
     (CORTST_DATA_AR_RELEASE_REVISION_VERSION_C != CORTST_DATA_AR_RELEASE_REVISION_VERSION) \
    )
#error "AutoSar Version Numbers of CorTst_Data.c and CorTst_Data.h are different"
#endif
#if ((CORTST_DATA_SW_MAJOR_VERSION_C != CORTST_DATA_SW_MAJOR_VERSION) || \
     (CORTST_DATA_SW_MINOR_VERSION_C != CORTST_DATA_SW_MINOR_VERSION) || \
     (CORTST_DATA_SW_PATCH_VERSION_C != CORTST_DATA_SW_PATCH_VERSION) \
    )
#error "Software Version Numbers of CorTst_Data.c and CorTst_Data.h are different"
#endif

/* CorTst_Compiler.h version check */
#if (CORTST_DATA_VENDOR_ID_C != CORTST_COMPILER_VENDOR_ID)
#error "CorTst_Data.c and CorTst_Compiler.h have different vendor ids"
#endif
#if ((CORTST_DATA_AR_RELEASE_MAJOR_VERSION_C != CORTST_COMPILER_AR_RELEASE_MAJOR_VERSION) || \
     (CORTST_DATA_AR_RELEASE_MINOR_VERSION_C != CORTST_COMPILER_AR_RELEASE_MINOR_VERSION) || \
     (CORTST_DATA_AR_RELEASE_REVISION_VERSION_C != CORTST_COMPILER_AR_RELEASE_REVISION_VERSION) \
    )
#error "AutoSar Version Numbers of CorTst_Data.c and CorTst_Compiler.h are different"
#endif
#if ((CORTST_DATA_SW_MAJOR_VERSION_C != CORTST_COMPILER_SW_MAJOR_VERSION) || \
     (CORTST_DATA_SW_MINOR_VERSION_C != CORTST_COMPILER_SW_MINOR_VERSION) || \
     (CORTST_DATA_SW_PATCH_VERSION_C != CORTST_COMPILER_SW_PATCH_VERSION) \
    )
#error "Software Version Numbers of CorTst_Data.c and CorTst_Compiler.h are different"
#endif

/*==================================================================================================
 *                                      FUNCTION PROTOTYPES
==================================================================================================*/
#if (CORTST_M33_INTERRUPT_ENABLE == 1U)
extern uint32 M33_Cst_ExcUsageFaultTest(void);
extern uint32 M33_Cst_ExcBusFaultTest(void);
extern uint32 M33_Cst_ExcMemFaultTest(void);
extern uint32 M33_Cst_ExcSvcTest(void);
extern uint32 M33_Cst_ExcPendsvTest(void);
extern uint32 M33_Cst_ExcSystickTest(void);
extern uint32 M33_Cst_ExcNmiTest(void);
extern uint32 M33_Cst_ExcHardFaultTest1(void);
extern uint32 M33_Cst_ExcHardFaultTest2(void);
#endif
#if (CORTST_M33_BRANCH_ENABLE == 1U)
extern uint32 M33_Cst_BranchTest1(void);
extern uint32 M33_Cst_BranchTest2(void);
extern uint32 M33_Cst_BranchTest3(void);
#endif
#if (CORTST_M33_REGISTER_ENABLE == 1U)
extern uint32 M33_Cst_RegbankTest(void);
#endif
#if (CORTST_M33_FORWARD_ENABLE == 1U)
extern uint32 M33_Cst_ForwardingTest1(void);
extern uint32 M33_Cst_ForwardingTest2(void);
extern uint32 M33_Cst_ForwardingTest3(void);
extern uint32 M33_Cst_ForwardingTest4(void);
#endif
#if (CORTST_M33_ALU_ENABLE == 1U)
extern uint32 M33_Cst_AluTest1(void);
extern uint32 M33_Cst_AluTest2(void);
extern uint32 M33_Cst_AluTest3(void);
extern uint32 M33_Cst_AluTest4(void);
#endif
#if (CORTST_M33_STATUS_ENABLE == 1U)
extern uint32 M33_Cst_StatusTest1(void);
extern uint32 M33_Cst_StatusTest2(void);
#endif
#if (CORTST_M33_LOADSTORE_ENABLE == 1U)
extern uint32 M33_Cst_LoadstoreTest1(void);
extern uint32 M33_Cst_LoadstoreTest2(void);
extern uint32 M33_Cst_LoadstoreTest3(void);
extern uint32 M33_Cst_LoadstoreTest4(void);
extern uint32 M33_Cst_LoadstoreTest5(void);
extern uint32 M33_Cst_LoadstoreTest6(void);
#endif
#if (CORTST_M33_MPU_ENABLE == 1U)
extern uint32 M33_Cst_MPUTest(void);
#endif
#if (CORTST_M33_FETCH_ENABLE == 1U)
extern uint32 M33_Cst_FetchTest(void);
#endif
#if (CORTST_M33_DIVIDER_ENABLE == 1U)
extern uint32 M33_Cst_DivTest(void);
#endif
#if (CORTST_M33_MAC_ENABLE == 1U)
extern uint32 M33_Cst_MacTest(void);
#endif
#if (CORTST_M33_SIMDSAT_ENABLE == 1U)
extern uint32 M33_Cst_SimdsatTest1(void);
extern uint32 M33_Cst_SimdsatTest2(void);
extern uint32 M33_Cst_SimdsatTest3(void);
extern uint32 M33_Cst_SimdsatTest4(void);
#endif
#if (CORTST_M33_FPU_ENABLE==1U)
extern uint32 M33_Cst_SpfpuExcStackTest(void);
extern uint32 M33_Cst_SpfpuRegbankTest1(void);
extern uint32 M33_Cst_SpfpuRegbankTest2(void);
extern uint32 M33_Cst_SpfpuForwardingTest(void);
extern uint32 M33_Cst_SpfpuMacTest(void);
extern uint32 M33_Cst_SpfpuDivTest(void);
extern uint32 M33_Cst_SpfpuAdderTest(void);
extern uint32 M33_Cst_SpfpuCmpTest(void);
extern uint32 M33_Cst_SpfpuMinMaxTest(void);
extern uint32 M33_Cst_SpfpuConvertTest1(void);
extern uint32 M33_Cst_SpfpuConvertTest2(void);
extern uint32 M33_Cst_SpfpuLoadstoreTest(void);
extern uint32 M33_Cst_SpfpuRoundingTest(void);
#endif

/*==================================================================================================
 *                                      GLOBAL VARIABLES
==================================================================================================*/
#define CORTST_START_SEC_CONST_32
#include "CorTst_MemMap.h"
CORTST_CONST const CorTst_AtomicTestDescType CorTst_AtomicTestDesc[CORTST_ATOMIC_TEST_NUM] =
{
    /*-----------------------------------------------------------------------------------------*/
    /* Atomic Test Name                   OrigSign     InjSign        Index  Select */
    /*-----------------------------------------------------------------------------------------*/
#if (CORTST_M33_INTERRUPT_ENABLE == 1U)
    {&M33_Cst_ExcUsageFaultTest,    0xD0005217U, 0x25D86D74U}, /* 0    CorTstInterrupt  */
    {&M33_Cst_ExcBusFaultTest,      0x4A39B35CU, 0xBFE18C3FU}, /* 1    CorTstInterrupt  */
    {&M33_Cst_ExcMemFaultTest,      0x57BF26CDU, 0xA26719AEU}, /* 2    CorTstInterrupt  */
    {&M33_Cst_ExcSvcTest,           0x3D4AF6F9U, 0xC892C99AU}, /* 3    CorTstInterrupt  */
    {&M33_Cst_ExcPendsvTest,        0x8D490D7DU, 0x7891321EU}, /* 4    CorTstInterrupt  */
    {&M33_Cst_ExcSystickTest,       0xA6D4B589U, 0x530C8AEAU}, /* 5    CorTstInterrupt  */
    {&M33_Cst_ExcNmiTest,           0x2873F706U, 0xDDABC865U}, /* 6    CorTstInterrupt  */
    {&M33_Cst_ExcHardFaultTest1,    0xA402BF86U, 0x51DA80E5U}, /* 7    CorTstInterrupt  */
#if defined(CPU_YTM32B1ME0) || defined(CPU_YTM32B1MD1)
    {&M33_Cst_ExcHardFaultTest2,    0x1A319611U, 0xEFE9A972U}, /* 8    CorTstInterrupt  */
#else   /* CPU_YTM32B1MC0, for cortex-m33+nodsp */
    {&M33_Cst_ExcHardFaultTest2,    0x1A1D94D1U, 0xEFC5ABB2U}, /* 8    CorTstInterrupt  */
#endif
#endif
#if (CORTST_M33_BRANCH_ENABLE == 1U)
    {&M33_Cst_BranchTest1,          0x096B9EA5U, 0xFCB3A1C6U}, /* 9    CorTstBranch     */
    {&M33_Cst_BranchTest2,          0x7D9392FDU, 0x884BAD9EU}, /* 10   CorTstBranch     */
    {&M33_Cst_BranchTest3,          0x06DC0F1CU, 0xF304307FU}, /* 11   CorTstBranch     */
#endif
#if (CORTST_M33_REGISTER_ENABLE == 1U)
    {&M33_Cst_RegbankTest,          0x1A631096U, 0xEFBB2FF5U}, /* 12   CorTstRegister   */
#endif
#if (CORTST_M33_FORWARD_ENABLE == 1U)
    {&M33_Cst_ForwardingTest1,      0x4A9EC017U, 0xBF46FF74U}, /* 13   CorTstForward    */
    {&M33_Cst_ForwardingTest2,      0xF7F2ADA2U, 0x022A92C1U}, /* 14   CorTstForward    */
    {&M33_Cst_ForwardingTest3,      0xC15BFA56U, 0x3483C535U}, /* 15   CorTstForward    */
    {&M33_Cst_ForwardingTest4,      0x76698DBFU, 0x83B1B2DCU}, /* 16   CorTstForward    */
#endif
#if (CORTST_M33_ALU_ENABLE == 1U)
    {&M33_Cst_AluTest1,             0x26E0C4FBU, 0xD338FB98U}, /* 17   CorTstAlu        */
    {&M33_Cst_AluTest2,             0x2A82F766U, 0xDF5AC805U}, /* 18   CorTstAlu        */
    {&M33_Cst_AluTest3,             0x36FB1B2FU, 0xC323244CU}, /* 19   CorTstAlu        */
    {&M33_Cst_AluTest4,             0x34CA20E8U, 0xC1121F8BU}, /* 20   CorTstAlu        */
#endif
#if (CORTST_M33_STATUS_ENABLE == 1U)
    {&M33_Cst_StatusTest1,          0xDD0F838FU, 0x28D7BCECU}, /* 21   CorTstStatus     */
    {&M33_Cst_StatusTest2,          0x901AD84FU, 0x65C2E72CU}, /* 22   CorTstStatus     */
#endif
#if (CORTST_M33_LOADSTORE_ENABLE == 1U)
    {&M33_Cst_LoadstoreTest1,       0x2FF78B74U, 0xDA2FB417U}, /* 23   CorTstLoadstore  */
    {&M33_Cst_LoadstoreTest2,       0x5C7DF8AEU, 0xA9A5C7CDU}, /* 24   CorTstLoadstore  */
    {&M33_Cst_LoadstoreTest3,       0x8F65E093U, 0x7ABDDFF0U}, /* 25   CorTstLoadstore  */
    {&M33_Cst_LoadstoreTest4,       0x53977E3EU, 0xA64F415DU}, /* 26   CorTstLoadstore  */
    {&M33_Cst_LoadstoreTest5,       0x7F0BF5A3U, 0x8AD3CAC0U}, /* 27   CorTstLoadstore  */
    {&M33_Cst_LoadstoreTest6,       0x4639FD88U, 0xB3E1C2EBU}, /* 28   CorTstLoadstore  */
#endif
#if (CORTST_M33_MPU_ENABLE == 1U)
    {&M33_Cst_MPUTest,              0x2F6AB216U, 0xDAB28D75U}, /* 29   CorTstMPUTest    */
#endif
#if (CORTST_M33_FETCH_ENABLE == 1U)
    {&M33_Cst_FetchTest,            0x976F02E7U, 0x62B73D84U}, /* 30   CorTstFetch      */
#endif
#if (CORTST_M33_DIVIDER_ENABLE == 1U)
    {&M33_Cst_DivTest,              0x76E120AFU, 0x83391FCCU}, /* 31   CorTstDivdier    */
#endif
#if (CORTST_M33_MAC_ENABLE == 1U)
    {&M33_Cst_MacTest,              0x93391406U, 0x66E12B65U}, /* 32   CorTstMac        */
#endif
#if (CORTST_M33_SIMDSAT_ENABLE == 1U)
    {&M33_Cst_SimdsatTest1,         0xC6C1493AU, 0x33197659U}, /* 33   CorTstSimdsat    */
    {&M33_Cst_SimdsatTest2,         0x97672361U, 0x62BF1C02U}, /* 34   CorTstSimdsat    */
    {&M33_Cst_SimdsatTest3,         0x08E2F59EU, 0xFD3ACAFDU}, /* 35   CorTstSimdsat    */
    {&M33_Cst_SimdsatTest4,         0x39C3A6A5U, 0xCC1B99C6U}, /* 36   CorTstSimdsat    */
#endif
#if (CORTST_M33_FPU_ENABLE == 1U)
    {&M33_Cst_SpfpuExcStackTest,    0x2E482E48U, 0xDB90112BU}, /* 37   CorTstFpu        */
    {&M33_Cst_SpfpuRegbankTest1,    0x2271B455U, 0xD7A98B36U}, /* 38   CorTstFpu        */
    {&M33_Cst_SpfpuRegbankTest2,    0xECE8EC3AU, 0x1930D359U}, /* 39   CorTstFpu        */
    {&M33_Cst_SpfpuForwardingTest,  0x97FDF5C9U, 0x6225CAAAU}, /* 40   CorTstFpu        */
    {&M33_Cst_SpfpuMacTest,         0xF1B0909CU, 0x0468AFFFU}, /* 41   CorTstFpu        */
    {&M33_Cst_SpfpuDivTest,         0x403E2CC2U, 0xB5E613A1U}, /* 42   CorTstFpu        */
    {&M33_Cst_SpfpuAdderTest,       0x8D366D34U, 0x78EE5257U}, /* 43   CorTstFpu        */
    {&M33_Cst_SpfpuCmpTest,         0xB24CE682U, 0x4794D9E1U}, /* 44   CorTstFpu        */
    {&M33_Cst_SpfpuMinMaxTest,      0xB6F6BB40U, 0x432E8423U}, /* 45   CorTstFpu        */
    {&M33_Cst_SpfpuConvertTest1,    0x82EEB640U, 0x77368923U}, /* 46   CorTstFpu        */
    {&M33_Cst_SpfpuConvertTest2,    0xC6F4DB0BU, 0x332CE468U}, /* 47   CorTstFpu        */
    {&M33_Cst_SpfpuLoadstoreTest,   0x9450B754U, 0x61888837U}, /* 48   CorTstFpu        */
    {&M33_Cst_SpfpuRoundingTest,    0x363D0F2FU, 0xC3E5304CU}  /* 49   CorTstFpu        */
#endif
};
#define CORTST_STOP_SEC_CONST_32
#include "CorTst_MemMap.h"

#ifdef __cplusplus
}
#endif

/** @} */

