/**
 * @file    CorTst_Data.h
 * @version V2.0.0
 *
 * @brief   AUTOSAR CorTst module data
 * @details API implementation for CorTst driver
 *
 * @addtogroup CORTST_MODULE
 * @{
 */
/*==================================================================================================
 *   Project              : YTMicro AUTOSAR 4.4.0 MCAL
 *   Platform             : ARM
 *   Peripheral           : Core
 *   Dependencies         : none
 *
 *   Autosar Version      : V4.4.0
 *   Autosar Revision     : ASR_REL_4_4_REV_0000
 *   Autosar Conf.Variant :
 *   SW Version           : V2.0.0
 *
 *   (c) Copyright 2020-2025 Yuntu Microelectronics co.,ltd.
 *   All Rights Reserved.
==================================================================================================*/

#ifndef CORTST_DATA_H
#define CORTST_DATA_H

#ifdef __cplusplus
extern "C" {
#endif

/*=================================================================================================
 *                                        INCLUDE FILES
=================================================================================================*/
#include "CorTst_Types.h"

/*==================================================================================================
 *                               SOURCE FILE VERSION INFORMATION
==================================================================================================*/
#define CORTST_DATA_VENDOR_ID                      (180)
#define CORTST_DATA_AR_RELEASE_MAJOR_VERSION       (4)
#define CORTST_DATA_AR_RELEASE_MINOR_VERSION       (4)
#define CORTST_DATA_AR_RELEASE_REVISION_VERSION    (0)
#define CORTST_DATA_SW_MAJOR_VERSION               (2)
#define CORTST_DATA_SW_MINOR_VERSION               (0)
#define CORTST_DATA_SW_PATCH_VERSION               (0)

/*==================================================================================================
 *                                     FILE VERSION CHECKS
==================================================================================================*/
/* CorTst_Types.h version check */
#if (CORTST_DATA_VENDOR_ID != CORTST_TYPES_VENDOR_ID)
#error "CorTst_Data.h and CorTst_Types.h have different vendor ids"
#endif
#if ((CORTST_DATA_AR_RELEASE_MAJOR_VERSION != CORTST_TYPES_AR_RELEASE_MAJOR_VERSION) || \
     (CORTST_DATA_AR_RELEASE_MINOR_VERSION != CORTST_TYPES_AR_RELEASE_MINOR_VERSION) || \
     (CORTST_DATA_AR_RELEASE_REVISION_VERSION != CORTST_TYPES_AR_RELEASE_REVISION_VERSION) \
    )
#error "AutoSar Version Numbers of CorTst_Data.h and CorTst_Types.h are different"
#endif
#if ((CORTST_DATA_SW_MAJOR_VERSION != CORTST_TYPES_SW_MAJOR_VERSION) || \
     (CORTST_DATA_SW_MINOR_VERSION != CORTST_TYPES_SW_MINOR_VERSION) || \
     (CORTST_DATA_SW_PATCH_VERSION != CORTST_TYPES_SW_PATCH_VERSION) \
    )
#error "Software Version Numbers of CorTst_Data.h and CorTst_Types.h are different"
#endif

/*==================================================================================================
*                              STRUCTURES AND OTHER TYPEDEFS
==================================================================================================*/
/**
 * @brief       The CorTst_AtomicTestDescType data type specifies a descriptor for individual atomic
 *              test.
 * @sw_type     sw_detail
 *
 * @trace       YTDT_CorTst_861
 */
typedef struct
{
    uint32(*AtomicTestStartAddress)(void);      /**< Pointer to the start address of the atomic test. */
    uint32 OrigSign;                            /**< Expected original signature of the atomic test. */
    uint32 InjSign;                             /**< Expected injected signature of the atomic test. */
} CorTst_AtomicTestDescType;

/*==================================================================================================
 *                                      GLOBAL VARIABLES
==================================================================================================*/
extern const CorTst_AtomicTestDescType CorTst_AtomicTestDesc[CORTST_ATOMIC_TEST_NUM];

#ifdef __cplusplus
}
#endif

#endif /* CORTST_DATA_H */

/** @} */

