/*
 * Copyright 2020-2025 Yuntu Microelectronics co.,ltd
 * All rights reserved.
 *
 * YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 * used strictly in accordance with the applicable license terms. By expressly
 * accepting such terms or by downloading, installing, activating and/or otherwise
 * using the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software. The production use license in
 * Section 2.3 is expressly granted for this software.
 */

/******************************************************************************
* Test summary:
* -------------
* Tests condition flags behavior inside the IT block.
*
* Overall coverage:
* -----------------
*  - Condition flags behavior for 16-bit Thumb instructions inside the IT-block
*  - Condition flags behavior for 32-bit Thumb instructions inside the IT-block
* 
* Decoder coverage:
* ----------------
* Thumb (16-bit) DECODER:
*   - IT
******************************************************************************/

#include "CorTst_Compiler.h"
#include "CorTst_M33_Cfg.h"

#if (CORTST_M33_STATUS_ENABLE==1)
    /* Compatible with ABI. */
    CST_PRES8
    /* Symbols defined in the current module but to be visible to outside */
    CST_EXPORT M33_Cst_StatusTest2
    
    /* Symbols defined outside but used within current module */
    CST_EXTERN m33_cst_test_tail_end
    
    /* Local defines */    
    CST_SET(PRESIGNATURE_SEED, 0x75DA) /* this macro has to be at the beginning of the line */

    /**
     * Values stored in registers:
     * - R8  ... accumulated signature
     * - R0  ... 0
     * - R1  ... 1
     */
    /*------------------------------------------------------------------------*/
    CST_SECTION_EXEC(mcal_text)
    /*------------------------------------------------------------------------*/
    /* The ".type" directive instructs the assembler/linker that the label 
       "M33_Cst_StatusTest2" designates a function.
       This would cause setting the least significant bit to '1' within any 
       pointer to this function, causing change to Thumb mode whenever this 
       function is called. */
    CST_THUMB2
    CST_TYPE(M33_Cst_StatusTest2, function)
M33_Cst_StatusTest2:

    PUSH    {R4-R12,R14}
    
    /*------------------------------------------------------------------------*/
    /* Test - preparation                                                     */
    /*------------------------------------------------------------------------*/
    MOV     R8,#PRESIGNATURE_SEED   /* Compute PRESIGNATURE */
    MLA     R1,R8,R8,R8
    
    /*------------------------------------------------------------------------*/
    /* Test - start                                                           */
    /*------------------------------------------------------------------------*/
    MOVS    R0,#0
    
    CST_OPCODE_START
    CST_OPCODE16(0xF380)       /* MSR     APSR,R0 */     
    CST_OPCODE16(0x8C00)       /* Clears APSR_nzcvq, APSR_ge */    
    CST_OPCODE_END
    
    /***************************************************************************
    *  Test that dedicated 16-bit instructions set flags in the IT blocks  
    *  - 16-bit CMP, CMN instructions always sets flags inside the IT block.
    ***************************************************************************/
    ITEEE       NE
    CMNNE.N     R0,R0           /* Yes! - This will set Z flag !! */      
    ADDEQ       R2,R0,R1        /* Yes! */   
    ADDEQ       R3,R0,R1        /* Yes! */   
    ADDEQ       R4,R0,R1        /* Yes! */
    ITTEE       EQ  
    ADDEQ       R5,R0,R1        /* Yes! */
    CMNEQ.N     R1,R0           /* Yes! - This will clear Z flag !! */
    ADDNE       R6,R0,R1        /* Yes! */
    ADDNE       R7,R0,R1        /* Yes! */
    /* !! We need to update signature !! */
    BL          m33_cst_status_test2_sum_r2_r7_to_r8
    
    ITETE       PL
    CMPPL.N     R0,R1           /* Yes! - This will set N flag !!  */
    ADDMI       R2,R2,R1        /* Yes! */      
    ADDPL       R3,R3,#0xFF     /* No ! */   
    ADDMI       R4,R4,R1        /* Yes! */
    ITTTT       MI      
    ADDMI       R5,R5,R1        /* Yes! */
    ADDMI       R6,R6,R1        /* Yes! */
    CMNMI.N     R1,R1           /* Yes! - This will clear N flag !! */   
    ADDMI       R7,R7,#0xFF     /* No ! */
    /* !! We need to update signature !! */
    BL          m33_cst_status_test2_sum_r2_r7_to_r8
    
    ITETT       CS
    ADDCS       R2,R2,#0xFF     /* No ! */
    CMPCC.N     R0,R0           /* Yes! - This will set C flag !! */
    ADDCS       R3,R3,R1        /* Yes! */
    ADDCS       R4,R4,R1        /* Yes! */
    ITTET       CC  
    ADDCC       R5,R5,#0xFF     /* No ! */
    ADDCC       R6,R6,#0xFF     /* No ! */
    CMPCS.N     R0,R1           /* Yes! - This will clear C flag !! */
    ADDCC       R7,R7,R1        /* Yes! */
    /* !! We need to update signature !! */
    BL          m33_cst_status_test2_sum_r2_r7_to_r8
    
    
    /***************************************************************************
    * Test that 32-bit instructions set flags in the IT block
    * - 32-bit ALU instructions sets flags inside IT block
    ***************************************************************************/
    ITEET       VS
    ADDVS.N     R2,R2,#0xFF     /* No ! */
    CMPVC.W     R1,R1,LSL #31   /* Yes! - This will set V flag !! */
    ADDVC.N     R3,R3,#0xFF     /* No ! */
    ADDVS.N     R4,R4,R1        /* Yes! */
    ITETE       VC
    ADDVC       R5,R5,#0xFF     /* No ! */
    CMNVS.W     R1,R1,LSL #0    /* Yes! - This will clear V flag !! */
    ADDVC.N     R6,R6,R1        /* Yes! */
    ADDVS.N     R7,R7,#0xFF     /* No ! */
    /* !! We need to update signature !! */
    BL          m33_cst_status_test2_sum_r2_r7_to_r8
    
    ITTE        GT  
    SUBSGT.W    R0,R0,R1        /* Yes! - Sets N!=V */     
    ADDGT.N     R2,R2,#0xFF     /* No ! */
    ADDSLE.W    R3,R3,R1        /* Yes! - Clear all flags */
    ITEE        LE
    ADDLE.N     R4,R4,#0xFF     /* No ! */
    EORSGT.W    R0,R0,R0        /* Yes! - Sets Z==1 */      
    ADDGT.N     R5,R5,#0xFF     /* No ! */
    ITT         EQ
    ADDEQ.N     R7,R7,R1        /* Yes! */
    RRXSEQ      R11,R1          /* Yes! - Sets C flag  */
    ITE         CS
    ORRSCS.W    R1,R1,R0,LSL #1 /* Yes! - Clears C,Z flags */
    ADDCC.N     R7,R7,R1        /* Yes! */
    IT      AL
    /* !! We need to update signature !! */
    BLAL    m33_cst_status_test2_sum_r2_r7_to_r8
    
    
    /***************************************************************************
    *  Test IT block discards flags inside IT block
    *
    *  Note, that there are 16-Bit Thumb instructions which do not set 
    *  flags inside the IT block.
    ***************************************************************************/
    /* Check that Z flag is not set inside IT block !!
       We will intentionally use opcode to confuse compiler to avoid 
       instructions optimizations inside the IT block */  
    CST_OPCODE_START
    CST_OPCODE16(0xBFE1)       /* ITTTT AL */
    CST_OPCODE_END 
    EORS    R0,R0               /* EORS -> EOR (Inside IT block) */
    MULS    R0,R0               /* MULS -> MUL (Inside IT block) */
    EORS    R0,R0               /* EORS -> EOR (Inside IT block) */
    MULS    R0,R0               /* MULS -> MUL (Inside IT block) */
    /* Check Z flag was not set !! */                            
    MRS     R4,APSR             
    
    /* Check that N flag is not set inside IT block !!
       We will intentionally use opcode to confuse compiler to avoid 
       instructions optimizations inside the IT block */
    CST_OPCODE_START
    CST_OPCODE16(0xBFE1)       /* ITTTT AL */
    CST_OPCODE_END
    SUBS    R5,R0,#1            /* SUBS -> SUB (Inside IT block) */
    MULS    R5,R1               /* MULS -> MUL (Inside IT block) */
    LSLS    R6,R1,#31           /* LSLS -> LSL (Inside IT block) */
    ADDS    R7,R1,R6            /* ADDS -> ADD (Inside IT block) */
    /* Check N flag was not set !! */
    MRS     R5,APSR             
    
    /* Check that C,V flags are not set inside IT block !!
       We will intentionally use opcode to confuse compiler to avoid 
       instructions optimizations inside the IT block */    
    CST_OPCODE_START
    CST_OPCODE16(0xBFE1)       /* ITTTT AL */
    CST_OPCODE_END
    ADDS    R4,R7,R6            /* ADDS -> ADD (Inside IT block) */
    ADDS    R4,R7,R6            /* ADDS -> ADD (Inside IT block) */
    ADDS    R4,R7,R6            /* ADDS -> ADD (Inside IT block) */
    ADDS    R4,R7,R6            /* ADDS -> ADD (Inside IT block) */
    /* Check C,V flags were not set !! */
    MRS     R6,APSR             /* Load flags !! */
    
    MOV     R11,#0xF0000000
    MSR     APSR_nzcvq,R11             /* Set N,Z,C,V flags */
    /* Check that none of the N,Z,C,V flags is cleared inside IT block !!
       We will intentionally use opcode to confuse compiler to avoid 
       instructions optimizations inside the IT block */
    CST_OPCODE_START
    CST_OPCODE16(0xBFE1)       /* ITTTT AL */
    CST_OPCODE_END 
    ADDS    R1,R1,R0            /* ADDS -> ADD (inside IT block) */
    MULS    R1,R1               /* MULS -> MUL (inside IT block) */
    ADDS    R1,R1,R0            /* ADDS -> ADD (inside IT block) */
    ADDS    R1,R1,R0            /* ADDS -> ADD (inside IT block) */
    /* Check N,Z,C,V flags were not cleared !! */
    MRS     R7,APSR             /* Load flags */
    
    /* !! We need to update signature !! */
    BL      m33_cst_status_test2_sum_r4_r7_to_r8
    
    
    /*------------------------------------------------------------------------*/
    /* Test - end                                                             */
    /*------------------------------------------------------------------------*/
    MOV     R0,R8       /* Test result is returned in R0 */
m33_cst_status_test2_end:
    B       m33_cst_test_tail_end    
    
    
    /**************************************************************************/
    /* !! Updates Signature !!                                                */
    /**************************************************************************/
m33_cst_status_test2_sum_r2_r7_to_r8:  
    ADD     R8,R8,R2
    ROR     R8,R8,#1 
    ADD     R8,R8,R3 
    ROR     R8,R8,#1
m33_cst_status_test2_sum_r4_r7_to_r8:    
    ADD     R8,R8,R4
    ROR     R8,R8,#1
    ADD     R8,R8,R5
    ROR     R8,R8,#1
    ADD     R8,R8,R6
    ROR     R8,R8,#1
    ADD     R8,R8,R7
    ROR     R8,R8,#1
    IT      AL
    BXAL    LR      
    
    
    CST_ALIGN_BYTES_4
    /* Marks the current location for dumping psuedoinstruction pools containing
       numeric values for used symbolic names used within LDR instruction. */
    CST_LTORG

#endif  /* CORTST_M33_STATUS_ENABLE */
    
    CST_FILE_END

