/*
 * Copyright 2020-2025 Yuntu Microelectronics co.,ltd
 * All rights reserved.
 *
 * YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 * used strictly in accordance with the applicable license terms. By expressly
 * accepting such terms or by downloading, installing, activating and/or otherwise
 * using the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software. The production use license in
 * Section 2.3 is expressly granted for this software.
 */
 
/******************************************************************************
* Test summary:
* -------------
* Tests whether condition code is executed correctly depending
* on condition and mask. 
* Tests all possible conditions and masks.
*
* Overall coverage:
* -----------------
*  - N,Z,C,V flags forwarding from ALUs into the IT block logic.
*  - N,Z flags forwarding from the MUL into the IT block logic.
*  - Execute dual-issued instructions inside IT block
*  - Execute not dual-issued instructions inside IT block.
*  - IT conditions:
*       MI,PL
*       EQ,NE
*       CS,CC
*       VS,VC
*       HI,LS
*       GT,LE
*       GE,LT
* 
* Decoder coverage:
* ----------------
* Thumb (16-bit) DECODER:
*   - IT 
******************************************************************************/

#include "CorTst_Compiler.h"
#include "CorTst_M33_Cfg.h"

#if (CORTST_M33_STATUS_ENABLE==1)
    /* Compatible with ABI. */
    CST_PRES8
    /* Symbols defined in the current module but to be visible to outside */
    CST_EXPORT M33_Cst_StatusTest1
    
    /* Symbols defined outside but used within current module */
    CST_EXTERN m33_cst_test_tail_end

    /* Local defines */
    CST_SET(PRESIGNATURE_SEED, 0xE152)
    
    /**
     * Values stored in registers:
     * - R7  ... accumulated signature
     * - R9  ... PRIMASK
     */
    /*------------------------------------------------------------------------*/
    CST_SECTION_EXEC(mcal_text)
    /*------------------------------------------------------------------------*/
    /* The ".type" directive instructs the assembler/linker that the label 
       "M33_Cst_StatusTest1" designates a function.
       This would cause setting the least significant bit to '1' within any 
       pointer to this function, causing change to Thumb mode whenever this 
       function is called. */
    CST_THUMB2   
    CST_TYPE(M33_Cst_StatusTest1, function)
M33_Cst_StatusTest1:

    PUSH    {R4-R12,R14}
    
    /*------------------------------------------------------------------------*/
    /* Test - preparation                                                     */
    /*------------------------------------------------------------------------*/
    MOV     R7,#PRESIGNATURE_SEED   /* Compute PRESIGNATURE */
    MLA     R7,R7,R7,R7
    
    /*------------------------------------------------------------------------*/
    /* Test - start                                                           */
    /*------------------------------------------------------------------------*/
    MRS     R9,PRIMASK
    
    /******************************************************************************
    * Test connection between ALU modules and the IT block logic
    ******************************************************************************/
    MOVS    R0,#0
    MOVS    R1,#1
    MSR     APSR_nzcvq,R0 /* Clear flags */
    /**************************************************************************
    * Test Conditions - MI,PL
    *  ITTTT, ITTTE
    ***************************************************************************/
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    SUBS     R2,R0,R1       /* Slot0: ALU0 sets N flag */
    NOP                     /* Slot1: */
    ITTTT   MI              /* Slot0: */
    ADDMI   R3,R0,R1        /* Yes! */
    ADDMI   R4,R0,R1        /* Yes! */
    ADDMI   R5,R0,R1        /* Yes! */
    ADDMI   R6,R0,R1        /* Yes! */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R9      /* Restore PRIMASK register */
    /*------------------------------------------------------------------------*/
    /* !! We need to update signature !! */
    BL      m33_cst_status_test1_sum_result_to_r7
    
    
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    ADDS    R2,R1,R1        /* Slot0: ALU0 clears N flag */
    NOP
    ITTTT   MI              /* Slot0: */
    ADDMI   R3,R0,#0xFF     /* No! */
    ADDMI   R4,R0,#0xFF     /* No! */
    ADDMI   R5,R0,#0xFF     /* No! */
    ADDMI   R6,R0,#0xFF     /* No! */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R9      /* Restore PRIMASK register */
    /*------------------------------------------------------------------------*/
    /* !! We need to update signature !! */
    BL      m33_cst_status_test1_sum_result_to_r7
   
    
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    NOP                     /* Slot0: */
    SUBS    R0,R0,R1        /* Slot1: ALU1 sets N flag */
    NOP                     /* Slot0: */
    ITTTE   PL              /* Slot1: */
    ADDPL   R3,R3,#0xFF     /* No ! */
    ADDPL   R4,R4,#0xFF     /* No ! */
    ADDPL   R5,R5,#0xFF     /* No ! */
    ADDMI   R6,R6,R1        /* Yes! */
    /* !! We need to update signature !! */
    BL      m33_cst_status_test1_sum_result_to_r7
    
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    NOP                     /* Slot0: */    
    ADDS    R2,R2,R1        /* Slot1: ALU1 clears N flag */
    NOP                     /* Slot0: */
    ITTTE   PL              /* Slot1: */
    ADDPL   R3,R3,R1        /* Yes ! */
    ADDPL   R4,R4,R1        /* Yes ! */
    ADDPL   R5,R5,R1        /* Yes ! */
    ADDMI   R6,R6,#0xFF     /* No! */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R9      /* Restore PRIMASK register */
    /*------------------------------------------------------------------------*/
    /* !! We need to update signature !! */
    BL      m33_cst_status_test1_sum_result_to_r7
    
    
    /**************************************************************************
    * Test Conditions - EQ,NE
    *  ITTEE, ITEEE
    ***************************************************************************/
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    EORS    R0,R0           /* Slot0: ALU0 sets Z flag */
    NOP                     /* Slot1: */
    ITTEE   NE              /* Slot0: */
    ADDNE   R3,R3,#0xFF     /* No ! */
    ADDNE   R4,R4,#0xFF     /* No ! */
    ADDEQ   R5,R5,R1        /* Yes! */
    ADDEQ   R6,R6,R1        /* Yes! */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R9      /* Restore PRIMASK register */
    /*------------------------------------------------------------------------*/
    /* !! We need to update signature !! */
    BL      m33_cst_status_test1_sum_result_to_r7
    
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    ADDS    R2,R2,R1        /* Slot0: ALU0 Clears Z flag */
    NOP                     /* Slot1: */
    ITTEE   NE              /* Slot0: */
    ADDNE   R3,R3,R1        /* Yes! */
    ADDNE   R4,R4,R1        /* Yes! */
    ADDEQ   R5,R5,#0xFF     /* No ! */
    ADDEQ   R6,R6,#0xFF     /* No ! */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R9      /* Restore PRIMASK register */
    /*------------------------------------------------------------------------*/
    /* !! We need to update signature !! */
    BL      m33_cst_status_test1_sum_result_to_r7
    
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    NOP                     /* Slot0: */
    EORS    R0,R0           /* Slot1: ALU1 sets Z flag */
    NOP                     /* Slot0: */
    ITEEE   EQ              /* Slot1: */
    ADDEQ   R3,R3,R1        /* Yes! */
    ADDNE   R4,R4,#0xFF     /* No ! */
    ADDNE   R5,R5,#0xFF     /* No ! */
    ADDNE   R6,R6,#0xFF     /* No ! */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R9      /* Restore PRIMASK register */
    /*------------------------------------------------------------------------*/
    /* !! We need to update signature !! */
    BL      m33_cst_status_test1_sum_result_to_r7
    
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    NOP                     /* Slot0: */
    ADDS    R2,R2,R1        /* Slot1: ALU1 clears Z flag */
    NOP                     /* Slot0: */
    ITEEE   EQ              /* Slot1: */
    ADDEQ   R3,R3,#0xFF     /* No ! */
    ADDNE   R4,R4,R1        /* Yes! */
    ADDNE   R5,R5,R1        /* Yes! */
    ADDNE   R6,R6,R1        /* Yes! */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R9      /* Restore PRIMASK register */
    /*------------------------------------------------------------------------*/
    /* !! We need to update signature !! */
    BL      m33_cst_status_test1_sum_result_to_r7
    
    
    /**************************************************************************
    * Test Conditions - CS,CC
    *  ITTT, ITTE
    ***************************************************************************/
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    LSLS    R2,R2,#30   /* Slot0: ALU0 sets C flag */
    NOP                 /* Slot1: */
    ITTT    CC          /* Slot0: */
    ADDCC   R3,R3,#0xFF /* No ! */
    ADDCC   R4,R4,#0xFF /* No ! */
    ADDCC   R5,R5,#0xFF /* No ! */
    ADD     R6,R6,R1    /* Yes! - out of IT block */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R9      /* Restore PRIMASK register */
    /*------------------------------------------------------------------------*/
    /* !! We need to update signature !! */
    BL      m33_cst_status_test1_sum_result_to_r7
     
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    ADDS    R8,R2,R0    /* Slot0: ALU0 clears C flag */
    NOP                 /* Slot1: */
    ITTT    CC          /* Slot0: */
    ADDCC   R3,R3,R1    /* Yes ! */
    ADDCC   R4,R4,R1    /* Yes ! */
    ADDCC   R5,R5,R1    /* Yes ! */
    ADD     R6,R6,R1    /* Yes - out of IT block */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R9      /* Restore PRIMASK register */
    /*------------------------------------------------------------------------*/
    /* !! We need to update signature !! */
    BL      m33_cst_status_test1_sum_result_to_r7
    
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    NOP                 /* Slot0: */    
    LSLS    R2,R3,#30   /* Slot1: ALU1 sets C flag */
    NOP                 /* Slot0: */    
    ITTE    CS          /* Slot1: */
    ADDCS   R3,R3,R1    /* Yes ! */
    ADDCS   R4,R4,R1    /* Yes ! */
    ADDCC   R5,R5,#0xFF /* No  ! */
    ADD     R6,R6,R1    /* Yes - out of IT block */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R9      /* Restore PRIMASK register */
    /*------------------------------------------------------------------------*/
    /* !! We need to update signature !! */
    BL      m33_cst_status_test1_sum_result_to_r7
    
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    NOP                 /* Slot0: */    
    ADDS    R2,R2,R0    /* Slot1: ALU1 clears C flag */
    NOP                 /* Slot0: */    
    ITTE    CS          /* Slot1: */
    ADDCS   R3,R3,#0xFF /* No ! */
    ADDCS   R4,R4,#0xFF /* No ! */
    ADDCC   R5,R5,R1    /* Yes! */
    ADD     R6,R6,R1    /* Yes - out of IT block */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R9      /* Restore PRIMASK register */
    /*------------------------------------------------------------------------*/
    /* !! We need to update signature !! */
    BL      m33_cst_status_test1_sum_result_to_r7
    
    
    /**************************************************************************
    * Test Conditions - VS,VC
    *  ITT, ITE
    ***************************************************************************/
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    ADDS    R2,R2,R2    /* Slot0: ALU0 sets V flag */
    NOP                 /* Slot1: */    
    ITT     VC          /* Slot0: */
    ADDVC   R3,R3,#0xFF /* No ! */       
    ADDVC   R4,R4,#0xFF /* No ! */       
    ADD     R5,R5,R1    /* Yes - out of IT block */
    ADD     R6,R6,R1    /* Yes - out of IT block */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R9      /* Restore PRIMASK register */
    /*------------------------------------------------------------------------*/
    /* !! We need to update signature !! */
    BL      m33_cst_status_test1_sum_result_to_r7
    
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    ADDS    R2,R2,R1    /* Slot0: ALU0 clears V flag */
    NOP                 /* Slot1: */
    ITT     VC          /* Slot0: */
    ADDVC   R3,R3,R1    /* Yes! */
    ADDVC   R4,R4,R1    /* Yes! */
    ADD     R5,R5,R1    /* Yes - out of IT block */
    ADD     R6,R6,R1    /* Yes - out of IT block */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R9      /* Restore PRIMASK register */
    /*------------------------------------------------------------------------*/
    /* !! We need to update signature !! */
    BL      m33_cst_status_test1_sum_result_to_r7
    
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    NOP                 /* Slot0: */    
    ADDS    R2,R2,R2    /* Slot1: ALU1 sets V flag */
    NOP                 /* Slot0: */    
    ITE     VS          /* Slot1: */
    ADDVS   R3,R3,R1    /* Yes! */
    ADDVC   R4,R4,#0xFF /* No ! */    
    ADD     R5,R5,R1    /* Yes - out of IT block */
    ADD     R6,R6,R1    /* Yes - out of IT block */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R9      /* Restore PRIMASK register */
    /*------------------------------------------------------------------------*/
    /* !! We need to update signature !! */
    BL      m33_cst_status_test1_sum_result_to_r7
    
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    NOP                 /* Slot0: */    
    ADDS    R1,R1,R0    /* Slot1: ALU1 clears V flag */
    NOP                 /* Slot0: */    
    ITE     VS          /* Slot1: */
    ADDVS   R3,R3,#0xFF /* No ! */
    ADDVC   R4,R4,R1    /* Yes! */    
    ADD     R5,R5,R1    /* Yes - out of IT block */
    ADD     R6,R6,R1    /* Yes - out of IT block */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R9      /* Restore PRIMASK register */
    /*------------------------------------------------------------------------*/
    /* !! We need to update signature !! */
    BL      m33_cst_status_test1_sum_result_to_r7
    
    
    /**************************************************************************
    * Test Conditions - HI,LS
    *  ITETT, ITTET
    ***************************************************************************/
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    LSLS    R2,R5,#29   /* Slot0: ALU0 sets (C==1)&&(Z==0) */
    NOP                 /* Slot1: */
    ITETT   HI          /* Slot0: */
    ADDHI   R3,R3,R1    /* Yes! */
    ADDLS   R4,R4,#0xFF /* No ! */
    ADDHI   R5,R5,R1    /* Yes! */
    ADDHI   R6,R6,R1    /* Yes! */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R9      /* Restore PRIMASK register */
    /*------------------------------------------------------------------------*/
    /* !! We need to update signature !! */
    BL      m33_cst_status_test1_sum_result_to_r7
    
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    EORS    R0,R0       /* Slot0: ALU0 sets (C==0)||(Z==1) */
    NOP                 /* Slot1: */
    ITTET   HI          /* Slot0: */
    ADDHI   R3,R3,#0xFF /* No ! */
    ADDHI   R4,R4,#0xFF /* No ! */
    ADDLS   R5,R5,R1    /* Yes! */
    ADDHI   R6,R6,#0xFF /* No ! */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R9      /* Restore PRIMASK register */
    /*------------------------------------------------------------------------*/
    /* !! We need to update signature !! */
    BL      m33_cst_status_test1_sum_result_to_r7
    
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    NOP                 /* Slot0: */
    LSLS    R2,R3,#29   /* Slot1: ALU1 sets (C==1)&&(Z==0) */
    NOP                 /* Slot0: */
    ITETT   LS          /* Slot1: */
    ADDLS   R3,R3,#0xFF /* No ! */
    ADDHI   R4,R4,R1    /* Yes! */
    ADDLS   R5,R5,#0xFF /* No ! */
    ADDLS   R6,R6,#0xFF /* No ! */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R9      /* Restore PRIMASK register */
    /*------------------------------------------------------------------------*/
    /* !! We need to update signature !! */
    BL      m33_cst_status_test1_sum_result_to_r7
    
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    NOP                 /* Slot0: */
    ADDS    R1,R1,R0    /* Slot1: ALU1 sets (C==0)||(Z==1) */
    ITTET   LS          /* Slot0: */
    ADDLS   R3,R3,R1    /* Yes! */
    ADDLS   R4,R4,R1    /* Yes! */
    ADDHI   R5,R5,#0xFF /* No ! */
    ADDLS   R6,R6,R1    /* Yes! */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R9      /* Restore PRIMASK register */
    /*------------------------------------------------------------------------*/
    /* !! We need to update signature !! */
    BL      m33_cst_status_test1_sum_result_to_r7
    
    
    /**************************************************************************
    * Test Conditions - GE,LT
    *  ITEET, ITET
    ***************************************************************************/
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    ADDS    R2,R8,R8    /* Slot0: ALU0 sets N==V */
    NOP                 /* Slot1: */
    ITEET   GE          /* Slot0: */
    ADDGE   R3,R3,R1    /* Yes! */
    ADDLT   R4,R4,#0xFF /* No ! */
    ADDLT   R5,R5,#0xFF /* No ! */
    ADDGE   R6,R6,R1    /* Yes! */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R9      /* Restore PRIMASK register */
    /*------------------------------------------------------------------------*/
    /* !! We need to update signature !! */
    BL      m33_cst_status_test1_sum_result_to_r7
    
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    ADDS    R2,R2,R0    /* Slot0: ALU0 sets N!=V */
    NOP                 /* Slot1: */
    ITEET   GE          /* Slot0: */
    ADDGE   R3,R3,#0xFF /* No ! */
    ADDLT   R4,R4,R1    /* Yes! */
    ADDLT   R5,R5,R1    /* Yes! */
    ADDGE   R6,R6,#0xFF /* No ! */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R9      /* Restore PRIMASK register */
    /*------------------------------------------------------------------------*/
    /* !! We need to update signature !! */
    BL      m33_cst_status_test1_sum_result_to_r7
    
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    NOP                 /* Slot0: */
    ADDS    R2,R8,R8    /* Slot1: ALU1 sets N==V */
    NOP                 /* Slot0: */
    ITET    LT          /* Slot1: */
    ADDLT   R3,R3,#0xFF /* No ! */
    ADDGE   R4,R4,R1    /* Yes! */
    ADDLT   R5,R5,#0xFF /* No ! */
    ADD     R6,R6,R1    /* Yes - out of IT block */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R9      /* Restore PRIMASK register */
    /*------------------------------------------------------------------------*/
    /* !! We need to update signature !! */
    BL      m33_cst_status_test1_sum_result_to_r7
    
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    NOP                 /* Slot0: */
    ADDS    R2,R2,R0    /* Slot1: ALU1 sets N!=V */
    NOP                 /* Slot0: */
    ITET    LT          /* Slot1: */
    ADDLT   R3,R3,R1    /* Yes! */
    ADDGE   R4,R4,#0xFF /* No ! */
    ADDLT   R5,R5,R1    /* Yes! */
    ADD     R6,R6,R1    /* Yes - out of IT block */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R9      /* Restore PRIMASK register */
    /*------------------------------------------------------------------------*/
    /* !! We need to update signature !! */
    BL      m33_cst_status_test1_sum_result_to_r7
    
    
    /**************************************************************************
    * Test Conditions - GT,LE
    *  ITEE, IT
    ***************************************************************************/
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    ADDS    R2,R8,R8    /* Slot0: ALU0 sets (Z==0)&&(N==V) */
    NOP                 /* Slot1: */
    IT      GT          /* Slot0: */
    ADDGT   R3,R3,R1    /* Yes! */
    ADD     R4,R4,R1    /* Yes - Out of IT block */
    ADD     R5,R5,R1    /* Yes - Out of IT block */
    ADD     R6,R6,R1    /* Yes - Out of IT block */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R9      /* Restore PRIMASK register */
    /*------------------------------------------------------------------------*/
    /* !! We need to update signature !! */
    BL      m33_cst_status_test1_sum_result_to_r7
    
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    ADDS    R0,R2,R2    /* Slot0: ALU0 sets (Z==1)||(N!=V) */
    NOP                 /* Slot1: */
    IT      GT          /* Slot0: */
    ADDGT   R3,R3,R1    /* Yes! */
    ADD     R4,R4,R1    /* Yes - Out of IT block */
    ADD     R5,R5,R1    /* Yes - Out of IT block */
    ADD     R6,R6,R1    /* Yes - Out of IT block */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R9      /* Restore PRIMASK register */
    /*------------------------------------------------------------------------*/
    /* !! We need to update signature !! */
    BL      m33_cst_status_test1_sum_result_to_r7
    
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    NOP                 /* Slot0: */
    ADDS    R2,R8,R8    /* Slot1: ALU1 sets (Z==0)&&(N==V) */
    NOP                 /* Slot0: */
    ITEE    LE          /* Slot1: */
    ADDLE   R3,R3,#0xFF /* No ! */
    ADDGT   R4,R4,R1    /* Yes! */
    ADDGT   R5,R5,R1    /* Yes! */
    ADD     R6,R6,R1    /* Yes - Out of IT block */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R9      /* Restore PRIMASK register */
    /*------------------------------------------------------------------------*/
    /* !! We need to update signature !! */
    BL      m33_cst_status_test1_sum_result_to_r7
    
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    NOP                 /* Slot0: */
    ADDS    R0,R2,R2    /* Slot1: ALU1 sets (Z==1)&&(N!=V) */
    NOP                 /* Slot0: */
    ITEE    LE          /* Slot1: */
    ADDLE   R3,R3,R1    /* Yes! */
    ADDGT   R4,R4,#0xFF /* No ! */
    ADDGT   R5,R5,#0xFF /* No ! */
    ADD     R6,R6,R1    /* Yes - Out of IT block */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R9      /* Restore PRIMASK register */
    /*------------------------------------------------------------------------*/
    /* !! We need to update signature !! */
    BL      m33_cst_status_test1_sum_result_to_r7
    
    
    /***************************************************************************
    * Test connection between MUL and IT block logic
    * Execute instructions which are not dual-issued inside the IT block
    ***************************************************************************/
    ADDS    R2,R1,R1    /* ALU clears Z flag */    
    ITETE   EQ
    SDIVEQ  R3,R3,R7    /* No ! */
    SDIVNE  R4,R4,R2    /* Yes! */
    SDIVEQ  R5,R5,R7    /* No ! */
    SDIVNE  R6,R6,R2    /* Yes! */
    /* !! We need to update signature !! */
    BL      m33_cst_status_test1_sum_result_to_r7
    
    MULS    R0,R0,R0    /* MUL sets Z flag */
    ITETE   EQ
    MULEQ   R3,R3,R2    /* Yes! */
    MULNE   R4,R4,R7    /* No ! */
    MULEQ   R5,R5,R2    /* Yes! */
    MULNE   R6,R6,R7    /* No ! */
    /* !! We need to update signature !! */
    BL      m33_cst_status_test1_sum_result_to_r7
    
    MULS    R2,R1,R2    /* MUL clears Z flag */
    ITET    EQ
    MULEQ   R3,R3,R7    /* No ! */
    MULNE   R4,R4,R2    /* Yes! */
    MULEQ   R5,R5,R7    /* No ! */
    MUL     R6,R6,R2    /* Yes - Out of IT block */
    /* !! We need to update signature !! */
    BL      m33_cst_status_test1_sum_result_to_r7
    
    MULS    R7,R1,R7    /* MUL sets N flag */
    ITETE   PL
    MULPL   R3,R3,R7    /* No ! */
    MULMI   R4,R4,R2    /* Yes! */
    MULPL   R5,R5,R7    /* No ! */
    MULMI   R6,R6,R2    /* Yes! */
    /* !! We need to update signature !! */
    BL      m33_cst_status_test1_sum_result_to_r7
    
    MULS    R2,R1,R2    /* MUL clears N flag */
    ITT     MI
    MULMI   R3,R3,R7    /* No! */
    MULMI   R4,R4,R7    /* No! */
    MUL     R5,R5,R2    /* Yes - Out of IT Block */
    MUL     R6,R6,R2    /* Yes - Out of IT Block */
    /* !! We need to update signature !! */
    BL      m33_cst_status_test1_sum_result_to_r7
    
    
    /*------------------------------------------------------------------------*/
    /* Test - end                                                             */
    /*------------------------------------------------------------------------*/
    MOV     R0,R7       /* Test result is returned in R0 */
    B       m33_cst_test_tail_end
    
   
    /*------------------------------------------------------------------------*/
    /* Test - internal routine                                                */
    /*------------------------------------------------------------------------*/
    /**************************************************************************/
    /* !! Updates Signature !!                                                */
    /**************************************************************************/
m33_cst_status_test1_sum_result_to_r7:
    ADD     R7,R3,R7
    ROR     R7,R7,#1
    ADD     R7,R4,R7
    ROR     R7,R7,#1
    ADD     R7,R5,R7
    ROR     R7,R7,#1
    ADD     R7,R6,R7
    BX      LR
    
    
    CST_ALIGN_BYTES_4
    /* Marks the current location for dumping psuedoinstruction pools containing
       numeric values for used symbolic names used within LDR instruction. */
    CST_LTORG

#endif  /* CORTST_M33_STATUS_ENABLE */

    CST_FILE_END

