/*
 * Copyright 2020-2025 Yuntu Microelectronics co.,ltd
 * All rights reserved.
 *
 * YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 * used strictly in accordance with the applicable license terms. By expressly
 * accepting such terms or by downloading, installing, activating and/or otherwise
 * using the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software. The production use license in
 * Section 2.3 is expressly granted for this software.
 */

/******************************************************************************
* Test summary:
* -------------
*
* Tests the cm33fpu_rf.v module ports and multiplexers to test all
* possible connections between each port and each register.
*
* Four Read ports
* ================
*  Read port 0 gets data0 for channel 0 (f0)
*  Read port 1 gets data0 for channel 1 (f0)
*  Read port 2 gets the data for a VSTR in channel 0 (f2)
*  Read port 3 gets the data for a VSTR in channel 1 (f2)
* 
* Dynamic port allocation:
* ------------------------
*  Data 2 comes from read port 0, 1, 2 or 3, depending on which one is free
*  Data 1 comes from read port 0, 1, 2 or 3, depending on which one is free
*
* Two Write ports
* ================
* The FPU has two channels, but certain instructions can only go down certain 
* channels.
*  Channel 0 deals with MULs, DIVs, SPQRTs, and the first half of MACs
*  Channel 1 deals with ADDs, all convertions, VMAXNMs, VABSs, VNEGs, VSELs and the second
*  half of MACs
*  
*  A full instruction can be dual issued with a small instruction (A VMOV or VLDR),
*  which can go down either FPU channel.
******************************************************************************/

#include "CorTst_Compiler.h"
#include "CorTst_M33_Cfg.h"

#if (CORTST_M33_FPU_ENABLE==1)

    /* Compatible with ABI. */
    CST_PRES8
    /* Symbols defined in the current module but to be visible to outside */
    CST_EXPORT M33_Cst_SpfpuRegbankTest2
    
    /* Symbols defined outside but to be used in current module */
    CST_EXTERN m33_cst_test_tail_fpu_end
    CST_EXTERN m33_cst_sum_fpu_s0_s31_to_r1_destr_r2
    CST_EXTERN m33_cst_write_fpu_regs_from_r0
    CST_EXTERN CST_RAM_TARGET0
    CST_EXTERN CST_RAM_TARGET1

    /* Pre-signature */
    CST_SET(PRESIGNATURE_SEED_0, 0xB81D)
    CST_SET(PRESIGNATURE_SEED_1, 0x90A9)

    /* Values stored in registers:
       - R1  ... accumulated signature
       - R11 ... PRIMASK register
       - R12 ... FPSCR register
    */
    
    /*------------------------------------------------------------------------*/
    CST_SECTION_EXEC(mcal_text)
    /*------------------------------------------------------------------------*/
    /* The ".type" directive instructs the assembler/linker that the label 
       "M33_Cst_SpfpuRegbankTest2" designates a function.
       This would cause setting the least significant bit to '1' within any 
       pointer to this function, causing change to Thumb mode whenever this 
       function is called. */
    CST_TYPE(M33_Cst_SpfpuRegbankTest2, function)
    CST_THUMB2
M33_Cst_SpfpuRegbankTest2:

    PUSH    {R4-R12,R14}
    MRS     R1,CONTROL  /* Store CONTROL prior first FPU instruction */
    PUSH    {R1}
    VPUSH   {S16-S31}

    /*------------------------------------------------------------------------*/
    /* Test - preparation                                                     */
    /*------------------------------------------------------------------------*/
    MOV     R1,#PRESIGNATURE_SEED_0
    MOVT    R1,#PRESIGNATURE_SEED_1

    /*------------------------------------------------------------------------*/
    /* Test - start                                                           */
    /*------------------------------------------------------------------------*/
    MRS     R11,PRIMASK /* Store PRIMASK register */
    VMRS    R12,FPSCR   /* Store FPSCR register */
    MOV     R0,#0
    VMSR    FPSCR,R0    /* Clear FPSR register */
    
    /* Load CST Memory addresses */
    LDR     R8,=CST_RAM_TARGET0
    LDR     R9,=CST_RAM_TARGET1
    
    /* Clear all FPU registers & clear TARGET0 TARGET1 memories */
    BL      m33_cst_write_fpu_regs_from_r0
    VSTMIA      R8,{S0-S12}
    VSTMIA      R9,{S0-S12}
    /* Initialize registers to can start port testing */
    MOV     R3,#0x55555555
    MOV     R4,#0xAAAAAAAA         
    VMOV    S0,S1,R3,R3
    VMOV    S2,S3,R4,R4
    VMOV    S4,S5,R4,R4
    VMOV    S6,S7,R3,R3
    /* Initialize registers with pseudo-random PRESIGNATURE */
    MVN     R2,R1   
    VMOV    S8,S9,R1,R1
    VMOV    S10,S11,R2,R2
    VMOV    S12,S13,R2,R2
    VMOV    S14,S15,R1,R1
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE   /* Port   W0    W1    R0    R1     R2     R3      */
    /*------------------------------------------------------------------------*/
    VMOV.F32    S16,S0      /* Slot0  S16   -     S0    -      -      -       */
    VADD.F32    S17,S1,S1   /* Slot1  -     S17   -     S1     S1     -       */
    VMUL.F32    S18,S2,S2   /* Slot0  S18   -     S2    -      S2     -       */
    VMOV.F32    S19,S3      /* Slot1  -     S19   -     S3     -      -       */
    
    VMOV.F32    S20,S4      /* Slot0  S20   -     S4    -      -      -       */
    VADD.F32    S21,S5,S5   /* Slot1  -     S21   -     S5     S5     -       */
    VMUL.F32    S22,S6,S6   /* Slot0  S22   -     S6    -      S6     -       */
    VMOV.F32    S23,S7      /* Slot1  -     S23   -     S7     -      -       */
    
    VMOV.F32    S24,S8      /* Slot0  S24   -     S8    -      -      -       */
    VADD.F32    S25,S9,S9   /* Slot1  -     S25   -     S9     S9     -       */
    VMUL.F32    S26,S10,S10 /* Slot0  S26   -     S10   -      S10    -       */
    VMOV.F32    S27,S11     /* Slot1  -     S27   -     S11    -      -       */
    
    VMOV.F32    S28,S12     /* Slot0  S28   -     S12   -      -      -       */
    VADD.F32    S29,S13,S13 /* Slot1  -     S29   -     S13    S13    -       */
    VMUL.F32    S30,S14,S14 /* Slot0  S30   -     S14   -      S14    -       */
    VMOV.F32    S31,S15     /* Slot1  -     S31   -     S15    -      -       */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R11     /* Restore PRIMASK register */
    /*------------------------------------------------------------------------*/
    /* !! Update Signature !! */
    BL      m33_cst_sum_fpu_s0_s31_to_r1_destr_r2
    
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE    /* Port    W0    W1    R0    R1     R2     R3    */
    /*------------------------------------------------------------------------*/
    VSTR        S0,[R8,#0]   /* Slot0   -     -     -     -      S0     -     */
    VMOV.F32    S16,S16      /* Slot1   -     -     -     -      -      -     */
    VMOV.F32    S16,S16      /* Slot0   -     -     -     -      -      -     */
    VSTR        S1,[R9,#0]   /* Slot1   -     -     -     -      -      S1    */
                                      
    VSTR        S2,[R8,#4]   /* Slot0   -     -     -     -      S2     -     */
    VMOV.F32    S16,S16      /* Slot1   -     -     -     -      -      -     */
    VMOV.F32    S16,S16      /* Slot0   -     -     -     -      -      -     */
    VSTR        S3,[R9,#4]   /* Slot1   -     -     -     -      -      S3    */
                                      
    VSTR        S4,[R8,#8]   /* Slot0   -     -     -     -      S4     -     */
    VMOV.F32    S16,S16      /* Slot1   -     -     -     -      -      -     */
    VMOV.F32    S16,S16      /* Slot0   -     -     -     -      -      -     */
    VSTR        S5,[R9,#8]   /* Slot1   -     -     -     -      -      S5    */
                                      
    VSTR        S6,[R8,#12]  /* Slot0   -     -     -     -      S6     -     */
    VMOV.F32    S16,S16      /* Slot1   -     -     -     -      -      -     */
    VMOV.F32    S16,S16      /* Slot0   -     -     -     -      -      -     */
    VSTR        S7,[R9,#12]  /* Slot1   -     -     -     -      -      S7    */
                                                                        
    VSTR        S8,[R8,#16]  /* Slot0   -     -     -     -      S8     -     */
    VMOV.F32    S16,S16      /* Slot1   -     -     -     -      -      -     */
    VMOV.F32    S16,S16      /* Slot0   -     -     -     -      -      -     */
    VSTR        S9,[R9,#16]  /* Slot1   -     -     -     -      -      S9    */
                                                                        
    VSTR        S10,[R8,#20] /* Slot0   -     -     -     -      S10    -     */
    VMOV.F32    S16,S16      /* Slot1   -     -     -     -      -      -     */
    VMOV.F32    S16,S16      /* Slot0   -     -     -     -      -      -     */
    VSTR        S11,[R9,#20] /* Slot1   -     -     -     -      -      S11   */
                                                                        
    VSTR        S12,[R8,#24] /* Slot0   -     -     -     -      S12    -     */
    VMOV.F32    S16,S16      /* Slot1   -     -     -     -      -      -     */
    VMOV.F32    S16,S16      /* Slot0   -     -     -     -      -      -     */
    VSTR        S13,[R9,#24] /* Slot1   -     -     -     -      -      S13   */
                                                                        
    VSTR        S14,[R8,#28] /* Slot0   -     -     -     -      S14    -     */
    VMOV.F32    S16,S16      /* Slot1   -     -     -     -      -      -     */
    VMOV.F32    S16,S16      /* Slot0   -     -     -     -      -      -     */
    VSTR        S15,[R9,#28] /* Slot1   -     -     -     -      -      S15   */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R11     /* Restore PRIMASK register */
    /*------------------------------------------------------------------------*/
    
    /* !! Update Signature !! */
    VLDMIA  R8,{S0-S7}
    VLDMIA  R9,{S8-S16}
    BL      m33_cst_sum_fpu_s0_s31_to_r1_destr_r2
    
    
    /* Initialize registers with updated SIGNATURE */
    MVN     R2,R1
    VMOV    S8,S9,R1,R1
    VMOV    S10,S11,R2,R2
    VMOV    S12,S13,R2,R2
    VMOV    S14,S15,R1,R1
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE   /* Port   W0    W1    R0    R1     R2     R3      */
    /*------------------------------------------------------------------------*/
    VMOV.F32    S17,S1      /* Slot0  S17   -     S1    -      -      -       */
    VADD.F32    S16,S0,S0   /* Slot1  -     S16   -     S0     S0     -       */
    VMUL.F32    S19,S3,S3   /* Slot0  S19   -     S3    -      S3     -       */
    VMOV.F32    S18,S2      /* Slot1  -     S18   -     S2     -      -       */
    
    VMOV.F32    S21,S5      /* Slot0  S21   -     S5    -      -      -       */
    VADD.F32    S20,S4,S4   /* Slot1  -     S20   -     S4     S4     -       */
    VMUL.F32    S23,S7,S7   /* Slot0  S23   -     S7    -      S7     -       */
    VMOV.F32    S22,S6      /* Slot1  -     S22   -     S6     -      -       */
    
    VMOV.F32    S25,S9      /* Slot0  S25   -     S9    -      -      -       */
    VADD.F32    S24,S8,S8   /* Slot1  -     S24   -     S8     S8     -       */
    VMUL.F32    S27,S11,S11 /* Slot0  S27   -     S11   -      S11    -       */
    VMOV.F32    S26,S10     /* Slot1  -     S26   -     S10    -      -       */
    
    VMOV.F32    S29,S13     /* Slot0  S29   -     S13   -      -      -       */
    VADD.F32    S28,S12,S12 /* Slot1  -     S28   -     S12    S12    -       */
    VMUL.F32    S31,S15,S15 /* Slot0  S31   -     S15   -      S15    -       */
    VMOV.F32    S30,S14     /* Slot1  -     S30   -     S14    -      -       */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R11     /* Restore PRIMASK register */
    /*------------------------------------------------------------------------*/
    
    /* !! Update Signature !! */
    BL      m33_cst_sum_fpu_s0_s31_to_r1_destr_r2
    
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE    /* Port    W0    W1    R0    R1     R2     R3    */
    /*------------------------------------------------------------------------*/
    VSTR    S1,[R9,#28]     /* Slot0   -     -     -     -      S1     -     */
    VMOV.F32    S16,S16     /* Slot1   -     -     -     -      -      -     */
    VMOV.F32    S16,S16     /* Slot0   -     -     -     -      -      -     */
    VSTR    S0,[R8,#28]     /* Slot1   -     -     -     -      -      S0    */
                                      
    VSTR    S3,[R9,#24]     /* Slot0   -     -     -     -      S3     -     */
    VMOV.F32    S16,S16     /* Slot1   -     -     -     -      -      -     */
    VMOV.F32    S16,S16     /* Slot0   -     -     -     -      -      -     */
    VSTR    S2,[R8,#24]     /* Slot1   -     -     -     -      -      S2    */
                                      
    VSTR    S5,[R9,#20]     /* Slot0   -     -     -     -      S5     -     */
    VMOV.F32    S16,S16     /* Slot1   -     -     -     -      -      -     */
    VMOV.F32    S16,S16     /* Slot0   -     -     -     -      -      -     */
    VSTR    S4,[R8,#20]     /* Slot1   -     -     -     -      -      S4    */
                                      
    VSTR    S7,[R9,#16]     /* Slot0   -     -     -     -      S7     -     */
    VMOV.F32    S16,S16     /* Slot1   -     -     -     -      -      -     */
    VMOV.F32    S16,S16     /* Slot0   -     -     -     -      -      -     */
    VSTR    S6,[R8,#16]     /* Slot1   -     -     -     -      -      S6    */
                                                                        
    VSTR    S9,[R9,#12]     /* Slot0   -     -     -     -      S9     -     */
    VMOV.F32    S16,S16     /* Slot1   -     -     -     -      -      -     */
    VMOV.F32    S16,S16     /* Slot0   -     -     -     -      -      -     */
    VSTR    S8,[R8,#12]     /* Slot1   -     -     -     -      -      S8    */
                                                                        
    VSTR    S11,[R9,#8]     /* Slot0   -     -     -     -      S11    -     */
    VMOV.F32    S16,S16     /* Slot1   -     -     -     -      -      -     */
    VMOV.F32    S16,S16     /* Slot0   -     -     -     -      -      -     */
    VSTR    S10,[R8,#8]     /* Slot1   -     -     -     -      -      S10   */
                                                                        
    VSTR    S13,[R9,#4]     /* Slot0   -     -     -     -      S13    -     */
    VMOV.F32    S16,S16     /* Slot1   -     -     -     -      -      -     */
    VMOV.F32    S16,S16     /* Slot0   -     -     -     -      -      -     */
    VSTR    S12,[R8,#4]     /* Slot1   -     -     -     -      -      S12   */
                                                                        
    VSTR    S15,[R9,#0]     /* Slot0   -     -     -     -      S15    -     */
    VMOV.F32    S16,S16     /* Slot1   -     -     -     -      -      -     */
    VMOV.F32    S16,S16     /* Slot0   -     -     -     -      -      -     */
    VSTR    S14,[R8,#0]     /* Slot1   -     -     -     -      -      S14   */
   /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R11     /* Restore PRIMASK register */
   /*------------------------------------------------------------------------*/
   
    
    /* !! Update Signature !! */
    VLDMIA  R8,{S0-S7}
    VLDMIA  R9,{S8-S16}
    BL      m33_cst_sum_fpu_s0_s31_to_r1_destr_r2
    
    
    /* Clear all FPU registers & clear TARGET0 TARGET1 memories */
    BL      m33_cst_write_fpu_regs_from_r0
    VSTMIA      R8,{S0-S12}
    VSTMIA      R9,{S0-S12}
    /* Initialize registers to can start port testing */
    MOV         R3,#0xCCCCCCCC
    MOV         R4,#0x33333333
    VMOV        S16,S17,R3,R3
    VMOV        S18,S19,R4,R4
    VMOV        S20,S21,R4,R4
    VMOV        S22,S23,R3,R3
    /* Initialize registers with updated SIGNATURE */
    MVN         R2,R1 
    VMOV        S24,S25,R1,R1
    VMOV        S26,S27,R2,R2
    VMOV        S28,S29,R2,R2
    VMOV        D15,R1,R1   
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE   /* Port   W0    W1    R0    R1     R2     R3      */
    /*------------------------------------------------------------------------*/
    VMOV.F32    S0,S16      /* Slot0  S0    -     S16   -      -      -       */
    VADD.F32    S1,S17,S17  /* Slot1  -     S1    -     S17    S17    -       */
    VMUL.F32    S2,S18,S18  /* Slot0  S2    -     S18    -     S18    -       */
    VMOV.F32    S3,S19      /* Slot1  -     S3    -     S19    -      -       */
    
    VMOV.F32    S4,S20      /* Slot0  S4    -     S20   -      -      -       */
    VADD.F32    S5,S21,S21  /* Slot1  -     S5    -     S21    S21    -       */
    VMUL.F32    S6,S22,S22  /* Slot0  S6    -     S22   -      S22    -       */
    VMOV.F32    S7,S23      /* Slot1  -     S7    -     S23    -      -       */
    
    VMOV.F32    S8,S24      /* Slot0  S8    -     S24   -      -      -       */
    VADD.F32    S9,S25,S25  /* Slot1  -     S9    -     S25    S25    -       */
    VMUL.F32    S10,S26,S26 /* Slot0  S10   -     S26   -      S26    -       */
    VMOV.F32    S11,S27     /* Slot1  -     S11   -     S27    -      -       */
    
    VMOV.F32    S12,S28     /* Slot0  S12   -     S28   -      -      -       */
    VADD.F32    S13,S29,S29 /* Slot1  -     S13   -     S29    S29    -       */
    VMUL.F32    S14,S30,S30 /* Slot0  S14   -     S30   -      S30    -       */
    VMOV.F32    S15,S31     /* Slot1  -     S15   -     S31    -      -       */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R11     /* Restore PRIMASK register */
    /*------------------------------------------------------------------------*/
    
    /* !! Update Signature !! */
    BL      m33_cst_sum_fpu_s0_s31_to_r1_destr_r2
    
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE    /* Port    W0    W1    R0    R1     R2     R3    */
    /*------------------------------------------------------------------------*/
    VSTR    S16,[R8]        /* Slot0   -     -     -     -      S16    -     */
    VMOV.F32    S0,S0       /* Slot1   -     -     -     -      -      -     */
    VMOV.F32    S0,S0       /* Slot0   -     -     -     -      -      -     */
    VSTR    S17,[R9]        /* Slot1   -     -     -     -      -      S17   */
                                      
    VSTR    S18,[R8,#4]     /* Slot0   -     -     -     -      S18    -     */
    VMOV.F32    S0,S0       /* Slot1   -     -     -     -      -      -     */
    VMOV.F32    S0,S0       /* Slot0   -     -     -     -      -      -     */
    VSTR    S19,[R9,#4]     /* Slot1   -     -     -     -      -      S19   */
                                      
    VSTR    S20,[R8,#8]     /* Slot0   -     -     -     -      S20    -     */
    VMOV.F32    S0,S0       /* Slot1   -     -     -     -      -      -     */
    VMOV.F32    S0,S0       /* Slot0   -     -     -     -      -      -     */
    VSTR    S21,[R9,#8]     /* Slot1   -     -     -     -      -      S21   */
                                      
    VSTR    S22,[R8,#12]    /* Slot0   -     -     -     -      S22    -     */
    VMOV.F32    S0,S0       /* Slot1   -     -     -     -      -      -     */
    VMOV.F32    S0,S0       /* Slot0   -     -     -     -      -      -     */
    VSTR    S23,[R9,#12]    /* Slot1   -     -     -     -      -      S23   */
                                                                       
    VSTR    S24,[R8,#16]    /* Slot0   -     -     -     -      S24    -     */
    VMOV.F32    S0,S0       /* Slot1   -     -     -     -      -      -     */
    VMOV.F32    S0,S0       /* Slot0   -     -     -     -      -      -     */
    VSTR    S25,[R9,#16]    /* Slot1   -     -     -     -      -      S25   */
                                                                        
    VSTR    S26,[R8,#20]    /* Slot0   -     -     -     -      S26    -     */
    VMOV.F32    S0,S0       /* Slot1   -     -     -     -      -      -     */
    VMOV.F32    S0,S0       /* Slot0   -     -     -     -      -      -     */
    VSTR    S27,[R9,#20]    /* Slot1   -     -     -     -      -      S27   */
                                                                        
    VSTR    S28,[R8,#24]    /* Slot0   -     -     -     -      S28    -     */
    VMOV.F32    S0,S0       /* Slot1   -     -     -     -      -      -     */
    VMOV.F32    S0,S0       /* Slot0   -     -     -     -      -      -     */
    VSTR    S29,[R9,#24]    /* Slot1   -     -     -     -      -      S29   */
                                                                        
    VSTR    S30,[R8,#28]    /* Slot0   -     -     -     -      S30    -     */
    VMOV.F32    S0,S0       /* Slot1   -     -     -     -      -      -     */
    VMOV.F32    S0,S0       /* Slot0   -     -     -     -      -      -     */
    VSTR    S31,[R9,#28]    /* Slot1   -     -     -     -      -      S31   */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R11     /* Restore PRIMASK register */
    /*------------------------------------------------------------------------*/
    
    /* !! Update Signature !! */
    VLDMIA  R8,{S16-S23}
    VLDMIA  R9,{S24-S31}
    BL      m33_cst_sum_fpu_s0_s31_to_r1_destr_r2
    
    /* Initialize registers with updated SIGNATURE */
    MVN     R2,R1
    VMOV    S24,S25,R1,R1
    VMOV    S26,S27,R2,R2
    VMOV    S28,S29,R2,R2
    VMOV    D15,R1,R1
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE   /* Port   W0    W1    R0    R1     R2     R3      */
    /*------------------------------------------------------------------------*/
    VMOV.F32    S1,S17      /* Slot0  S1    -     S17   -      -      -       */
    VADD.F32    S0,S16,S16  /* Slot1  -     S0    -     S16    S16    -       */
    VMUL.F32    S3,S19,S19  /* Slot0  S3    -     S19   -      S19    -       */
    VMOV.F32    S2,S18      /* Slot1  -     S2    -     S18    -      -       */
    
    VMOV.F32    S5,S21      /* Slot0  S5    -     S21   -      -      -       */
    VADD.F32    S4,S20,S20  /* Slot1  -     S4    -     S20    S20    -       */
    VMUL.F32    S7,S23,S23  /* Slot0  S7    -     S23   -      S23    -       */
    VMOV.F32    S6,S22      /* Slot1  -     S6    -     S22    -      -       */
    
    VMOV.F32    S9,S25      /* Slot0  S9    -     S25   -      -      -       */
    VADD.F32    S8,S24,S24  /* Slot1  -     S8    -     S24    S24    -       */
    VMUL.F32    S11,S27,S27 /* Slot0  S11   -     S27   -      S27    -       */
    VMOV.F32    S10,S26     /* Slot1  -     S10   -     S26    -      -       */
    
    VMOV.F32    S13,S29     /* Slot0  S13   -     S29   -      -      -       */
    VADD.F32    S12,S28,S28 /* Slot1  -     S12   -     S28    S28    -       */
    VMUL.F32    S15,S31,S31 /* Slot0  S15   -     S31   -      S31    -       */
    VMOV.F32    S14,S30     /* Slot1  -     S14   -     S30    -      -       */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R11     /* Restore PRIMASK register */
    /*------------------------------------------------------------------------*/
    
    /* !! Update Signature !! */
    BL          m33_cst_sum_fpu_s0_s31_to_r1_destr_r2
    
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE    /* Port   W0    W1    R0    R1     R2     R3     */
    /*------------------------------------------------------------------------*/
    VSTR    S17,[R8,#28]    /* Slot0  -     -     -     -      S17    -      */
    VMOV.F32    S0,S0       /* Slot1  -     -     -     -      -      -      */
    VMOV.F32    S0,S0       /* Slot0  -     -     -     -      -      -      */
    VSTR    S16,[R9,#28]    /* Slot1  -     -     -     -      -      S16    */
                             
    VSTR    S19,[R8,#24]    /* Slot0  -     -     -     -      S19    -      */
    VMOV.F32    S0,S0       /* Slot1  -     -     -     -      -      -      */
    VMOV.F32    S0,S0       /* Slot0  -     -     -     -      -      -      */
    VSTR    S18,[R9,#24]    /* Slot1  -     -     -     -      -      S18    */
                             
    VSTR    S21,[R8,#20]    /* Slot0  -     -     -     -      S21    -      */
    VMOV.F32    S0,S0       /* Slot1  -     -     -     -      -     -       */
    VMOV.F32    S0,S0       /* Slot0  -     -     -     -      -     -       */
    VSTR    S20,[R9,#20]    /* Slot1  -     -     -     -      -     S20     */
                             
    VSTR    S23,[R8,#16]    /* Slot0  -     -     -     -      S23   -       */
    VMOV.F32    S0,S0       /* Slot1  -     -     -     -      -     -       */
    VMOV.F32    S0,S0       /* Slot0  -     -     -     -      -     -       */
    VSTR    S22,[R9,#16]    /* Slot1  -     -     -     -      -     S22     */
                             
    VSTR    S25,[R8,#12]    /* Slot0  -     -     -     -      S25   -       */
    VMOV.F32    S0,S0       /* Slot1  -     -     -     -      -     -       */
    VMOV.F32    S0,S0       /* Slot0  -     -     -     -      -     -       */
    VSTR    S24,[R9,#12]    /* Slot1  -     -     -     -      -     S24     */
                             
    VSTR    S27,[R8,#8]     /* Slot0  -     -     -     -      S27   -       */
    VMOV.F32    S0,S0       /* Slot1  -     -     -     -      -     -       */
    VMOV.F32    S0,S0       /* Slot0  -     -     -     -      -     -       */
    VSTR    S26,[R9,#8]     /* Slot1  -     -     -     -      -     S26     */
                             
    VSTR    S29,[R8,#4]     /* Slot0  -     -     -     -      S29   -       */
    VMOV.F32    S0,S0       /* Slot1  -     -     -     -      -     -       */
    VMOV.F32    S0,S0       /* Slot0  -     -     -     -      -     -       */
    VSTR    S28,[R9,#4]     /* Slot1  -     -     -     -      -     S28     */
                             
    VSTR    S31,[R8]        /* Slot0  -     -     -     -      S31   -       */
    VMOV.F32    S0,S0       /* Slot1  -     -     -     -      -     -       */
    VMOV.F32    S0,S0       /* Slot0  -     -     -     -      -     -       */
    VSTR    S30,[R9]        /* Slot1  -     -     -     -      -     S30     */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R11     /* Restore PRIMASK register */
    /*------------------------------------------------------------------------*/

    /* !! Update Signature !! */
    VLDMIA  R8,{S16-S23}
    VLDMIA  R9,{S24-S31}
    BL      m33_cst_sum_fpu_s0_s31_to_r1_destr_r2
    
    
    /*------------------------------------------------------------------------*/
    /* Test - end                                                             */
    /*------------------------------------------------------------------------*/
m33_cst_spfpu_regbank_test2_end:
    VMSR    FPSCR,R12   /* Restore FPSCR register */
    /* Test result is returned in R0, according to the conventions */
    MVN     R0,R1 
    B       m33_cst_test_tail_fpu_end 
    
    
    CST_ALIGN_BYTES_4
    /* Marks the current location for dumping psuedoinstruction pools containing
       numeric values for used symbolic names used within LDR instruction. */
    CST_LTORG

#endif  /* CORTST_M33_FPU_ENABLE */

    CST_FILE_END

