/*
 * Copyright 2020-2025 Yuntu Microelectronics co.,ltd
 * All rights reserved.
 *
 * YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 * used strictly in accordance with the applicable license terms. By expressly
 * accepting such terms or by downloading, installing, activating and/or otherwise
 * using the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software. The production use license in
 * Section 2.3 is expressly granted for this software.
 */

/******************************************************************************
* Test summary:
* -------------
* Tests double and SIMD saturation commands with all possible saturation 
* conditions (size, saturation takes place / no saturation) as well as their 
* decoding.
* Where applicable, condition flag (Q) is set and checked explicitly.
*                               
* Decoder coverage:
* ----------------
* Thumb (16-bit) DECODER:
*  - QDADD, QDSUB, QADD, QADD16, QADD8, QSUB, QSUB16, QSUB8, UQADD16, 
*    UQASX, UQSAX, UQSUB16, UQADD8, UQSUB8
*  - TEQ(register), TEQ(immediate)
******************************************************************************/

#include "CorTst_Compiler.h"
#include "CorTst_M33_Cfg.h"

#if (CORTST_M33_SIMDSAT_ENABLE==1)
    /* Compatible with ABI. */
    CST_PRES8
    /* Symbols defined in the current module but to be visible to outside */
    CST_EXPORT M33_Cst_SimdsatTest1
    
    /* Symbols defined outside but used within current module */
    CST_EXTERN m33_cst_test_tail_end

    /*------------------------------------------------------------------------*/
    CST_SECTION_EXEC(mcal_text)
    /*------------------------------------------------------------------------*/
    /* The ".type" directive instructs the assembler/linker that the label 
       "M33_Cst_SimdsatTest1" designates a function.
       This would cause setting the least significant bit to '1' within any 
       pointer to this function, causing change to Thumb mode whenever this 
       function is called. */
    CST_THUMB2
    CST_TYPE(M33_Cst_SimdsatTest1, function)
M33_Cst_SimdsatTest1:

    PUSH    {R4-R12,R14}
    
    /*------------------------------------------------------------------------*/
    /* Test - preparation                                                     */
    /*------------------------------------------------------------------------*/
    MOV     R0,#0x00FE00FE
    MUL     R0,R0,R0    /* Prepare presignature */
    PUSH    {R0}        /* R0=0xF808FC04 */
    
    /*------------------------------------------------------------------------*/
    /* Test - start                                                           */
    /*------------------------------------------------------------------------*/
    MOV     R0,#0   /* Use R0 for flags clearing */
    
    CST_OPCODE_START
    CST_OPCODE16(0xF380)       /* MSR     APSR,R0 */     
    CST_OPCODE16(0x8C00)       /* Clears APSR_nzcvq, APSR_ge */    
    CST_OPCODE_END
    
    
    /**************************************************************************/
    /* QDADD - without saturation                                             */
    /**************************************************************************/
    MOV     R10,#0x22222222
    MOV     R5,#0x11111111
    /* Saturation not expected !! */
    QDADD   R3,R5,R10
    /* Check result and Q flag */
    TEQ     R3,#0x55555555      /* Check result - Set Z flag */
    MRS     R14,APSR            /* Load flags */
    TEQ     R14,#(1<<30)        /* Check flags - Z==1 and Q==0 */
    BNE     m33_cst_simdsat_test1_end
   
    RSB     R5,R10,#0           /* R5 =0xDDDDDDDE (-0x22222222) */
    MVN     R10,#0x11111111     /* R10=0xEEEEEEEE (-0x11111112) */     
    /* Saturation not expected !! */
    QDADD   R12,R10,R5
    /* Check result and Q flag */
    TEQ     R12,#0xAAAAAAAA     /* Check result - Set Z flag */
    MRS     R14,APSR            /* Load flags */
    TEQ     R14,#(1<<30)        /* Check flags - Z==1 and Q==0 */
    BNE     m33_cst_simdsat_test1_end
    
    /* Update signature here !!! */
    POP     {R1}
    ROR     R2,R1,#1
    QDADD   R1,R2,R1
    PUSH    {R1}        /* R1=0x6C16760A */
    
    
    /**************************************************************************/
    /* QDADD - with saturation                                                */
    /**************************************************************************/
    MOV     R9,#0x80000000      /* 0x80000000 - Saturated signed (-) value */
    MVN     R11,#0x80000000     /* 0x7FFFFFFF - Saturated signed (+) value */
    MSR     APSR_nzcvq,R0       /* Clear flags */
    
    MOV     R2,#0x40000000  
    /* Saturation expected !! */
    QDADD   R12,R0,R2           /* Saturates doubling (input operand) !! */
    /* Check result and Q flag */
    TEQ     R12,R11             /* Check result - Set Z flag */
    MRS     R14,APSR            /* Load flags */
    TEQ     R14,#(9<<27)        /* Check flags - Z==1 and Q==1 */
    BNE     m33_cst_simdsat_test1_end
    
    MSR     APSR_nzcvq,R0       /* Clear flags */
    MVN     R2,#0x40000000      /* R2=0xBFFFFFFF (-0x40000001) */ 
    /* Saturation expected !! */
    QDADD   R3,R0,R2            /* Saturates doubling (input operand) !! */
    /* Check result and Q flag */
    TEQ     R3,R9               /* Check result - Set Z flag */
    MRS     R14,APSR            /* Load flags */
    TEQ     R14,#(9<<27)        /* Check flags - Z==1 and Q==1 */
    BNE     m33_cst_simdsat_test1_end
    
    MSR     APSR_nzcvq,R0   /* Clear flags */
    MOV     R1,#0x40000000
    MOV     R2,#0x20000000
    /* Saturation expected !! */
    QDADD   R3,R1,R2            /* Saturates final addition */
    /* Check result and Q flag */
    TEQ     R3,R11              /* Check result - Set Z flag */
    MRS     R14,APSR            /* Load flags */
    TEQ     R14,#(9<<27)        /* Check flags - Z==1 and Q==1 */
    BNE     m33_cst_simdsat_test1_end
    
    MSR     APSR_nzcvq,R0       /* Clear flags */
    MVN     R1,R1               /* R1=0xBFFFFFFF (-0x40000001) */
    RSB     R2,R2,#0            /* R2=0xE0000000 (-0x20000000) */
    /* Saturation expected !! */
    QDADD   R3,R1,R2            /* Saturates final addition */
    /* Check result and Q flag */
    TEQ     R3,R9               /* Check result - Set Z flag */ 
    MRS     R14,APSR            /* Load flags */
    TEQ     R14,#(9<<27)        /* Check flags - Z==1 and Q==1 */
    BNE     m33_cst_simdsat_test1_end
    
    /* Update signature here !!! */
    POP     {R5}
    LSR     R6,R5,#16
    QDADD   R5,R5,R6
    PUSH    {R5}        /* R5=0x6C174E36  */
    
    
    /**************************************************************************/
    /* QDSUB - without saturation                                             */
    /**************************************************************************/
    /* MOV  R9, #0x80000000 - Saturated signed (-) value */
    /* MOV  R11,#0x7FFFFFFF - Saturated signed (+) value */
    MSR     APSR_nzcvq,R0       /* Clear flags */ 
    
    MOV     R10,#0x11111111
    MOV     R5,#0x77777777      
    /* Saturation not expected !! */
    QDSUB   R3,R5,R10
    /* Check result and Q flag */
    TEQ     R3,#0x55555555      /* Check result - Set Z flag */
    MRS     R14,APSR            /* Load flags */    
    TEQ     R14,#(1<<30)        /* Check flags - Z==1 and Q==0 */
    BNE     m33_cst_simdsat_test1_end
    
    RSB     R5,R10,#0           /* R5=0xEEEEEEEF  (-0x11111111) */
    MVN     R10,#0x77777777     /* R10=0x88888888 (-0x77777778) */ 
    /* Saturation not expected !! */
    QDSUB   R12,R10,R5
    /* Check result and Q flag */
    TEQ     R12,#0xAAAAAAAA     /* Check result - Set Z flag */
    MRS     R14,APSR            /* Load flags */    
    TEQ     R14,#(1<<30)        /* Check flags - Z==1 and Q==0 */
    BNE     m33_cst_simdsat_test1_end
    
    /* Update signature here !!! */
    POP     {R2}
    ROR     R3,R2,#1
    QDSUB   R2,R3,R2
    PUSH    {R2}        /* R2=0xB60BA71C */
    
    
    /**************************************************************************/
    /* QDSUB - with saturation                                                */
    /**************************************************************************/
    /* MOV  R9, #0x80000000 - Saturated signed (-) value */
    /* MOV  R11,#0x7FFFFFFF - Saturated signed (+) value */
    MSR     APSR_nzcvq,R0       /* Clear flags */
    
    MOV     R2,#0x40000000
    /* Saturation expected !! */
    QDSUB   R3,R11,R2           /* Saturate doubling !! */
    /* Check result and Q flag */
    TEQ     R3,#0               /* Check result - Set Z flag */
    MRS     R14,APSR            /* Load flags */
    TEQ     R14,#(9<<27)        /* Check flags - Z==1 and Q==1 */
    BNE     m33_cst_simdsat_test1_end
  
    MSR     APSR_nzcvq,R0       /* Clear flags */
    MVN     R2,#0x40000000      /* R2=0xBFFFFFFF (-0x40000001) */
    /* Saturation expected !! */
    QDSUB   R3,R9,R2            /* Saturate doubling !! */
    /* Check result and Q flag */
    TEQ     R3,R0               /* Check result - Set Z flag */
    MRS     R14,APSR            /* Load flags */
    TEQ     R14,#(9<<27)        /* Check flags - Z==1 and Q==1 */
    BNE     m33_cst_simdsat_test1_end
     
    MSR     APSR_nzcvq,R0       /* Clear flags */
    MVN     R1,#0x00000002      /* R1=0xFFFFFFFD */
    MOV     R2,#0x3FFFFFFF
    /* Saturation expected !! */
    QDSUB   R3,R1,R2            /* Saturates final subtraction */
    /* Check result and Q flag */
    TEQ     R3,R9               /* Check result - Set Z flag */
    MRS     R14,APSR            /* Load flags */
    TEQ     R14,#(9<<27)        /* Check flags - Z==1 and Q==1 */
    BNE     m33_cst_simdsat_test1_end
    
    MSR     APSR_nzcvq,R0       /* Clear flags */
    MVN     R1,R1               /* R1=0x00000002 */               
    RSB     R2,R2,#0            /* R2=0xC0000001 (-0x3FFFFFFF) */
    /* Saturation expected !! */
    QDSUB   R3,R1,R2            /* Saturates final subtraction */
    /* Check result and Q flag */
    TEQ     R3,R11              /* Check result - Set Z flag */
    MRS     R14,APSR            /* Load flags */
    TEQ     R14,#(9<<27)        /* Check flags - Z==1 and Q==1 */
    BNE     m33_cst_simdsat_test1_end
    
    /* Update signature here !!! */
    POP     {R3}
    LSR     R4,R3,#16
    QDSUB   R3,R3,R4
    PUSH    {R3}        /* R3=0xB60A3B06 */
    
    
    /**************************************************************************/
    /* QADD - with/without saturation                                         */
    /**************************************************************************/
    MSR     APSR_nzcvq,R0       /* Clear flags */
    
    MOV     R3,#0x22222222
    MOV     R12,#0x33333333
    /* Saturation not expected !! */
    QADD    R5,R3,R12
    /* Check result and Q flag */
    TEQ     R5,#0x55555555      /* Check result - Set Z flag */
    MRS     R14,APSR            /* Load flags */
    TEQ     R14,#(1<<30)        /* Check flags - Z==1 and Q==0 */
    BNE     m33_cst_simdsat_test1_end
    
    /* Saturation expected !! */
    QADD    R1,R5,R5
    /* Check result and Q flag */
    TEQ     R1,R11              /* Check result - Set Z flag */
    MRS     R14,APSR            /* Load flags */
    TEQ     R14,#(9<<27)        /* Check flags - Z==1 and Q==1 */
    BNE     m33_cst_simdsat_test1_end
    
    MSR     APSR_nzcvq,R0       /* Clear flags */
    
    RSB     R3,R3,#0            /* R3 =0xDDDDDDDE (-0x22222222) */
    MVN     R12,R12             /* R12=0xCCCCCCCC (-0x33333334) */
    /* Saturation not expected !! */
    QADD    R10,R12,R3
    /* Check result and Q flag */
    TEQ     R10,#0xAAAAAAAA     /* Check result - Set Z flag */
    MRS     R14,APSR            /* Load flags */
    TEQ     R14,#(1<<30)        /* Check flags - Z==1 and Q==0 */
    BNE     m33_cst_simdsat_test1_end
    
    /* Saturation expected !! */
    QADD    R1,R10,R10
    /* Check result and Q flag */
    TEQ     R1,R9               /* Check result - Set Z flag */
    MRS     R14,APSR            /* Load flags */
    TEQ     R14,#(9<<27)        /* Check flags - Z==1 and Q==1 */
    BNE     m33_cst_simdsat_test1_end
    
    /* Update signature here !!! */
    POP     {R6}
    LSR     R7,R6,#8
    QADD    R6,R6,R7    
    PUSH    {R6}        /* R6=0xB6C04541 */
    
    
    /**************************************************************************/
    /* QSUB - with/without saturation                                         */
    /**************************************************************************/
    MSR     APSR_nzcvq,R0       /* Clear flags */
    
    /* Saturation not expected !! */
    QSUB    R6,R0,R5
    /* Check result and Q flag */
    CMN     R6,#0x55555555      /* Check result - Set Z flag */
    MRS     R14,APSR            /* Load flags */
    TEQ     R14,#(3<<29)        /* Check flags - Z==1,C==1 and Q==0 */
    BNE     m33_cst_simdsat_test1_end
    
    /* Saturation expected !! */
    QSUB    R1,R5,R6
    /* Check result and Q flag */
    TEQ     R1,R11              /* Check result - Set Z flag */
    MRS     R14,APSR            /* Load flags */
    TEQ     R14,#(9<<27)        /* Check flags - Z==1 and Q==1 */
    BNE     m33_cst_simdsat_test1_end
    
    MSR     APSR_nzcvq,R0       /* Clear flags */
    
    /* Saturation not expected !! */
    QSUB    R8,R0,R10
    /* Check result and Q flag */
    CMN     R8,#0xAAAAAAAA      /* Check result - Set Z flag */
    MRS     R14,APSR            /* Load flags */
    TEQ     R14,#(3<<29)        /* Check flags - Z==1,C==1 and Q==0 */
    BNE     m33_cst_simdsat_test1_end
    
    /* Saturation expected !! */
    QSUB    R1,R10,R8
    /* Check result and Q flag */
    TEQ     R1,R9               /* Check result - Set Z flag */
    MRS     R14,APSR            /* Load flags */
    TEQ     R14,#(9<<27)        /* Check flags - Z==1 and Q==1 */
    BNE     m33_cst_simdsat_test1_end
    
    /* Update signature here !!! */
    POP     {R4}
    LSR     R2,R4,#8
    QSUB    R4,R4,R2
    PUSH    {R4}        /* R4=0xB60984FC */
    
    
    /**************************************************************************/
    /* QADD16, QADD8 - with saturation                                        */
    /**************************************************************************/
    MSR     APSR_nzcvq,R0   /* Clear flags */
    
    BIC     R4,R11,#0x00008000  /* R4=0x7FFF7FFF */
    /* Saturation expected !! */
    QADD16  R2,R5,R5
    QADD8   R3,R5,R5
    /* Check results */
    /* Unlike QADD, QADD16, QADD8 do not set Q flag !!*/
    TEQ     R2,R4               /* Check result */
    BNE     m33_cst_simdsat_test1_end 
    TEQ     R3,#0x7F7F7F7F      /* Check result */
    BNE     m33_cst_simdsat_test1_end
    
    /* Update signature here !!! */
    POP     {R2}
    AND     R3,R2,#0x000F000F
    QADD16  R2,R2,R3
    PUSH    {R2}    /* 0x09F011F8 */
      
    ORR     R4,R9,#0x00008000   /* R10=0x80008000 */
    /* Saturation expected !! */
    QADD16  R2,R10,R10
    QADD8   R3,R10,R10
    /* Check results */
    /* Unlike QADD, QADD16, QADD8 do not set Q flag !!*/
    TEQ     R2,R4               /* Check result */    
    BNE     m33_cst_simdsat_test1_end
    TEQ     R3,#0x80808080      /* Check result */
    BNE     m33_cst_simdsat_test1_end
    
    /* Update signature here !!! */
    POP     {R7}
    AND     R2,R7,#0x07070707
    QADD8   R7,R7,R2
    PUSH    {R7}    /* 0xBC148A08 */
    
    
    /**************************************************************************/
    /* QSUB16, QSUB8 - with saturation                                        */
    /**************************************************************************/
    MSR     APSR_nzcvq,R0   /* Clear flags */
    
    BIC     R4,R11,#0x00008000  /* R4=0x7FFF7FFF */
    /* Saturation expected !! */
    QSUB16  R2,R5,R6
    QSUB8   R3,R5,R6
    /* Check results */
    /* Unlike QSUB, QSUB16, QSUB8 do not set Q flag !!*/
    TEQ     R2,R4               /* Check result */
    BNE     m33_cst_simdsat_test1_end 
    TEQ     R3,#0x7F7F7F7F      /* Check result */
    BNE     m33_cst_simdsat_test1_end
    
    /* Update signature here !!! */
    POP     {R2}
    AND     R3,R2,#0x000F000F
    QSUB16  R2,R2,R3
    PUSH    {R2}        /* R8=0x04F808FC */
    
    ORR     R4,R9,#0x00008000   /* R10=0x80008000 */
    /* Saturation expected !! */
    QSUB16  R2,R10,R8
    QSUB8   R3,R10,R8
    /* Check results */
    /* Unlike QSUB, QSUB16, QSUB8 do not set Q flag !!*/
    TEQ     R2,R4               /* Check result */    
    BNE     m33_cst_simdsat_test1_end
    TEQ     R3,#0x80808080      /* Check result */
    BNE     m33_cst_simdsat_test1_end
    
    /* Update signature here !!! */
    POP     {R8}
    AND     R3,R8,#0x07070707
    QSUB8   R8,R8,R3
    PUSH    {R8}        /* R8=0xB8108800 */
    
    
    /**************************************************************************/
    /* UQADD16, UQADD8 - with saturation                                      */
    /**************************************************************************/
    /* Saturation expected !! */
    /* MOV  R1=0x80000000 - Already set in previous test */
    UQADD8  R3,R1,R1    /* Expected result: 0xFF000000 */
    UQADD16 R4,R1,R1    /* Expected result: 0xFFFF0000 */    
    LSR     R1,R1,#8        /* R1=0x00800000 */
    UQADD8  R5,R1,R1    /* Expected result: 0x00FF0000 */
    LSR     R1,R1,#8        /* R1=0x00008000 */
    UQADD16 R6,R1,R1    /* Expected result: 0x0000FFFF */
    UQADD8  R7,R1,R1    /* Expected result: 0x0000FF00 */
    LSR     R1,R1,#8        /* R1=0x00000080 */
    UQADD8  R8,R1,R1    /* Expected result: 0x000000FF */
    /* Check results */
    /* Unlike QADD, UQADD16, UQADD8 do not set Q flag !!*/
    TEQ     R3,#0xFF000000
    BNE     m33_cst_simdsat_test1_end
    TEQ     R4,R3,ASR #8
    BNE     m33_cst_simdsat_test1_end
    TEQ     R5,R3,LSR #8
    BNE     m33_cst_simdsat_test1_end
    TEQ     R7,R3,ROR #16
    BNE     m33_cst_simdsat_test1_end
    TEQ     R8,R3,ROR #24
    BNE     m33_cst_simdsat_test1_end
    TEQ     R6,R4,LSR #16
    BNE     m33_cst_simdsat_test1_end
    
    /* Update signature here !!! */
    POP     {R11}
    ROR     R2,R11,#7
    UQADD8  R2,R2,R2
    UQADD16 R11,R11,R2
    PUSH    {R11}       /* R11=0xBAF0CA20 */
    
    
    /**************************************************************************/
    /* UQSUB16, UQSUB8 - with saturation                                      */
    /**************************************************************************/
    /* Saturation expected !! */
    /* MOV  R1=0x00000080 - Already set in previous test */
    MVN     R2,R1           /* R2=0xFFFFFF7F */
    UQSUB8  R3,R2,R1    /* Expected result: 0xFFFFFF00 */    
    LSL     R1,R1,#8        /* R1=0x00008000 */
    MVN     R2,R1           /* R2=0xFFFF7FFF */
    UQSUB8  R4,R2,R1    /* Expected result: 0xFFFF00FF */    
    UQSUB16 R5,R2,R1    /* Expected result: 0xFFFF0000 */
    LSL     R1,R1,#8        /* R1=0x00800000 */        
    MVN     R2,R1           /* R2=0xFF7FFFFF */
    UQSUB8  R6,R2,R1    /* Expected result: 0xFF00FFFF */
    LSL     R1,R1,#8        /* R1=0x80000000 */        
    MVN     R2,R1           /* R2=0x7FFFFFFF */
    UQSUB8  R7,R2,R1    /* Expected result: 0x00FFFFFF */    
    UQSUB16 R8,R2,R1    /* Expected result: 0x0000FFFF */
    /* Check results */
    /* Unlike QSUB, UQSUB16, UQSUB8 do not set Q flag !!*/
    MVN     R3,R3
    TEQ     R3,#0x000000FF
    BNE     m33_cst_simdsat_test1_end
    MVN     R4,R4
    TEQ     R4,R3,LSL #8
    BNE     m33_cst_simdsat_test1_end
    MVN     R6,R6
    TEQ     R6,R3,LSL #16
    BNE     m33_cst_simdsat_test1_end
    MVN     R7,R7
    TEQ     R7,R3,LSL #24
    BNE     m33_cst_simdsat_test1_end
    TEQ     R5,R7,ASR #8
    BNE     m33_cst_simdsat_test1_end
    TEQ     R8,R5,LSR #16
    BNE     m33_cst_simdsat_test1_end
    
    /* Update signature here !!! */
    POP     {R9}
    ROR     R2,R9,#7
    UQSUB8  R2,R9,R2
    UQSUB16 R9,R9,R2
    PUSH    {R9}       /* R11=0x4175CA20 */
    
    
    /**************************************************************************/
    /* QASX, QSAX with saturation                                             */
    /**************************************************************************/
    MOV     R1,#0x40000000
    MOV     R2,#0xC0000000
    
    /* Saturation not expected !! */
    QASX    R3,R1,R1    /* Expected result: 0x4000C000 */
    QSAX    R4,R1,R1    /* Expected result: 0x40004000 */
    QASX    R5,R2,R2    /* Expected result: 0xC0004000 */
    QSAX    R6,R2,R2    /* Expected result: 0xC000C000 */ 
    /* Saturation expected !! */
    QASX    R7,R6,R3    /* Expected result: 0x80008000 */
    QASX    R8,R4,R5    /* Expected result: 0x7FFF7FFF */
    QSAX    R9,R6,R5    /* Expected result: 0x80008000 */
    QSAX    R10,R4,R3   /* Expected result: 0x7FFF7FFF */
    /* Check results */
    ORR     R11,R1,R2, LSR #16
    TEQ     R3,R11
    BNE     m33_cst_simdsat_test1_end
    TEQ     R4,#0x40004000
    BNE     m33_cst_simdsat_test1_end
    ORR     R11,R2,R1, LSR #16
    TEQ     R5,R11
    BNE     m33_cst_simdsat_test1_end
    TEQ     R6,#0xC000C000
    BNE     m33_cst_simdsat_test1_end
    TEQ     R7,#0x80008000
    BNE     m33_cst_simdsat_test1_end
    TEQ     R9,#0x80008000
    BNE     m33_cst_simdsat_test1_end
    MVN     R11,R7      /* R11=0x7FFF7FFF */
    TEQ     R8,R11
    BNE     m33_cst_simdsat_test1_end
    TEQ     R10,R11
    BNE     m33_cst_simdsat_test1_end
    
    /* Update signature here !!! */
    POP     {R10}
    BIC     R9,R10,#0xFE00FE00
    QASX    R10,R10,R9
    PUSH    {R10}       /* R10=0x4195C8AB */
    
    
    /**************************************************************************/
    /* UQASX, UQSAX with saturation                                           */
    /**************************************************************************/
    /* Saturation not expected !! */
    UQASX   R8,R3,R4    /* Expected result: 0x80008000 */
    UQSAX   R10,R5,R4   /* Expected result: 0x80008000 */
    /* Saturation expected !! */
    UQASX   R7,R5,R6    /* Expected result: 0xFFFF0000 */
    UQSAX   R9,R4,R6    /* Expected result: 0x0000FFFF */
    /* Check results */
    TEQ     R8,#0x80008000
    BNE     m33_cst_simdsat_test1_end
    TEQ     R10,#0x80008000
    BNE     m33_cst_simdsat_test1_end
    TEQ     R7,R2,ASR #14
    BNE     m33_cst_simdsat_test1_end
    TEQ     R9,R7,ROR #16
    BNE     m33_cst_simdsat_test1_end
    
    /* Update signature here !!! */
    POP     {R12}
    BIC     R11,R12,#0xFC00FC00
    QASX    R12,R12,R11
    PUSH    {R12}       /* R12=0x4240C716 */
   
    /*------------------------------------------------------------------------*/
    /* Test routine - End                                                     */
    /*------------------------------------------------------------------------*/
m33_cst_simdsat_test1_end:
    /* Test result is returned in R0, according to the conventions */
    POP     {R0}
    B       m33_cst_test_tail_end
    
    
    CST_ALIGN_BYTES_4
    /* Marks the current location for dumping psuedoinstruction pools containing
       numeric values for used symbolic names used within LDR instruction. */
    CST_LTORG

#endif  /* CORTST_M33_SIMDSAT_ENABLE */

    CST_FILE_END

