/*
 * Copyright 2020-2025 Yuntu Microelectronics co.,ltd
 * All rights reserved.
 *
 * YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 * used strictly in accordance with the applicable license terms. By expressly
 * accepting such terms or by downloading, installing, activating and/or otherwise
 * using the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software. The production use license in
 * Section 2.3 is expressly granted for this software.
 */

/******************************************************************************
* Test summary:
* -------------
* Tests the REGISTER-FILE module ports and multiplexors to test all possible
* connections between each port and each register.
*
* Note, that the REGISTER-FILE module has six read-ports (A0,A1,B0,B1,C0,C1)
* and four write-ports (W0,W1,W2,W3) connected to the data processing unit.
*
* Connections between each read-port and each register is explicitly tested. 
* Connections between each write-port and each register is explicitly tested.
*
* Each read-port is stimulated with at least 12 test vectors. 
* Each write-port is stimulated with at least 12 test vectors.
*
* Masking of bit0 and bit1 is tested for the R13(SP) register.
* 
* Note, that test vector instructions ensure that their input parameters are 
* taken directly from the REGISTER-FILE module and not using the FORWARDING 
* logic!!
******************************************************************************/

#include "CorTst_Compiler.h"
#include "CorTst_M33_Cfg.h"

#if (CORTST_M33_REGISTER_ENABLE==1)
    /* Compatible with ABI. */
    CST_PRES8
    /* Symbols defined in the current module but to be visible to outside */
    CST_EXPORT M33_Cst_RegbankTest

    /* Symbols defined outside but used within current module */
    CST_EXTERN m33_cst_test_tail_end
    CST_EXTERN CST_RAM_TARGET0
    CST_EXTERN CST_RAM_TARGET1
    

    /*------------------------------------------------------------------------*/
    CST_SECTION_EXEC(mcal_text)
    /*------------------------------------------------------------------------*/
    /* The ".type" directive instructs the assembler/linker that the label 
       "M33_Cst_RegbankTest" designates a function.
       This would cause setting the least significant bit to '1' within any 
       pointer to this function, causing change to Thumb mode whenever this 
       function is called. */
    CST_THUMB2
    CST_TYPE(M33_Cst_RegbankTest, function)
M33_Cst_RegbankTest:

    PUSH    {R4-R12,R14}
    
    /*------------------------------------------------------------------------*/
    /* Test - preparation                                                     */
    /*------------------------------------------------------------------------*/
    MOV     R0,#0x1BD1
    MOV     R1,#0xF7F
    MOV     R2,#0x7F
    MUL     R0,R0,R1
    MUL     R0,R0,R2    /* PRESIGNATURE=0xD5D6CBD1 */
    
    /*------------------------------------------------------------------------*/
    /* Test start                                                             */
    /*------------------------------------------------------------------------*/
    MRS     R12,PRIMASK                 /* Load PRIMASK register              */
    PUSH    {R0,R12}                    /* Store PRESIGNITURE and PRIMASK     */
    
    /**************************************************************************/
    /*  Test read ports A0,A1,B0,B1,C0,C1 and their connections to R0-R14     */
    /*  registers.                                                            */
    /**************************************************************************/
    /*                                                                        */
    /*  Ports A0,A1,B0,B1 are tested by using dual-issued ALU pipeline which  */
    /*  uses ALU0 and ALU1 to execute two instructions in parallel.           */
    /*                                                                        */
    /*  Example:                            A0   B0   A1   B1                 */
    /*  --------------------------------------------------------------------- */
    /*  EOR     R6,R1,R0 - slot0 (ALU0)     R0   R1   -    -                  */
    /*  EOR     R7,R3,R2 - slot1 (ALU1)     -    -    R2   R3                 */
    /*                                                                        */
    /*  Ports C0 and C1 are tested by using the MAC pipeline because MAC uses */
    /*  C0 (and C1 for long accumulates).                                     */
    /*                                                                        */
    /*  Example:                                                C0   C1       */
    /*  --------------------------------------------------------------------- */
    /*  UMLAL   R0,R1,R0,R1                                     R0   R1       */
    /**************************************************************************/
    MOV     R0,#0x55555555  /* Initialize registers */
    MOV     R1,#0xAAAAAAAA
    MOV     R2,#0x33333333
    MOV     R3,#0xCCCCCCCC
    MOV     R4,#0x77777777
    MOV     R5,#0x88888888
    BL      m33_cst_regbank_test_clear_r6_r12
    LDR     R12,[SP,#4]     /* Load PRIMASK to R12 */
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE   /* Port   A0      B0      A1      B1     C0   C1  */
    /*------------------------------------------------------------------------*/
    EOR     R6,R1,R0        /* Slot0  R0(55)  R1(AA)  -       -      -    -   */
    EOR     R7,R3,R2        /* Slot1  -        -      R2(33)  R3(CC) -    -   */
    EOR     R8,R2,R1        /* Slot0  R1(AA)  R2(33)  -    -    -    -        */
    EOR     R9,R4,R3        /* Slot1  -       -       R3(CC)  R4(77) -    -   */
    EOR     R10,R3,R2       /* Slot0  R2(33)  R3(CC)  -       -      -    -   */
    EOR     R11,R5,R4       /* Slot1  -    -          R4(77)  R5(88) -    -   */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R12                 /* Restore PRIMASK (enable ISRs)      */
    /*------------------------------------------------------------------------*/
    /**************************************************************************/
    /*                         Port   A0    B0    A1    B1    C0      C1      */
    /**************************************************************************/
    UMLAL   R0,R1,R0,R1     /*                                R0(55)  R1(AA)  */
    UMLAL   R2,R3,R2,R3     /*                                R2(33)  R3(CC)  */
    UMLAL   R4,R5,R4,R5     /*                                R4(77)  R5(88)  */
    /*------------------------------------------------------------------------*/
    /* !! Update signature and clear R0-R12 registers !! */
    BL      m33_cst_regbank_test_sum_r0_r11_to_r12 
    
    
    MOV     R0,#0x55555555  /* Initialize registers */
    MOV     R1,#0xAAAAAAAA
    MOV     R2,#0x33333333
    MOV     R3,#0xCCCCCCCC
    MOV     R4,#0x77777777
    MOV     R5,#0x88888888
    LDR     R12,[SP,#4]     /* Load PRIMASK to R12 */
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE   /* Port   A0      B0      A1      B1     C0   C1  */
    /*------------------------------------------------------------------------*/
    EOR     R7,R4,R3        /* Slot0  R3(CC)  R4(77)  -       -      -    -   */
    EOR     R6,R0,R5        /* Slot1  -       -       R5(88)  R0(55) -    -   */
    EOR     R9,R5,R4        /* Slot0  R4(77)  R5(88)  -       -      -    -   */
    EOR     R8,R1,R0        /* Slot1  -       -       R0(55)  R1(AA) -    -   */
    EOR     R11,R0,R5       /* Slot0  R5(88)  R0(55)  -       -      -    -   */
    EOR     R10,R2,R1       /* Slot1  -       -       R1(AA)  R2(33) -    -   */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R12                 /* Restore PRIMASK (enable ISRs)      */
    /*------------------------------------------------------------------------*/
    /**************************************************************************/
    /*                         Port   A0    B0    A1    B1    C0      C1      */
    /**************************************************************************/
    UMLAL   R1,R0,R1,R0     /*                                R1(AA)  R0(55)  */
    UMLAL   R3,R2,R3,R2     /*                                R3(CC)  R2(33)  */
    UMLAL   R5,R4,R5,R4     /*                                R5(88)  R4(77)  */
    /*------------------------------------------------------------------------*/
    /* !! Update signature and clear R0-R12 registers !! */
    BL      m33_cst_regbank_test_sum_r0_r11_to_r12
    
    
    MOV     R6,#0x66666666  /* Initialize registers */
    MOV     R7,#0x99999999
    MOV     R8,#0x11111111
    MOV     R9,#0xEEEEEEEE
    MOV     R10,#0x22222222
    MOV     R11,#0xDDDDDDDD
    LDR     R12,[SP,#4]     /* Load PRIMASK to R12 */
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE   /* Port   A0      B0      A1      B1     C0   C1  */
    /*------------------------------------------------------------------------*/
    EOR     R0,R7,R6        /* Slot0  R6(66)  R7(99)  -       -      -    -   */
    EOR     R1,R9,R8        /* Slot1  -       -       R8(11)  R9(EE) -    -   */
    EOR     R2,R8,R7        /* Slot0  R7(99)  R8(11)  -       -      -    -   */
    EOR     R3,R10,R9       /* Slot1  -       -       R9(EE)  R10(22)-    -   */
    EOR     R4,R9,R8        /* Slot0  R8(11)  R9(EE)  -       -      -    -   */
    EOR     R5,R11,R10      /* Slot1  -       -       R10(22) R11(DD)-    -   */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R12                 /* Restore PRIMASK (enable ISRs)      */
    /*------------------------------------------------------------------------*/
    /**************************************************************************/
    /*                         Port   A0    B0    A1    B1    C0      C1      */
    /**************************************************************************/
    UMLAL   R6,R7,R6,R7     /*                                R6(66)  R7(99)  */
    UMLAL   R8,R9,R8,R9     /*                                R8(11)  R9(EE)  */
    UMLAL   R10,R11,R10,R11 /*                                R10(22) R11(DD) */
    /*------------------------------------------------------------------------*/
    /* !! Update signature and clear R0-R12 registers !! */
    BL      m33_cst_regbank_test_sum_r0_r11_to_r12
    
    
    MOV     R6,#0x66666666  /* Initialize registers */
    MOV     R7,#0x99999999
    MOV     R8,#0x11111111
    MOV     R9,#0xEEEEEEEE
    MOV     R10,#0x22222222
    MOV     R11,#0xDDDDDDDD
    LDR     R12,[SP,#4]     /* Load PRIMASK to R12 */
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE   /* Port   A0      B0      A1      B1     C0   C1  */
    /*------------------------------------------------------------------------*/
    EOR     R1,R10,R9       /* Slot0  R9(EE)  R10(22) -       -      -    -   */
    EOR     R0,R6,R11       /* Slot1  -       -       R11(DD) R6(66) -    -   */
    EOR     R3,R11,R10      /* Slot0  R10(22) R11(DD) -       -      -    -   */
    EOR     R2,R7,R6        /* Slot1  -       -       R6(66)  R7(99) -    -   */
    EOR     R5,R6,R11       /* Slot0  R11(DD) R6(66)  -       -      -    -   */
    EOR     R4,R8,R7        /* Slot1  -       -       R7(99)  R8(11) -    -   */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R12                 /* Restore PRIMASK (enable ISRs)      */
    /*------------------------------------------------------------------------*/
    /**************************************************************************/
    /*                         Port   A0    B0    A1    B1    C0      C1      */
    /**************************************************************************/
    UMLAL   R7,R6,R7,R6     /*                                R7(99)  R6(66)  */
    UMLAL   R9,R8,R9,R8     /*                                R9(EE)  R8(11)  */
    UMLAL   R11,R10,R11,R10 /*                                R11(DD) R10(22) */
    /*------------------------------------------------------------------------*/
    /* !! Update signature and clear R0-R12 registers !! */
    BL      m33_cst_regbank_test_sum_r0_r11_to_r12
    
    
    /**************************************************************************/
    /* Continue with testing R12,R13,R14 registers                            */
    /* Note, test that R13 register masks bit0 and bit1.                      */
    /**************************************************************************/
    MOV     R12,#0x5A5A5A5A /* Initialize registers */
    MOV     R14,#0x0F0F0F0F
    MOV     R11,#0xFFFFFFFF
    LDR     R0,[SP,#4]      /* Load PRIMASK to R0 */    
    MOV     R1,R13          /* Save stack pointer                             */
    /*------------------------------------------------------------------------*/    
    CPSID   i               /* !! Disables all interrupts !!                  */
    /*------------------------------------------------------------------------*/
    MOV     R13,R11         /* Change stack pointer - Test masking bit0,1 !!  */
    /*------------------------------------------------------------------------*/
    CST_FLUSH_PIPELINE     /* Port   A0      B0      A1      B1     C0   C1  */
    /*------------------------------------------------------------------------*/
    EOR     R2,R12,R14      /* Slot0  R14(0F) R12(5A) -       -      -    -   */
    EOR     R3,R12,R14      /* Slot1  -       -       R14(0F) R12(5A)-    -   */
    EOR     R4,R14,R12      /* Slot0  R12(5A) R14(0F) -       -      -    -   */
    EOR     R5,R14,R12      /* Slot1  -       -       R12(5A) R14(0F)-    -   */
    ADD     R6,R13,R11      /* Slot0  R11(FF) R13(FC) -       -      -    -   */
    ADD     R7,R13,R11      /* Slot1  -       -       R11(FF) R13(FC)-    -   */
    ADD     R13,R13         /* Slot0  R13(FC) R13(FC) -       -      -    -   */
    /**************************************************************************/
    /*                         Port   A0    B0    A1    B1    C0      C1      */
    /**************************************************************************/
    UMLAL   R12,R14,R12,R14 /*        -     -     -     -     R12(5A) R14(0F) */
    /**************************************************************************/
    MOV     R8,R13          /* Move result to R8 */
    MOV     R9,R12          /* Move result to R9 */
    MOV     R10,R14         /* Move result to R10*/
    /*------------------------------------------------------------------------*/
    MOV     R13,R1                      /* Restore stack pointer              */
    MSR     PRIMASK,R0                  /* Restore PRIMASK (enable ISRs)      */
    /*------------------------------------------------------------------------*/
    /* !! Update signature and clear R2-R12 registers !! */
    LDR     R12,[SP,#0]
    BL      m33_cst_regbank_test_sum_r2_r11_to_r12
    
    
    MOV     R12,#0xF0F0F0F0 /* Initialize registers */
    MOV     R14,#0xA5A5A5A5 
    MOV     R11,#0x33333333
    LDR     R0,[SP,#4]      /* Load PRIMASK to R0 */
    MOV     R1,R13          /* Save stack pointer                             */
    /*------------------------------------------------------------------------*/    
    CPSID   i               /* !! Disables all interrupts !!                  */
    /*------------------------------------------------------------------------*/
    MOV     R13,R11         /* Change stack pointer - Test masking bit0,1 !!  */
    /*------------------------------------------------------------------------*/
    CST_FLUSH_PIPELINE     /* Port   A0      B0      A1      B1     C0   C1  */
    /*------------------------------------------------------------------------*/
    EOR     R3,R12,R14      /* Slot0  R14(A5) R12(F0) -       -      -    -   */
    EOR     R4,R14,R12      /* Slot1  -       -       R12(F0) R14(A5)-    -   */
    EOR     R5,R14,R12      /* Slot0  R12(F0) R14(A5) -       -      -    -   */
    ADD     R6,R13,R11      /* Slot1  -       -       R11(33) R13(30)-    -   */
    ADD     R7,R13,R11      /* Slot0  R11(33) R13(30) -       -      -    -   */
    ADD     R13,R13         /* Slot1  -       -       R13(30) R13(30)-    -   */
    EOR     R2,R12,R14      /* Slot0  R14(A5) R12(F0) -       -      -    -   */
    /**************************************************************************/
    /*                         Port   A0    B0    A1    B1    C0      C1      */
    /**************************************************************************/
    UMLAL   R14,R12,R14,R12 /*        -     -     -     -     R14(A5) R12(F0) */
    /**************************************************************************/
    MOV     R8,R13          /* Move result to R8 */
    MOV     R9,R12          /* Move result to R9 */
    MOV     R10,R14         /* Move result to R10*/
    /*------------------------------------------------------------------------*/
    MOV     R13,R1                      /* Restore stack pointer              */
    MSR     PRIMASK,R0                  /* Restore PRIMASK (enable ISRs)      */
    /*------------------------------------------------------------------------*/
    /* !! Update signature and clear R2-R12 registers !! */
    LDR     R12,[SP,#0]
    BL      m33_cst_regbank_test_sum_r2_r11_to_r12
    
    
    /**************************************************************************/
    /* Test write ports W0,W1,W2,W3 and their connections to R0-R11 registers.*/
    /**************************************************************************/
    /*  Ports W0,W1 are tested by using dual-issued ALU operations.           */
    /*                                                                        */
    /*  Example:                            W0   W1   W2   W3                 */
    /*  --------------------------------------------------------------------- */
    /*  EOR     R0,R11,#0x55555555          R0   -    -    -                  */
    /*  EOR     R1,R11,#0xAAAAAAAA          -    R1   -    -                  */
    /**************************************************************************/
    /* R11,#0x00000000 - cleared in m33_cst_regbank_test_sum_r0_r11_to_r12   */ 
    LDR     R12,[SP,#4]     /* Load PRIMASK to R12 */
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE        /* Port   W0      W1      W2       W3        */
    /*------------------------------------------------------------------------*/
    EOR     R0,R11,#0x55555555   /* Slot0  R0(55)  -       -        -         */
    EOR     R1,R11,#0xAAAAAAAA   /* Slot1  -       R1(AA)  -        -         */
    EOR     R2,R11,#0x33333333   /* Slot0  R2(33)  -       -        -         */
    EOR     R3,R11,#0xCCCCCCCC   /* Slot1  -       R3(CC)  -        -         */
    EOR     R4,R11,#0x77777777   /* Slot0  R4(77)  -       -        -         */
    EOR     R5,R11,#0x88888888   /* Slot1  -       R5(88)  -        -         */
    EOR     R6,R11,#0x11111111   /* Slot0  R6(11)  -       -        -         */
    EOR     R7,R11,#0xEEEEEEEE   /* Slot1  -       R7(EE)  -        -         */
    EOR     R8,R11,#0x22222222   /* Slot0  R8(22)  -       -        -         */
    EOR     R9,R11,#0xDDDDDDDD   /* Slot1  -       R9(DD)  -        -         */
    EOR     R10,R11,#0x66666666  /* Slot0  R10(66) -       -        -         */
    EOR     R11,R11,#0x99999999  /* Slot1  -       R11(99) -        -         */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R12                 /* Restore PRIMASK (enable ISRs)      */
    /*------------------------------------------------------------------------*/
    /* !! Update signature !! */
    BL      m33_cst_regbank_test_sum_r0_r11_to_r12
    
    
    /* R10,#0x00000000 - cleared in m33_cst_regbank_test_sum_r0_r11_to_r12   */ 
    LDR     R12,[SP,#4]     /* Load PRIMASK to R12 */
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE        /* Port   W0      W1      W2       W3        */
    /*------------------------------------------------------------------------*/
    EOR     R1,R10,#0x99999999   /* Slot0  R1(99)  -       -        -         */
    EOR     R0,R10,#0x66666666   /* Slot1  -       R0(66)  -        -         */
    EOR     R3,R10,#0xAAAAAAAA   /* Slot0  R3(AA)  -       -        -         */
    EOR     R2,R10,#0x55555555   /* Slot1  -       R2(55)  -        -         */
    EOR     R5,R10,#0xCCCCCCCC   /* Slot0  R5(CC)  -       -        -         */
    EOR     R4,R10,#0x33333333   /* Slot1  -       R4(33)  -        -         */
    EOR     R7,R10,#0x88888888   /* Slot0  R7(88)  -       -        -         */
    EOR     R6,R10,#0x77777777   /* Slot1  -       R6(77)  -        -         */
    EOR     R9,R10,#0xEEEEEEEE   /* Slot0  R9(EE)  -       -        -         */
    EOR     R8,R10,#0x11111111   /* Slot1  -       R8(11)  -        -         */
    EOR     R11,R10,#0xDDDDDDDD  /* Slot0  R11(DD) -       -        -         */
    EOR     R10,R10,#0x22222222  /* Slot1  -       R10(22) -        -         */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R12                 /* Restore PRIMASK (enable ISRs)      */
    /*------------------------------------------------------------------------*/
    /* !! Update signature !! */
    BL      m33_cst_regbank_test_sum_r0_r11_to_r12
    
    
    /**************************************************************************/
    /*  Ports W2,W3 are tested by using dual-issued Load/Store pipeline       */
    /*                                                                        */
    /*  Example:                            W0   W1   W2   W3                 */
    /*  --------------------------------------------------------------------- */
    /*  LDR     R0,[R14,#0]                 -    -    R0   -                  */
    /*  LDR     R1,[R14,#4]                 -    -    -    R1                 */
    /**************************************************************************/
    MOV     R2,#0x55555555  /* Initialize registers */
    MOV     R3,#0xAAAAAAAA
    MOV     R0,#0x33333333
    MOV     R1,#0xCCCCCCCC
    MOV     R4,#0x77777777
    MOV     R5,#0x88888888
    /* Prepare data in SRAM memory */
    LDR     R14,=CST_RAM_TARGET0       
    STRD    R2,R3,[R14,#0]
    STRD    R0,R1,[R14,#8]
    STRD    R4,R5,[R14,#16]
    DSB
    LDR     R12,[SP,#4]     /* Load PRIMASK to R12 */
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE        /* Port   W0      W1      W2       W3        */
    /*------------------------------------------------------------------------*/
    LDR     R0,[R14,#0]          /* Slot0  -       -       R0(55)   -         */
    LDR     R1,[R14,#4]          /* Slot1  -       -       -        R1(AA)    */
    LDR     R2,[R14,#4]          /* Slot0  -       -       R2(AA)   -         */
    LDR     R3,[R14,#0]          /* Slot1  -       -       -        R3(55)    */
    LDR     R4,[R14,#8]          /* Slot0  -       -       R4(33)   -         */
    LDR     R5,[R14,#12]         /* Slot1  -       -       -        R5(CC)    */
    LDR     R6,[R14,#12]         /* Slot0  -       -       R6(CC)   -         */
    LDR     R7,[R14,#8]          /* Slot1  -       -       -        R7(33)    */
    LDR     R8,[R14,#16]         /* Slot0  -       -       R8(77)   -         */
    LDR     R9,[R14,#20]         /* Slot1  -       -       -        R9(88)    */
    LDR     R10,[R14,#20]        /* Slot0  -       -       R10(88)  -         */
    LDR     R11,[R14,#16]        /* Slot1  -       -       -        R11(77)   */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R12                 /* Restore PRIMASK (enable ISRs)      */
    /*------------------------------------------------------------------------*/
    /* !! Update signature !! */
    BL      m33_cst_regbank_test_sum_r0_r11_to_r12
    
    
    LDR     R12,[SP,#4]     /* Load PRIMASK to R12 */
    MOV     R0,#0x66666666
    MOV     R1,#0x99999999
    MOV     R2,#0x22222222
    MOV     R3,#0xDDDDDDDD
    MOV     R4,#0x11111111
    MOV     R5,#0xEEEEEEEE
    /* Prepare data in SRAM memory */
    LDR     R14,=CST_RAM_TARGET1       
    STRD    R0,R1,[R14,#0]
    STRD    R2,R3,[R14,#8]
    STRD    R4,R5,[R14,#16]
    DSB
    LDR     R12,[SP,#4]     /* Load PRIMASK to R12 */
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE         /* Port  W0      W1      W2       W3        */
    /*------------------------------------------------------------------------*/
    LDR     R1,[R14,#0]           /* Slot0 -       -       R1(66)   -         */
    LDR     R0,[R14,#4]           /* Slot1 -       -       -        R0(99)    */
    LDR     R3,[R14,#4]           /* Slot0 -       -       R3(99)   -         */
    LDR     R2,[R14,#0]           /* Slot1 -       -       -        R2(66)    */
    LDR     R5,[R14,#8]           /* Slot0 -       -       R5(22)  -          */
    LDR     R4,[R14,#12]          /* Slot1 -       -       -        R4(DD)    */
    LDR     R7,[R14,#12]          /* Slot0 -       -       R7(DD)   -         */
    LDR     R6,[R14,#8]           /* Slot1 -       -       -        R6(22)    */
    LDR     R9,[R14,#16]          /* Slot0 -       -       R9(11)   -         */
    LDR     R8,[R14,#20]          /* Slot1 -       -       -        R8(EE)    */
    LDR     R11,[R14,#20]         /* Slot0 -       -       R11(EE)   -        */
    LDR     R10,[R14,#16]         /* Slot1 -       -       -        R10(11)   */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R12                 /* Restore PRIMASK (enable ISRs)      */
    /*------------------------------------------------------------------------*/
    /* !! Update signature !! */
    BL      m33_cst_regbank_test_sum_r0_r11_to_r12
    
    
    /**************************************************************************/
    /* Continue with testing R12,R13,R14                                      */
    /* Test that R13 register masks bit0,bit1 !!                              */
    /**************************************************************************/
    POP     {R0,R3}                     /* Signature and PRIMASK from stack */
    MOV     R4,#0xAAAAAAAA
    /*------------------------------------------------------------------------*/
    MOV     R2,R13                      /* Save stack pointer                 */
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE         /* Port    W0      W1       W2      W3      */
    /*------------------------------------------------------------------------*/
    EOR     R12,R4,#0xFFFFFFFF    /* Slot0   R12(55) -        -       -       */
    EOR     R14,R4,#0xFFFFFFFF    /* Slot1           R14(55)  -       -       */
    MOV     R13,R4                /* Slot0   R13(A8)!-        -       -       */
    NOP                           /* Slot1   -       -        -       -       */
    /* !! Update signature !! */
    ADD     R0,R12
    EOR     R0,R0,R12
    ADD     R0,R13
    /*------------------------------------------------------------------------*/
    MOV     R13,R2                      /* Restore stack pointer              */
    MSR     PRIMASK,R3                  /* Restore PRIMASK (enable ISRs)      */
    /*------------------------------------------------------------------------*/
    /* !! Update signature !! */
    ADD     R0,R14
    EOR     R0,R0,R14
    
    MVN     R4,R4   /* R4=0x55555555 */
    /*------------------------------------------------------------------------*/
    MOV     R2,R13                      /* Save stack pointer                 */
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE         /* Port    W0      W1      W2       W3      */
    /*------------------------------------------------------------------------*/
    EOR     R14,R4,#0xFFFFFFFF    /* Slot0   R14(AA) -       -        -       */
    EOR     R12,R4,#0xFFFFFFFF    /* Slot1   -       R12(AA) -        -       */
    NOP                           /* Slot0   -       -       -        -       */
    MOV     R13,R4                /* Slot1   -       R13(54)!-        -       */
    /* !! Update signature !! */
    ADD     R0,R12
    EOR     R0,R0,R12
    ADD     R0,R13
    /*------------------------------------------------------------------------*/
    MOV     R13,R2                      /* Restore stack pointer              */
    MSR     PRIMASK,R3                  /* Restore PRIMASK (enable ISRs)      */
    /*------------------------------------------------------------------------*/
    /* !! Update signature !! */
    ADD     R0,R14
    EOR     R0,R0,R14
    
    
    LDR     R1,=CST_RAM_TARGET0
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE         /* Port    W0      W1      W2       W3      */
    /*------------------------------------------------------------------------*/
    LDR     R12,[R1,#0]           /* Slot0   -       -       R12(55)  -       */
    LDR     R13,[R1,#8]           /* Slot1   -       -                R13(30) */
    LDR     R14,[R1,#4]           /* Slot0   -       -       R14(AA)  -       */
    NOP                           /* Slot1   -       -       -        -       */
    /* !! Update signature !! */
    ADD     R0,R12
    EOR     R0,R0,R12
    ADD     R0,R13
    /*------------------------------------------------------------------------*/
    MOV     R13,R2                      /* Restore stack pointer              */
    MSR     PRIMASK,R3                  /* Restore PRIMASK (enable ISRs)      */
    /*------------------------------------------------------------------------*/
    /* !! Update signature !! */
    ADD     R0,R14
    EOR     R0,R0,R14
    
    
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE         /* Port    W0      W1      W2       W3      */
    /*------------------------------------------------------------------------*/
    NOP                           /* Slot0   -       -       -        -       */
    LDR     R12,[R1,#0]           /* Slot1   -       -       -        R12(55) */
    LDR     R13,[R1,#8]           /* Slot0   -       -       R13(30) -        */
    LDR     R14,[R1,#4]           /* Slot1   -       -       -        R14(AA) */
    /* !! Update signature !! */
    ADD     R0,R12
    EOR     R0,R0,R12
    ADD     R0,R13
    /*------------------------------------------------------------------------*/
    MOV     R13,R2                      /* Restore stack pointer              */
    MSR     PRIMASK,R3                  /* Restore PRIMASK (enable ISRs)      */
    /*------------------------------------------------------------------------*/
    /* !! Update signature !! */
    ADD     R0,R14
    EOR     R0,R0,R14
    
    
    /*------------------------------------------------------------------------*/
    /* Test routine - End                                                     */
    /*------------------------------------------------------------------------*/
m33_cst_regbank_test_end:
    /* Test result is returned in R0, according to the conventions */
    B       m33_cst_test_tail_end
    
    
    /**************************************************************************/
    /* Internal function which sums R1-R11 and returns the result in R12      */
    /**************************************************************************/
m33_cst_regbank_test_sum_r0_r11_to_r12:
    LDR     R12,[SP,#0] /* Load signature from stack */
    ADD     R12,R0
    EOR     R12,R12,R0
    ADD     R12,R1
    EOR     R12,R12,R1
m33_cst_regbank_test_sum_r2_r11_to_r12:
    ADD     R12,R2
    EOR     R12,R12,R2
    ADD     R12,R3
    EOR     R12,R12,R3
    ADD     R12,R4
    EOR     R12,R12,R4
    ADD     R12,R5
    EOR     R12,R12,R5
    ADD     R12,R6
    EOR     R12,R12,R6
    ADD     R12,R7
    EOR     R12,R12,R7
    ADD     R12,R8
    EOR     R12,R12,R8
    ADD     R12,R9
    EOR     R12,R12,R9
    ADD     R12,R10
    EOR     R12,R12,R10
    ADD     R12,R11
    EOR     R12,R12,R11
    STR     R12,[SP,#0] /* Update signature on stack */
m33_cst_regbank_test_clear_r0_r12:
    MOV     R0,#0
    MOV     R1,#0
    MOV     R2,#0
    MOV     R3,#0
    MOV     R4,#0
    MOV     R5,#0
m33_cst_regbank_test_clear_r6_r12:
    MOV     R6,#0
    MOV     R7,#0
    MOV     R8,#0
    MOV     R9,#0
    MOV     R10,#0
    MOV     R11,#0
    MOV     R12,#0
    
    BX      LR
    
    
    CST_ALIGN_BYTES_4
    /* Marks the current location for dumping psuedoinstruction pools containing
       numeric values for used symbolic names used within LDR instruction. */
    CST_LTORG
    
#endif /* CORTST_M33_REGISTER_ENABLE */
     
    CST_FILE_END

