/*
 * Copyright 2020-2025 Yuntu Microelectronics co.,ltd
 * All rights reserved.
 *
 * YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 * used strictly in accordance with the applicable license terms. By expressly
 * accepting such terms or by downloading, installing, activating and/or otherwise
 * using the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software. The production use license in
 * Section 2.3 is expressly granted for this software.
 */

/******************************************************************************
* Test summary:
* -------------
*
* Covers LSU operation type:
*   - load/store single
*   - 2 bit immediate shift value
*   - write back control
*   - AGU address + offset input signals
*
* Overall coverage:
* -----------------
* Covers LDR.W, STR.W, LDRB.W, STRB.W, LDRH.W, STRH.W, LDRSB.W, STRSB.W, LDRSH.W, 
* STRSH.W instructions as well as logic processing its various encoding types:
* - '<Rn>','<Rt>' and '#<imm12>' as well as  <data_to_store> and <data_to_load>
* - '<Rn>','<Rt>' and '#<imm8>' as well as  <data_to_store> and <data_to_load>
* - '<Rn>','<Rt>','#<imm2>' and 'Rm' as well as <data_to_store> and <data_to_load>
* - '<Rt>',<label> as well as  <data_to_load> 
* 
* DECODER:
* Thumb (32-bit)
*   - Encoding of "Store single data item" instructions
*   - Encoding of "Load byte, memory hints" instructions - Load byte
*   - Encoding of "Load halfword, memory hints" instructions - Load halfword
*   - Encoding of "Load word" instructions
******************************************************************************/

#include "CorTst_Compiler.h"
#include "CorTst_M33_Cfg.h"

#if (CORTST_M33_LOADSTORE_ENABLE==1)
    /* Compatible with ABI. */
    CST_PRES8
    /* Symbols defined in the current module but to be visible to outside */
    CST_EXPORT M33_Cst_LoadstoreTest5

    /* Symbols defined outside but used within current module */
    CST_EXTERN CST_RAM_TARGET0
    CST_EXTERN CST_RAM_TARGET1
    CST_EXTERN m33_cst_test_tail_end

    CST_EXTERN VAL1
    CST_EXTERN VAL2
    CST_EXTERN VAL3
    CST_EXTERN VAL4
    CST_EXTERN VAL5
    CST_EXTERN VAL6
    CST_EXTERN VAL7
    CST_EXTERN VAL8
    CST_EXTERN VAL9
    CST_EXTERN VAL10
    CST_EXTERN VAL11
    CST_EXTERN VAL12   
    
    CST_SET(PRESIGNATURE, 0xE54D84AB)

    /*------------------------------------------------------------------------*/
    CST_SECTION_EXEC(mcal_text)
    /*------------------------------------------------------------------------*/
    /* The ".type" directive instructs the assembler/linker that the label 
       "M33_Cst_LoadstoreTest5" designates a function.
       This would cause setting the least significant bit to '1' within any 
       pointer to this function, causing change to Thumb mode whenever this 
       function is called. */
    CST_THUMB2
    CST_TYPE(M33_Cst_LoadstoreTest5, function)
M33_Cst_LoadstoreTest5:

    PUSH    {R4-R12,R14}
    
    /*------------------------------------------------------------------------*/
    /* Test - preparation                                                     */
    /*------------------------------------------------------------------------*/
    LDR.W   R1,=PRESIGNATURE    /* Load pre-signature */ 
    
    /*------------------------------------------------------------------------*/
    /* Test - start                                                           */
    /*------------------------------------------------------------------------*/
    /* Start testing with CST_RAM_TARGET0 */
    LDR.W   R0,=CST_RAM_TARGET0
    BL      m33_cst_loadstore_test5_common
    
    /* Start testing with CST_RAM_TARGET1 */
    LDR.W   R0,=CST_RAM_TARGET1
    BL      m33_cst_loadstore_test5_common

    /*------------------------------------------------------------------------*/
    /* Test - end                                                             */
    /*------------------------------------------------------------------------*/
    /* Test result is returned in R0, according to the conventions */
    MVN     R0,R1
m33_cst_loadstore_test5_end:
    B      m33_cst_test_tail_end
    

    /*------------------------------------------------------------------------*/
    /* Test routine - start                                                   */
    /*------------------------------------------------------------------------*/ 
m33_cst_loadstore_test5_common:
    
    PUSH    {R1,R14}    /* We need to store R1 and R14. */
    
    /***************************************************************************
    * Instructions: 
    *   - STR (immediate)   Encoding T3 (32-bit)
    *   - LDR (immediate)   Encoding T3 (32-bit)
    ***************************************************************************/
    BL      m33_cst_loadstore_test5_clear_target_memory
    /* --- Prepare data to be stored and loaded --- */
    BL      m33_cst_loadstore_test5_init
    SUB     R10,R0,#0x555           /* Decrement address 0x555 */
    /* <Rn[3:0]>:R10
       <Rt[15:12]>:R1(STR) R2(LDR)
       <imm12[11:0]>:0x555 */
    STR.W   R1,[R10,#0x555]         /* <data_to_store>:R1=0x55555555 */
    DSB
    LDR.W   R2,[R10,#0x555]         /* <data_to_load>:R2=0x55555555 */
    /* We need to check data */
    CMP     R1,R2
    BNE     m33_cst_loadstore_test5_failed
    
    /* --- Prepare data to be stored and loaded --- */
    BL      m33_cst_loadstore_test5_init
    SUB     R10,R0,#0xAAA           /* Decrement address 0xAAA */
    /* <Rn[3:0]>:R10
       <Rt[15:12]>:R2(STR) R1(LDR)
       <imm12[11:0]>:0xAAA */
    STR.W   R2,[R10,#0xAAA]         /* <data_to_store>:R2=0xAAAAAAAA */
    DSB
    LDR.W   R1,[R10,#0xAAA]         /* <data_to_load>:R1=0xAAAAAAAA */
    /* We need to check data */
    CMP     R2,R1
    BNE     m33_cst_loadstore_test5_failed
    
    /* --- Prepare data to be stored and loaded --- */
    BL      m33_cst_loadstore_test5_init
    ADD     R0,R0,#4    /* Update address */
    SUB     R5,R0,#0x333            /* Decrement address 0x333 */
    /* <Rn[3:0]>:R5
       <Rt[15:12]>:R3(STR) R4(LDR)
       <imm12[11:0]>:0x333 */
    STR.W   R3,[R5,#0x333]          /* <data_to_store>:R3=0xCCCCCCCC */
    DSB
    LDR.W   R4,[R5,#0x333]          /* <data_to_load>:R4=0xCCCCCCCC */
    /* We need to check data */
    CMP     R3,R4
    BNE     m33_cst_loadstore_test5_failed
    
    /* --- Prepare data to be stored and loaded --- */
    BL      m33_cst_loadstore_test5_init  
    SUB     R5,R0,#0xCCC            /* Decrement address 0xCCC */
    /* <Rn[3:0]>:R5
       <Rt[15:12]>:R4(STR) R3(LDR)
       <imm12[11:0]>:0xCCC */
    STR.W   R4,[R5,#0xCCC]          /* <data_to_store>:R4=0x33333333 */
    DSB
    LDR.W   R3,[R5,#0xCCC]          /* <data_to_load>:R3=0x33333333 */
    /* We need to check data */
    CMP     R4,R3
    BNE     m33_cst_loadstore_test5_failed
    
    /* --- Prepare data to be stored and loaded --- */
    BL      m33_cst_loadstore_test5_init
    ADD     R0,R0,#4    /* Update address */
    SUB     R7,R0,#0x777            /* Decrement address 0x777 */
    /* <Rn[3:0]>:R7
       <Rt[15:12]>:R5(STR) R6(LDR)
       <imm12[11:0]>:0x777 */
    STR.W   R5,[R7,#0x777]          /* <data_to_store>:R5=0x99999999 */
    DSB
    LDR.W   R6,[R7,#0x777]          /* <data_to_load>:R6=0x99999999 */
    /* We need to check data */
    CMP     R5,R6
    BNE     m33_cst_loadstore_test5_failed
    
    /* --- Prepare data to be stored and loaded --- */
    BL      m33_cst_loadstore_test5_init
    SUB     R7,R0,#0xEEE            /* Decrement address 0xEEE */
    /* <Rn[3:0]>:R7
       <Rt[15:12]>:R6(STR) R5(LDR)
       <imm12[11:0]>:0xEEE */
    STR.W   R6,[R7,#0xEEE]          /* <data_to_store>:R6=0x66666666 */
    DSB
    LDR.W   R5,[R7,#0xEEE]          /* <data_to_load>:R5=0x66666666 */
    /* We need to check data */
    CMP     R6,R5
    BNE     m33_cst_loadstore_test5_failed
    
    /* --- Prepare data to be stored and loaded --- */
    BL      m33_cst_loadstore_test5_init
    ADD     R0,R0,#4    /* Update address */
    SUB     R3,R0,#0xFFF            /* Decrement address 0xFFF */
    /* <Rn[3:0]>:R3
       <Rt[15:12]>:R7(STR) R8(LDR)
       <imm12[11:0]>:0xFFF */
    STR.W   R7,[R3,#0xFFF]          /* <data_to_store>:R7=0x77777777 */
    DSB
    LDR.W   R8,[R3,#0xFFF]          /* <data_to_load>:R8=0x77777777 */
    /* We need to check data */
    CMP     R7,R8
    BNE     m33_cst_loadstore_test5_failed
    
    /* --- Prepare data to be stored and loaded --- */
    BL      m33_cst_loadstore_test5_init
    MOV     R3,R0
    /* <Rn[3:0]>:R3
       <Rt[15:12]:R8(STR) R7(LDR)
       <imm12[11:0]>:0x000 */
    STR.W   R8,[R3,#0x0]            /* <data_to_store>:R8=0xEEEEEEEE */
    DSB
    LDR.W   R7,[R3,#0x0]            /* <data_to_load>:R7=0xEEEEEEEE */
    /* We need to check data */
    CMP     R8,R7
    BNE     m33_cst_loadstore_test5_failed
    
    /***************************************************************************
    * Instructions: 
    *   - STRB (immediate)  Encoding T2 (32-bit)
    *   - LDRB (immediate)  Encoding T2 (32-bit)
    *
    * Note: Formats of these instructions are identical to T3 encoding of 
    *       the STR (immediate) and LDR (immediate) ones.
    *       Testing only of "byte" operations are performed.
    ***************************************************************************/
    ADD     R0,R0,#4    /* Update address */
    /* --- Prepare data to be stored and loaded --- */
    BL      m33_cst_loadstore_test5_init
    SUB     R12,R0,#0xF0F           /* Decrement address 0xF0F */    
    /* <Rn[3:0]>:R12
       <Rt[15:12]>:R9(STRB) R10(LDRB)
       <imm12[11:0]>:0xF0F */
    STRB.W  R9,[R12,#0xF0F]         /* <data_to_store>:R9=0x13579BDF (0xDF) */
    DSB
    LDRB.W  R10,[R12,#0xF0F]        /* <data_to_load>:R10=0xDF */
    /* We need to check data */
    LDR     R9,[R12,#0xF0F]
    MVN     R8,#0xFF                /* R8=0xFFFFFF00 */
    EOR     R9,R9,R8
    CMP     R10,R9
    BNE     m33_cst_loadstore_test5_failed
    
    /* --- Prepare data to be stored and loaded --- */
    BL      m33_cst_loadstore_test5_init
    SUB     R12,R0,#0x3D1           /* Decrement address 0x3D1 */
    /* <Rn[3:0]>:R12
       <Rt[15:12]>:R10(STRB) R9(LDRB)
       <imm12[11:0]>:0x3D1 */
    STRB.W  R10,[R12,#0x3D1]        /* <data_to_store>:R10=0xFDB97531 (0x31) */
    DSB
    LDRB.W  R9,[R12,#0x3D1]         /* <data_to_load>:R9=0x31 */
    /* We need to check data */
    LDR     R10,[R12,#0x3D1]
    MVN     R8,#0xFF                /* R8=0xFFFFFF00 */
    EOR     R10,R10,R8
    CMP     R9,R10
    BNE     m33_cst_loadstore_test5_failed
    
    /***************************************************************************
    * Instructions: 
    *   - LDRSB (immediate) Encoding T1 (32-bit)
    *
    * Note: Format of this instruction is identical to T3 encoding of 
    *       the LDR (immediate) one.
    *       Testing only of "signed-byte" operation is performed.
    ***************************************************************************/
    /* --- Prepare data to be stored and loaded --- */
    BL      m33_cst_loadstore_test5_init
    SUB     R1,R0,#0x222            /* Decrement address 0x222 */    
    /* <Rn[3:0]>:R1
       <Rt[15:12]>:R11(STR) R12(LDRSH)
       <imm12[11:0]>:0x222 */
    STR.W   R11,[R1,#0x222]         /* <data_to_store>:R11=0x2468ACE0 */
    DSB
    LDRSB.W R12,[R1,#0x222]         /* <data_to_load>:R12=0xFFFFFFE0 */
    /* We need to check data */
    SBFX    R10,R11,#0,#8
    CMP     R12,R10
    BNE     m33_cst_loadstore_test5_failed
    
    /* --- Prepare data to be stored and loaded --- */
    BL      m33_cst_loadstore_test5_init
    SUB     R1,R0,#0xC21        /* Decrement address 0xC21 */
    /* <Rn[3:0]>:R1
       <Rt[15:12]>:R12(STR) R11(LDRSH)
       <imm12[11:0]>:0xC21 */
    STR.W   R12,[R1,#0xC21]         /* <data_to_store>:R12=0x0ECA8642 */
    DSB
    LDRSB.W R11,[R1,#0xC21]         /* <data_to_load>:R11=0x00000042 */
    /* We need to check data */
    SBFX    R10,R12,#0,#8
    CMP     R11,R10
    BNE     m33_cst_loadstore_test5_failed
    
    /***************************************************************************
    * Instructions: 
    *   - STRH (immediate)  Encoding T2 (32-bit)
    *   - LDRH (immediate)  Encoding T2 (32-bit)
    *
    * Note: Formats of these instructions are identical to T3 encoding of 
    *       the STR (immediate) and LDR (immediate) ones.
    *       Testing only of "halfword" operations are performed.
    ***************************************************************************/
    ADD     R0,R0,#4    /* Update address */
    /* --- Prepare data to be stored and loaded --- */
    BL      m33_cst_loadstore_test5_init
    SUB     R9,R0,#0x0F0            /* Decrement address 0x0F0 */    
    /* <Rn[3:0]>:R9
       <Rt[15:12]>:R11(STRH) R12(LDRH)
       <imm12[11:0]>:0x0F0 */
    STRH.W  R11,[R9,#0x0F0]         /* <data_to_store>:R11=0x2468ACE0 (0xACE0)*/
    DSB
    LDRH.W  R12,[R9,#0x0F0]         /* <data_to_load>:R12=0xACE0 */
    /* We need to check data */
    LDR     R11,[R9,#0x0F0]
    LDR     R8,=0xFFFF0000
    EOR     R11,R11,R8
    CMP     R12,R11
    BNE     m33_cst_loadstore_test5_failed
    
    /* --- Prepare data to be stored and loaded --- */
    BL      m33_cst_loadstore_test5_init
    SUB     R9,R0,#0xE52            /* Decrement address 0xE52 */
    /* <Rn[3:0]>:R9
       <Rt[15:12]>:R12(STRH) R11(LDRH)
       <imm12[11:0]>:0xE52*/
    STRH.W  R12,[R9,#0xE52]         /* <data_to_store>:R12=0x0ECA8642 (0x8642)*/
    DSB
    LDRH.W  R11,[R9,#0xE52]         /* <data_to_load>:R11=0x8642 */
    /* We need to check data */
    LDR     R12,[R9,#0xE52]
    LDR     R8,=0xFFFF0000
    EOR     R12,R12,R8
    CMP     R11,R12
    BNE     m33_cst_loadstore_test5_failed
    
    
    /***************************************************************************
    * Instructions: 
    *   - LDRSH (immediate) Encoding T1 (32-bit)
    *
    * Note: Format of this instruction is identical to T3 encoding of 
    *       the LDR.W (immediate) one.
    *       Testing only of "signed-halfword" operation is performed.
    ***************************************************************************/
    /* --- Prepare data to be stored and loaded --- */
    BL      m33_cst_loadstore_test5_init
    SUB     R2,R0,#0x111            /* Decrement address 0x111 */    
    /* <Rn[3:0]>:R2
       <Rt[15:12]>:R9(STR) R10(LDRSH)
       <imm12[11:0]>:0x111 */
    STR.W   R9,[R2,#0x111]          /* <data_to_store>:R9=0x13579BDF */
    DSB
    LDRSH.W R10,[R2,#0x111]         /* <data_to_load>:R10=0xFFFF9BDF */
    /* We need to check data */
    SBFX    R8,R9,#0,#16
    CMP     R10,R8
    BNE     m33_cst_loadstore_test5_failed
    
    /* --- Prepare data to be stored and loaded --- */
    BL      m33_cst_loadstore_test5_init
    SUB     R2,R0,#0x5A3            /* Decrement address 0x5A3 */
    /* <Rn[3:0]>:R2
       <Rt[15:12]>:R10(STR) R9(LDRSH)
       <imm12[11:0]>:0x5A3 */
    STR.W   R10,[R2,#0x5A3]         /* <data_to_store>:R10=0xFDB97531 */
    DSB
    LDRSH.W R9,[R2,#0x5A3]          /* <data_to_load>:R9=0x00007531 */
    /* We need to check data */
    SBFX    R8,R10,#0,#16
    CMP     R9,R8
    BNE     m33_cst_loadstore_test5_failed
    
    
    /***************************************************************************
    * Instructions: 
    *   - STR (immediate)   Encoding T4 (32-bit)
    *   - LDR (immediate)   Encoding T4 (32-bit)
    ***************************************************************************/
    SUB     R0,R0,#20
    BL      m33_cst_loadstore_test5_clear_target_memory
    /* --- Prepare data to be stored and loaded --- */
    BL      m33_cst_loadstore_test5_init
    ADD     R10,R0,#0x55            /* Increment address 0x55 */    
    /* <Rn[3:0]>:R10
       <Rt[15:12]>:R1(STR) R2(LDR)
       <imm8[7:0]>:0x55 */
    STR     R1,[R10,#-0x55]         /* <data_to_store>:R0=0x55555555 */
    DSB
    /* We need to check address was not changed */
    SUB     R10,R10,#0x55 
    CMP     R10,R0
    BNE     m33_cst_loadstore_test5_failed
    ADD     R10,R0,#0x55            /* Increment address 0x55 */    
    LDR     R2,[R10,#-0x55]         /* <data_to_load>:R1=0x55555555 */
    /* We need to check address was not changed */
    SUB     R10,R10,#0x55 
    CMP     R10,R0
    BNE     m33_cst_loadstore_test5_failed
    /* We need to check data */
    CMP     R1,R2
    BNE     m33_cst_loadstore_test5_failed
    
    /* --- Prepare data to be stored and loaded --- */
    BL      m33_cst_loadstore_test5_init
    SUB     R10,R0,#0xAA            /* Decrement address 0xAA */
    /* <Rn[3:0]>:R10
       <Rt[15:12]>:R2(STR) R1(LDR)
       <imm8[7:0]>:0xAA */
    STR.W   R2,[R10,#0xAA]!         /* <data_to_store>:R1=0xAAAAAAAA */
    DSB
    /* We need to check address was incremented */
    CMP     R10,R0
    BNE     m33_cst_loadstore_test5_failed
    SUB     R10,R0,#0xAA            /* Decrement address 0xAA */
    LDR.W   R1,[R10,#0xAA]!         /* <data_to_load>:R0=0xAAAAAAAA */
    /* We need to check address was incremented */
    CMP     R10,R0
    BNE     m33_cst_loadstore_test5_failed
    /* We need to check data */
    CMP     R2,R1
    BNE     m33_cst_loadstore_test5_failed
    
    ADD     R0,R0,#4    /* Update address */
    /* --- Prepare data to be stored and loaded --- */
    BL      m33_cst_loadstore_test5_init
    MOV     R5,R0
    /* <Rn[3:0]>:R5
       <Rt[15:12]>:R3(STR) R4(LDR)
       <imm8[7:0]>:0x33 */
    STR.W   R3,[R5],#0x33           /* <data_to_store>:R3=0xCCCCCCCC */
    DSB
    /* We need to check address was incremented */
    SUB     R5,R5,#0x33
    CMP     R5,R0
    BNE     m33_cst_loadstore_test5_failed
    LDR.W   R4,[R5],#0x33           /* <data_to_load>:R4=0xCCCCCCCC */
    /* We need to check address was incremented */
    SUB     R5,R5,#0x33
    CMP     R5,R0
    BNE     m33_cst_loadstore_test5_failed
    /* We need to check data */
    CMP     R3,R4
    BNE     m33_cst_loadstore_test5_failed
    
    /* --- Prepare data to be stored and loaded --- */
    BL      m33_cst_loadstore_test5_init
    MOV     R5,R0
    /* <Rn[3:0]>:R5
       <Rt[15:12]>:R4(STR) R3(LDR)
       <imm8[7:0]>:0xCC */
    STR.W   R4,[R5],#-0xCC          /* <data_to_store>:R4=0x33333333 */
    DSB
    /* We need to check address was decremented */
    ADD     R5,R5,#0xCC
    CMP     R5,R0
    BNE     m33_cst_loadstore_test5_failed
    LDR.W   R3,[R5],#-0xCC          /* <data_to_load>:R3=0x33333333 */
    /* We need to check address was decremented */
    ADD     R5,R5,#0xCC
    CMP     R5,R0
    BNE     m33_cst_loadstore_test5_failed
    /* We need to check data */
    CMP     R4,R3
    BNE     m33_cst_loadstore_test5_failed
    
    ADD     R0,R0,#4    /* Update address */
    /* --- Prepare data to be stored and loaded --- */
    BL      m33_cst_loadstore_test5_init
    ADD     R7,R0,#0x77             /* Increment address 0x77 */
    /* <Rn[3:0]>:R7
       <Rt[15:12]>:R5(STR) R6(LDR)
       <imm8[7:0]>:0x77 */
    STR.W   R5,[R7,#-0x77]!         /* <data_to_store>:R5=0x99999999 */
    DSB
    /* We need to check address was decremented */
    CMP     R7,R0
    BNE     m33_cst_loadstore_test5_failed
    ADD     R7,R0,#0x77             /* Increment address 0x77 */
    LDR.W   R6,[R7,#-0x77]!         /* <data_to_load>:R6=0x99999999 */
    /* We need to check address was decremented */
    CMP     R7,R0
    BNE     m33_cst_loadstore_test5_failed
    /* We need to check data */
    CMP     R5,R6
    BNE     m33_cst_loadstore_test5_failed
    
    /* --- Prepare data to be stored and loaded --- */
    BL      m33_cst_loadstore_test5_init
    ADD     R7,R0,#0xEE             /* Increment address 0xEE */
    /* <Rn[3:0]>:R7
       <Rt[15:12]>:R6(STR) R5(LDR)
       <imm8[7:0]>:0xEE */
    STR     R6,[R7,#-0xEE]          /* <data_to_store>:R6=0x66666666 */
    DSB
    /* We need to check address was not changed */
    SUB     R7,R7,#0xEE 
    CMP     R7,R0
    BNE     m33_cst_loadstore_test5_failed
    ADD     R7,R0,#0xEE             /* Increment address 0xEE */ 
    LDR     R5,[R7,#-0xEE]          /* <data_to_load>:R5=0x66666666 */
    /* We need to check address was not changed */
    SUB     R7,R7,#0xEE 
    CMP     R7,R0
    BNE     m33_cst_loadstore_test5_failed
    /* We need to check data */
    CMP     R6,R5
    BNE     m33_cst_loadstore_test5_failed
    
    ADD     R0,R0,#4    /* Update address */
    /* --- Prepare data to be stored and loaded --- */
    BL      m33_cst_loadstore_test5_init
    MOV     R3,R0
    /* <Rn[3:0]>:R3
       <Rt[15:12]>:R7(STR) R8(LDR)
       <imm8[7:0]>:0xFF */
    STR.W   R7,[R3],#0xFF           /* <data_to_store>:R7=0x77777777 */
    DSB
    /* We need check address was incremented */
    SUB     R3,R3,#0xFF
    CMP     R3,R0
    BNE     m33_cst_loadstore_test5_failed
    LDR.W   R8,[R3],#0xFF           /* <data_to_load>:R8=0x77777777 */
    /* We need check address was incremented */
    SUB     R3,R3,#0xFF
    CMP     R3,R0
    BNE     m33_cst_loadstore_test5_failed
    /* We need to check data */
    CMP     R7,R8
    BNE     m33_cst_loadstore_test5_failed
    
    
    /***************************************************************************
    * Instructions: 
    *   - STRB (immediate)  Encoding T3 (32-bit)
    *   - LDRB (immediate)  Encoding T3 (32-bit)
    *
    * Note: Format of these instructions are identical to T4 encoding of 
    *       the STR (immediate) and LDR (immediate) ones.
    *       Testing only of "byte" operations are performed.
    ***************************************************************************/
    ADD     R0,R0,#4    /* Update address */
    /* --- Prepare data to be stored and loaded --- */
    BL      m33_cst_loadstore_test5_init
    ADD     R12,R0,#0x0F            /* Increment address 0x0F */    
    /* <Rn[3:0]>:R12
       <Rt[15:12]>:R9(STRB) R10(LDRB)
       <imm8[7:0]>:0x0F */
    STRB    R9,[R12,#-0x0F]         /* <data_to_store>:R9=0x13579BDF (0xDF) */
    DSB
    /* We need to check address was not changed */
    SUB     R12,R12,#0x0F 
    CMP     R12,R0
    BNE     m33_cst_loadstore_test5_failed
    ADD     R12,R0,#0x0F            /* Increment address 0x0F */    
    LDRB    R10,[R12,#-0x0F]        /* <data_to_load>:R10=0xDF */
    /* We need to check address was not changed */
    SUB     R12,R12,#0x0F 
    CMP     R12,R0
    BNE     m33_cst_loadstore_test5_failed
    /* We need to check data */
    LDR     R9,[R12]
    MVN     R8,#0xFF                /* R8=0xFFFFFF00 */
    EOR     R9,R9,R8
    CMP     R10,R9
    BNE     m33_cst_loadstore_test5_failed
    
    /* --- Prepare data to be stored and loaded --- */
    BL      m33_cst_loadstore_test5_init
    SUB     R12,R0,#0x3B            /* Decrement address 0x3B */
    /* <Rn[3:0]>:R12
       <Rt[15:12]>:R10(STRB) R9(LDRB)
       <imm8[7:0]>:0x3B */
    STRB    R10,[R12,#0x3B]!        /* <data_to_store>:R10=0xFDB97531 */
    DSB
    /* We need to check address was incremented */
    CMP     R12,R0
    BNE     m33_cst_loadstore_test5_failed
    SUB     R12,R0,#0x3B            /* Decrement address 0x3B */
    LDRB    R9,[R12,#0x3B]!         /* <data_to_load>:R9=0x31 */
    /* We need to check address was incremented */
    CMP     R12,R0
    BNE     m33_cst_loadstore_test5_failed
    /* We need to check data */
    LDR     R10,[R12]
    MVN     R8,#0xFF                /* R8=0xFFFFFF00 */
    EOR     R10,R10,R8
    CMP     R9,R10
    BNE     m33_cst_loadstore_test5_failed
    
    
    /***************************************************************************
    * Instructions: 
    *   LDRSB (immediate)   Encoding T2 (32-bit)
    *
    * Note: Format of this instruction is identical to T4 encoding of 
    *       the LDR (immediate) one.
    *       Testing only of "signed-byte" operation is performed.
    ***************************************************************************/
    /* --- Prepare data to be stored and loaded --- */
    BL      m33_cst_loadstore_test5_init 
    MOV     R1,R0
    /* <Rn[3:0]>:R1
       <Rt[15:12]>:R11(STR) R12(LDRSB)
       <imm8[7:0]>:0x22 */
    STR.W   R11,[R1],#0x22          /* <data_to_store>:R11=0x2468ACE0 */
    DSB
    /* We need to check address was incremented */
    SUB     R1,R1,#0x22
    CMP     R1,R0
    BNE     m33_cst_loadstore_test5_failed
    LDRSB   R12,[R1],#0x22          /* <data_to_load>:R12=0xFFFFFFE0 */
    /* We need to check address was incremented */
    SUB     R1,R1,#0x22
    CMP     R1,R0
    BNE     m33_cst_loadstore_test5_failed
    /* We need to check data */
    SBFX    R10,R11,#0,#8
    CMP     R12,R10
    BNE     m33_cst_loadstore_test5_failed
    
    /* --- Prepare data to be stored and loaded --- */
    BL      m33_cst_loadstore_test5_init 
    MOV     R1,R0
    /* <Rn[3:0]>:R1
       <Rt[15:12]>:R12(STR) R11(LDRSB)
       <imm8[7:0]>:0xA1 */
    STR.W   R12,[R1],#-0xA1         /* <data_to_store>:R12=0x0ECA8642 */
    DSB
    /* We need to check address was decremented */
    ADD     R1,R1,#0xA1
    CMP     R1,R0
    BNE     m33_cst_loadstore_test5_failed
    LDRSB   R11,[R1],#-0xA1         /* <data_to_load>:R11=0x00000042 */
    /* We need to check address was decremented */
    ADD     R1,R1,#0xA1
    CMP     R1,R0
    BNE     m33_cst_loadstore_test5_failed
    /* We need to check data */
    SBFX    R10,R12,#0,#8
    CMP     R11,R10
    BNE     m33_cst_loadstore_test5_failed
    
    
    /***************************************************************************
    * Instructions: 
    *   - STRH (immediate)  Encoding T3 (32-bit)
    *   - LDRH (immediate)  Encoding T3 (32-bit)
    *
    * Note: Formats of these instructions are identical to T4 encoding of 
    *       the STR (immediate) and LDR (immediate) ones.
    *       Testing only of "halfword" operations are performed.
    ***************************************************************************/
    ADD     R0,R0,#4    /* Update address */
    /* --- Prepare data to be stored and loaded --- */
    BL      m33_cst_loadstore_test5_init
    ADD     R9,R0,#0xF0             /* Increment address 0xF0 */
    /* <Rn[3:0]>:R9
       <Rt[15:12]>:R11(STRH) R12(LDRH)
       <imm8[7:0]>:0xF0 */
    STRH    R11,[R9,#-0xF0]!        /* <data_to_store>:R11=0x2468ACE0 (0xACE0)*/
    DSB
    /* We need to check address was decremented */
    CMP     R9,R0
    BNE     m33_cst_loadstore_test5_failed
    ADD     R9,R0,#0xF0             /* Increment address 0xF0 */
    LDRH    R12,[R9,#-0xF0]!        /* <data_to_load>:R12=0xACE0 */
    /* We need to check address was decremented */
    CMP     R9,R0
    BNE     m33_cst_loadstore_test5_failed
    /* We need to check data */
    LDR     R11,[R9]
    LDR     R8,=0xFFFF0000
    EOR     R11,R11,R8
    CMP     R12,R11
    BNE     m33_cst_loadstore_test5_failed
    
    /* --- Prepare data to be stored and loaded --- */
    BL      m33_cst_loadstore_test5_init
    ADD     R9,R0,#0xE4             /* Increment address 0xE4 */
    /* <Rn[3:0]>:R9
       <Rt[15:12]>:R12(STRH) R11(LDRH)
       <imm8[7:0]>:0xE4 */
    STRH    R12,[R9,#-0xE4]         /* <data_to_store>:R12=0x0ECA8642 (0x8642) */
    DSB
    /* We need to check address was not changed */
    SUB     R9,R9,#0xE4 
    CMP     R9,R0
    BNE     m33_cst_loadstore_test5_failed
    ADD     R9,R0,#0xE4             /* Increment address 0xE4 */ 
    LDRH    R11,[R9,#-0xE4]         /* <data_to_load>:R11=0x8642 */
    /* We need to check address was not changed */
    SUB     R9,R9,#0xE4 
    CMP     R9,R0
    BNE     m33_cst_loadstore_test5_failed
    /* We need to check data */
    LDR     R12,[R9]
    LDR     R8,=0xFFFF0000
    EOR     R12,R12,R8
    CMP     R11,R12
    BNE     m33_cst_loadstore_test5_failed
    
    
    /***************************************************************************
    * Instructions: 
    *   - LDRSH (immediate) Encoding T2 (32-bit)
    *
    * Note: Format of this instruction is identical to T4 encoding of 
    *       the LDR (immediate) one.
    *       Testing only of "signed-halfword" operation is performed.
    ***************************************************************************/
    /* --- Prepare data to be stored and loaded --- */
    BL      m33_cst_loadstore_test5_init
    MOV     R2,R0
    /* <Rn[3:0]>:R2
       <Rt[15:12]>:R9(STR) R10(LDRSH)
       <imm8[7:0]>:0x11 */
    STR.W   R9,[R2],#0x11           /* <data_to_store>:R9=0x13579BDF */
    DSB
    /* We need check address was incremented */
    SUB     R2,R2,#0x11
    CMP     R2,R0
    BNE     m33_cst_loadstore_test5_failed
    LDRSH   R10,[R2],#0x11          /* <data_to_load>:R10=0xFFFF9BDF */
    /* We need check address was incremented */
    SUB     R2,R2,#0x11
    CMP     R2,R0
    BNE     m33_cst_loadstore_test5_failed
    /* We need to check data */
    SBFX    R8,R9,#0,#16
    CMP     R10,R8
    BNE     m33_cst_loadstore_test5_failed
    
    /* --- Prepare data to be stored and loaded --- */
    BL      m33_cst_loadstore_test5_init
    MOV     R2,R0
    /* <Rn[3:0]>:R2
       <Rt[15:12]:R10(STR) R9(LDRSH)
       <imm8[7:0]>:0x34 */
    SUB     R2,R0,#0x34             /* Decrement address 0x34 */
    STR.W   R10,[R2,#0x34]!         /* <data_to_store>:R10=0xFDB97531 */
    DSB
    /* We need to check address was incremented */
    CMP     R2,R0
    BNE     m33_cst_loadstore_test5_failed
    SUB     R2,R0,#0x34             /* Decrement address 0x34 */
    LDRSH   R9,[R2,#0x34]!          /* <data_to_load>:R9=0x00007531 */
    /* We need to check address was incremented */
    CMP     R2,R0
    BNE     m33_cst_loadstore_test5_failed
    /* We need to check data */
    SBFX    R8,R10,#0,#16
    CMP     R9,R8
    BNE     m33_cst_loadstore_test5_failed
    
    
    /***************************************************************************
    * Instructions: 
    *   - STR (register)    Encoding T2 (32-bit)
    *   - LDR (register)    Encoding T2 (32-bit)
    *
    * Test AGU input signals - address and offset 
    ***************************************************************************/
    SUB    R0,R0,#20
    BL     m33_cst_loadstore_test5_clear_target_memory
    /* --- Prepare data to be stored and loaded --- */
    BL      m33_cst_loadstore_test5_init
    MOV     R4,#0x55555555  /* Add offset/address (0x55555555) to R4 */ 
    SUB     R3,R0,R4        /* Prepare address/offset to R3 */
    /* <Rn[3:0]>:R3
       <Rt[15:12]>:R1(STR) R2(LDR)
       <imm2[5:4]>:#0
       <Rm[3:0]>:R4 */
    STR.W   R1,[R3,R4,LSL #0]       /* <data_to_store>:R1=0x55555555 */
    DSB
    LDR.W   R2,[R4,R3,LSL #0]       /* <data_to_load>:R2=0x55555555 */
    /* We need to check data */
    CMP     R1,R2
    BNE     m33_cst_loadstore_test5_failed
    
    /* --- Prepare data to be stored and loaded --- */
    BL      m33_cst_loadstore_test5_init
    MOV     R4,#0x55555555  /* Load address/offset (0x55555555) to R4 */ 
    SUB     R3,R0,R4        /* Prepare offset/address to R3 */
    /* <Rn[3:0]>:R4
       <Rt[15:12]>:R2(STR) R1(LDR)
       <imm2[5:4]>:#0
       <Rm[3:0]>:R3 */
    STR.W   R2,[R4,R3,LSL #0]       /* <data_to_store>:R2=0xAAAAAAAA */
    DSB
    LDR.W   R1,[R3,R4,LSL #0]       /* <data_to_load>:R1=0xAAAAAAAA */
    /* We need to check data */
    CMP     R2,R1
    BNE     m33_cst_loadstore_test5_failed
    
    ADD     R0,R0,#4    /* Update address */
    
    /* --- Prepare data to be stored and loaded --- */
    BL      m33_cst_loadstore_test5_init 
    MOV     R2,#0x55555555  /* Add offset to R2 (will be shifted to 0xAAAAAAAA) */
    SUB     R1,R0,R2,LSL #1 /* Prepare address/offset to R1 */
    /* <Rn[3:0]>:R1
       <Rt[15:12]>:R3(STR) R4(LDR)
       <imm2[5:4]>:#1
       <Rm[3:0]>:R2 */
    STR.W   R3,[R1,R2,LSL #1]       /* <data_to_store>:R3=0xCCCCCCCC */
    MOV     R2,#0xAAAAAAAA  /* Add address (0xAAAAAAAA) to R2 */
    DSB
    LDR.W   R4,[R2,R1,LSL #0]       /* <data_to_load>:R4=0xCCCCCCCC */
    /* We need to check data */
    CMP     R3,R4
    BNE     m33_cst_loadstore_test5_failed
    
    /* --- Prepare data to be stored and loaded --- */
    BL      m33_cst_loadstore_test5_init
    MOV     R2,#0xAAAAAAAA  /* Load address/offset (0xAAAAAAAA) to R2 */
    SUB     R1,R0,R2        /* Prepare offset/address to R1 */
    /* <Rn[3:0]>:R2
       <Rt[15:12]>:R4(STR) R3(LDR)
       <imm2[5:4]>:#0
       <Rm[3:0]>:R1 */
    STR.W   R4,[R2,R1,LSL #0]       /* <data_to_store>:R4=0x33333333 */
    MOV     R2,#0x55555555  /* Add offset to R2 (will be shifted to 0xAAAAAAAA) */
    DSB
    LDR.W   R3,[R1,R2,LSL #1]       /* <data_to_load>:R3=0x33333333 */
    /* We need to check data */
    CMP     R4,R3
    BNE     m33_cst_loadstore_test5_failed
    
    ADD     R0,R0,#4    /* Update address */
    
    /* --- Prepare data to be stored and loaded --- */
    BL      m33_cst_loadstore_test5_init
    MOV     R7,#0x33333333  /* Add offset to R7 (will be shifted to 0xCCCCCCCC) */
    SUB     R8,R0,R7,LSL #2 /* Prepare address to R8 */
    /* <Rn[3:0]>:R8
       <Rt[15:12]>:R5(STR) R6(LDR)
       <imm2[5:4]>:#2
       <Rm[3:0]>:R7 */
    STR.W   R5,[R8,R7,LSL #2]       /* <data_to_store>:R5=0x99999999 */
    MOV     R7,#0xCCCCCCCC  /* Add address (0xCCCCCCCC) to R7 */
    DSB
    LDR.W   R6,[R7,R8,LSL #0]       /* <data_to_load>:R6=0x99999999 */
    /* We need to check data */
    CMP     R5,R6
    BNE     m33_cst_loadstore_test5_failed
    
    /* --- Prepare data to be stored and loaded --- */
    BL      m33_cst_loadstore_test5_init
    MOV     R7,#0xCCCCCCCC  /* Load address/offset (0xCCCCCCCC) to R7 */
    SUB     R8,R0,R7        /* Prepare offset/address to R8 */
    /* <Rn[3:0]>:R7
       <Rt[15:12]>:R6(STR) R5(LDR)
       <imm2[5:4]>:#0
       <Rm[3:0]>:R8 */
    STR.W   R6,[R7,R8,LSL #0]      /* <data_to_store>:R6=0x66666666 */
    MOV     R7,#0x33333333  /* Add offset to R7 (will be shifted to 0xCCCCCCCC) */
    DSB
    LDR.W   R5,[R8,R7,LSL #2]      /* <data_to_load>:R5=0x66666666 */
    /* We need to check data */
    CMP     R6,R5
    BNE     m33_cst_loadstore_test5_failed
    
    ADD     R0,R0,#4    /* Update address */
    
    /* --- Prepare data to be stored and loaded --- */
    BL      m33_cst_loadstore_test5_init
    MOV     R10,#0x33333333 /* Add offset/address (0x33333333) to R10 */
    SUB     R9,R0,R10       /* Prepare address/offset to R9 */
    /* <Rn[3:0]>:R9
       <Rt[15:12]>:R7(STR) R8(LDR)
       <imm2[5:4]>:#0
       <Rm[3:0]>:R10 */
    STR.W   R7,[R9,R10,LSL #0]      /* <data_to_store>:R7=0x77777777 */
    DSB
    LDR.W   R8,[R10,R9,LSL #0]      /* <data_to_load>:R8=0x77777777 */
    /* We need to check data */
    CMP     R7,R8
    BNE     m33_cst_loadstore_test5_failed
    
    /* --- Prepare data to be stored and loaded --- */
    BL      m33_cst_loadstore_test5_init   
    MOV     R10,#0x33333333 /* Load address/offset (0x33333333) to R10 */
    SUB     R9,R0,R10       /* Prepare offset/address to R9 */       
    /* <Rn[3:0]>:R10
       <Rt[15:12]>:R8(STR) R7(LDR)
       <imm2[5:4]>:#0
       <Rm[3:0]>:R9 */
    STR.W   R8,[R10,R9,LSL #0]      /* <data_to_store>:R8=0xEEEEEEEE */
    DSB
    LDR.W   R7,[R9,R10,LSL #0]      /* <data_to_load>:R7=0xEEEEEEEE */
    /* We need to check data */
    CMP     R8,R7
    BNE     m33_cst_loadstore_test5_failed
    
    
    /***************************************************************************
    * Instructions: 
    *   - STRB (register)   Encoding T2 (32-bit)
    *   - LDRB (register)   Encoding T2 (32-bit)
    *
    * Note: Formats of these instructions are identical to T2 encoding of 
    *       the STR (register) and LDR (register) ones.
    *       Testing only of "byte" operations are performed.
    ***************************************************************************/
    ADD     R0,R0,#4    /* Update address */
    /* --- Prepare data to be stored and loaded --- */
    BL      m33_cst_loadstore_test5_init
    MOV     R12,#0x11111111     /* Add offset to R12 (will be shifted to 0x88888888) */ 
    SUB     R11,R0,R12,LSL #3   /* Prepare address/offset to R11 */
    /* <Rn[3:0]>:R11
       <Rt[15:12]>:R9(STRB) R10(LDRB)
       <imm2[5:4]>:#3
       <Rm[3:0]>:R12 */
    STRB.W  R9,[R11,R12,LSL #3]     /* <data_to_store>:R9=0x13579BDF (0xDF)*/
    MOV     R12,#0x88888888     /* Add address (0x88888888) to R12 */
    DSB
    LDRB.W  R10,[R12,R11,LSL #0]    /* <data_to_load>:R10=0xDF */
    /* We need to check data */
    LDR     R9,[R12,R11,LSL #0]
    MVN     R8,#0xFF                /* R8=0xFFFFFF00 */
    EOR     R9,R9,R8
    CMP     R10,R9
    BNE     m33_cst_loadstore_test5_failed
    
    /* --- Prepare data to be stored and loaded --- */
    BL      m33_cst_loadstore_test5_init
    MOV     R12,#0x88888888 /* Load address (0x88888888) to R12 */ 
    SUB     R11,R0,R12      /* Prepare offset/address to R11 */
    /* <Rn[3:0]>:R12
       <Rt[15:12]>:R10(STRB) R9(LDRB)
       <imm2[5:4]>:#0
       <Rm[3:0]>:R11 */
    STRB.W  R10,[R12,R11,LSL #0]    /* <data_to_store>:R10=0xFDB97531 (0x31) */
    MOV     R12,#0x11111111     /* Add offset to R12 (will be shifted to 0x88888888) */
    DSB
    LDRB.W  R9,[R11,R12,LSL #3]     /* <data_to_load>:R9=0x31 */
    /* We need to check data */
    LDR     R10,[R11,R12,LSL #3]
    MVN     R8,#0xFF                /* R8=0xFFFFFF00 */
    EOR     R10,R10,R8
    CMP     R9,R10
    BNE     m33_cst_loadstore_test5_failed

    
    /***************************************************************************
    * Instructions: 
    *   - LDRSB (register)  Encoding T2 (32-bit)
    *
    * Note: Format of this instruction is identical to T2 encoding of 
    *       the LDR (register) one.
    *       Testing only of "signed-byte" operation is performed.
    ***************************************************************************/
    /* --- Prepare data to be stored and loaded --- */
    BL      m33_cst_loadstore_test5_init
    MOV     R2,#0x77777777  /* Add offset/address (0x77777777) to R2 */
    SUB     R1,R0,R2        /* Prepare address/offset to R1 */
    /* <Rn[3:0]>:R1
       <Rt[15:12]>:R11(STR) R12(LDRSB)
       <imm2[5:4]>:#0
       <Rm[3:0]>:R2 */
    STR.W   R11,[R1,R2,LSL #0]      /* <data_to_store>:R11=0x2468ACE0 */
    DSB
    LDRSB.W R12,[R2,R1,LSL #0]      /* <data_to_load>:R12=0xFFFFFFE0 */
    /* We need to check data */
    SBFX    R10,R11,#0,#8
    CMP     R12,R10
    BNE     m33_cst_loadstore_test5_failed
    
    /* --- Prepare data to be stored and loaded --- */
    BL      m33_cst_loadstore_test5_init  
    MOV     R2,#0x77777777  /* Load address/offset (0x77777777) to R2 */
    SUB     R1,R0,R2        /* Prepare offset/address to R1 */
    /* <Rn[3:0]>:R2
       <Rt[15:12]>:R12(STR) R11(LDRSB)
       <imm2[5:4]>:#0
       <Rm[3:0]>:R1 */
    STR.W   R12,[R2,R1,LSL #0]      /* <data_to_store>:R12=0x0ECA8642*/
    DSB
    LDRSB.W R11,[R1,R2,LSL #0]      /* <data_to_load>:R11=0x00000042 */
    /* We need to check data */
    SBFX    R10,R12,#0,#8
    CMP     R11,R10
    BNE     m33_cst_loadstore_test5_failed
        
        
    /***************************************************************************
    * Instructions: 
    *   - STRH (register)   Encoding T2 (32-bit)
    *   - LDRH (register)   Encoding T2 (32-bit)
    *
    * Note: Formats of these instructions are identical to T2 encoding of 
    *       the STR (register) and LDR (register) ones.
    *       Testing only of "halfword" operations are performed.
    ***************************************************************************/
    ADD     R0,R0,#4    /* Update address */
    /* --- Prepare data to be stored and loaded --- */
    BL      m33_cst_loadstore_test5_init
    MOV     R3,#0x33333333  /* Add offset to R3 (will be shifted to 0x66666666)  */ 
    SUB     R2,R0,R3,LSL #1 /* Prepare address to R2 */
    /* <Rn[3:0]>:R2
       <Rt[15:12]>:R11(STRH) R12(LDRH)
       <imm2[5:4]>:#1
       <Rm[3:0]>:R3 */
    STRH.W  R11,[R2,R3,LSL #1]      /* <data_to_store>:R11=0x2468ACE0 (0xACE0) */
    MOV     R3,#0x66666666  /* Add address (0x66666666) to R3 */
    DSB
    LDRH.W  R12,[R3,R2,LSL #0]      /* <data_to_load>:R12=0xACE0 */
    /* We need to check data */
    LDR     R11,[R3,R2,LSL #0]
    LDR     R8,=0xFFFF0000
    EOR     R11,R11,R8
    CMP     R12,R11
    BNE     m33_cst_loadstore_test5_failed
    
    /* --- Prepare data to be stored and loaded --- */
    BL      m33_cst_loadstore_test5_init
    MOV     R3,#0x66666666  /* Load address to R3 */ 
    SUB     R2,R0,R3        /* Prepare offset to R2 */
    /* <Rn[3:0]>:R3
       <Rt[15:12]>:R12(STRH) R11(LDRH)
       <imm2[5:4]>:#0
       <Rm[3:0]>:R2 */
    STRH.W  R12,[R3,R2,LSL #0]       /* <data_to_store>:R12=0x0ECA8642 (0x8642) */
    MOV     R3,#0x33333333  /* Add offset to R3 (will be shifted to 0x66666666) */
    DSB
    LDRH.W  R11,[R2,R3,LSL #1]       /* <data_to_load>:R1=0x8642 */
    /* We need to check data */
    LDR     R12,[R2,R3,LSL #1]
    LDR     R8,=0xFFFF0000
    EOR     R12,R12,R8
    CMP     R11,R12
    BNE     m33_cst_loadstore_test5_failed
    
    
    /***************************************************************************
    * Instructions: 
    *   - LDRSH (register)  Encoding T2 (32-bit)
    *
    * Note: Format of this instruction is identical to T2 encoding of the 
    *       LDR (register) one.
    *       Testing only of "signed-halfword" operation is performed.
    ***************************************************************************/
    /* --- Prepare data to be stored and loaded --- */
    BL      m33_cst_loadstore_test5_init
    MOV     R1,#0x99999999  /* Add offset/address (0x99999999) to R1 */
    SUB     R0,R0,R1        /* Prepare address/offset to R0 */
    /* <Rn[3:0]>:R0
       <Rt[15:12]>:R9(STR) R10(LDRSH)
       <imm2[5:4]>:#0
       <Rm[3:0]>:R1 */
    STR.W   R9,[R0,R1,LSL #0]       /* <data_to_store>:R9=0x13579BDF*/
    DSB
    LDRSH.W R10,[R1,R0,LSL #0]      /* <data_to_load>:R10=0xFFFF9BDF */
    /* We need to check data */
    SBFX    R8,R9,#0,#16
    CMP     R10,R8
    BNE     m33_cst_loadstore_test5_failed
    
    /* --- Prepare data to be stored and loaded --- */
    BL      m33_cst_loadstore_test5_init
    MOV     R1,#0x99999999    /* Load address to R1 */
    /* <Rn[3:0]>:R1
       <Rt[15:12]>:R10(STR) R9(LDRSH)
       <imm2[5:4]>:#0
       <Rm[3:0]>:R0 */
    STR.W   R10,[R1,R0,LSL #0]      /* <data_to_store>:R10=0xFDB97531 */
    DSB
    LDRSH.W R9,[R0,R1,LSL #0]       /* <data_to_load>:R9=0x00007531 */
    /* We need to check data */
    SBFX    R8,R10,#0,#16
    CMP     R9,R8
    BNE     m33_cst_loadstore_test5_failed
    
    /*------------------------------------------------------------------------*/
    /* Test routine - end                                                     */
    /*------------------------------------------------------------------------*/    
    POP     {R1}        /* Update signature */
    ROR     R0,R1,#5
    PUSH    {R0}        /* Store signature back to stack !! */
    
m33_cst_loadstore_test5_failed:
    POP.W   {R1,PC}     /* We need to restore R1 and return back */

    
m33_cst_loadstore_test5_init:

    /***************************************************************************
    * Instruction: 
    * - LDR (literal)   Encoding T2 (32-bit)
    *
    * Note: Tested indirectly 
    ***************************************************************************/
    LDR.W   R1,=VAL1
    LDR.W   R2,=VAL2
    LDR.W   R3,=VAL3
    LDR.W   R4,=VAL4
    LDR.W   R5,=VAL5
    LDR.W   R6,=VAL6
    LDR.W   R7,=VAL7
    LDR.W   R8,=VAL8
    LDR.W   R9,=VAL9
    LDR.W   R10,=VAL10
    LDR.W   R11,=VAL11
    LDR.W   R12,=VAL12

    BX      LR
    
m33_cst_loadstore_test5_clear_target_memory:
    
    EORS    R1,R1   /* Clear R1 */
    MVN     R1,R1
    
    /* Clear memory */
    STR     R1,[R0]
    STR     R1,[R0,#4]
    STR     R1,[R0,#8]
    STR     R1,[R0,#12]
    STR     R1,[R0,#16]
    STR     R1,[R0,#20]
    
    BX      LR
    
    
    CST_ALIGN_BYTES_4
    /* Marks the current location for dumping psuedoinstruction pools containing
       numeric values for used symbolic names used within LDR instruction. */
    CST_LTORG

#endif  /* CORTST_M33_LOADSTORE_ENABLE */
    
    CST_FILE_END

