/*
 * Copyright 2020-2025 Yuntu Microelectronics co.,ltd
 * All rights reserved.
 *
 * YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 * used strictly in accordance with the applicable license terms. By expressly
 * accepting such terms or by downloading, installing, activating and/or otherwise
 * using the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software. The production use license in
 * Section 2.3 is expressly granted for this software.
 */

/******************************************************************************
* Test summary:
* -------------
*
* Covers LSU operation type:
*   - load/store single
*
* Overall coverage:
* -----------------
* Covers LDR.N, STR.N, LDRB.N, STRB.N, LDRH.N, STRH.N, LDRSB.N, STRSB.N, 
* LDRSH.N, STRSH.N instructions as well as logic processing its various 
* encoding types:
* - '<Rn>','<Rt>' and #<imm5> as well as <data_to_store> and <data_to_load>
* - '<Rt>' and '#<imm8>' as well <data_to_store> and <data_to_load>
* - '<Rm>','<Rn>','<Rt>' as well <data_to_store> and <data_to_load>
* - '<Rt>',<label> as well as <data_to_load> 
* 
* DECODER:
* Thumb (16-bit)
*   - Encoding of "Load/store single data item" instructions
******************************************************************************/

#include "CorTst_Compiler.h"
#include "CorTst_M33_Cfg.h"

#if (CORTST_M33_LOADSTORE_ENABLE==1)
    /* Compatible with ABI. */
    CST_PRES8
    /* Symbols defined in the current module but to be visible to outside */
    CST_EXPORT M33_Cst_LoadstoreTest4

    /* Symbols defined outside but used within current module */
    CST_EXTERN CST_RAM_TARGET0
    CST_EXTERN CST_RAM_TARGET1
    CST_EXTERN m33_cst_test_tail_end

    CST_EXTERN VAL1
    CST_EXTERN VAL2
    CST_EXTERN VAL3
    CST_EXTERN VAL4
    CST_EXTERN VAL5
    CST_EXTERN VAL6
    CST_EXTERN VAL7
    CST_EXTERN VAL8

    CST_SET(PRESIGNATURE, 0x72D5EA31)
        
    /*------------------------------------------------------------------------*/
    CST_SECTION_EXEC(mcal_text)
    /*------------------------------------------------------------------------*/
    /* The ".type" directive instructs the assembler/linker that the label 
       "M33_Cst_LoadstoreTest4" designates a function.
       This would cause setting the least significant bit to '1' within any 
       pointer to this function, causing change to Thumb mode whenever this 
       function is called. */
    CST_THUMB2
    CST_TYPE(M33_Cst_LoadstoreTest4, function)
M33_Cst_LoadstoreTest4:

    PUSH    {R4-R12,R14}
    
    /*------------------------------------------------------------------------*/
    /* Test - preparation                                                     */
    /*------------------------------------------------------------------------*/
    LDR.W   R1, =PRESIGNATURE /* Load pre-signature */
    PUSH    {R1}
    
    /* Backup SP to R12 - Do not overwrite R12 !!! */
    MOV     R12, SP
    
    /* Load RAM0&RAM1 pointers to R9, R10 - Do not overwrite R9, R10 !!!*/
    LDR     R9,  =CST_RAM_TARGET0
    LDR     R10, =CST_RAM_TARGET1
    
    /*------------------------------------------------------------------------*/
    /* Dual issue test routine - start                                        */
    /*------------------------------------------------------------------------*/
    /***************************************************************************
    * Instructions:
    *   - STR (immediate)   Encoding T1 (16-bit) - Dual issue
    *   - LDR (immediate)   Encoding T1 (16-bit) - Dual issue
    ***************************************************************************/
    /* Clear RAM0&RAM1 */
    MOV     R8, R9
    BL      m33_cst_loadstore_test4_clear_target_memory
    MOV     R8, R10
    BL      m33_cst_loadstore_test4_clear_target_memory

    /* Initialize registers */
    MOV     R2, R9
    MOV     R5, R10
    BL      m33_cst_loadstore_test4_init
    
    /* Modify RAM0 pointer to check imm offset */
    SUB     R4, R2, #0x60
    
    /* Store R0, R3, R6 to RAM0 */
    STR.N   R0, [R4, #0x60] /* <Rn[5:3]>:R4=0b100 */
    STR.N   R3, [R4, #0x64] /* <imm5[10:6]>:0x19=0b11001 */
    STR.N   R6, [R4, #0x68] /* <imm5[10:6]>:0x1A=0b11010 */
    DSB
    
    /* Check that pointer was not incremented */
    ADD     R4, R4, #0x60
    CMP     R4, R2
    BNE     m33_cst_loadstore_test4_failed
    
    /* Modify RAM0 and RAM1 pointers to check imm offset */
    SUB     R2, R2, #0x50
    SUB     R5, R5, #0x20
    
    MRS     R11, PRIMASK    /* Save PRIMASK to R11 - Do not overwrite R11 !!! */
    
    /* Load from RAM0 to R1, R4, R7 (Slot0) */
    /* Store R3, R6, R0 to RAM1 (Slot1) */
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    LDR.N   R1, [R2, #0x50] /* Slot0 <Rn[5:3]>:R2=0b010 */
    STR.N   R3, [R5, #0x20] /* Slot1 <Rn[5:3]>:R5=0b101 */
    LDR.N   R4, [R2, #0x54] /* Slot0 <imm5[10:6]>:0x15=0b10101 */
    STR.N   R6, [R5, #0x24] /* Slot1 */
    LDR.N   R7, [R2, #0x58] /* Slot0 */
    STR.N   R0, [R5, #0x28] /* Slot1 <imm5[10:6]>:0x0A=0b01010 */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK, R11    /* Restore PRIMASK (enable ISRs) */
    /*------------------------------------------------------------------------*/
    DSB
    
    /* Check RAM0&RAM1 pointers and data */
    ADD     R2, R2, #0x50
    ADD     R5, R5, #0x20
    BL      m33_cst_loadstore_test4_compare

    /* Modify RAM0&RAM1 pointers to check imm offset */
    SUB     R2, R2, #0x50
    SUB     R5, R5, #0x20

    /* Initialize registers */
    BL      m33_cst_loadstore_test4_init
    
    /* Store R6, R0, R3 to RAM0 (Slot0) */
    /* Load from RAM1 to R4, R7, R1 (Slot1) */
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    STR.N   R6, [R2, #0x50] /* Slot0 <Rn[5:3]>:R2=0b010 */
    LDR.N   R4, [R5, #0x20] /* Slot1 <Rn[5:3]>:R5=0b101 */
    STR.N   R0, [R2, #0x54] /* Slot0 <imm5[10:6]>:0x15=0b10101 */
    LDR.N   R7, [R5, #0x24] /* Slot1 */
    STR.N   R3, [R2, #0x58] /* Slot0 */
    LDR.N   R1, [R5, #0x28] /* Slot1 <imm5[10:6]>:0x0A=0b01010 */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK, R11    /* Restore PRIMASK (enable ISRs) */
    /*------------------------------------------------------------------------*/
    DSB
    
    /* Check RAM0&RAM1 pointers and data */
    ADD     R2, R2, #0x50
    ADD     R5, R5, #0x20
    BL      m33_cst_loadstore_test4_compare

    /* Initialize registers */
    BL      m33_cst_loadstore_test4_init
    
    /* Modify RAM0 pointer to check imm offset */
    SUB     R4, R2, #0x60
    
    /* Load RAM0 to R7, R1, R5 */
    LDR.N   R7, [R4, #0x60]
    LDR.N   R1, [R4, #0x64]
    LDR.N   R5, [R4, #0x68] /* RAM1 pointer is overwritten with data */
    
    /* Check that pointer was not incremented */
    ADD     R4, R4, #0x60
    CMP     R4, R2
    BNE     m33_cst_loadstore_test4_failed

    /* Move data to R4 and restore R5, then check data */
    MOV     R4, R5
    MOV     R5, R10 /* RAM1 pointer is restored */
    BL      m33_cst_loadstore_test4_compare

    /* !! We update signature which is on stack !! */
    LDR     R14,[SP,#0]
    ROR     R14,R14,#1    /* !! Update Signature !! */
    STR     R14,[SP,#0]
    
    /* Initialize registers */
    BL      m33_cst_loadstore_test4_init
    
    /* Modify RAM1 pointer to check imm offset */
    SUB     R4, R5, #0x60
    
    /* Store R0, R3, R6 to RAM1 */
    STR.N   R0, [R4, #0x60] /* <Rn[5:3]>:R4=0b100 */
    STR.N   R3, [R4, #0x64] /* <imm5[10:6]>:0x19=0b11001 */
    STR.N   R6, [R4, #0x68] /* <imm5[10:6]>:0x1A=0b11010 */
    DSB
    
    /* Check that pointer was not incremented */
    ADD     R4, R4, #0x60
    CMP     R4, R5
    BNE     m33_cst_loadstore_test4_failed
    
    /* Modify RAM0&RAM1 pointers to check imm offset */
    SUB     R5, R5, #0x20
    SUB     R2, R2, #0x50
    
    /* Load from RAM1 to R1, R4, R7 (Slot0) */
    /* Store R3, R6, R0 to RAM0 (Slot1) */
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    LDR.N   R1, [R5, #0x20] /* Slot0 <Rn[5:3]>:R5=0b101 */
    STR.N   R3, [R2, #0x50] /* Slot1 <Rn[5:3]>:R2=0b010 */
    LDR.N   R4, [R5, #0x24] /* Slot0 */
    STR.N   R6, [R2, #0x54] /* Slot1 <imm5[10:6]>:0x15=0b10101 */
    LDR.N   R7, [R5, #0x28] /* Slot0 <imm5[10:6]>:0x0A=0b01010 */
    STR.N   R0, [R2, #0x58] /* Slot1 */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK, R11    /* Restore PRIMASK (enable ISRs) */
    /*------------------------------------------------------------------------*/
    DSB
    
    /* Check pointers and data */
    ADD     R5, R5, #0x20
    ADD     R2, R2, #0x50
    BL      m33_cst_loadstore_test4_compare

    /* Modify RAM0&RAM1 pointers to check imm offset */
    SUB     R5, R5, #0x20
    SUB     R2, R2, #0x50

    /* Initialize registers */
    BL      m33_cst_loadstore_test4_init
    
    /* Store R6, R0, R3 to RAM1 (Slot0) */
    /* Load from RAM0 to R4, R7, R1 (Slot1) */
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    STR.N   R6, [R5, #0x20] /* Slot0 <Rn[5:3]>:R2=0b010 */
    LDR.N   R4, [R2, #0x50] /* Slot1 <Rn[5:3]>:R5=0b101 */
    STR.N   R0, [R5, #0x24] /* Slot0 */
    LDR.N   R7, [R2, #0x54] /* Slot1 <imm5[10:6]>:0x15=0b10101 */
    STR.N   R3, [R5, #0x28] /* Slot0 <imm5[10:6]>:0x0A=0b01010 */
    LDR.N   R1, [R2, #0x58] /* Slot1 */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK, R11    /* Restore PRIMASK (enable ISRs) */
    /*------------------------------------------------------------------------*/
    DSB
    
    /* Check pointers and data */
    ADD     R5, R5, #0x20
    ADD     R2, R2, #0x50
    BL      m33_cst_loadstore_test4_compare

    /* Initialize registers */
    BL      m33_cst_loadstore_test4_init
    
    /* Modify RAM1 pointer to check imm offset */
    SUB     R4, R5, #0x60
    
    /* Load RAM0 to R7, R1, R2 */
    LDR.N   R7, [R4, #0x60]
    LDR.N   R1, [R4, #0x64]
    LDR.N   R2, [R4, #0x68] /* RAM0 pointer is overwritten with data */
    
    /* Check that pointer was not incremented */
    ADD     R4, R4, #0x60
    CMP     R4, R5
    BNE     m33_cst_loadstore_test4_failed

    /* Move data to R4 and restore R2, then check data */
    MOV     R4, R2
    MOV     R2, R9 /* RAM0 pointer is restored */
    BL      m33_cst_loadstore_test4_compare

    /* !! We update signature which is on stack !! */
    LDR     R14,[SP,#0]
    ROR     R14,R14,#1    /* !! Update Signature !! */
    STR     R14,[SP,#0]

    /***************************************************************************
    * Instructions: 
    *   - STRB (immediate)  Encoding T1 (16-bit) - Dual issue
    *   - LDRB (immediate)  Encoding T1 (16-bit) - Dual issue
    *
    * Note: Formats of these instructions are identical to T1 encoding of 
    *       the STR (immediate) and LDR (immediate) ones.
    *       Testing only of "byte" operations are performed.
    ***************************************************************************/
    /* Clear RAM0&RAM1 */
    MOV     R8, R2
    BL      m33_cst_loadstore_test4_clear_target_memory
    MOV     R8, R5
    BL      m33_cst_loadstore_test4_clear_target_memory
    
    /* Initialize registers */
    BL      m33_cst_loadstore_test4_init
    MVN     R7, #0xFF
    
    /* Modify RAM0&RAM1 pointers */
    SUB     R2, R2, #0x15
    SUB     R5, R5, #0x0A

    /* Store R0 to RAM0 (Slot0) */
    /* Store R1 to RAM1 (Slot1) */
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/    
    STRB.N  R0,[R2,#0x15] /* Slot0 */
    STRB.N  R1,[R5,#0x0A] /* Slot1 */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK, R11    /* Restore PRIMASK (enable ISRs) */
    /*------------------------------------------------------------------------*/
    DSB
    
    /* Load from RAM1 to R4 (Slot0) */
    /* Load from RAM0 to R3 (Slot1) */
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    LDRB.N  R4,[R5,#0x0A] /* Slot0 */
    LDRB.N  R3,[R2,#0x15] /* Slot1 */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK, R11    /* Restore PRIMASK (enable ISRs) */
    /*------------------------------------------------------------------------*/
    
    /* Load from RAM0&RAM1 to R1&R0 */
    LDR     R1,[R2,#0x15]!
    LDR     R0,[R5,#0x0A]!
    
    /* Check RAM0&RAM1 pointers */
    CMP     R2,R9
    BNE     m33_cst_loadstore_test4_failed
    CMP     R5,R10
    BNE     m33_cst_loadstore_test4_failed    
    
    /* Check loaded data */
    EOR     R1,R1,R7
    CMP     R1,R3
    BNE     m33_cst_loadstore_test4_failed
    EOR     R0,R0,R7
    CMP     R0,R4
    BNE     m33_cst_loadstore_test4_failed

    /* !! We update signature which is on stack !! */
    LDR     R14,[SP,#0]
    ROR     R14,R14,#1    /* !! Update Signature !! */
    STR     R14,[SP,#0]
    
    /***************************************************************************
    * Instructions: 
    *   - STRH (immediate)  Encoding T1 (16-bit) - Dual issue
    *   - LDRH (immediate)  Encoding T1 (16-bit) - Dual issue
    *
    * Note: Formats of these instructions are identical to T1 encoding of 
    *       the STR (immediate) and LDR (immediate) ones.
    *       Testing only of "halfword" operations are performed.
    ***************************************************************************/
    /* Initialize registers */
    BL      m33_cst_loadstore_test4_init
    MOV     R7, #0xFFFF
    MVN     R7, R7
    
    /* Modify RAM0&RAM1 pointers */
    SUB     R2, R2, #0x2C
    SUB     R5, R5, #0x32

    /* Store R1 to RAM0 (Slot0) */
    /* Store R0 to RAM1 (Slot1) */
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/    
    STRH.N  R1,[R2,#0x2C] /* Slot0 */
    STRH.N  R0,[R5,#0x32] /* Slot1 */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK, R11    /* Restore PRIMASK (enable ISRs) */
    /*------------------------------------------------------------------------*/
    DSB
    
    /* Load from RAM1 to R3 (Slot0) */
    /* Load from RAM0 to R4 (Slot1) */
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    LDRH.N  R3,[R5,#0x32] /* Slot0 */
    LDRH.N  R4,[R2,#0x2C] /* Slot1 */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK, R11    /* Restore PRIMASK (enable ISRs) */
    /*------------------------------------------------------------------------*/
    
    /* Load from RAM0&RAM1 to R0&R1 */
    LDR     R0,[R2,#0x2C]!
    LDR     R1,[R5,#0x32]!
    
    /* Check RAM0&RAM1 pointers */
    CMP     R2,R9
    BNE     m33_cst_loadstore_test4_failed
    CMP     R5,R10
    BNE     m33_cst_loadstore_test4_failed    
    
    /* Check loaded data */
    EOR     R0,R0,R7
    CMP     R0,R4
    BNE     m33_cst_loadstore_test4_failed
    EOR     R1,R1,R7
    CMP     R1,R3
    BNE     m33_cst_loadstore_test4_failed

    /* !! We update signature which is on stack !! */
    LDR     R14,[SP,#0]
    ROR     R14,R14,#1    /* !! Update Signature !! */
    STR     R14,[SP,#0]
    
    /***************************************************************************
    * Instructions: 
    *   - STR (register)    Encoding T1 (16-bit) - Dual issue
    *   - LDR (register)    Encoding T1 (16-bit) - Dual issue
    *
    * Note: Formats of these instructions are similar to T1 encoding of 
    *       the STR (immediate) and LDR (immediate) ones.
    *       Only Rm decoder is tested
    ***************************************************************************/
    /* Initialize registers */
    BL      m33_cst_loadstore_test4_init
    MOV     R6, #0
    MOV     R1, #4

    /* Store R0, R4 to RAM0 (Slot0) */
    /* Store R3, R7 to RAM1 (Slot1) */
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/    
    STR.N   R0, [R2, R6]    /* Slot0 */
    STR.N   R3, [R5, R6]    /* Slot1 */
    STR.N   R4, [R1, R2]    /* Slot0 */
    STR.N   R7, [R1, R5]    /* Slot1 */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK, R11    /* Restore PRIMASK (enable ISRs) */
    /*------------------------------------------------------------------------*/
    DSB
    
    /* Check RAM0&RAM1 pointers */
    CMP     R2,R9
    BNE     m33_cst_loadstore_test4_failed
    CMP     R5,R10
    BNE     m33_cst_loadstore_test4_failed
    
    /* Modify RAM0 pointer */
    ADD     R2, R2, #8
    
    /* Load from RAM1 to R4, R0 (Slot0) */
    /* Store R7, R3 to RAM0 (Slot1) */
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    LDR.N   R4, [R5, R6]    /* Slot0 */
    STR.N   R7, [R6, R2]    /* Slot1 */
    LDR.N   R0, [R1, R5]    /* Slot0 */
    STR.N   R3, [R2, R1]    /* Slot1 */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK, R11    /* Restore PRIMASK (enable ISRs) */
    /*------------------------------------------------------------------------*/
    DSB
    
    /* Check RAM1 pointer */
    CMP     R5,R10
    BNE     m33_cst_loadstore_test4_failed
    
    /* Check loaded data */
    CMP     R4, #0x33333333
    BNE     m33_cst_loadstore_test4_failed
    CMP     R0, #0xEEEEEEEE
    BNE     m33_cst_loadstore_test4_failed
    
    /* Initialize registers */
    LDR     R0, =VAL1
    LDR     R4, =VAL5
    
    /* Modify RAM0&RAM1 pointers */
    SUB     R2, R2, #8
    ADD     R5, R5, #8
    
    /* Store R4, R0 to RAM1 (Slot0) */
    /* Load from RAM0 to R7, R3 (Slot1) */
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    STR.N   R4, [R6, R5]    /* Slot0 */
    LDR.N   R7, [R2, R6]    /* Slot1 */
    STR.N   R0, [R5, R1]    /* Slot0 */
    LDR.N   R3, [R1, R2]    /* Slot1 */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK, R11    /* Restore PRIMASK (enable ISRs) */
    /*------------------------------------------------------------------------*/
    DSB
    
    /* Check RAM0 pointer */
    CMP     R2,R9
    BNE     m33_cst_loadstore_test4_failed
    
    /* Check loaded data */
    CMP     R3, #0x99999999
    BNE     m33_cst_loadstore_test4_failed
    CMP     R7, #0x55555555
    BNE     m33_cst_loadstore_test4_failed
    
    /* Modify RAM0 pointer */
    ADD     R2, R2, #8
    
    /* Load from RAM0 to R3, R7 (Slot0) */
    /* Load from RAM1 to R0, R4 (Slot1) */
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    LDR.N   R3, [R6, R2]    /* Slot0 */
    LDR.N   R0, [R6, R5]    /* Slot1 */
    LDR.N   R7, [R2, R1]    /* Slot0 */
    LDR.N   R4, [R5, R1]    /* Slot1 */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK, R11    /* Restore PRIMASK (enable ISRs) */
    /*------------------------------------------------------------------------*/
    
    /* Modify RAM0&RAM1 pointers */
    SUB     R2, R2, #8
    SUB     R5, R5, #8
    
    /* Check RAM0&RAM1 pointers */
    CMP     R2,R9
    BNE     m33_cst_loadstore_test4_failed
    CMP     R5,R10
    BNE     m33_cst_loadstore_test4_failed
    
    /* Check RAM0&RAM1 offsets */
    CMP     R6, #0
    BNE     m33_cst_loadstore_test4_failed
    CMP     R1, #4
    BNE     m33_cst_loadstore_test4_failed

    /* Check loaded data */
    CMP     R0, #0x99999999
    BNE     m33_cst_loadstore_test4_failed
    CMP     R3, #0xEEEEEEEE
    BNE     m33_cst_loadstore_test4_failed
    CMP     R4, #0x55555555
    BNE     m33_cst_loadstore_test4_failed
    CMP     R7, #0x33333333
    BNE     m33_cst_loadstore_test4_failed

    /* !! We update signature which is on stack !! */
    LDR     R14,[SP,#0]
    ROR     R14,R14,#1    /* !! Update Signature !! */
    STR     R14,[SP,#0]
    
    /***************************************************************************
    * Instructions: 
    *   - STRB  (register)  Encoding T1 (16-bit) - Dual issue
    *   - LDRB  (register)  Encoding T1 (16-bit) - Dual issue
    *   - LDRSB (register)  Encoding T1 (16-bit) - Dual issue
    *
    * Note: Formats of these instructions are identical to T1 encoding of 
    *       the STR (register) and LDR (register) ones.
    *       Testing only of "byte" and "signed-byte" operations are performed.
    ***************************************************************************/
    /* Initialize registers */
    MVN     R8, #0xFF
    
    /* Modify RAM0&RAM1 pointers */
    SUB     R2, R2, #0x15
    SUB     R5, R5, #0x0A
    
    /* Set memory offsets */
    MOV     R0, #0x25
    MOV     R7, #0x1A

    /* Store R3 to RAM0 (Slot0) */
    /* Store R4 to RAM1 (Slot1) */
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/    
    STRB.N  R3,[R2, R0]     /* Slot0 */
    STRB.N  R4,[R5, R7]     /* Slot1 */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK, R11    /* Restore PRIMASK (enable ISRs) */
    /*------------------------------------------------------------------------*/
    DSB
    
    /* Load from RAM1 to R1 (Slot0) */
    /* Load from RAM0 to R6 (Slot1) */
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    LDRB.N  R1,[R5, R7]     /* Slot0 */
    LDRB.N  R6,[R2, R0]     /* Slot1 */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK, R11    /* Restore PRIMASK (enable ISRs) */
    /*------------------------------------------------------------------------*/
    
    /* Load from RAM0&RAM1 to R4&R3 */
    LDR     R4,[R2, R0]
    LDR     R3,[R5, R7]
    
    /* Check loaded data */
    EOR     R3,R3,R8
    CMP     R3,R1
    BNE     m33_cst_loadstore_test4_failed
    EOR     R4,R4,R8
    CMP     R4,R6
    BNE     m33_cst_loadstore_test4_failed
    
    /* Load from RAM1 to R6 (Slot0) */
    /* Load from RAM0 to R1 (Slot1) */
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    LDRSB.N R6, [R7, R5]    /* Slot0 */
    LDRSB.N R1, [R0, R2]    /* Slot1 */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK, R11    /* Restore PRIMASK (enable ISRs) */
    /*------------------------------------------------------------------------*/
    
    /* Check loaded data */
    CMP     R3,R6
    BNE     m33_cst_loadstore_test4_failed
    EOR     R4,R4,R8
    CMP     R4,R1
    BNE     m33_cst_loadstore_test4_failed
    
    /* Modify RAM0&RAM1 pointers */
    ADD     R2, R2, #0x15
    ADD     R5, R5, #0x0A
    
    /* Check RAM0&RAM1 pointers */
    CMP     R2,R9
    BNE     m33_cst_loadstore_test4_failed
    CMP     R5,R10
    BNE     m33_cst_loadstore_test4_failed

    /* !! We update signature which is on stack !! */
    LDR     R14,[SP,#0]
    ROR     R14,R14,#1    /* !! Update Signature !! */
    STR     R14,[SP,#0]
    
    /***************************************************************************
    * Instructions: 
    *   - STRH  (register)  Encoding T1 (16-bit) - Dual issue
    *   - LDRH  (register)  Encoding T1 (16-bit) - Dual issue
    *   - LDRSH (register)  Encoding T1 (16-bit) - Dual issue
    *
    * Note: Formats of these instructions are identical to T1 encoding of 
    *       the STR (register) and LDR (register) ones.
    *       Testing only "halfword" and "signed-halfword" operations.
    ***************************************************************************/
    /* Initialize registers */
    BL      m33_cst_loadstore_test4_init
    MOV     R8, #0xFFFF
    MVN     R8, R8
    
    /* Modify RAM0&RAM1 pointers */
    SUB     R2, R2, #0x15
    SUB     R5, R5, #0x0A
    
    /* Set memory offsets */
    MOV     R3, #0x29
    MOV     R4, #0x1E

    /* Store R7 to RAM0 (Slot0) */
    /* Store R0 to RAM1 (Slot1) */
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/    
    STRH.N  R7,[R2, R3]     /* Slot0 */
    STRH.N  R0,[R5, R4]     /* Slot1 */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK, R11    /* Restore PRIMASK (enable ISRs) */
    /*------------------------------------------------------------------------*/
    DSB
    
    /* Load from RAM1 to R1 (Slot0) */
    /* Load from RAM0 to R6 (Slot1) */
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    LDRH.N  R1,[R5, R4]     /* Slot0 */
    LDRH.N  R6,[R2, R3]     /* Slot1 */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK, R11    /* Restore PRIMASK (enable ISRs) */
    /*------------------------------------------------------------------------*/
    
    /* Load from RAM0&RAM1 to R0&R7 */
    LDR     R0,[R2, R3]
    LDR     R7,[R5, R4]
    
    /* Check loaded data */
    EOR     R7,R7,R8
    CMP     R7,R1
    BNE     m33_cst_loadstore_test4_failed
    EOR     R0,R0,R8
    CMP     R0,R6
    BNE     m33_cst_loadstore_test4_failed
    
    /* Load from RAM1 to R6 (Slot0) */
    /* Load from RAM0 to R1 (Slot1) */
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    LDRSH.N R6, [R4, R5]    /* Slot0 */
    LDRSH.N R1, [R3, R2]    /* Slot1 */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK, R11    /* Restore PRIMASK (enable ISRs) */
    /*------------------------------------------------------------------------*/
    
    /* Check loaded data */
    CMP     R7,R6
    BNE     m33_cst_loadstore_test4_failed
    EOR     R0,R0,R8
    CMP     R0,R1
    BNE     m33_cst_loadstore_test4_failed
    
    /* Modify RAM0&RAM1 pointers */
    ADD     R2, R2, #0x15
    ADD     R5, R5, #0x0A
    
    /* Check RAM0&RAM1 pointers */
    CMP     R2,R9
    BNE     m33_cst_loadstore_test4_failed
    CMP     R5,R10
    BNE     m33_cst_loadstore_test4_failed

    /* !! We update signature which is on stack !! */
    LDR     R14,[SP,#0]
    ROR     R14,R14,#1    /* !! Update Signature !! */
    STR     R14,[SP,#0]
    
    /***************************************************************************
    * Instructions: 
    *   - STR (immediate)   Encoding T2 (16-bit) - Dual issue
    *   - LDR (immediate)   Encoding T2 (16-bit) - Dual issue
    *
    * Dual issue test:
    *   - Functionality of LSU is checked in T1 encoding test
    ***************************************************************************/
    
    /* Initialize registers and stack*/
    BL      m33_cst_loadstore_test4_init
    LDR.N   R2,=VAL3
    LDR.N   R5,=VAL6
    PUSH    {R2, R5}
    
    /* Store SP -8 backup */
    MOV     R8, SP
    
    /*------------------------------------------------------------------------*/
    CPSID   i               /* Disable interupts */
    NOP
    /*------------------------------------------------------------------------*/
    /* Modify SP to check imm offset */
    SUB     SP, #0x150
    /*------------------------------------------------------------------------*/
    CST_FLUSH_PIPELINE
    /*------------------------------------------------------------------------*/
    LDR.N   R0, [SP, #0x150] /* Slot0 */
    STR.N   R4, [SP, #0x154] /* Slot1 */
    DSB
    
    /* Check that SP was not changed */
    ADD     SP, #0x150
    CMP     SP, R8
    BNE     m33_cst_loadstore_test4_failed
    
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK, R11    /* Restore PRIMASK (enable ISRs) */
    /*------------------------------------------------------------------------*/
    
    /* Check data */
    CMP     R0, R2
    BNE     m33_cst_loadstore_test4_failed
    
    /*------------------------------------------------------------------------*/
    CPSID   i               /* Disable interupts */
    NOP
    /*------------------------------------------------------------------------*/
    /* Modify SP to check imm offset */
    SUB     SP, #0x198
    /*------------------------------------------------------------------------*/
    CST_FLUSH_PIPELINE
    /*------------------------------------------------------------------------*/
    LDR.N   R3, [SP, #0x19C] /* Slot0 */
    STR.N   R1, [SP, #0x198] /* Slot1 */
    DSB
    
    /* Check that SP was not changed */
    ADD     SP, #0x198
    CMP     SP, R8
    BNE     m33_cst_loadstore_test4_failed
    
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK, R11    /* Restore PRIMASK (enable ISRs) */
    /*------------------------------------------------------------------------*/
    
    /* Check data */
    CMP     R3, R4
    BNE     m33_cst_loadstore_test4_failed
    
    /*------------------------------------------------------------------------*/
    CPSID   i               /* Disable interupts */
    NOP
    /*------------------------------------------------------------------------*/
    /* Modify SP to check imm offset */
    SUB     SP, #0x1E0
    /*------------------------------------------------------------------------*/
    CST_FLUSH_PIPELINE
    /*------------------------------------------------------------------------*/
    STR.N   R7, [SP, #0x1E4] /* Slot0 */
    LDR.N   R6, [SP, #0x1E0] /* Slot1 */
    DSB
    
    /* Check that SP was not changed */
    ADD     SP, #0x1E0
    CMP     SP, R8
    BNE     m33_cst_loadstore_test4_failed
    
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK, R11    /* Restore PRIMASK (enable ISRs) */
    /*------------------------------------------------------------------------*/
    
    /* Check data */
    CMP     R6, R1
    BNE     m33_cst_loadstore_test4_failed
    
    /*------------------------------------------------------------------------*/
    CPSID   i               /* Disable interupts */
    NOP
    /*------------------------------------------------------------------------*/
    /* Modify SP to check imm offset */
    SUB     SP, SP, #0x200
    /*------------------------------------------------------------------------*/
    CST_FLUSH_PIPELINE
    /*------------------------------------------------------------------------*/
    LDR.N   R2, [SP, #0x204] /* Slot0 */
    STR.N   R3, [SP, #0x200] /* Slot1 */
    DSB
    
    /* Check that SP was not changed */
    ADD     SP, SP, #0x200
    CMP     SP, R8
    BNE     m33_cst_loadstore_test4_failed
    
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK, R11    /* Restore PRIMASK (enable ISRs) */
    /*------------------------------------------------------------------------*/
    
    /* Check data */
    CMP     R2, R7
    BNE     m33_cst_loadstore_test4_failed
    
    /* Load data stored in stack */
    POP     {R0, R4}
    
    /* Check data */
    CMP     R0, R3
    BNE     m33_cst_loadstore_test4_failed
    CMP     R4, R2    
    BNE     m33_cst_loadstore_test4_failed
    
    
    /*------------------------------------------------------------------------*/
    /* Test - end                                                             */
    /*------------------------------------------------------------------------*/
    POP.N   {R1}            /* Update signature */
    ROR     R0,R1,#1
    PUSH.N  {R0}            /* Store signature back to stack !! */
m33_cst_loadstore_test4_failed:
    MOV     SP, R12         /* Restore SP */
    MSR     PRIMASK, R11    /* Restore PRIMASK (enable ISRs) */
    POP     {R1}
    /* Test result is returned in R0, according to the conventions */
    MVN     R0,R1
m33_cst_loadstore_test4_end:
    B       m33_cst_test_tail_end


    /*------------------------------------------------------------------------*/
    /* Load test values to registers R0, R1, R3, R4, R6, R7                   */
    /*------------------------------------------------------------------------*/
m33_cst_loadstore_test4_init:
    /***************************************************************************
    * Instruction: 
    * - LDR (literal)   Encoding T1 (16-bit)
    *
    * Note: Tested indirectly 
    ***************************************************************************/
    LDR.N   R0,=VAL1
    LDR.N   R1,=VAL2
    LDR.N   R3,=VAL4
    LDR.N   R4,=VAL5
    LDR.N   R6,=VAL7
    LDR.N   R7,=VAL8

    BX  LR
    
    /*------------------------------------------------------------------------*/
    /* Clear 6 words starting from address in R8                              */
    /*------------------------------------------------------------------------*/
m33_cst_loadstore_test4_clear_target_memory:
    MVN     R4, #0          /* Set R4 to 0xFFFFFFFF */
    
    /* Clear memory */
    STR     R4,[R8]
    STR     R4,[R8,#4]
    STR     R4,[R8,#8]
    STR     R4,[R8,#12]
    STR     R4,[R8,#16]
    STR     R4,[R8,#20]
    
    DSB
    BX      LR

    /*------------------------------------------------------------------------*/
    /* Compare registers {R2, R9}, {R5, R10}, {R0, R1}, {R3, R4}, {R6, R7}    */
    /*------------------------------------------------------------------------*/
m33_cst_loadstore_test4_compare:
    CMP     R2, R9
    BNE     m33_cst_loadstore_test4_failed
    CMP     R5, R10
    BNE     m33_cst_loadstore_test4_failed

    CMP     R0, R1
    BNE     m33_cst_loadstore_test4_failed
    CMP     R3, R4
    BNE     m33_cst_loadstore_test4_failed
    CMP     R6, R7
    BNE     m33_cst_loadstore_test4_failed

    BX      LR

    CST_ALIGN_BYTES_4
    /* Marks the current location for dumping psuedoinstruction pools containing
       numeric values for used symbolic names used within LDR instruction. */
    CST_LTORG

#endif  /* CORTST_M33_LOADSTORE_ENABLE */
    
    CST_FILE_END

