/*
 * Copyright 2020-2025 Yuntu Microelectronics co.,ltd
 * All rights reserved.
 *
 * YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 * used strictly in accordance with the applicable license terms. By expressly
 * accepting such terms or by downloading, installing, activating and/or otherwise
 * using the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software. The production use license in
 * Section 2.3 is expressly granted for this software.
 */

/******************************************************************************
* Test summary:
* -------------
*   Tests forwarding logic functionality. 
*   - Verifies that results from one instruction can be used immediately 
*     as inputs in next instructions. Values are not taken from register file 
*     but they must be forwarded.
*
* The following cases are tested:
* -------------------------------
* 1) Forward data from the end of EX1 stage to ALU EX1 stage
* 2) Forward data from the end of EX1 stage to MAC EX1 stage
* 3) Forward data from the end of EX1 stage to DIV EX1 stage
* 4) Forward data from the end of EX1 stage to SHIFT EX1 stage
******************************************************************************/

#include "CorTst_Compiler.h"
#include "CorTst_M33_Cfg.h"

#if (CORTST_M33_FORWARD_ENABLE==1)
    /* Compatible with ABI. */
    CST_PRES8
    /* Symbols defined in the current module but to be visible to outside */
    CST_EXPORT M33_Cst_ForwardingTest3

    /* Symbols defined outside but used within current module */
    CST_EXTERN m33_cst_test_tail_end
    

    CST_SET(PRESIGNATURE, 0xD38212FD)
   
    /* Values stored in registers:
       - R0  ... accumulated signature
       - R12 ... PRIMASK
    */
    /*------------------------------------------------------------------------*/
    CST_SECTION_EXEC(mcal_text)
    /*------------------------------------------------------------------------*/
    /* The ".type" directive instructs the assembler/linker that the label 
       "M33_Cst_ForwardingTest3" designates a function.
       This would cause setting the least significant bit to '1' within any 
       pointer to this function, causing change to Thumb mode whenever this 
       function is called. */
    CST_THUMB2
    CST_TYPE(M33_Cst_ForwardingTest3, function)
M33_Cst_ForwardingTest3:

    PUSH    {R4-R12,R14}
    
    /*------------------------------------------------------------------------*/
    /* Test - preparation                                                     */
    /*------------------------------------------------------------------------*/
    LDR     R0,=PRESIGNATURE    /* Initialize results registers */
    
    
    /*------------------------------------------------------------------------*/
    /* Test - start                                                           */
    /*------------------------------------------------------------------------*/
    MRS     R12,PRIMASK                 /* Save PRIMASK  */
    
    MOV     R1,#0x00000000
    MSR     APSR_nzcvq,R1               /* Clear flags */
   
    /**************************************************************************/
    /* 1) Test forwarding from EX1 to ALU0,ALU1                               */
    /**************************************************************************/
    MOV     R1,#0x55555555      /* First value to be forwarded !! */
    BL      m33_cst_forwarding_test3_part1
    MOV     R1,#0xAAAAAAAA      /* First value to be forwarded !! */
    BL      m33_cst_forwarding_test3_part1
      
    /**************************************************************************/
    /* 2) Test forwarding from EX1 to MAC                                     */
    /**************************************************************************/
    MOV     R1,#0x55555555      /* First value to be forwarded !! */
    BL      m33_cst_forwarding_test3_part2
    MOV     R1,#0xAAAAAAAA      /* First value to be forwarded !! */
    BL      m33_cst_forwarding_test3_part2
    
    /**************************************************************************/
    /* 3) Test forwarding from EX1 to DIV                                     */
    /**************************************************************************/
    MOV     R1,#0x55555555      /* First value to be forwarded !! */
    BL      m33_cst_forwarding_test3_part3
    MOV     R1,#0xAAAAAAAA      /* First value to be forwarded !! */
    BL      m33_cst_forwarding_test3_part3
    
    /**************************************************************************/
    /* 4) Test forwarding from EX1 to DIV                                     */
    /**************************************************************************/
    MOV     R1,#0x55555555      /* First value to be forwarded !! */
    BL      m33_cst_forwarding_test3_part4
    MOV     R1,#0xAAAAAAAA      /* First value to be forwarded !! */
    BL      m33_cst_forwarding_test3_part4
   
    
    /*------------------------------------------------------------------------*/
    /* Test routine - End                                                     */
    /*------------------------------------------------------------------------*/    
m33_cst_forwarding_test3_end:
    /* Test result is returned in R0, according to the conventions */ 
    B       m33_cst_test_tail_end
    
    
    /*------------------------------------------------------------------------*/
    /* Test - internal routines                                               */
    /*------------------------------------------------------------------------*/
    /**************************************************************************/
    /* 1) Forwarding from EX1->ALU EX1                                        */
    /**************************************************************************/
m33_cst_forwarding_test3_part1:
    MOV     R11,#10             /* Initialize loop counter */
    PUSH    {R14}
m33_cst_forwarding_test3_loop1:
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE               
    /*------------------------------------------------------------------------*/
    REV     R10,R1          /* Slot0 - REV produces result at the end of EX1 */
    NOP                     /* Slot1 */
    ADD     R3,R1,R10       /* Slot0 - Forward data to A0 read port !! */
    ADD     R4,R1,R10       /* Slot1 - Forward data to A1 read port !! */
    /*------------------------------------------------------------------------*/
    ISB     /* Flush pipeline */
    /*------------------------------------------------------------------------*/
    REV     R10,R1          /* Slot0 - REV produces result at the end of EX1 */
    NOP                     /* Slot1 */
    SUB     R5,R10,R1       /* Slot0 - Forward data to B0 read port !! */
    SUB     R6,R10,R1       /* Slot1 - Forward data to B1 read port !! */
    /*------------------------------------------------------------------------*/
    ISB     /* Flush pipeline */
    /*------------------------------------------------------------------------*/
    NOP                     /* Slot0 */
    REV     R10,R1          /* Slot1 - REV produces result at the end of EX1 */
    ADD     R7,R1,R10       /* Slot0 - Forward data to A0 read port !! */
    ADD     R8,R1,R10       /* Slot1 - Forward data to A1 read port !! */
    /*------------------------------------------------------------------------*/
    ISB     /* Flush pipeline */
    /*------------------------------------------------------------------------*/
    NOP                     /* Slot0 */
    REV     R10,R1          /* Slot1 - REV produces result at the end of EX1 */
    SUB     R9,R10,R1       /* Slot0 - Forward data to B0 read port !! */
    SUB     R10,R10,R1      /* Slot1 - Forward data to B1 read port !! */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R12
    /*------------------------------------------------------------------------*/
    /* Update signature !! */
    BL      m33_cst_forwarding_test3_sum_r3_r10      
    /* Prepare new random data to be forwarded in next cycle */
    MOV     R1,R0
    SUBS    R11,R11,#1
    BNE     m33_cst_forwarding_test3_loop1  
    
    POP     {R15}   /* Exit test subroutine */
    
   
    /**************************************************************************/
    /* 2) Forwarding from EX1->MAC EX1                                        */
    /**************************************************************************/
m33_cst_forwarding_test3_part2:
    MOV     R11,#10             /* Initialize loop counter */
    PUSH    {R14}
m33_cst_forwarding_test3_loop2:
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE               
    /*------------------------------------------------------------------------*/
    REV     R10,R1          /* Slot0 - REV produces result at the end of EX1 */
    NOP                     /* Slot1 */
    UMULL   R3,R4,R1,R10    /* Slot0 - Forward data to A0 read port !! */
    NOP                     /* Slot1 */
    /*------------------------------------------------------------------------*/
    ISB     /* Flush pipeline */
    /*------------------------------------------------------------------------*/
    REV     R10,R1          /* Slot0 - REV produces result at the end of EX1 */
    NOP                     /* Slot1 */
    UMULL   R5,R6,R10,R1    /* Slot0 - Forward data to B0 read port !! */
    NOP                     /* Slot1 */
    /*------------------------------------------------------------------------*/
    ISB     /* Flush pipeline */
    /*------------------------------------------------------------------------*/
    NOP                     /* Slot0 */
    REV     R10,R1          /* Slot1 - REV produces result at the end of EX1 */
    UMULL   R7,R8,R1,R10    /* Slot0 - Forward data to A0 read port !! */
    NOP                     /* Slot1 */
    /*------------------------------------------------------------------------*/
    ISB     /* Flush pipeline */
    /*------------------------------------------------------------------------*/
    NOP                     /* Slot0 */
    REV     R10,R1          /* Slot1 - REV produces result at the end of EX1 */
    UMULL   R9,R10,R10,R1   /* Slot0 - Forward data to B0 read port !! */
    NOP                     /* Slot1 */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R12
    /*------------------------------------------------------------------------*/
    /* Update signature !! */
    BL      m33_cst_forwarding_test3_sum_r3_r10      
    /* Prepare new random data to be forwarded in next cycle */
    MOV     R1,R0
    SUBS    R11,R11,#1
    BNE     m33_cst_forwarding_test3_loop2  
    
    POP     {R15}   /* Exit test subroutine */
    
    
    /**************************************************************************/
    /* 3) Forwarding from EX1->DIV EX1                                        */
    /**************************************************************************/
m33_cst_forwarding_test3_part3:
    MOV     R11,#10             /* Initialize loop counter */
    PUSH    {R14}
m33_cst_forwarding_test3_loop3:
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE               
    /*------------------------------------------------------------------------*/
    REV     R10,R1          /* Slot0 - REV produces result at the end of EX1 */
    NOP                     /* Slot1 */
    UDIV    R7,R1,R10       /* Slot0 - Forward data to A0 read port !! */
    NOP                     /* Slot1 */
    /*------------------------------------------------------------------------*/
    ISB     /* Flush pipeline */
    /*------------------------------------------------------------------------*/
    REV     R10,R1          /* Slot0 - REV produces result at the end of EX1 */
    NOP                     /* Slot1 */
    UDIV    R8,R10,R1       /* Slot0 - Forward data to B0 read port !! */
    NOP                     /* Slot1 */
    /*------------------------------------------------------------------------*/
    ISB     /* Flush pipeline */
    /*------------------------------------------------------------------------*/
    NOP                     /* Slot0 */
    REV     R10,R1          /* Slot1 - REV produces result at the end of EX1 */
    UDIV    R9,R1,R10       /* Slot0 - Forward data to A0 read port !! */
    NOP                     /* Slot1 */
    /*------------------------------------------------------------------------*/
    ISB     /* Flush pipeline */
    /*------------------------------------------------------------------------*/
    NOP                     /* Slot0 */
    REV     R10,R1          /* Slot1 - REV produces result at the end of EX1 */
    UDIV    R10,R10,R1      /* Slot0 - Forward data to B0 read port !! */
    NOP                     /* Slot1 */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R12
    /*------------------------------------------------------------------------*/
    /* Update signature !! */
    BL      m33_cst_forwarding_test3_sum_r7_r10      
    /* Prepare new random data to be forwarded in next cycle */
    MOV     R1,R0
    SUBS    R11,R11,#1
    BNE     m33_cst_forwarding_test3_loop3  
    
    POP     {R15}   /* Exit test subroutine */
    
    
    /**************************************************************************/
    /* 4) Forwarding from EX1->SHIFT EX1                                      */
    /**************************************************************************/
m33_cst_forwarding_test3_part4:
    MOV     R11,#10             /* Initialize loop counter */
    PUSH    {R14}
m33_cst_forwarding_test3_loop4:
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE               
    /*------------------------------------------------------------------------*/
    REV     R10,R1              /* Slot0 - DPU produces result to W0 port */
    NOP                         /* Slot1 */   
    ROR     R3,R1,R10           /* Slot0 - Forward data to A0 read port !! */
    ROR     R4,R1,R10           /* Slot1 - Forward data to A1 read port !! */
    /*------------------------------------------------------------------------*/
    ISB     /* Flush pipeline */
    /*------------------------------------------------------------------------*/
    REV     R10,R1              /* Slot0 - DPU produces result to W0 port */
    NOP                         /* Slot1 */  
    ROR     R5,R10,R1           /* Slot0 - Forward data to B0 read port !! */
    ROR     R6,R10,R1           /* Slot1 - Forward data to B1 read port !! */
    /*------------------------------------------------------------------------*/
    ISB     /* Flush pipeline */
    /*------------------------------------------------------------------------*/
    NOP                         /* Slot0 */
    REV     R10,R1              /* Slot1 - DPU produces result to W0 port */
    ROR     R7,R1,R10           /* Slot0 - Forward data to A0 read port !! */
    ROR     R8,R1,R10           /* Slot1 - Forward data to A1 read port !! */
    /*------------------------------------------------------------------------*/
    ISB     /* Flush pipeline */
    /*------------------------------------------------------------------------*/
    NOP                         /* Slot0 */
    REV     R10,R1              /* Slot1 - DPU produces result to W0 port */
    ROR     R9,R10,R1           /* Slot0 - Forward data to B0 read port !! */
    ROR     R10,R10,R1          /* Slot1 - Forward data to B1 read port !! */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R12
    /*------------------------------------------------------------------------*/
    /* Update signature !! */
    BL      m33_cst_forwarding_test3_sum_r3_r10      
    /* Prepare new random data to be forwarded in next cycle */
    MOV     R1,R0
    SUBS    R11,R11,#1
    BNE     m33_cst_forwarding_test3_loop4
    
    POP     {R15}   /* Exit test subroutine */
    
    
    /**************************************************************************/
    /* !! Update Signature !!                                                 */
    /**************************************************************************/
m33_cst_forwarding_test3_sum_r3_r10:
    SBC     R3,R3,R0,ROR #1
    EOR     R0,R0,R3
    SBC     R4,R4,R0,ROR #2
    EOR     R0,R0,R4
    SBC     R5,R5,R0,ROR #3
    EOR     R0,R0,R5
    SBC     R6,R6,R0,ROR #4
    EOR     R0,R0,R6
m33_cst_forwarding_test3_sum_r7_r10:
    SBC     R7,R7,R0,ROR #5
    EOR     R0,R0,R7
    SBC     R8,R8,R0,ROR #6
    EOR     R0,R0,R8
    SBC     R9,R9,R0,ROR #7
    EOR     R0,R0,R9
    SBC     R10,R10,R0,ROR #8
    EOR     R0,R0,R10
    
    BX      LR
    
    
    CST_ALIGN_BYTES_4
    /* Marks the current location for dumping psuedoinstruction pools containing
       numeric values for used symbolic names used within LDR instruction. */
    CST_LTORG

#endif /* CORTST_M33_FORWARD_ENABLE */
    
    CST_FILE_END

