/*
 * Copyright 2020-2025 Yuntu Microelectronics co.,ltd
 * All rights reserved.
 *
 * YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 * used strictly in accordance with the applicable license terms. By expressly
 * accepting such terms or by downloading, installing, activating and/or otherwise
 * using the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software. The production use license in
 * Section 2.3 is expressly granted for this software.
 */

/******************************************************************************
* Test summary:
* -------------
*
* Tests triggering of MemFault exception.
*
******************************************************************************/

#include "CorTst_M33_Cfg.h"
#include "CorTst_Compiler.h"

#if (CORTST_M33_INTERRUPT_ENABLE == 1U)
    /* Compatible with ABI. */
    CST_PRES8
    /* Symbols defined in the current module but to be visible to outside */
    CST_EXPORT M33_Cst_ExcMemFaultTest

    /* Symbols defined outside but used within current module */
    CST_EXTERN m33_cst_test_tail_end
    CST_EXTERN m33_cst_store_registers_content
    CST_EXTERN m33_cst_restore_registers_content
    CST_EXTERN m33_cst_set_cst_interrupt_vector_table
    CST_EXTERN m33_cst_ISR_address
    CST_EXTERN m33_cst_exception_timeout

    
    CST_SET(PRESIGNATURE, 0x364ED615)
    
    CST_DEFINE(M33_XN_REGION_ADDR, 0xFFFFFFF8)
    
    /*------------------------------------------------------------------------*/
    CST_SECTION_EXEC(mcal_text)
    /*------------------------------------------------------------------------*/
    /* The ".type" directive instructs the assembler/linker that the label 
       "M33_Cst_ExcMemFaultTest" designates a function.
       This would cause setting the least significant bit to '1' within any 
       pointer to this function, causing change to Thumb mode whenever this 
       function is called. */
    CST_THUMB2  
    CST_TYPE(M33_Cst_ExcMemFaultTest,function)
M33_Cst_ExcMemFaultTest:
    
    PUSH    {R4-R12,R14}

    /*------------------------------------------------------------------------*/
    /* Test - preparation                                                     */
    /*------------------------------------------------------------------------*/
    LDR     R5,=PRESIGNATURE
    
    /*------------------------------------------------------------------------*/
    /* Store register content                                                 */
    /*------------------------------------------------------------------------*/
    /* !! Don't use R6, R7, R8, R9 for any other purpose until CONTROL, PRIMASK,
          FAULTMASK and BASEPRI are restored !! */
    BL      m33_cst_store_registers_content
    
    /*------------------------------------------------------------------------*/
    /* Test - start                                                           */
    /*------------------------------------------------------------------------*/   
    /* Store address of the CST-own ISR into the m33_cst_ISR_address pointer */
    ADR.W   R4,m33_cst_exc_mem_fault_ISR0
    ORR     R4,R4,#1        /* Set bit [0] as this address will be used within 
                               BX command and should indicate the Thumb code */
    LDR     R3,=m33_cst_ISR_address
    STR     R4,[R3]
    
    /* Before vector table is changed to the CST-own one, set R2 to
       to the expected ISR number and R0 to the expected ISR address.
       
       Content of R0 and R2 will allow determining whether interrupt was 
       triggered by CST library or by alien SW.

    !! Don't use R0, R2 for any other purpose until vector table is changed 
       to a user one. !! */ 
    MOV     R2,#0x3     /* R2 indicates that CST library will explicitly 
                           initiate an exception with IRQ number 0x3 */
    LDR     R0,=m33_cst_exc_mem_fault_test_ISR0_addr
    BIC     R0,R0,#1    /* Clear bit [0]. Ensures that label is not treated as 
                           Thumb function */
    
    /*------------------------------------------------------------------------*/
    /* Set CST interrupt vector table & Disable external interrupts          */
    /*------------------------------------------------------------------------*/
    BL      m33_cst_set_cst_interrupt_vector_table
    
    CPSID   i   /* Set PRIMASK -> Escalate SVC to HardFault ! */
    CPSIE   f   /* Clear FAULTMASK */
    
    /*************************************************************************
      Next ISR1 requires to be generated from the Thread mode. 
      We must ensure that we will return to the Thread Mode 
      even if test was invoked from Handler mode !!                  
     *************************************************************************/
    SVC     #0  /* -> Generate exception and return to the Thread mode !!  */
    
m33_cst_exc_mem_fault_test_ISR0_addr:
    
    /*------------------------------------------------------------------------*/
    /* Restore all registers & Enable external interrupts                     */
    /*------------------------------------------------------------------------*/
    BL      m33_cst_restore_registers_content

    /* Store address of the CST-own ISR into the m33_cst_ISR_address pointer */
    ADR.W   R4,m33_cst_exc_mem_fault_ISR1
    ORR     R4,R4,#1        /* Set bit [0] as this address will be used within 
                               BX command and should indicate the Thumb code */
    LDR     R3,=m33_cst_ISR_address
    STR     R4,[R3]
    
    /* Before vector table is changed to the CST-own one, set R2 to
       to the expected ISR number and R0 to the expected ISR address.
       
       Content of R0 and R2 will allow determining whether interrupt was 
       triggered by CST library or by alien SW.

    !! Don't use R0, R2 for any other purpose until vector table is changed 
       to a user one. !! */ 
    MOV     R2,#0x4     /* R2 indicates that CST library will explicitly 
                           initiate an exception with IRQ number 0x4 */
                           
    /* If an EXC_RETURN value is loaded into the PC when in Thread mode !!
       the value is treated as an address, not as a special value !! */                       
    LDR     R0,=M33_XN_REGION_ADDR  /* Load R0 with (XN) region address */
    
    /*------------------------------------------------------------------------*/
    /* Set CST interrupt vector table & Disable external interrupts          */
    /*------------------------------------------------------------------------*/
    BL      m33_cst_set_cst_interrupt_vector_table   
    /* We need to enable MemFault fault exception */
    LDR     R3,=M33_SHCSR_REG
    LDR     R4,[R3]             /* Load SHCSR register */
    ORR     R4,R4,#(1<<16)      /* Set SHCSR[MEMFAULTENA] bit */
    STR     R4,[R3]             /* Modify SHCSR register */
    
    CPSIE   i   /* Clear PRIMASK   */
    CPSIE   f   /* Clear FAULTMASK */
    
    CST_QUA_FAULT_INJECTION(CST_ERROR_INJECT_MEM_FAULT)
    ORR     R3,R0,#1    /* Set bit[0] -> EXC_RETURN=0xFFFFFFF9 */
    BX      R3          /* Access (XN) region -> Generate exception */

m33_cst_exc_mem_fault_timeout_addr:
    MOV     R1, #0x0000FFFF
    LDR     R11, =m33_cst_exc_mem_fault_test_ISR_ret_addr1
    ORR     R11,R11,#1  /* Set address valid to thumb */
    B       m33_cst_exception_timeout

    
m33_cst_exc_mem_fault_test_ISR_ret_addr1:
    /*------------------------------------------------------------------------*/
    /* Restore all registers & Enable external interrupts                     */
    /*------------------------------------------------------------------------*/
    BL      m33_cst_restore_registers_content
    
    /*------------------------------------------------------------------------*/
    /* Test - end                                                             */
    /*------------------------------------------------------------------------*/    
m33_cst_exc_mem_fault_end:
    /* Test result is returned in R0, according to the conventions */
    MOV     R0,R5
    LDR     R5,=m33_cst_test_tail_end
    BX      R5    /* -> Exit test */
    
    
    /*------------------------------------------------------------------------*/
    /* Test - ISR routines                                                    */
    /*------------------------------------------------------------------------*/ 
m33_cst_exc_mem_fault_ISR1:

    ROR     R3,R5,R2        /* !! Update signature !! */
    EOR     R5,R3,R5
    
    /* We need to check the IACCVIOL flag is set */
    LDR     R3,=M33_MMFSR_REG
    LDRB    R4,[R3]         /* Use byte access to MMFSR */
    AND     R4,R4,#(1<<0)   /* Check MMFSR[IACCVIOL] flag is set */
    ROR     R5,R5,R4        /* !! Update signature !! */
    ADD     R5,R5,R4
    
    /* We need to clear the IACCVIOL flag */
    STRB    R4,[R3]         /* Clear MMFSR[IACCVIOL](rc_w1) flag */
    LDRB    R4,[R3]         /* Use byte access to UFSR */
    AND     R4,R4,#(1<<0)   /* Check MMFSR[IACCVIOL] flag was cleared */
    ADD     R5,R5,R4        /* Destroy signature in case of error !! */
    
    /* !! We must restore R14 register !! */
    MOV     R14,R10
    /* !! We must restore xPSR register */
    STR     R11,[SP,#28]
    
    /* We need to change return address that is stored in stack:
       it points to (XN) region */
    ADR.W   R4,m33_cst_exc_mem_fault_test_ISR_ret_addr1
    STR     R4,[SP,#24] /* Store new return address from the ISR... */
    DSB     /* Ensures that stacked value is updated before exception return */
    
    BX      LR
    
    /* Return to Thread mode */
m33_cst_exc_mem_fault_ISR0:

   /* We must enable return to the Thread mode with active ISR when invoking
       this test from Handler mode */ 
   LDR      R3,=M33_CCR_REG
   
   /* We must save current EXC_RETURN value */
   MOV      R10,R14        /* Do not use R10 !! */
   /* We must save stacked xPSR value */
   LDR      R11,[SP,#28]   /* Do not use R11 !! */
    
   /* We must modify EXC_RETURN value to return to Thread mode */
   ORR      R14,R14,#(1<<3)
   
   /* We must modify XPSR value which on the stack to return
      to Thread mode */
   MOV      R3,#0x1FF
   BIC      R3,R11,R3
   STR      R3,[SP,#28]
   DSB
   
   BX       LR
   
   
    
    CST_ALIGN_BYTES_4
    /* Marks the current location for dumping psuedoinstruction pools containing
       numeric values for used symbolic names used within LDR instruction. */
    CST_LTORG

#endif /* CORTST_M33_INTERRUPT_ENABLE */
    
    CST_FILE_END

