/*
 * Copyright 2020-2025 Yuntu Microelectronics co.,ltd
 * All rights reserved.
 *
 * YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 * used strictly in accordance with the applicable license terms. By expressly
 * accepting such terms or by downloading, installing, activating and/or otherwise
 * using the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software. The production use license in
 * Section 2.3 is expressly granted for this software.
 */

/******************************************************************************
* Test summary:
* -------------
*
* Tests triggering of Hard fault.
* Tests EPSR, APSR registers restoring on exception return.
*
******************************************************************************/

#include "CorTst_M33_Cfg.h"
#include "CorTst_Compiler.h"

#if (CORTST_M33_INTERRUPT_ENABLE == 1U)
    /* Compatible with ABI. */
    CST_PRES8
    /* Symbols defined in the current module but to be visible to outside */
    CST_EXPORT M33_Cst_ExcHardFaultTest1

    /* Symbols defined outside but used within current module */
    CST_EXTERN m33_cst_store_registers_content
    CST_EXTERN m33_cst_set_cst_interrupt_vector_table
    CST_EXTERN m33_cst_set_user_interrupt_vector_table
    CST_EXTERN m33_cst_restore_registers_content
    CST_EXTERN m33_cst_test_tail_end
    CST_EXTERN m33_cst_ISR_address
    
    CST_EXTERN CST_RAM_TARGET0
    CST_EXTERN m33_cst_exception_timeout

    
    CST_SET(PRESIGNATURE,0x6054824C)
    
    /* This address is used to trigger both Precise and Imprecise BusFault 
       exceptions.  The address was chosen from device System Memory Map 
       reserved space, see -DM33_DEVICE_RESERVED_ADDR preprocessor macro 
       definition in the CST User Manual document. 
       Note that application must ensure that this memory is not protected 
       e.g by the MPU. In case of this address is protected another address 
       from the device Reserved address space has to be chosen. */
    CST_DEFINE(M33_RESERVED_ADDR, M33_DEVICE_RESERVED_ADDR)
    
    /* This address is used to trigger MemFault exception when accessing 
       XN (Execute Never) region */
    CST_DEFINE(M33_XN_REGION_ADDR, 0xFFFFFFF0)
     
    /*------------------------------------------------------------------------*/
    CST_SECTION_EXEC(mcal_text)
    /*------------------------------------------------------------------------*/
    /* The ".type" directive instructs the assembler/linker that the label 
       "M33_Cst_ExcHardFaultTest1" designates a function.
       This would cause setting the least significant bit to '1' within any 
       pointer to this function, causing change to Thumb mode whenever this 
       function is called. */
    CST_THUMB2
    CST_TYPE(M33_Cst_ExcHardFaultTest1, function)
M33_Cst_ExcHardFaultTest1:
    
    PUSH    {R4-R12,R14}
    
    /*------------------------------------------------------------------------*/
    /* Test - preparation                                                     */
    /*------------------------------------------------------------------------*/
    LDR     R5,=PRESIGNATURE
    REV.N   R5,R5           /* Reverse byte order */
    
    /* Clear RAM to check STM and LDM restoration after return from exception */
    LDR     R3,=CST_RAM_TARGET0
    ADD     R3,R3,#16 /* We add offset 16 bytes to prevent STM from storing to
                         unallocated memory */
    MOV     R0,#0
    MOV     R1,#0
    MOV     R2,#0
    MOV     R4,#0
    STM     R3,{R0,R1,R2,R4}
    DSB

    /*------------------------------------------------------------------------*/
    /* Store register content                                                 */
    /*------------------------------------------------------------------------*/
    /* !! Don't use R6, R7, R8, R9 for any other purpose until CONTROL, PRIMASK,
          FAULTMASK and BASEPRI are restored !! */
    BL      m33_cst_store_registers_content

    /*------------------------------------------------------------------------*/
    /* Test - start                                                           */
    /*------------------------------------------------------------------------*/ 
    /* Store address of the CST-own ISR into the m33_cst_ISR_address pointer */
    ADR.W   R4,m33_cst_exc_hard_fault_test1_ISR1
    ORR     R4,R4,#1    /* Set bit [0] as this address will be used within 
                           BX command and should indicate the Thumb code */
    LDR     R3,=m33_cst_ISR_address
    STR     R4,[R3]
    
    /* Before vector table is changed to the CST-own one, set R2 to
       to the expected ISR number and R0 to the expected ISR address.
       
       Content of R0 and R2 will allow determining whether interrupt was 
       triggered by CST library or by alien SW.

    !! Don't use R0, R2 for any other purpose until vector table is changed 
       to a user one. !! */
    MOV     R2,#0x3     /* R2 indicates that CST library will explicitly 
                           initiate an exception with IRQ number 0x3 */
    ADR.W   R0,m33_cst_exc_hard_fault_test1_ISR1_addr
    BIC     R0,R0,#1    /* Clear bit [0]. Ensures that label is not treated as 
                           Thumb function */
    
    /*------------------------------------------------------------------------*/
    /* Set CST interrupt vector table & Disable external interrupts          */
    /*------------------------------------------------------------------------*/
    BL      m33_cst_set_cst_interrupt_vector_table
    
    /* Disable UsageFalut exceptions */
    LDR     R3,=M33_SHCSR_REG    /* Load SHCSR(SCB) register address */
    LDR     R4,[R3]             /* Load current SHCSR register value */
    BIC     R4,R4,#(1<<18)      /* Clear SHCSR[USGFAULTENA] bit */
    STR     R4,[R3]             /* Modify SHCSR register */

    CPSIE   i   /* Clear PRIMASK   */
    CPSIE   f   /* Clear FAULTMASK */
    
    /* R3 contains expected APSR_nzcvq and APSR_ge */
    MOV     R3,#0x68000000      /* Z==1,C==1,Q==1,GE[3:0]=0x0 */
    
    /* R12 contains inverted APSR_nzcvq and APSR_ge */
    MVN     R12,R3
    BFC     R12,#0,#16
    BFC     R12,#20,#7          /* R12==0x900F0000 */
    
    /* Write APSR_nzcvq and APSR_ge bits */
    CST_OPCODE_START           /* Used opcode due to compiler problem */
    CST_OPCODE32_HIGH(0xF383)  /* MSR APSR_nzcvq_ge, R3 */
    CST_OPCODE32_LOW(0x8C00)
    CST_OPCODE_END

    CST_OPCODE_START           /* Used opcode due to compiler problem */
    CST_OPCODE16(0xBF0F)       /* ITEEE   EQ  Z == 1 */
    CST_OPCODE_END
m33_cst_exc_hard_fault_test1_ISR1_addr:    
    UDF.W   #0xFFFF     /* Yes! -> Undef instruction -> Generate exception !! */
    /* !! We are again at the beginning of IT-block !! */
m33_cst_exc_hard_fault_test1_ISR1_ret_addr:
    MRS     R12,APSR    /* EQ, Yes-> Load APSR_nzcvq and APSR_ge */
    MOV     R5,#0       /* NE, No -> Destroy signature in faulty case !! */
    MOV     R5,#0       /* NE, No -> Destroy signature in faulty case !! */
    MOV     R5,#0       /* NE, No -> !! We are still in IT block !! */

    /* We must check that APSR_nzcvq and APSR_ge bits were restored correctly */     
    EOR     R3,R12,R3   /* Compare R12 with expected APSR_nzcvq from R3 */
    ADD     R5,R3       /* !! Destroy signature in faulty case !! */
 
    /*------------------------------------------------------------------------*/
    /* Restore registers & Enable external interrupts                         */
    /*------------------------------------------------------------------------*/
    BL      m33_cst_set_user_interrupt_vector_table
    
    /* Store address of the CST-own ISR into the m33_cst_ISR_address pointer */
    ADR.W   R4,m33_cst_exc_hard_fault_test1_ISR2
    ORR     R4,R4,#1    /* Set bit [0] as this address will be used within 
                           BX command and should indicate the Thumb code */
    LDR     R3,=m33_cst_ISR_address
    STR     R4,[R3]
    
    ADR.W   R0, m33_cst_exc_hard_fault_test1_ISR2_addr
    BIC     R0,R0,#1    /* Clear bit [0]. Ensures that label is not treated as 
                           Thumb function */   
    
    /*------------------------------------------------------------------------*/
    /* Set CST interrupt vector table & Disable external interrupts          */
    /*------------------------------------------------------------------------*/
    BL      m33_cst_set_cst_interrupt_vector_table
    
    
    /* Disable BusFault exceptions */
    LDR     R3,=M33_SHCSR_REG    /* Load SHCSR(SCB) register address */
    LDR     R4,[R3]             /* Load current SHCSR register value */
    BIC     R4,R4,#(1<<17)      /* Clear SHCSR[BUSFAULTENA] bit */
    STR     R4,[R3]             /* Modify SHCSR register */
       
    /* Disable Unaligned access Usage fault exception */
    LDR     R3,=M33_CCR_REG
    LDR     R4,[R3]
    BFC     R4,#3,#1    /* Clear CCR[UNALIGN_TRP] bit */
    STR     R4,[R3]
    
    LDR     R3,=M33_RESERVED_ADDR    /* Load R3 with reserved address !! */
    
    CPSIE   i   /* Clear PRIMASK   */
    CPSIE   f   /* Clear FAULTMASK */
 
    CST_QUA_FAULT_INJECTION(CST_ERROR_INJECT_HARD_FAULT)

m33_cst_exc_hard_fault_test1_ISR2_addr:
    LDR     R2,[R3]     /* Precise data bus error -> Generate exception!! */

m33_cst_exc_hard_fault_timeout_addr:
    MOV     R1, #0x0000FFFF
    LDR     R11, =m33_cst_exc_hard_fault_test1_ISR3_ret_addr
    ORR     R11,R11,#1  /* Set address valid to thumb */
    B       m33_cst_exception_timeout

    

m33_cst_exc_hard_fault_test1_ISR2_ret_addr:
    STMDB   R3!,{R0,R2,R5,R12}  /* !! Only R5 and R12 should be stored !! */
    SUB     R3,R3,R12           /* !! Check R3 was not decremented !! */
    ADD     R5,R5,R3            /* !! Destroy signature when R3!=0 */
    
    /*------------------------------------------------------------------------*/
    /* Restore registers & Enable external interrupts                         */
    /*------------------------------------------------------------------------*/
    BL      m33_cst_set_user_interrupt_vector_table
    
    /* Check that R0 and R2 were not stored by STMDB */
    LDRD    R1,R4,[R12] /* R12 contains address as was in R3, see STMDB R3! */
    ADD     R5,R5,R1    /* !! Destroy signature if R1!=0 !! */
    ADD     R5,R5,R4    /* !! Destroy signature if R4!=0 !! */
    
    /* Store address of the CST-own ISR into the m33_cst_ISR_address pointer */
    ADR.W   R4,m33_cst_exc_hard_fault_test1_ISR3
    ORR     R4,R4,#1    /* Set bit [0] as this address will be used within 
                           BX command and should indicate the Thumb code */
    LDR     R3,=m33_cst_ISR_address
    STR     R4,[R3]
    
    /* If an EXC_RETURN value is loaded into the PC when in Thread mode !!
       the value is treated as an address, not as a special value !! */ 
    LDR     R0,=M33_XN_REGION_ADDR   /* Load R0 with (XN) region address */
    
    /*------------------------------------------------------------------------*/
    /* Set CST interrupt vector table & Disable external interrupts          */
    /*------------------------------------------------------------------------*/
    BL      m33_cst_set_cst_interrupt_vector_table
    
    
    /* Disable MemFault exceptions */
    LDR     R3,=M33_SHCSR_REG    /* Load SHCSR register address */
    LDR     R4,[R3]             /* Load current SHCSR register value */
    BIC     R4,R4,#(1<<16)      /* Clear SHCSR[MEMFAULTENA] bit */
    STR     R4,[R3]             /* Modify SHCSR register */
    
    CPSIE   i           /* Clear PRIMASK   */
    CPSIE   f           /* Clear FAULTMASK */
    
    ORR     R3,R0,#1    /* Set bit[0] -> EXC_RETURN=0xFFFFFFF1 */
    BX      R3          /* Access (XN) region -> Generate exception */
    
    
m33_cst_exc_hard_fault_test1_ISR3_ret_addr:
    LDMIA   R3!,{R2,R5,R10,R11} /* !! Only R10 and R11 should be loaded !! */
    SUB     R3,R3,R12           /* Check that R3 was not modified by STM */
    ADD     R10,R10,R3          /* !! Destroy signature in case of error !! */
    
    /*------------------------------------------------------------------------*/
    /* Restore all registers & Enable external interrupts                     */
    /*------------------------------------------------------------------------*/
    BL      m33_cst_restore_registers_content
    
    /* Check that only R10 and R11 were modified by LDMIA  */
    ROR     R3,R10,R2        /* !! Update signature !! */
    EOR     R10,R3,R10
    SUB     R11,R12,R11
    SUB     R11,R11,#15
    ROR     R10,R10,R11     
    ADD     R10,R10,R11     /* R10 contains the same value as R5 */
    

    SUB     R10,R10,R5
    ADD     R5,R5,R10       /* !! Destroy signature in case of error !! */       
    
    /*------------------------------------------------------------------------*/
    /* Test - end                                                             */
    /*------------------------------------------------------------------------*/
m33_cst_exc_hard_fault_test1_end:    
    /* Test result is returned in R0, according to the conventions */
    MOV     R0,R5
    LDR     R5,=m33_cst_test_tail_end
    BX      R5    /* -> Exit test */
    
    
    /*------------------------------------------------------------------------*/
    /* Test - ISR routines                                                    */
    /*------------------------------------------------------------------------*/ 
m33_cst_exc_hard_fault_test1_ISR1:

    ROR     R3,R5,R2        /* !! Update signature !! */
    EOR     R5,R3,R5
    
    /* We need to check that UNDEFINSTR flag was set */
    LDR     R3,=M33_UFSR_REG
    LDRH    R4,[R3]         /* Use halfword access to UFSR */
    AND     R4,R4,#(1<<0)   /* Check UFSR[UNDEFINSTR] flag is set */ 
    ADD     R5,R5,R4        /* !! Update signature !! */
    ROR     R5,R5,R4
    
    /* We need to clear UNDEFINSTR flag */
    STRH    R4,[R3]         /* Clear UFSR[UNDEFINSTR](rc_w1) flag */
    LDRH    R4,[R3]         /* Use halfword access to UFSR */
    AND     R4,R4,#(1<<0)   /* Check UFSR[UNDEFINSTR] flag was cleared */ 
    ADD     R5,R5,R4        /* !! Destroy signature in case of error !! */
    
    /* We need to change return address that is stored in stack:
       it points again to the undefined instruction */
    ADR.W   R3,m33_cst_exc_hard_fault_test1_ISR1_ret_addr
    STR     R3,[SP,#24]
    DSB     /* Ensures that stacked value is updated before exception return */
    
    /* Set APSR_nzcv flags and APSR_ge bits to inverted value compared to 
       expected value on exception return */
    CST_OPCODE_START           /* Used opcode due to compiler problem */
    CST_OPCODE32_HIGH(0xF38C)  /* MSR APSR_nzcvq_ge, R12 */
    CST_OPCODE32_LOW(0x8C00)
    CST_OPCODE_END
    
    BX      LR
     
m33_cst_exc_hard_fault_test1_ISR2:

    ROR     R3,R5,R2    /* !! Update signature !! */
    EOR     R5,R3,R5
    
    /* We need to check that PRECISERR & BFARVALID flags are set */
    LDR     R3,=M33_BFSR_REG
    LDRB    R4,[R3]     /* Use byte access to BFSR */
    AND     R4,R4,#0x82 /* Check BFSR[PRECISERR]&[BFARVALID] flags are set */
    ADD     R5,R5,R4    /* !! Update signature !! */
    
    /* We need to clear PRECISERR & BFARVALID flags */
    STRB    R4,[R3]     /* Clear BFSR[PRECISERR] & BFSR[BFARVALID] flags */
    LDRB    R4,[R3]     /* Use byte access to BFSR */
    AND     R4,R4,#0x82 /* Check BFSR[PRECISERR]&[BFARVALID] were cleared */
    ADD     R5,R5,R4    /* !! Destroy signature in case of error !! */
    
    /*************************************************************************
      Next ISR1 requires to be generated from the Thread mode. 
      We must ensure that we will return to the Thread Mode 
      even if test was invoked from Handler mode !!                  
     *************************************************************************/
    /* We must enable return to the Thread mode with active ISR when invoking
       this test from Handler mode */ 
    LDR     R3,=M33_CCR_REG
    
    /* We must save current EXC_RETURN value */
    MOV     R10,R14         /* Do not use R10 until R14 is restored !! */
    /* We must save stacked xPSR value */
    LDR     R11,[SP,#28]    /* Do not use R11 !! */
    
    /* We must modify EXC_RETURN value */
    ORR     R14,R14,#(1<<3) /* set bit[4] -> Return to Thread mode */
    
    /* We must modify stacked xPSR value */
    MOV     R4,#0x1FF           /* xPSR Exception number mask */
    BIC     R4,R11,R4           /* Clear Exception number, write see next STRD */
    ADD     R4,R4,#0x00005000   /* STMDB will continue from R5 */
    
    /* We need to change R3, R12 values that are stored in stack to RAM target 0
       address + offset */
    LDR     R3,=CST_RAM_TARGET0
    ADD     R3,R3,#16       /* Simulate address that was written back by STMDB */
    STR     R3,[SP,#12]
    STR     R3,[SP,#16]
    
    /* We need to change return address that is stored in stack:
       it points to instruction which causes PRECISERR Bus fault */
    ADR.W   R3,m33_cst_exc_hard_fault_test1_ISR2_ret_addr
    STRD    R3,R4,[SP,#24]
    DSB     /* Ensures that stack is updated before exception return */
    
    BX      LR
   
m33_cst_exc_hard_fault_test1_ISR3:
    
    ROR     R3,R5,R2       /* !! Update signature !! */
    EOR     R5,R3,R5
    
    /* We need to check the IACCVIOL flag is set */
    LDR     R3,=M33_MMFSR_REG
    LDRB    R4,[R3]         /* Use byte access to MMFSR */
    AND     R4,R4,#(1<<0)   /* Check MMFSR[IACCVIOL] flag is set */
    ROR     R5,R5,R4        /* !! Update signature !! */
    ADD     R5,R5,R4
    
    /* We need to clear the IACCVIOL flag */
    STRB    R4,[R3]         /* Clear MMFSR[IACCVIOL](rc_w1) flag */
    LDRB    R4,[R3]         /* Use byte access to UFSR */
    AND     R4,R4,#(1<<0)   /* Check MMFSR[IACCVIOL] flag was cleared */
    ADD     R5,R5,R4        /* Destroy signature in case of error !! */
    
    /* !! We must restore R14 register !! */
    MOV     R14,R10
    /* !! We must restore xPSR register */
    ADD     R11,R11,#0x0000A000 /* LDMIA will continue from R10 */
    STR     R11,[SP,#28]    
    
    /* We need to change R3 and R12 values that are stored in stack to 
       RAM target 0 address */
    ADD     R3,R12,#16     /* Simulate address, that was written back by LDMIA */
    STR     R3,[SP,#12]      
    STR     R3,[SP,#16]      
    
    /* We need to change return address that is stored in stack:
       it points to (XN) region */
    ADR.W   R4,m33_cst_exc_hard_fault_test1_ISR3_ret_addr
    STR     R4,[SP,#24] /* Store new return address from the ISR... */
    DSB     /* Ensures that stacked value is updated before exception return */
    
    BX      LR
    
     
    
    CST_ALIGN_BYTES_4
    /* Marks the current location for dumping psuedoinstruction pools containing
       numeric values for used symbolic names used within LDR instruction. */
    CST_LTORG

#endif /* CORTST_M33_INTERRUPT_ENABLE */
   
    CST_FILE_END

