/*
 * Copyright 2020-2025 Yuntu Microelectronics co.,ltd
 * All rights reserved.
 *
 * YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 * used strictly in accordance with the applicable license terms. By expressly
 * accepting such terms or by downloading, installing, activating and/or otherwise
 * using the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software. The production use license in
 * Section 2.3 is expressly granted for this software.
 */
 
/******************************************************************************
* Test summary:
* -------------
*
* This test covers unconditional branches as well as their decoding. Both
* relative and absolute branches are tested. Instructions tested are ADR,
* B <label>, BL <label>, BX <Rn>, BLX <Rn>
*
* There are two code sections "m33_cst_test_code0" and
* "m33_cst_test_code1", that contain the test code. Branches are tested
* inside these sections in both directions - forward and backward.
*
* Branches are always single issued but can be in either slot. 
* Branch instructions are always placed in the code twice to test both  
* slot0 and slot1. 
* Instructions in slot0 and slot1 are intentionally not both branches.
*
* Decoder coverage:
* ----------------
* Thumb (16-bit) DECODER
*   - ADR
*   - B <label>
*   - BLX <Rm>
*   - BX <Rm>
*
* Thumb (32-bit) DECODER
*   - ADR.W
*   - B <label>
*   - BL <label>
******************************************************************************/

#include "CorTst_Compiler.h"
#include "CorTst_M33_Cfg.h"

#if (CORTST_M33_BRANCH_ENABLE==1)
    /* Compatible with ABI. */
    CST_PRES8
    /* Symbols defined in the current module but to be visible to outside */
    CST_EXPORT M33_Cst_BranchTest1

    /* Symbols defined outside but used within current module */
    CST_EXTERN m33_cst_test_tail_end

    /**
     * Symbols defined in the current module for the internal use only
     */
    CST_SET(SIG_UPDATE_VAL,   0x000002AE)
    CST_SET(PRESIGNATURE_SEED_0, 0x1B1F) /* 5678 - halfbyte order */
    CST_SET(PRESIGNATURE_SEED_1, 0x5722) /* 3412 */
    
    CST_SET(TEST_ADR_INV_SIG, 0x442)
    CST_SET(TEST_B_INV_SIG,   0x444)
    CST_SET(TEST_BX_INV_SIG,  0x445)
    CST_SET(TEST_BL_INV_SIG,  0x446)
    CST_SET(TEST_BLX_INV_SIG, 0x447)

    /**
     * Values stored in registers:
     * - R0  ... temporary wrong signature
     * - R7  ... accumulated signature
     * - R9  ... PRIMASK
     * - R11 ... absolute address to jump to on test failure
     */
    /*------------------------------------------------------------------------*/
    CST_SECTION_EXEC(mcal_text)
    /*------------------------------------------------------------------------*/
    /* The ".type" directive instructs the assembler/linker that the label 
       "M33_Cst_BranchTest1" designates a function.
       This would cause setting the least significant bit to '1' within any 
       pointer to this function, causing change to Thumb mode whenever this 
       function is called. */
    CST_THUMB2
    CST_TYPE(M33_Cst_BranchTest1, function)
M33_Cst_BranchTest1:

    PUSH    {R4-R12,R14}

    /*------------------------------------------------------------------------*/
    /* Test - preparation                                                     */
    /*------------------------------------------------------------------------*/
    /* Prepare signature */
    MOV     R10,#PRESIGNATURE_SEED_0 /* 00005678 - halfbyte order */
    REVSH.W R5,R10                   /* 00007856 */
    MOV     R1,#0x00000000           /* 00000000 */
    MOVT    R1,#PRESIGNATURE_SEED_1  /* 34120000 */
    ORR     R0,R5,R1                 /* 34127856 */
    RBIT    R5,R0                    /* 65872143 */
    REV16.W R7,R5                    /* 87654321 -> PRESIGNATURE = 0xF8D8EA44 */

    /*------------------------------------------------------------------------*/
    /* Test - start                                                           */
    /*------------------------------------------------------------------------*/
    /* Set return register value to wrong value */
    MOV     R0,#0x00000000
    /* Set return address for failure case - do not use R11 !! */
    LDR     R11,=m33_cst_branch_test1_failed
    ORR     R11,R11,#0x00000001     /* Ensure bit0 is set !! */
    
    MRS     R9,PRIMASK      /* Save PRIMASK to R9 */
    
    /**************************************************************************
     *    Execute ADR tests in the mcal_text section
     *************************************************************************/
    /**************************************************************************
     *  Instruction: ADR <Rd>,<label>
     *    - Offset in range +1MB/-1MB
     *  Section: m33_cst_test_code0
     *************************************************************************/
    MOV     R0, #TEST_ADR_INV_SIG
   
    CST_ALIGN_BYTES_4
    CST_LABEL
m33_cst_branch_test1_adr_1:
    CST_THUMB2
    /* ADR Encodig T2 - Label before current instruction */
    ADR.W   R12,(m33_cst_branch_test1_adr_1 - 0x551)    /* imm12=0x555 */
    LDR     R6,=(m33_cst_branch_test1_adr_1)
    BIC     R6,R6,#0x00000001   /* Ensure bit0 is cleared !! */
    SUB     R6,R6,#0x551
    SUB     R6,R12, R6
    CBZ     R6,m33_cst_branch_test1_adr_1_ret
    BX      R11 /* !! Never executed in fault-free case !! */
m33_cst_branch_test1_adr_1_ret:
    ADD     R7,R7,#SIG_UPDATE_VAL

    CST_ALIGN_BYTES_4
    CST_LABEL
m33_cst_branch_test1_adr_2:                                                    
    CST_THUMB2
    /* ADR Encodig T3 - Label after current instruction */
    ADR.W   R3,(m33_cst_branch_test1_adr_2 + 0xAAE)     /* imm12=0xAAA */
    LDR     R6,=(m33_cst_branch_test1_adr_2)
    BIC     R6,R6,#0x00000001   /* Ensure bit0 is cleared !! */
    ADD     R6,R6,#0xAAE
    SUB     R6,R3, R6                                                          
    CBZ     R6,m33_cst_branch_test1_adr_2_ret                                  
    BX      R11 /* !! Never executed in fault-free case !! */               
m33_cst_branch_test1_adr_2_ret:                                                
    ADD     R7,R7,#SIG_UPDATE_VAL                                              

    CST_ALIGN_BYTES_4
    CST_LABEL
m33_cst_branch_test1_adr_3:                                                     
    CST_THUMB2
    /* ADR Encodig T2 - Label before current instruction */ 
    ADR.W   R3,(m33_cst_branch_test1_adr_3 -  0xFFB)    /* imm12=0xFFF */    
    LDR     R6,=(m33_cst_branch_test1_adr_3)
    BIC     R6,R6,#0x00000001   /* Ensure bit0 is cleared !! */
    SUB     R6,R6,#0xFFB
    SUB     R6,R3, R6                                                           
    CBZ     R6,m33_cst_branch_test1_adr_3_ret                                   
    BX      R11 /* !! Never executed in fault-free case !! */                
m33_cst_branch_test1_adr_3_ret:                                                 
    ADD     R7,R7,#SIG_UPDATE_VAL                                               
  
    CST_ALIGN_BYTES_4
    CST_LABEL
m33_cst_branch_test1_adr_4:
    CST_THUMB2
    /* ADR Encodig T3 - Label after current instruction */
    ADR.W   R12,(m33_cst_branch_test1_adr_4 + 0x004)    /* imm12=0x000 */
    LDR     R6,=(m33_cst_branch_test1_adr_4)
    BIC     R6,R6,#0x00000001   /* Ensure bit0 is cleared !! */
    ADD     R6,R6,#0x004
    SUB     R6,R12, R6
    CBZ     R6,m33_cst_branch_test1_adr_4_ret
    BX      R11 /* !! Never executed in fault-free case !! */
    
m33_cst_branch_test1_adr_4_ret:
    ADD     R7,R7,#SIG_UPDATE_VAL

    
    /***************************************************************************
    *  !!  Execute tests in cortst_branch_code0 section !!
    ***************************************************************************/
    LDR     R2,=CorTst_TestBranchCode0_entry
    BLX     R2
    CBNZ    R0,m33_cst_branch_test1_failed

    /***************************************************************************
    *  !!  Execute tests in cortst_branch_code1 section !!
    ***************************************************************************/
    LDR     R2,=CorTst_TestBranchCode1_entry
    BLX     R2
    CBNZ    R0,m33_cst_branch_test1_failed

    /*------------------------------------------------------------------------*/
    /* Test routine - End                                                     */
    /*------------------------------------------------------------------------*/
m33_cst_branch_test1_end:
    /* Test result is returned in R0, according to the conventions */
    MOV     R0,R7
m33_cst_branch_test1_failed:    
    B       m33_cst_test_tail_end
    

    /*------------------------------------------------------------------------*/
    CST_SECTION_EXEC(mcal_text)
    /*------------------------------------------------------------------------*/
    CST_THUMB2
    CST_TYPE(CorTst_TestBranchCode0_entry, function)
CorTst_TestBranchCode0_entry:
    PUSH    {R14}
    LDR     R11,=CorTst_TestBranchCode0_exit
    B       m33_cst_branch_test1_code0_start

    /***************************************************************************
    *    This is Test Label 1
    ***************************************************************************/
m33_cst_branch_test1_testlabel1_code0:
    MSR     PRIMASK,R9          /* Restore PRIMASK register */   
    ADD     R7,R7,#SIG_UPDATE_VAL
    ORR     R2,R2,#0x00000001   /* Ensure bit0 is set !! */
    BX      R2

    /***************************************************************************
    *    This is Test Label 1 with LR check
    ***************************************************************************/
m33_cst_branch_test1_testlabel1_link_code0:
    MSR     PRIMASK,R9          /* Restore PRIMASK register */
    ADD     R7,R7,#SIG_UPDATE_VAL
    ORR     R4,R4,#0x00000001   /* Ensure bit0 is set !! */
    SUB     R4,LR,R4
    CBNZ    R4, m33_cst_branch_test1_testlabel1_link_code0_err
    ADD     R7,R7,#SIG_UPDATE_VAL
    ORR     R2,R2,#0x00000001   /* Ensure bit0 is set !! */
    BX      R2
m33_cst_branch_test1_testlabel1_link_code0_err:
    BX      R11 /* !! Never executed in fault-free case !! */

    /***************************************************************************
    *  Instruction: B <label>
    *  Section: m33_cst_test_code0
    ***************************************************************************/
m33_cst_branch_test1_code0_start:
    MOV     R0, #TEST_B_INV_SIG

    ADR     R2,m33_cst_branch_test1_b_1_code0_ret
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    B       m33_cst_branch_test1_testlabel1_code0       /* Slot0: Branch --> */
    MOV     R7,#TEST_B_INV_SIG  /* !! Never executed in fault-free case !! */
    BX      R11                 /* !! Never executed in fault-free case !! */
    
    CST_ALIGN_BYTES_4
    CST_LABEL
m33_cst_branch_test1_b_1_code0_ret:
    CST_THUMB2
    ADR     R2,m33_cst_branch_test1_b_2_code0_ret
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    NOP                                                 /* Slot0: */
    B       m33_cst_branch_test1_testlabel1_code0       /* Slot1: Branch --> */
    MOV     R7,#TEST_B_INV_SIG  /* !! Never executed in fault-free case !! */
    BX      R11                 /* !! Never executed in fault-free case !! */
    
    CST_ALIGN_BYTES_4
    CST_LABEL
m33_cst_branch_test1_b_2_code0_ret:
    CST_THUMB2
    ADR     R5,m33_cst_branch_test1_b_3_code0_ret
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    B.W     m33_cst_branch_test1_testlabel2_code0       /* Slot0: Branch --> */
    NOP
    MOV     R7,#TEST_B_INV_SIG  /* !! Never executed in fault-free case !! */
    BX      R11                 /* !! Never executed in fault-free case !! */
    
    CST_ALIGN_BYTES_4
    CST_LABEL
m33_cst_branch_test1_b_3_code0_ret:
    CST_THUMB2
    ADR     R5,m33_cst_branch_test1_b_4_code0_ret
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    NOP                                                 /* Slot0: */
    B.W     m33_cst_branch_test1_testlabel2_code0       /* Slot1: Branch --> */
    MOV     R7,#TEST_B_INV_SIG  /* !! Never executed in fault-free case !! */
    BX      R11                 /* !! Never executed in fault-free case !! */
    
    CST_ALIGN_BYTES_4
    CST_LABEL
m33_cst_branch_test1_b_4_code0_ret:
    CST_THUMB2
    /***************************************************************************
    *  Instruction: BX <Rm>
    *  Section: m33_cst_test_code0
    ***************************************************************************/
m33_cst_branch_test1_branch_bx_code0:
    MOV     R0,#TEST_BX_INV_SIG

    ADR     R2,m33_cst_branch_test1_bx_1_code0_ret
    LDR     R3,=m33_cst_branch_test1_testlabel1_code0
    ORR     R3,R3,#0x00000001   /* Ensure bit0 is set !! */
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    BX      R3                                          /* Slot0: Branch --> */
    MOV     R7,#TEST_BX_INV_SIG /* !! Never executed in fault-free case !! */
    BX      R11                 /* !! Never executed in fault-free case !! */
    
    CST_ALIGN_BYTES_4
    CST_LABEL
m33_cst_branch_test1_bx_1_code0_ret:
    CST_THUMB2
    ADR     R5, m33_cst_branch_test1_bx_2_code0_ret
    LDR     R4,=m33_cst_branch_test1_testlabel2_code0
    ORR     R4,R4,#0x00000001   /* Ensure bit0 is set !! */
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    NOP                                                 /* Slot0: */ 
    BX      R4                                          /* Slot1: Branch --> */
    MOV     R7,#TEST_BX_INV_SIG /* !! Never executed in fault-free case !! */
    BX      R11                 /* !! Never executed in fault-free case !! */
    
    CST_ALIGN_BYTES_4
    CST_LABEL
m33_cst_branch_test1_bx_2_code0_ret:
    CST_THUMB2
    ADR     R2,m33_cst_branch_test1_bx_3_code0_ret
    LDR     R10,=m33_cst_branch_test1_testlabel3_code1
    ORR     R10,R10,#0x00000001 /* Ensure bit0 is set !! */
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    BX      R10                                         /* Slot0: Branch --> */
    MOV     R7,#TEST_BX_INV_SIG /* !! Never executed in fault-free case !! */
    BX      R11                 /* !! Never executed in fault-free case !! */
    
    CST_ALIGN_BYTES_4
    CST_LABEL
m33_cst_branch_test1_bx_3_code0_ret:
    CST_THUMB2
    ADR     R5, m33_cst_branch_test1_bx_4_code0_ret
    LDR     R10,=m33_cst_branch_test1_testlabel4_code1
    ORR     R10,R10,#0x00000001 /* Ensure bit0 is set !! */
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    NOP                                                 /* Slot0: */
    BX      R10                                         /* Slot1: Branch --> */
    MOV     R7,#TEST_BX_INV_SIG /* !! Never executed in fault-free case !! */
    BX      R11                 /* !! Never executed in fault-free case !! */
    
    CST_ALIGN_BYTES_4
    CST_LABEL
m33_cst_branch_test1_bx_4_code0_ret:
    CST_THUMB2
    /***************************************************************************
    *  Instruction: BL <label>
    *  Section: m33_cst_test_code0
    ***************************************************************************/
m33_cst_branch_test1_branch_bl_code0:
    MOV     R0, #TEST_BL_INV_SIG

    ADR     R2,m33_cst_branch_test1_bl_1_code0_ret
    LDR     R4,=m33_cst_branch_test1_bl_1_code0_next
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    BL      m33_cst_branch_test1_testlabel1_link_code0  /* Slot0: Branch --> */
m33_cst_branch_test1_bl_1_code0_next:
    MOV     R7,#TEST_BL_INV_SIG /* !! Never executed in fault-free case !! */
    BX      R11                 /* !! Never executed in fault-free case !! */
    
    CST_ALIGN_BYTES_4
    CST_LABEL
m33_cst_branch_test1_bl_1_code0_ret:
    CST_THUMB2
    ADR     R2,m33_cst_branch_test1_bl_2_code0_ret
    LDR     R4,=m33_cst_branch_test1_bl_2_code0_next
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    NOP                                                 /* Slot0: */    
    BL      m33_cst_branch_test1_testlabel1_link_code0  /* Slot1: Branch --> */
m33_cst_branch_test1_bl_2_code0_next:
    MOV     R7,#TEST_BL_INV_SIG /* !! Never executed in fault-free case !! */
    BX      R11                 /* !! Never executed in fault-free case !! */
    
    CST_ALIGN_BYTES_4
    CST_LABEL
m33_cst_branch_test1_bl_2_code0_ret:
    CST_THUMB2
    ADR     R5,m33_cst_branch_test1_bl_3_code0_ret
    LDR     R4,=m33_cst_branch_test1_bl_3_code0_next
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    BL      m33_cst_branch_test1_testlabel2_link_code0  /* Slot0: Branch --> */
m33_cst_branch_test1_bl_3_code0_next:                   /* Slot1: */
    MOV     R7,#TEST_BL_INV_SIG /* !! Never executed in fault-free case !! */
    BX      R11                 /* !! Never executed in fault-free case !! */
    
    CST_ALIGN_BYTES_4
    CST_LABEL
m33_cst_branch_test1_bl_3_code0_ret:
    CST_THUMB2
    ADR     R5,m33_cst_branch_test1_bl_4_code0_ret
    LDR     R4,=m33_cst_branch_test1_bl_4_code0_next
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    NOP                                                 /* Slot0: */
    BL      m33_cst_branch_test1_testlabel2_link_code0  /* Slot1: Branch --> */
m33_cst_branch_test1_bl_4_code0_next:   
    MOV     R7,#TEST_BL_INV_SIG /* !! Never executed in fault-free case !! */
    BX      R11                 /* !! Never executed in fault-free case !! */
    
    CST_ALIGN_BYTES_4
    CST_LABEL
m33_cst_branch_test1_bl_4_code0_ret:
    CST_THUMB2
    /***************************************************************************
    *  Instruction: BLX <Rm>
    *  Section: m33_cst_test_code0
    ***************************************************************************/
m33_cst_branch_test1_branch_blx_code0:
    MOV     R0, #TEST_BLX_INV_SIG

    ADR     R2,m33_cst_branch_test1_blx_1_code0_ret
    LDR     R4,=m33_cst_branch_test1_blx_1_code0_next
    LDR     R5,=m33_cst_branch_test1_testlabel1_link_code0
    ORR     R5,R5,#0x00000001   /* Ensure bit0 is set !! */
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    BLX     R5                                          /* Slot0: Branch --> */
m33_cst_branch_test1_blx_1_code0_next:
    MOV     R7,#TEST_BLX_INV_SIG    /* !! Never executed in fault-free case !! */
    BX      R11                     /* !! Never executed in fault-free case !! */
    
    CST_ALIGN_BYTES_4
    CST_LABEL
m33_cst_branch_test1_blx_1_code0_ret:
    CST_THUMB2
    ADR     R5,m33_cst_branch_test1_blx_2_code0_ret
    LDR     R4,=m33_cst_branch_test1_blx_2_code0_next
    LDR     R6,=m33_cst_branch_test1_testlabel2_link_code0
    ORR     R6,R6,#0x00000001       /* Ensure bit0 is set !! */
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    NOP                                                 /* Slot0: */
    BLX     R6                                          /* Slot1: Branch --> */
m33_cst_branch_test1_blx_2_code0_next:
    MOV     R7,#TEST_BLX_INV_SIG    /* !! Never executed in fault-free case !! */
    BX      R11                     /* !! Never executed in fault-free case !! */
    
    CST_ALIGN_BYTES_4
    CST_LABEL
m33_cst_branch_test1_blx_2_code0_ret:
    CST_THUMB2
    ADR     R2,m33_cst_branch_test1_blx_3_code0_ret
    LDR     R4,=m33_cst_branch_test1_blx_3_code0_next
    LDR     R14,=m33_cst_branch_test1_testlabel3_link_code1
    ORR     R14,R14,#0x00000001     /* Ensure bit0 is set !! */
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    BLX     R14                                         /* Slot0: Branch --> */
m33_cst_branch_test1_blx_3_code0_next:
    MOV     R7,#TEST_BLX_INV_SIG    /* !! Never executed in fault-free case !! */
    BX      R11                     /* !! Never executed in fault-free case !! */
    
    CST_ALIGN_BYTES_4
    CST_LABEL
m33_cst_branch_test1_blx_3_code0_ret:
    CST_THUMB2
    ADR     R5,m33_cst_branch_test1_blx_4_code0_ret
    LDR     R4,=m33_cst_branch_test1_blx_4_code0_next
    LDR     R14,=m33_cst_branch_test1_testlabel4_link_code1
    ORR     R14,R14,#0x00000001     /* Ensure bit0 is set !! */
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    NOP                                                 /* Slot0: */
    BLX     R14                                         /* Slot1: Branch --> */
m33_cst_branch_test1_blx_4_code0_next:
    MOV     R7,#TEST_BLX_INV_SIG    /* !! Never executed in fault-free case !! */
    BX      R11                     /* !! Never executed in fault-free case !! */
    
    CST_ALIGN_BYTES_4
    CST_LABEL
m33_cst_branch_test1_blx_4_code0_ret:
    CST_THUMB2
    /***************************************************************************
    *    Set return value to zero to indicate successful test
    ***************************************************************************/
    MOV     R0,#0x00000000
    
    /***************************************************************************
    *    This return from the "cortst_branch_code0" section
    ***************************************************************************/
CorTst_TestBranchCode0_exit:
    POP     {PC}

    /***************************************************************************
     *    This is Test Label 2
     **************************************************************************/
m33_cst_branch_test1_testlabel2_code0:
    MSR     PRIMASK,R9          /* Restore PRIMASK register */
    ADD     R7,R7,#SIG_UPDATE_VAL
    ORR     R5,R5,#0x00000001   /* Ensure bit0 is set !! */
    BX      R5

    /***************************************************************************
    *    This is Test Label 2 with LR check
    ***************************************************************************/
m33_cst_branch_test1_testlabel2_link_code0:
    MSR     PRIMASK,R9          /* Restore PRIMASK register */
    ADD     R7,R7,#SIG_UPDATE_VAL
    ORR     R4,R4,#0x00000001   /* Ensure bit0 is set !! */
    SUB     R4,LR,R4
    CBNZ    R4, m33_cst_branch_test1_testlabel2_link_code0_err
    ADD     R7,R7,#SIG_UPDATE_VAL
    ORR     R5,R5,#0x00000001   /* Ensure bit0 is set !! */
    BX      R5
m33_cst_branch_test1_testlabel2_link_code0_err:
    BX      R11 /* !! Never executed in fault-free case !! */

    /*------------------------------------------------------------------------*/
    CST_SECTION_EXEC(mcal_text)
    /*------------------------------------------------------------------------*/
    CST_THUMB2
    CST_TYPE(CorTst_TestBranchCode1_entry, function)
CorTst_TestBranchCode1_entry:
    PUSH    {R14}
    LDR     R11,=CorTst_TestBranchCode1_exit
    B       m33_cst_branch_test1_code1_start

    /***************************************************************************
    *    This is Test Label 3
    ***************************************************************************/
m33_cst_branch_test1_testlabel3_code1:
    MSR     PRIMASK,R9          /* Restore PRIMASK register */
    ADD     R7,R7,#SIG_UPDATE_VAL
    ORR     R2,R2,#0x00000001   /* Ensure bit0 is set !! */
    BX      R2

    /***************************************************************************
    *    This is Test Label 3 with LR check
    ***************************************************************************/
m33_cst_branch_test1_testlabel3_link_code1:
    MSR     PRIMASK,R9          /* Restore PRIMASK register */
    ADD     R7,R7,#SIG_UPDATE_VAL
    ORR     R4,R4,#0x00000001   /* Ensure bit0 is set !! */
    SUB     R4,LR,R4
    CBNZ    R4, m33_cst_branch_test1_testlabel3_link_code1_err
    ADD     R7,R7,#SIG_UPDATE_VAL
    ORR     R2,R2,#0x00000001   /* Ensure bit0 is set !! */
    BX      R2
m33_cst_branch_test1_testlabel3_link_code1_err:
    BX      R11 /* !! Never executed in fault-free case !! */ 

    /***************************************************************************
    *  Instruction: B <label>
    *  Section: m33_cst_test_code1
    ***************************************************************************/
m33_cst_branch_test1_code1_start:
    MOV     R0, #TEST_B_INV_SIG

    ADR     R2,m33_cst_branch_test1_b_1_code1_ret
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    B       m33_cst_branch_test1_testlabel3_code1       /* Slot0: Branch --> */
    MOV     R7,#TEST_B_INV_SIG  /* !! Never executed in fault-free case !! */
    BX      R11                 /* !! Never executed in fault-free case !! */
    
    CST_ALIGN_BYTES_4
    CST_LABEL
m33_cst_branch_test1_b_1_code1_ret:
    CST_THUMB2
    ADR     R2,m33_cst_branch_test1_b_2_code1_ret
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    NOP                                                 /* Slot0:*/
    B       m33_cst_branch_test1_testlabel3_code1       /* Slot1: Branch --> */
    MOV     R7,#TEST_B_INV_SIG  /* !! Never executed in fault-free case !! */
    BX      R11                 /* !! Never executed in fault-free case !! */
    
    CST_ALIGN_BYTES_4
    CST_LABEL
m33_cst_branch_test1_b_2_code1_ret:
    CST_THUMB2
    ADR     R5,m33_cst_branch_test1_b_3_code1_ret
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    B.W     m33_cst_branch_test1_testlabel4_code1       /* Slot0: Branch --> */
    MOV     R7,#TEST_B_INV_SIG  /* !! Never executed in fault-free case !! */
    BX      R11                 /* !! Never executed in fault-free case !! */
    
    CST_ALIGN_BYTES_4
    CST_LABEL
m33_cst_branch_test1_b_3_code1_ret:
    CST_THUMB2
    ADR     R5,m33_cst_branch_test1_b_4_code1_ret
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    NOP                                                 /* Slot0: */
    B.W     m33_cst_branch_test1_testlabel4_code1       /* Slot1: Branch --> */
    MOV     R7,#TEST_B_INV_SIG  /* !! Never executed in fault-free case !! */
    BX      R11                 /* !! Never executed in fault-free case !! */
    
    CST_ALIGN_BYTES_4
    CST_LABEL
m33_cst_branch_test1_b_4_code1_ret:
    CST_THUMB2
    /***************************************************************************
    *  Instruction: BX <Rm>
    *  Section: m33_cst_test_code1
    ***************************************************************************/
m33_cst_branch_test1_branch_bx_code1:
    MOV     R0, #TEST_BX_INV_SIG

    ADR     R2,m33_cst_branch_test1_bx_1_code1_ret
    LDR     R3,=m33_cst_branch_test1_testlabel3_code1
    ORR     R3,R3,#0x00000001   /* Ensure bit0 is set !! */
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    BX      R3                                          /* Slot0: Branch --> */
    MOV     R7,#TEST_BX_INV_SIG /* !! Never executed in fault-free case !! */
    BX      R11                 /* !! Never executed in fault-free case !! */
    
    CST_ALIGN_BYTES_4
    CST_LABEL
m33_cst_branch_test1_bx_1_code1_ret:
    CST_THUMB2
    ADR     R5,m33_cst_branch_test1_bx_2_code1_ret
    LDR     R4,=m33_cst_branch_test1_testlabel4_code1
    ORR     R4,R4,#0x00000001   /* Ensure bit0 is set !! */
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    NOP                                                 /* Slot0:*/
    BX      R4                                          /* Slot1: Branch --> */
    MOV     R7,#TEST_BX_INV_SIG /* !! Never executed in fault-free case !! */
    BX      R11                 /* !! Never executed in fault-free case !! */
    
    CST_ALIGN_BYTES_4
    CST_LABEL
m33_cst_branch_test1_bx_2_code1_ret:
    CST_THUMB2
    ADR     R2,m33_cst_branch_test1_bx_3_code1_ret
    LDR     R10,=m33_cst_branch_test1_testlabel1_code0
    ORR     R10,R10,#0x00000001 /* Ensure bit0 is set !! */
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    BX      R10                                         /* Slot0: Branch --> */
    MOV     R7,#TEST_BX_INV_SIG /* !! Never executed in fault-free case !! */
    BX      R11                 /* !! Never executed in fault-free case !! */
    
    CST_ALIGN_BYTES_4
    CST_LABEL
m33_cst_branch_test1_bx_3_code1_ret:
    CST_THUMB2
    ADR     R5,m33_cst_branch_test1_bx_4_code1_ret
    LDR     R10,=m33_cst_branch_test1_testlabel2_code0
    ORR     R10,R10,#0x00000001 /* Ensure bit0 is set !! */
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    NOP                                                 /* Slot0: */
    BX      R10                                         /* Slot1: Branch --> */
    MOV     R7,#TEST_BX_INV_SIG /* !! Never executed in fault-free case !! */
    BX      R11                 /* !! Never executed in fault-free case !! */
    
    CST_ALIGN_BYTES_4
    CST_LABEL
m33_cst_branch_test1_bx_4_code1_ret:
    CST_THUMB2
    /***************************************************************************
    *  Instruction: B <label>
    *  Section: m33_cst_test_code1
    ***************************************************************************/
m33_cst_branch_test1_branch_bl_code1:
    MOV     R0, #TEST_BL_INV_SIG

    ADR     R2,m33_cst_branch_test1_bl_1_code1_ret
    LDR     R4,=m33_cst_branch_test1_bl_1_code1_next
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    BL      m33_cst_branch_test1_testlabel3_link_code1  /* Slot0: Branch --> */
m33_cst_branch_test1_bl_1_code1_next:
    NOP
    MOV     R7,#TEST_BL_INV_SIG /* !! Never executed in fault-free case !! */
    BX      R11                 /* !! Never executed in fault-free case !! */
    
    CST_ALIGN_BYTES_4
    CST_LABEL
m33_cst_branch_test1_bl_1_code1_ret:
    CST_THUMB2
    ADR     R2,m33_cst_branch_test1_bl_2_code1_ret
    LDR     R4,=m33_cst_branch_test1_bl_2_code1_next
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    NOP                                                 /* Slot0: */
    BL      m33_cst_branch_test1_testlabel3_link_code1  /* Slot1: Branch --> */
m33_cst_branch_test1_bl_2_code1_next:
    MOV     R7,#TEST_BL_INV_SIG /* !! Never executed in fault-free case !! */
    BX      R11                 /* !! Never executed in fault-free case !! */
    
    CST_ALIGN_BYTES_4
    CST_LABEL
m33_cst_branch_test1_bl_2_code1_ret:
    CST_THUMB2
    ADR     R5,m33_cst_branch_test1_bl_3_code1_ret
    LDR     R4,=m33_cst_branch_test1_bl_3_code1_next
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    BL      m33_cst_branch_test1_testlabel4_link_code1  /* Slot0: Branch --> */
m33_cst_branch_test1_bl_3_code1_next:
    NOP
    MOV     R7,#TEST_BL_INV_SIG /* !! Never executed in fault-free case !! */
    BX      R11                 /* !! Never executed in fault-free case !! */
    
    CST_ALIGN_BYTES_4
    CST_LABEL
m33_cst_branch_test1_bl_3_code1_ret:
    CST_THUMB2
    ADR     R5,m33_cst_branch_test1_bl_4_code1_ret
    LDR     R4,=m33_cst_branch_test1_bl_4_code1_next
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    NOP                                                 /* Slot0: */
    BL      m33_cst_branch_test1_testlabel4_link_code1  /* Slot1: Branch --> */
m33_cst_branch_test1_bl_4_code1_next:
    MOV     R7,#TEST_BL_INV_SIG /* !! Never executed in fault-free case !! */
    BX      R11                 /* !! Never executed in fault-free case !! */
    
    CST_ALIGN_BYTES_4
    CST_LABEL
m33_cst_branch_test1_bl_4_code1_ret:
    CST_THUMB2
    /***************************************************************************
    *  Instruction: BLX <Rm>
    *  Section: m33_cst_test_code1
    ***************************************************************************/
m33_cst_branch_test1_branch_blx_code1:
    MOV     R0, #TEST_BLX_INV_SIG

    ADR     R2,m33_cst_branch_test1_blx_1_code1_ret
    LDR     R4,=m33_cst_branch_test1_blx_1_code1_next
    LDR     R5,=m33_cst_branch_test1_testlabel3_link_code1
    ORR     R5,R5,#0x00000001   /* Ensure bit0 is set !! */
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    BLX     R5                                          /* Slot0: Branch --> */
m33_cst_branch_test1_blx_1_code1_next:
    MOV     R7,#TEST_BLX_INV_SIG    /* !! Never executed in fault-free case !! */
    BX      R11                     /* !! Never executed in fault-free case !! */
    
    CST_ALIGN_BYTES_4
    CST_LABEL
m33_cst_branch_test1_blx_1_code1_ret:
    CST_THUMB2
    ADR     R5,m33_cst_branch_test1_blx_2_code1_ret
    LDR     R4,=m33_cst_branch_test1_blx_2_code1_next
    LDR     R6,=m33_cst_branch_test1_testlabel4_link_code1
    ORR     R6,R6,#0x00000001   /* Ensure bit0 is set !! */
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    NOP                                                 /* Slot0: */
    BLX     R6                                          /* Slot1: Branch --> */
m33_cst_branch_test1_blx_2_code1_next:
    MOV     R7,#TEST_BLX_INV_SIG    /* !! Never executed in fault-free case !! */
    BX      R11                     /* !! Never executed in fault-free case !! */
    
    CST_ALIGN_BYTES_4
    CST_LABEL
m33_cst_branch_test1_blx_2_code1_ret:
    CST_THUMB2
    ADR     R2,m33_cst_branch_test1_blx_3_code1_ret
    LDR     R4,=m33_cst_branch_test1_blx_3_code1_next
    LDR     R10,=m33_cst_branch_test1_testlabel1_link_code0
    ORR     R10,R10,#0x00000001 /* Ensure bit0 is set !! */
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    BLX     R10                                         /* Slot0: Branch --> */
m33_cst_branch_test1_blx_3_code1_next:
    MOV     R7,#TEST_BLX_INV_SIG    /* !! Never executed in fault-free case !! */
    BX      R11                     /* !! Never executed in fault-free case !! */
    
    CST_ALIGN_BYTES_4
    CST_LABEL
m33_cst_branch_test1_blx_3_code1_ret:
    CST_THUMB2
    ADR     R5,m33_cst_branch_test1_blx_4_code1_ret
    LDR     R4,=m33_cst_branch_test1_blx_4_code1_next
    LDR     R10,=m33_cst_branch_test1_testlabel2_link_code0
    ORR     R10,R10,#0x00000001 /* Ensure bit0 is set !! */
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE
    /*------------------------------------------------------------------------*/
    NOP                                                 /* Slot0: */
    BLX     R10                                         /* Slot1: Branch --> */
m33_cst_branch_test1_blx_4_code1_next:
    MOV     R7,#TEST_BLX_INV_SIG    /* !! Never executed in fault-free case !! */
    BX      R11                     /* !! Never executed in fault-free case !! */
    
    CST_ALIGN_BYTES_4
    CST_LABEL
m33_cst_branch_test1_blx_4_code1_ret:
    CST_THUMB2
    /***************************************************************************
    *    Set return value to X0 to indicate successful test
    ***************************************************************************/
    MOV     R0,#0x00000000

    /***************************************************************************
    *    This return from the "cortst_branch_code1" section
    ***************************************************************************/
CorTst_TestBranchCode1_exit:
    POP     {PC}

    /***************************************************************************
    *    This is Test Label 4
    ***************************************************************************/
m33_cst_branch_test1_testlabel4_code1:
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R9          /* Restore PRIMASK register */
    /*------------------------------------------------------------------------*/
    ADD     R7,R7,#SIG_UPDATE_VAL
    ORR     R5,R5,#0x00000001
    BX      R5

    /***************************************************************************
    *    This is Test Label 4 with LR check
    ***************************************************************************/
m33_cst_branch_test1_testlabel4_link_code1:
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R9          /* Restore PRIMASK register */
    /*------------------------------------------------------------------------*/
    ADD     R7,R7,#SIG_UPDATE_VAL
    ORR     R4,R4,#0x00000001   /* Ensure bit0 is set !! */
    SUB     R4,LR,R4
    CBNZ    R4, m33_cst_branch_test1_testlabel4_link_code1_err
    ADD     R7,R7,#SIG_UPDATE_VAL
    ORR     R5,R5,#0x00000001   /* Ensure bit0 is set !! */
    BX      R5
m33_cst_branch_test1_testlabel4_link_code1_err:
    BX      R11


    CST_ALIGN_BYTES_4
    /* Marks the current location for dumping psuedoinstruction pools containing
       numeric values for used symbolic names used within LDR instruction. */
    CST_LTORG

#endif /* CORTST_M33_BRANCH_ENABLE */

    CST_FILE_END

