/*
 * Copyright 2020-2025 Yuntu Microelectronics co.,ltd
 * All rights reserved.
 *
 * YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 * used strictly in accordance with the applicable license terms. By expressly
 * accepting such terms or by downloading, installing, activating and/or otherwise
 * using the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software. The production use license in
 * Section 2.3 is expressly granted for this software.
 */

/******************************************************************************
* Test summary:
* -------------
* Tests ALU0 and ALU1 CLZ Unit as well as decoding of the CLZ instruction.
* Each time before issuing the tested instructions, the external
* interrupts are disabled and pipeline is flushed to ensure its consistent 
* state.    
*
* Decoder coverage:
* ----------------
* Thumb (32-bit) DECODER:
*   - CLZ
******************************************************************************/

#include "CorTst_Compiler.h"
#include "CorTst_M33_Cfg.h"

#if (CORTST_M33_ALU_ENABLE==1)
    /* Compatible with ABI. */
    CST_PRES8
    /* Symbols defined in the current module but to be visible to outside */
    CST_EXPORT M33_Cst_AluTest3

    /* Symbols defined outside but used within current module */
    CST_EXTERN m33_cst_test_tail_end


    CST_SET(PRESIGNATURE_SEED_0, 0x484A) /* 5678 - halfbyte order */
    CST_SET(PRESIGNATURE_SEED_1, 0xACDB) /* 3412 */
    
    /*------------------------------------------------------------------------*/
    CST_SECTION_EXEC(mcal_text)
    /*------------------------------------------------------------------------*/
    /* The ".type" directive instructs the assembler/linker that the label 
       "M33_Cst_AluTest3" designates a function.
       This would cause setting the least significant bit to '1' within any 
       pointer to this function, causing change to Thumb mode whenever this 
       function is called. */
    CST_THUMB2
    CST_TYPE(M33_Cst_AluTest3, function)
M33_Cst_AluTest3:

    PUSH    {R4-R12,R14}
    
    /*------------------------------------------------------------------------*/
    /* Test - preparation                                                     */
    /*------------------------------------------------------------------------*/
    /* Prepare signature */
    MOV     R4,#PRESIGNATURE_SEED_0 /* 00005678 - halfbyte order */
    REVSH.N R1,R4                   /* 00007856 */
    MOV     R4,#0x00000000          /* 00000000 */
    MOVT    R4,#PRESIGNATURE_SEED_1 /* 34120000 */
    ORR     R8,R1,R4                /* 34127856 */
    RBIT    R4,R8                   /* 65872143 */
    REV16.N R2,R4                   /* 87654321 -> PRESIGNATURE = 0x521235DB */
    PUSH    {R2}
    
    
    /*------------------------------------------------------------------------*/
    /* Test - start                                                           */
    /*------------------------------------------------------------------------*/
    MRS     R0,PRIMASK                  /* Save PRIMASK                       */
    
    MVN     R1,#0x55555555      /* 0xAAAAAAAA */
    LSR     R4,R1,#8            /* 0x00AAAAAA */
    LSR     R7,R1,#16           /* 0x0000AAAA */
    LSR     R10,R1,#24          /* 0x000000AA  */
    MOV     R14,#0              /* Prepare counter */
    
 m33_cst_alu_test3_clz_loop:
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE               /* Flush pipeline & disable ISRs      */
    /*------------------------------------------------------------------------*/
    CLZ     R2,R1       /* Slot0 - Expected res: 0, 1, 2, 3, 4, 5, 6, 7 |8    */
    CLZ     R3,R1       /* Slot1 - Expected res: 0, 1, 2, 3, 4, 5, 6, 7 |8    */
    CLZ     R5,R4       /* Slot0 - Expected res: 8, 9, 10,11,12,13,14,15|16   */
    CLZ     R6,R4       /* Slot1 - Expected res: 8, 9, 10,11,12,13,14,15|16   */                      
    CLZ     R8,R7       /* Slot0 - Expected res: 16,17,18,19,20,21,22,23|24   */
    CLZ     R9,R7       /* Slot1 - Expected res: 16,17,18,19,20,21,22,23|24   */
    CLZ     R11,R10     /* Slot0 - Expected res: 24,25,26,27,28,29,30,31|32   */
    CLZ     R12,R10     /* Slot1 - Expected res: 24,25,26,27,28,29,30,31|32   */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R0      /* Restore PRIMASK register */
    
    CMP     R2,R14
    BNE     m33_cst_alu_test3_end
    CMP     R3,R14
    BNE     m33_cst_alu_test3_end
    ADD     R14,R14,#8
    CMP     R5,R14
    BNE     m33_cst_alu_test3_end
    CMP     R6,R14
    BNE     m33_cst_alu_test3_end
    ADD     R14,R14,#8
    CMP     R8,R14
    BNE     m33_cst_alu_test3_end
    CMP     R9,R14
    BNE     m33_cst_alu_test3_end
    ADD     R14,R14,#8
    CMP     R11,R14
    BNE     m33_cst_alu_test3_end
    CMP     R12,R14
    BNE     m33_cst_alu_test3_end
    SUB     R14,R14,#23 /* Update R14 = R14 + (24-23) */
    
    /* Prepare new test vector */
    LSR     R1,R1,#1
    LSR     R4,R4,#1
    LSR     R7,R7,#1
    LSR     R10,R10,#1
    CMP     R14,#8
    BLS     m33_cst_alu_test3_clz_loop  /* Repeat loop 9-times */
    
    /* Update Signature !! */
    POP     {R0}
    ROR     R1,R0,R14
    PUSH    {R1}
    
    /*------------------------------------------------------------------------*/
    /* Test routine - End                                                     */
    /*------------------------------------------------------------------------*/
m33_cst_alu_test3_end:
    /* Test result is returned in R0, according to the conventions */
    POP     {R0}
    B       m33_cst_test_tail_end
    
        
    CST_ALIGN_BYTES_4
    /* Marks the current location for dumping psuedoinstruction pools containing
       numeric values for used symbolic names used within LDR instruction. */
    CST_LTORG

#endif /* CORTST_M33_ALU_ENABLE */
    
    CST_FILE_END

