/*
 * Copyright 2020-2025 Yuntu Microelectronics co.,ltd
 * All rights reserved.
 *
 * YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 * used strictly in accordance with the applicable license terms. By expressly
 * accepting such terms or by downloading, installing, activating and/or otherwise
 * using the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software. The production use license in
 * Section 2.3 is expressly granted for this software.
 */

/******************************************************************************
* Test summary:
* -------------
* Tests ALU0 and ALU1 Logic Unit related logics as well as decoding of logic
* instructions. 
* Each time before issuing the tested instructions, the external
* interrupts are disabled and pipeline is flushed to ensure its consistent 
* state.    
*
* Decoder coverage:
* ----------------
* Thumb (16-bit) DECODER:
*   - ANDS, ORRS, BICS, EORS, TST
*
* Thumb (32-bit) DECODER:
*   - AND{S}, ORR{S}, BIC{S}, EOR{S}, ORN{S}, TST
******************************************************************************/

#include "CorTst_Compiler.h"
#include "CorTst_M33_Cfg.h"

#if (CORTST_M33_ALU_ENABLE==1)
    /* Compatible with ABI. */
    CST_PRES8
    /* Symbols defined in the current module but to be visible to outside */
    CST_EXPORT M33_Cst_AluTest1

    /* Symbols defined outside but used within current module */
    CST_EXTERN m33_cst_test_tail_end


    CST_SET(PRESIGNATURE_SEED_0, 0xAB13) /* 5678 - halfbyte order */
    CST_SET(PRESIGNATURE_SEED_1, 0x1207) /* 3412 */

    /*------------------------------------------------------------------------*/
    CST_SECTION_EXEC(mcal_text)
    /*------------------------------------------------------------------------*/
    /* The ".type" directive instructs the assembler/linker that the label 
       "M33_Cst_AluTest1" designates a function.
       This would cause setting the least significant bit to '1' within any 
       pointer to this function, causing change to Thumb mode whenever this 
       function is called. */
    CST_THUMB2
    CST_TYPE(M33_Cst_AluTest1, function)
M33_Cst_AluTest1:

    PUSH    {R4-R12,R14}
    
    /*------------------------------------------------------------------------*/
    /* Test - preparation                                                     */
    /*------------------------------------------------------------------------*/
    /* Prepare signature */
    MOV     R1,#PRESIGNATURE_SEED_0 /* 00005678 - halfbyte order */
    REVSH.N R2,R1                   /* 00007856 */
    MOV     R1,#0x00000000          /* 00000000 */
    MOVT    R1,#PRESIGNATURE_SEED_1 /* 34120000 */
    ORR     R1,R1,R2                /* 34127856 */
    RBIT    R2,R1                   /* 65872143 */
    REV16.N R1,R2                   /* 87654321 -> PRESIGNATURE = 0x83235523 */
    
    /***************************************************************************
    * Instructions:
    *   - TST (register)  Encoding T1 (16-bit)
    *   - TST (register)  Encoding T2 (32-bit)
    *   - TST (immediate) Encoding T1 (32-bit)
    *
    * Note: TST is similar to ANDS, but only flags are updated, result is not
    *       stored to register. We need to check that instruction was correctly
    *       decoded and registers are not overwriten
    ***************************************************************************/
    MVN     R2,R1,ROR #2    /* Prepare inverted and shifted signature */

m33_cst_loadstore_test1_tst1:
    ROR     R1,R1,#1        /* Update signature !! */
    TST.N   R1,R2
    BNE.N   m33_cst_loadstore_test1_tst1

m33_cst_loadstore_test1_tst2:
    ROR     R1,R1,#1        /* Update signature !! */
    TST.W   R1,R2,ROR #2
    BNE.W   m33_cst_loadstore_test1_tst2
    
m33_cst_loadstore_test1_tst3:
    ROR     R1,R1,#1        /* Update signature !! */
    TST.W   R1,#(1<<6)
    BNE     m33_cst_loadstore_test1_tst3
    
    PUSH    {R1}
    
    
    /*------------------------------------------------------------------------*/
    /* Test - start                                                           */
    /*------------------------------------------------------------------------*/
    MOV     R0,#0
    
    CST_OPCODE_START
    CST_OPCODE16(0xF380)       /* MSR     APSR,R0 */     
    CST_OPCODE16(0x8C00)       /* Clears APSR_nzcvq, APSR_ge */    
    CST_OPCODE_END
    
    MRS     R0,PRIMASK                  /* Save PRIMASK                       */
    
    /**************************************************************************/
    /* Test combinations of '1' and '0' for input operands                    */ 
    /* as well as multiplexer selecting logic operation                       */
    /**************************************************************************/
    MOV     R1,#0x55555555               
    MOV     R2,#0xFFFFFFFF               
    BL      m33_cst_alu_lu_test_code1   /* Branch & execute testing code */
    
    MOV     R1,#0xAAAAAAAA               
    MOV     R2,#0x00000000               
    BL      m33_cst_alu_lu_test_code1   /* Branch & execute testing code */
      
    MOV     R1,#0xFFFFFFFF               
    MOV     R2,#0xAAAAAAAA               
    BL      m33_cst_alu_lu_test_code1   /* Branch & execute testing code */
     
    MOV     R1,#0x00000000               
    MOV     R2,#0x55555555               
    BL      m33_cst_alu_lu_test_code1   /* Branch & execute testing code */
    
    /**************************************************************************/
    /* Continue with testing using pseudo-random test vectors                 */
    /**************************************************************************/
    MOV     R10,R14                     
    ROR     R5,R14,#1                   
    BL      m33_cst_alu_lu_test_code2   /* Branch & execute testing code */
    
    MOV     R10,R14                     
    ROR     R5,R14,#2                   
    BL      m33_cst_alu_lu_test_code2   /* Branch & execute testing code */
    
    MOV     R3,R14                      
    ROR     R12,R14,#3                   
    BL      m33_cst_alu_lu_test_code3   /* Branch & execute testing code */
    
    MOV     R3,R14                      
    ROR     R12,R14,#4                   
    BL      m33_cst_alu_lu_test_code3   /* Branch & execute testing code */
    
    MOV     R1,R14                      
    MOV     R2,R14                      
    BL      m33_cst_alu_lu_test_code4   /* Branch & execute testing code */
    
    /**************************************************************************/
    /* Continue with flags testing                                            */
    /**************************************************************************/
    MOV     R1,#0x00000000
    MSR     APSR_nzcvq,R1   /* Clear flags */
    MVN     R2,R1
    BL      m33_cst_alu_lu_test_code5   /* Branch & execute testing code */
    
    
    /*------------------------------------------------------------------------*/
    /* Test routine - End                                                     */
    /*------------------------------------------------------------------------*/
m33_cst_alu_test1_end:
    POP     {R0}
    /* Test result is returned in R0, according to the conventions */
    B       m33_cst_test_tail_end
    
    
    /**************************************************************************/
    /* Test routines                                                          */
    /**************************************************************************/
m33_cst_alu_lu_test_code1:
    PUSH    {R14}       /* Save return address to stack !! */
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE               /* Flush pipeline & disable ISRs      */
    /*------------------------------------------------------------------------*/
    AND     R3,R1,R2                   
    AND     R4,R1,R2                   
    EOR     R5,R1,R2                   
    EOR     R6,R1,R2                   
    ORN     R7,R1,R2                   
    ORN     R8,R1,R2                    
    BIC     R9,R1,R2                    
    BIC     R10,R1,R2                   
    ORR     R11,R1,R2                   
    ORR     R12,R1,R2                   
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R0
    B       m7_alu_test1_sum_r1_r12

m33_cst_alu_lu_test_code2:
    PUSH    {R14}       /* Save return address to stack !! */
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE               /* Flush pipeline & disable ISRs      */
    /*------------------------------------------------------------------------*/
    AND     R3, R10,R5,LSL #5           
    AND     R4, R10,R5                  
    EOR     R1, R5,R10,ROR #10          
    EOR     R6, R5,R10                  
    ORN     R7, R10,R5,LSR #3           
    ORN     R8,R10,R5                   
    BIC     R9,R5,R10,ASR #12           
    BIC     R2,R5,R10                   
    ORR     R11,R10,R5,ROR #1           
    ORR     R12,R10,R5                  
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R0
    B       m7_alu_test1_sum_r1_r12   
    
m33_cst_alu_lu_test_code3:
    PUSH    {R14}       /* Save return address to stack !! */
    /* Decoder: AND, BIC, EOR, ORN, ORR (register) - 32bit Encoding T2 */
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE               /* Flush pipeline & disable ISRs      */
    /*------------------------------------------------------------------------*/
    AND     R4, R3,R12                  
    AND     R1, R3,R12,LSL #7           
    EOR     R6, R12,R3                  
    EOR     R5, R12,R3,ROR #18          
    ORN     R8, R3,R12                  
    ORN     R7, R3,R12,LSR #15          
    BIC     R10,R12,R3                  
    BIC     R9, R12,R3,ASR #16          
    ORR     R2, R3,R12                  
    ORR     R11,R3,R12,ROR #31          
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R0
    B       m7_alu_test1_sum_r1_r12 
    
m33_cst_alu_lu_test_code4:
    PUSH    {R14}       /* Save return address to stack !! */
    /* Decoder: AND, BIC, EOR, ORN, ORR (immediate) */
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE               /* Flush pipeline & disable ISRs      */
    /*------------------------------------------------------------------------*/
    AND     R3, R1,#0xA500A500 
    AND     R4, R2,#0xA500A500
    EOR     R5, R1,#0x005A005A 
    EOR     R6, R2,#0x005A005A
    ORN     R7, R1,#0x1FE00000 
    ORN     R8, R2,#0x1FE00000 
    BIC     R9, R1,#0x0037C000 
    BIC     R10,R2,#0x0037C000 
    ORR     R11,R1,#0x00007B80 
    ORR     R12,R2,#0x00007B80 
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R0
    B       m7_alu_test1_sum_r1_r12 
      
    
    /**************************************************************************/
    /* Test N,Z flags                                                         */  
    /**************************************************************************/
m33_cst_alu_lu_test_code5:
    PUSH    {R14}               /* Save return address to stack !! */
    /*------------------------------------------------------------------------*/
    /* Test that slot1 has priority over slot0 as it is always newer !!      */
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE               /* Flush pipeline & disable ISRs      */
    /*------------------------------------------------------------------------*/
    ANDS    R1,R1               /* Slot0 - Set Z flag */
    ANDS    R2,R2               /* Slot1 - Set N flag - Slot1 has priority !! */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R0
    MRS     R5,APSR                 /* Load flags */
    
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE               /* Flush pipeline & disable ISRs      */
    /*------------------------------------------------------------------------*/
    ORRS    R2,R2               /* Slot0 - Set N flag */       
    ORRS    R1,R1               /* Slot1 - Set Z flag - Slot1 has priority !! */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R0
    MRS     R6,APSR                 /* Load flags */
    
    /*------------------------------------------------------------------------*/
    /* Check that Data path 0 drives N,Z flags correctly */
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE           /* Flush pipeline & disable ISRs          */
    /*------------------------------------------------------------------------*/
    EORS    R2,R1                   /* Slot0 - Set N flag */
    NOP
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R0
    MRS     R7,APSR                 /* Load flags */
    
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE           /* Flush pipeline & disable ISRs          */
    /*------------------------------------------------------------------------*/
    BICS    R1,R2                   /* Slot0 - Set Z flag */        
    NOP
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R0
    MRS     R8,APSR                 /* Load flags */
    
    
    /**************************************************************************/
    /* Continue with the decoder testing                                      */
    /*  - check {S} bit is decoded correctly !!                               */
    /**************************************************************************/
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE               /* Flush pipeline & disable ISRs      */
    /*------------------------------------------------------------------------*/
    ANDS    R3,R2,R2                    /* Slot0 - Set N Flag */
    NOP
    AND     R3,R1,R1                    /* Slot0 - Z flag is not set !! */
    NOP
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R0
    MRS     R9,APSR                     /* Load flags */

    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE               /* Flush pipeline & disable ISRs      */
    /*------------------------------------------------------------------------*/    
    ORNS    R4,R1,#0xFFFFFFFF           /* Slot0 - Set Z Flag */
    NOP
    ORN     R4,R1,#0x00000000           /* Slot0 - N Flag is not set !! */
    NOP
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R0
    MRS     R10,APSR                    /* Load flags */
    
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE               /* Flush pipeline & disable ISRs      */
    /*------------------------------------------------------------------------*/
    NOP
    EORS    R3,R1,R2                    /* Slot1 - Set N Flag */
    NOP
    EOR     R3,R1,R1                    /* Slot1 - Z flag is not set !! */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R0
    MRS     R11,APSR                    /* Load flags */
    
    /*------------------------------------------------------------------------*/
    CST_PREPARE_PIPELINE               /* Flush pipeline & disable ISRs      */
    /*------------------------------------------------------------------------*/
    NOP
    BICS    R4,R2,#0xFFFFFFFF           /* Slot1 - Set Z Flag */
    NOP
    BIC     R4,R2,#0x00000000           /* Slot1 - N flag is not set !! */
    /*------------------------------------------------------------------------*/
    MSR     PRIMASK,R0
    MRS     R12,APSR                    /* Load flags */
    
    
    /**************************************************************************/
    /* Update test signature here                                             */
    /**************************************************************************/
m7_alu_test1_sum_r1_r12:
    LDR     R14,[SP,#4]     /* Load Signature */
    ADCS    R14,R14,R1
    ADCS    R14,R14,R2
    RRX     R14,R14
    ADCS    R14,R14,R3
    ADCS    R14,R14,R4
    RRX     R14,R14
    ADCS    R14,R14,R5
    ADCS    R14,R14,R6
    RRX     R14,R14
    ADCS    R14,R14,R7
    ADCS    R14,R14,R8
    RRX     R14,R14
    ADCS    R14,R14,R9
    ADCS    R14,R14,R10
    RRX     R14,R14
    ADCS    R14,R14,R11
    ADCS    R14,R14,R12
    STR     R14,[SP,#4]     /* Save updated signature !! */
    POP     {R15}           /* Branch back to return address !! */
    
    CST_ALIGN_BYTES_4
    /* Marks the current location for dumping psuedoinstruction pools containing
       numeric values for used symbolic names used within LDR instruction. */
    CST_LTORG

#endif /* CORTST_M33_ALU_ENABLE */

    CST_FILE_END

