/*
 * Copyright 2020-2025 Yuntu Microelectronics co.,ltd
 * All rights reserved.
 *
 * YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 * used strictly in accordance with the applicable license terms. By expressly
 * accepting such terms or by downloading, installing, activating and/or otherwise
 * using the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software. The production use license in
 * Section 2.3 is expressly granted for this software.
 */

#include "CorTst_Compiler.h"

    /* Compatible with ABI. */
    CST_PRES8
    /* Symbols defined in the current module but to be visible to outside */
    CST_EXPORT m33_cst_VTABLE
   
    /* Symbols defined outside but used within current module */
    CST_EXTERN m33_cst_ISR_dispatcher
    
    /*------------------------------------------------------------------------*/
    CST_SECTION_CONST_ALIGN(cortst_vector_table, CST_BYTES_128)
    /*------------------------------------------------------------------------*/
    CST_ALIGN_BYTES_128
m33_cst_VTABLE:

    CST_WORD m33_cst_ISR_dispatcher        /* Top of Stack for Initial SP */
    CST_WORD m33_cst_ISR_dispatcher        /* Reset Handler */
    CST_WORD m33_cst_ISR_dispatcher        /* NMI Handler */
    CST_WORD m33_cst_ISR_dispatcher        /* Hard Fault Handler */
    CST_WORD m33_cst_ISR_dispatcher        /* Mem Manage Handler */
    CST_WORD m33_cst_ISR_dispatcher        /* Bus Fault Handler */
    CST_WORD m33_cst_ISR_dispatcher        /* Usage Fault Handler */
    CST_WORD m33_cst_ISR_dispatcher        /* Reserved */
    CST_WORD m33_cst_ISR_dispatcher        /* Reserved */
    CST_WORD m33_cst_ISR_dispatcher        /* Reserved */
    CST_WORD m33_cst_ISR_dispatcher        /* Reserved */
    CST_WORD m33_cst_ISR_dispatcher        /* SVCall Handler */
    CST_WORD m33_cst_ISR_dispatcher        /* Debug Monitor Handler */
    CST_WORD m33_cst_ISR_dispatcher        /* Reserved */
    CST_WORD m33_cst_ISR_dispatcher        /* PendSV Handler */
    CST_WORD m33_cst_ISR_dispatcher        /* SysTick Handler */ /* 15*/

    /* External interrupts 0-15 */
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher

    /* External interrupts 16-31 */
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher

    /* External interrupts 32-47 */
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher

    /* External interrupts 48-63 */
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher

    /* External interrupts 64-79 */
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher

    /* External interrupts 80-95 */
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher

    /* External interrupts 96-111 */
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher

    /* External interrupts 112-127 */
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher

    /* External interrupts 128-143 */
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher

    /* External interrupts 144-159 */
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher

    /* External interrupts 160-175 */
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher

    /* External interrupts 176-191 */
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher
    CST_WORD m33_cst_ISR_dispatcher

    CST_FILE_END

