/*
 * Copyright 2020-2025 Yuntu Microelectronics co.,ltd
 * All rights reserved.
 *
 * YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 * used strictly in accordance with the applicable license terms. By expressly
 * accepting such terms or by downloading, installing, activating and/or otherwise
 * using the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software. The production use license in
 * Section 2.3 is expressly granted for this software.
 */

#include "CorTst_Compiler.h"
#include "CorTst_M33_Cfg.h"

    /* Compatible with ABI. */
    CST_PRES8
    /* Symbols defined outside but used within current module */
    CST_EXTERN CorTst_FaultInjectValue
    
    /* Symbols defined in the current module but to be visible to outside */
    CST_EXPORT CST_RAM_TARGET0
    CST_EXPORT CST_RAM_TARGET1
    CST_EXPORT CST_RAM_TEST_CODE
    CST_EXPORT m33_cst_nvic_registers_dump
    CST_EXPORT m33_cst_scb_registers_dump
    CST_EXPORT CorTst_AccumulatedSignature
    CST_EXPORT m33_cst_test_tail_end

    CST_EXPORT VAL1
    CST_EXPORT VAL2
    CST_EXPORT VAL3
    CST_EXPORT VAL4
    CST_EXPORT VAL5
    CST_EXPORT VAL6
    CST_EXPORT VAL7
    CST_EXPORT VAL8
    CST_EXPORT VAL9
    CST_EXPORT VAL10
    CST_EXPORT VAL11
    CST_EXPORT VAL12

    /* Data patterns definition for short fault detection within load/store module */
    CST_DEFINE(VAL1, 0x55555555)  /* <data_to_store>: Short fault pattern #1 */
    CST_DEFINE(VAL2, 0xAAAAAAAA)  /* <data_to_store>: Short fault pattern #1 */
    CST_DEFINE(VAL3, 0xCCCCCCCC)  /* <data_to_store>: Short fault pattern #2 */
    CST_DEFINE(VAL4, 0x33333333)  /* <data_to_store>: Short fault pattern #2 */
    CST_DEFINE(VAL5, 0x99999999)  /* <data_to_store>: Short fault pattern #3 */
    CST_DEFINE(VAL6, 0x66666666)  /* <data_to_store>: Short fault pattern #3 */
    CST_DEFINE(VAL7, 0x77777777)  /* <data_to_store>: Short fault pattern #4 */
    CST_DEFINE(VAL8, 0xEEEEEEEE)  /* <data_to_store>: Short fault pattern #5 */
    CST_DEFINE(VAL9, 0x13579BDF)  /* <data_to_store>: Short fault pattern #6 */
    CST_DEFINE(VAL10, 0xFDB97531)  /* <data_to_store>: Short fault pattern #7 */
    CST_DEFINE(VAL11, 0x2468ACE0)  /* <data_to_store>: Short fault pattern #8 */
    CST_DEFINE(VAL12, 0x0ECA8642)  /* <data_to_store>: Short fault pattern #9 */

    /*------------------------------------------------------------------------*/
    /* NOTE: Data has to be aligned by 32 bytes, because smallest MPU region
             has 32 bytes and CST_RAM_TARGET0 is RW for any privilege level.
    */
    CST_SECTION_DATA_UNINIT_ALIGN(cortst_ram_data_target0, CST_BYTES_32)
    /*------------------------------------------------------------------------*/
    CST_ALIGN_BYTES_32
CST_RAM_TARGET0:
    /* Allocate space for Load/Store tests */
    #if (CORTST_M33_FPU_ENABLE==1)
    CST_ALLOC_BYTES(128)
    #else
    CST_ALLOC_BYTES(52)
    #endif

    /*------------------------------------------------------------------------*/
    /* NOTE: Data has to be aligned by 32 bytes, because smallest MPU region
             has 32 bytes and CST_RAM_TARGET1 is RW only for privileged mode.
             Core has no access to CST_RAM_TARGET1 in unprivileged mode.
    */
    CST_SECTION_DATA_UNINIT_ALIGN(cortst_ram_data_target1, CST_BYTES_32)
    /*------------------------------------------------------------------------*/
    CST_ALIGN_BYTES_32
CST_RAM_TARGET1:
    /* Allocate space for Load/Store tests */
    #if (CORTST_M33_FPU_ENABLE==1)
    CST_ALLOC_BYTES(128)
    #else
    CST_ALLOC_BYTES(52)
    #endif
  
    /* NOTE: Data has to be aligned by 32 bytes, because cache invalidation
             by address has base address aligned to 32 bytes.
    */
    /*------------------------------------------------------------------------*/
    CST_SECTION_EXEC_W_ALIGN(cortst_ram_test_code, CST_BYTES_32)
    /*------------------------------------------------------------------------*/
    CST_ALIGN_BYTES_32
CST_RAM_TEST_CODE:
    /* Allocate space for CST test code running from RAM */
    CST_ALLOC_BYTES(32)

    /*------------------------------------------------------------------------*/
    CST_SECTION_DATA_ALIGN(mcal_bss, CST_BYTES_4)
    /*------------------------------------------------------------------------*/
    CST_ALIGN_BYTES_4
m33_cst_nvic_registers_dump:
    /* 8 registers NVIC_ISER x 4 bytes */
    CST_ALLOC_BYTES(32)           
m33_cst_scb_registers_dump:
    #if (CORTST_M33_FPU_ENABLE==1)
    /* 3 registers (SHCSR, CCR, FPCCR) x 4 bytes */
    CST_ALLOC_BYTES(12)
    #else
    /* 2 registers (SHCSR, CCR) x 4 bytes */
    CST_ALLOC_BYTES(8)
    #endif

              
    /*------------------------------------------------------------------------*/    
    CST_SECTION_DATA_ALIGN(mcal_bss, CST_BYTES_4)
    /*------------------------------------------------------------------------*/
    CST_ALIGN_BYTES_4
CorTst_AccumulatedSignature:
    CST_ALLOC_BYTES(4)
  
  
    /*------------------------------------------------------------------------*/    
    CST_SECTION_EXEC(mcal_text)
    /*------------------------------------------------------------------------*/
    CST_THUMB2    
    CST_TYPE(m33_cst_test_tail_end, function)
m33_cst_test_tail_end:
    
    /* Apply the fault injection */
    LDR     R1,=CorTst_FaultInjectValue
    LDR     R3,[R1]
    EOR     R0,R0,R3
    
    /* Accumulate test result into global variable */
    LDR     R1,=CorTst_AccumulatedSignature
    LDR     R3,[R1]
    EOR     R3,R3,R0
    STR     R3,[R1]
    
    /* Return from test */
    POP     {R4-R12,PC}
    

    CST_ALIGN_BYTES_4
    CST_LTORG
    /* Marks the current location for dumping psuedoinstruction pools containing
       numeric values for used symbolic names used within LDR instruction. */
    CST_FILE_END

