/*
 * Copyright 2020-2025 Yuntu Microelectronics co.,ltd
 * All rights reserved.
 *
 * YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 * used strictly in accordance with the applicable license terms. By expressly
 * accepting such terms or by downloading, installing, activating and/or otherwise
 * using the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software. The production use license in
 * Section 2.3 is expressly granted for this software.
 */

#include "CorTst_Compiler.h"
#include "CorTst_M33_Cfg.h"

#if (CORTST_M33_FPU_ENABLE==1)
    
    /* Compatible with ABI. */
    CST_PRES8
    /* Symbols defined outside but used within current module */
    CST_EXTERN m33_cst_test_tail_end
    
    /* Symbols defined in the current module but to be visible to outside */
    CST_EXPORT m33_cst_test_tail_fpu_end
    
    CST_EXPORT m33_cst_write_fpu_regs_from_r0
    CST_EXPORT m33_cst_write_fpu_s0_s31_from_r0
    CST_EXPORT m33_cst_write_fpu_s2_s31_from_r0
    CST_EXPORT m33_cst_write_fpu_s4_s31_from_r0
    CST_EXPORT m33_cst_write_fpu_s6_s31_from_r0
    CST_EXPORT m33_cst_write_fpu_s8_s31_from_r0
    CST_EXPORT m33_cst_write_fpu_s10_s31_from_r0
    CST_EXPORT m33_cst_write_fpu_s12_s31_from_r0
    CST_EXPORT m33_cst_write_fpu_s14_s31_from_r0
    CST_EXPORT m33_cst_write_fpu_s16_s31_from_r0
    CST_EXPORT m33_cst_write_fpu_s18_s31_from_r0
    CST_EXPORT m33_cst_write_fpu_s20_s31_from_r0
    CST_EXPORT m33_cst_write_fpu_s22_s31_from_r0
    CST_EXPORT m33_cst_write_fpu_s24_s31_from_r0
    CST_EXPORT m33_cst_write_fpu_s26_s31_from_r0
    CST_EXPORT m33_cst_write_fpu_s28_s31_from_r0
    CST_EXPORT m33_cst_write_fpu_s30_s31_from_r0
    CST_EXPORT m33_cst_sum_fpu_s0_s31_to_r1_destr_r2
    CST_EXPORT m33_cst_sum_fpu_s1_s31_to_r1_destr_r2
    CST_EXPORT m33_cst_sum_fpu_s2_s31_to_r1_destr_r2
    CST_EXPORT m33_cst_sum_fpu_s3_s31_to_r1_destr_r2
    CST_EXPORT m33_cst_sum_fpu_s4_s31_to_r1_destr_r2
    CST_EXPORT m33_cst_sum_fpu_s5_s31_to_r1_destr_r2
    CST_EXPORT m33_cst_sum_fpu_s6_s31_to_r1_destr_r2
    CST_EXPORT m33_cst_sum_fpu_s7_s31_to_r1_destr_r2
    CST_EXPORT m33_cst_sum_fpu_s8_s31_to_r1_destr_r2
    CST_EXPORT m33_cst_sum_fpu_s9_s31_to_r1_destr_r2
    CST_EXPORT m33_cst_sum_fpu_s10_s31_to_r1_destr_r2
    CST_EXPORT m33_cst_sum_fpu_s11_s31_to_r1_destr_r2
    CST_EXPORT m33_cst_sum_fpu_s12_s31_to_r1_destr_r2
    CST_EXPORT m33_cst_sum_fpu_s13_s31_to_r1_destr_r2
    CST_EXPORT m33_cst_sum_fpu_s14_s31_to_r1_destr_r2
    CST_EXPORT m33_cst_sum_fpu_s15_s31_to_r1_destr_r2
    CST_EXPORT m33_cst_sum_fpu_s16_s31_to_r1_destr_r2
    CST_EXPORT m33_cst_sum_fpu_s17_s31_to_r1_destr_r2
    CST_EXPORT m33_cst_sum_fpu_s18_s31_to_r1_destr_r2
    CST_EXPORT m33_cst_sum_fpu_s19_s31_to_r1_destr_r2
    CST_EXPORT m33_cst_sum_fpu_s20_s31_to_r1_destr_r2
    CST_EXPORT m33_cst_sum_fpu_s21_s31_to_r1_destr_r2
    CST_EXPORT m33_cst_sum_fpu_s22_s31_to_r1_destr_r2
    CST_EXPORT m33_cst_sum_fpu_s23_s31_to_r1_destr_r2
    CST_EXPORT m33_cst_sum_fpu_s24_s31_to_r1_destr_r2
    CST_EXPORT m33_cst_sum_fpu_s25_s31_to_r1_destr_r2
    CST_EXPORT m33_cst_sum_fpu_s26_s31_to_r1_destr_r2
    CST_EXPORT m33_cst_sum_fpu_s27_s31_to_r1_destr_r2
    CST_EXPORT m33_cst_sum_fpu_s28_s31_to_r1_destr_r2
    CST_EXPORT m33_cst_sum_fpu_s29_s31_to_r1_destr_r2
    CST_EXPORT m33_cst_sum_fpu_s30_s31_to_r1_destr_r2
    CST_EXPORT m33_cst_sum_fpu_s31_s31_to_r1_destr_r2
 
    /*------------------------------------------------------------------------*/
    CST_SECTION_EXEC(mcal_text)
    /*------------------------------------------------------------------------*/
    CST_THUMB2    
    CST_TYPE(m33_cst_test_tail_fpu_end, function)
m33_cst_test_tail_fpu_end:
    VPOP    {S16-S31}   /* Restore FPU registers */
    POP     {R1}        /* Restore CONTROL register */
    MSR     CONTROL,R1
    ISB
    LDR     R5,=m33_cst_test_tail_end
    BX      R5          /* -> Exit FPU test */
    
    
    /* Clears FPU registers */
    CST_TYPE(m33_cst_write_fpu_regs_from_r0, function)
    CST_TYPE(m33_cst_write_fpu_s0_s31_from_r0, function)
    CST_TYPE(m33_cst_write_fpu_s2_s31_from_r0, function)
    CST_TYPE(m33_cst_write_fpu_s4_s31_from_r0, function)
    CST_TYPE(m33_cst_write_fpu_s6_s31_from_r0, function)
    CST_TYPE(m33_cst_write_fpu_s8_s31_from_r0, function)
    CST_TYPE(m33_cst_write_fpu_s10_s31_from_r0, function)
    CST_TYPE(m33_cst_write_fpu_s12_s31_from_r0, function)
    CST_TYPE(m33_cst_write_fpu_s14_s31_from_r0, function)
    CST_TYPE(m33_cst_write_fpu_s16_s31_from_r0, function)
    CST_TYPE(m33_cst_write_fpu_s18_s31_from_r0, function)
    CST_TYPE(m33_cst_write_fpu_s20_s31_from_r0, function)
    CST_TYPE(m33_cst_write_fpu_s22_s31_from_r0, function)
    CST_TYPE(m33_cst_write_fpu_s24_s31_from_r0, function)
    CST_TYPE(m33_cst_write_fpu_s26_s31_from_r0, function)
    CST_TYPE(m33_cst_write_fpu_s28_s31_from_r0, function)
    CST_TYPE(m33_cst_write_fpu_s30_s31_from_r0, function)
m33_cst_write_fpu_regs_from_r0:
m33_cst_write_fpu_s0_s31_from_r0:
    VMOV        D0,R0,R0
m33_cst_write_fpu_s2_s31_from_r0:
    VMOV        D1,R0,R0
m33_cst_write_fpu_s4_s31_from_r0:
    VMOV        D2,R0,R0
m33_cst_write_fpu_s6_s31_from_r0:
    VMOV        D3,R0,R0
m33_cst_write_fpu_s8_s31_from_r0:
    VMOV        D4,R0,R0
m33_cst_write_fpu_s10_s31_from_r0:
    VMOV        D5,R0,R0
m33_cst_write_fpu_s12_s31_from_r0:
    VMOV        D6,R0,R0
m33_cst_write_fpu_s14_s31_from_r0:
    VMOV        D7,R0,R0
m33_cst_write_fpu_s16_s31_from_r0:
    VMOV        D8,R0,R0
m33_cst_write_fpu_s18_s31_from_r0:
    VMOV        D9,R0,R0
m33_cst_write_fpu_s20_s31_from_r0:
    VMOV        D10,R0,R0
m33_cst_write_fpu_s22_s31_from_r0:
    VMOV        D11,R0,R0
m33_cst_write_fpu_s24_s31_from_r0:
    VMOV        D12,R0,R0
m33_cst_write_fpu_s26_s31_from_r0:
    VMOV        D13,R0,R0
m33_cst_write_fpu_s28_s31_from_r0:
    VMOV        D14,R0,R0
m33_cst_write_fpu_s30_s31_from_r0:
    VMOV        D15,R0,R0
    BX          LR
   
        
    /* Sum FPU registers */
    CST_TYPE(m33_cst_sum_fpu_s0_s31_to_r1_destr_r2,function)
    CST_TYPE(m33_cst_sum_fpu_s1_s31_to_r1_destr_r2,function)
    CST_TYPE(m33_cst_sum_fpu_s2_s31_to_r1_destr_r2,function)
    CST_TYPE(m33_cst_sum_fpu_s3_s31_to_r1_destr_r2,function)
    CST_TYPE(m33_cst_sum_fpu_s4_s31_to_r1_destr_r2,function)
    CST_TYPE(m33_cst_sum_fpu_s5_s31_to_r1_destr_r2,function)
    CST_TYPE(m33_cst_sum_fpu_s6_s31_to_r1_destr_r2,function)
    CST_TYPE(m33_cst_sum_fpu_s7_s31_to_r1_destr_r2,function)
    CST_TYPE(m33_cst_sum_fpu_s8_s31_to_r1_destr_r2,function)
    CST_TYPE(m33_cst_sum_fpu_s9_s31_to_r1_destr_r2,function)
    CST_TYPE(m33_cst_sum_fpu_s10_s31_to_r1_destr_r2,function)
    CST_TYPE(m33_cst_sum_fpu_s11_s31_to_r1_destr_r2,function)
    CST_TYPE(m33_cst_sum_fpu_s12_s31_to_r1_destr_r2,function)
    CST_TYPE(m33_cst_sum_fpu_s13_s31_to_r1_destr_r2,function)
    CST_TYPE(m33_cst_sum_fpu_s14_s31_to_r1_destr_r2,function)
    CST_TYPE(m33_cst_sum_fpu_s15_s31_to_r1_destr_r2,function)
    CST_TYPE(m33_cst_sum_fpu_s16_s31_to_r1_destr_r2,function)
    CST_TYPE(m33_cst_sum_fpu_s17_s31_to_r1_destr_r2,function)
    CST_TYPE(m33_cst_sum_fpu_s18_s31_to_r1_destr_r2,function)
    CST_TYPE(m33_cst_sum_fpu_s19_s31_to_r1_destr_r2,function)
    CST_TYPE(m33_cst_sum_fpu_s20_s31_to_r1_destr_r2,function)
    CST_TYPE(m33_cst_sum_fpu_s21_s31_to_r1_destr_r2,function)
    CST_TYPE(m33_cst_sum_fpu_s22_s31_to_r1_destr_r2,function)
    CST_TYPE(m33_cst_sum_fpu_s23_s31_to_r1_destr_r2,function)
    CST_TYPE(m33_cst_sum_fpu_s24_s31_to_r1_destr_r2,function)
    CST_TYPE(m33_cst_sum_fpu_s25_s31_to_r1_destr_r2,function)
    CST_TYPE(m33_cst_sum_fpu_s26_s31_to_r1_destr_r2,function)
    CST_TYPE(m33_cst_sum_fpu_s27_s31_to_r1_destr_r2,function)
    CST_TYPE(m33_cst_sum_fpu_s28_s31_to_r1_destr_r2,function)
    CST_TYPE(m33_cst_sum_fpu_s29_s31_to_r1_destr_r2,function)
    CST_TYPE(m33_cst_sum_fpu_s30_s31_to_r1_destr_r2,function)
    CST_TYPE(m33_cst_sum_fpu_s31_s31_to_r1_destr_r2,function)
m33_cst_sum_fpu_s0_s31_to_r1_destr_r2:   
    VMOV        R2,S0
    ADD         R1,R2,R1,ROR #1
m33_cst_sum_fpu_s1_s31_to_r1_destr_r2:
    VMOV        R2,S1
    ADD         R1,R2,R1,ROR #1
m33_cst_sum_fpu_s2_s31_to_r1_destr_r2:
    VMOV        R2,S2
    ADD         R1,R2,R1,ROR #1
m33_cst_sum_fpu_s3_s31_to_r1_destr_r2:
    VMOV        R2,S3
    ADD         R1,R2,R1,ROR #1    
m33_cst_sum_fpu_s4_s31_to_r1_destr_r2:
    VMOV        R2,S4
    ADD         R1,R2,R1,ROR #1
m33_cst_sum_fpu_s5_s31_to_r1_destr_r2:
    VMOV        R2,S5
    ADD         R1,R2,R1,ROR #1    
m33_cst_sum_fpu_s6_s31_to_r1_destr_r2:
    VMOV        R2,S6
    ADD         R1,R2,R1,ROR #1    
m33_cst_sum_fpu_s7_s31_to_r1_destr_r2:
    VMOV        R2,S7
    ADD         R1,R2,R1,ROR #1
m33_cst_sum_fpu_s8_s31_to_r1_destr_r2:
    VMOV        R2,S8
    ADD         R1,R2,R1,ROR #1
m33_cst_sum_fpu_s9_s31_to_r1_destr_r2:
    VMOV        R2,S9
    ADD         R1,R2,R1,ROR #1
m33_cst_sum_fpu_s10_s31_to_r1_destr_r2:
    VMOV        R2,S10
    ADD         R1,R2,R1,ROR #1
m33_cst_sum_fpu_s11_s31_to_r1_destr_r2:
    VMOV        R2,S11
    ADD         R1,R2,R1,ROR #1
m33_cst_sum_fpu_s12_s31_to_r1_destr_r2:
    VMOV        R2,S12
    ADD         R1,R2,R1,ROR #1
m33_cst_sum_fpu_s13_s31_to_r1_destr_r2:
    VMOV        R2,S13
    ADD         R1,R2,R1,ROR #1
m33_cst_sum_fpu_s14_s31_to_r1_destr_r2:
    VMOV        R2,S14
    ADD         R1,R2,R1,ROR #1
m33_cst_sum_fpu_s15_s31_to_r1_destr_r2:    
    VMOV        R2,S15
    ADD         R1,R2,R1,ROR #1
m33_cst_sum_fpu_s16_s31_to_r1_destr_r2:    
    VMOV        R2,S16
    ADD         R1,R2,R1,ROR #1
m33_cst_sum_fpu_s17_s31_to_r1_destr_r2:    
    VMOV        R2,S17
    ADD         R1,R2,R1,ROR #1
m33_cst_sum_fpu_s18_s31_to_r1_destr_r2:    
    VMOV        R2,S18
    ADD         R1,R2,R1,ROR #1
m33_cst_sum_fpu_s19_s31_to_r1_destr_r2:    
    VMOV        R2,S19
    ADD         R1,R2,R1,ROR #1
m33_cst_sum_fpu_s20_s31_to_r1_destr_r2:    
    VMOV        R2,S20
    ADD         R1,R2,R1,ROR #1
m33_cst_sum_fpu_s21_s31_to_r1_destr_r2:    
    VMOV        R2,S21
    ADD         R1,R2,R1,ROR #1
m33_cst_sum_fpu_s22_s31_to_r1_destr_r2:   
    VMOV        R2,S22
    ADD         R1,R2,R1,ROR #1
m33_cst_sum_fpu_s23_s31_to_r1_destr_r2:
    VMOV        R2,S23
    ADD         R1,R2,R1,ROR #1
m33_cst_sum_fpu_s24_s31_to_r1_destr_r2:
    VMOV        R2,S24
    ADD         R1,R2,R1,ROR #1
m33_cst_sum_fpu_s25_s31_to_r1_destr_r2:
    VMOV        R2,S25
    ADD         R1,R2,R1,ROR #1
m33_cst_sum_fpu_s26_s31_to_r1_destr_r2:
    VMOV        R2,S26
    ADD         R1,R2,R1,ROR #1
m33_cst_sum_fpu_s27_s31_to_r1_destr_r2:
    VMOV        R2,S27
    ADD         R1,R2,R1,ROR #1
m33_cst_sum_fpu_s28_s31_to_r1_destr_r2:
    VMOV        R2,S28
    ADD         R1,R2,R1,ROR #1
m33_cst_sum_fpu_s29_s31_to_r1_destr_r2:
    VMOV        R2,S29
    ADD         R1,R2,R1,ROR #1
m33_cst_sum_fpu_s30_s31_to_r1_destr_r2:
    VMOV        R2,S30
    ADD         R1,R2,R1,ROR #1
m33_cst_sum_fpu_s31_s31_to_r1_destr_r2:
    VMOV        R2,S31
    ADD         R1,R2,R1,ROR #1
    BX          LR

    CST_ALIGN_BYTES_4
    CST_LTORG
    /* Marks the current location for dumping psuedoinstruction pools containing
       numeric values for used symbolic names used within LDR instruction. */

#endif  

    CST_FILE_END

