/*
 * Copyright 2020-2025 Yuntu Microelectronics co.,ltd
 * All rights reserved.
 *
 * YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 * used strictly in accordance with the applicable license terms. By expressly
 * accepting such terms or by downloading, installing, activating and/or otherwise
 * using the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software. The production use license in
 * Section 2.3 is expressly granted for this software.
 */

#include "CorTst_M33_Cfg.h"
#include "CorTst_Compiler.h"

    /* Compatible with ABI. */
    CST_PRES8
    /* Symbols defined in the current module but to be visible to outside */
    CST_EXPORT m33_cst_store_registers_content
    CST_EXPORT m33_cst_store_isr_registers_content
    CST_EXPORT m33_cst_restore_registers_content
    CST_EXPORT m33_cst_set_cst_interrupt_vector_table
    CST_EXPORT m33_cst_set_user_interrupt_vector_table
    CST_EXPORT m33_cst_restore_isr_registers_content
    CST_EXPORT m33_cst_exception_timeout
    #if (CORTST_M33_FPU_ENABLE==1)
    CST_EXPORT m33_cst_store_fpu_registers_content
    CST_EXPORT m33_cst_restore_fpu_registers_content
    #endif
    
    /* Symbols defined outside but used within current module */
    CST_EXTERN m33_cst_user_VTOR
    CST_EXTERN m33_cst_VTABLE
    CST_EXTERN m33_cst_nvic_registers_dump
    CST_EXTERN m33_cst_scb_registers_dump

    
    /*------------------------------------------------------------------------*/   
    CST_SECTION_EXEC(mcal_text)
    /*------------------------------------------------------------------------*/
    CST_THUMB2
    CST_TYPE(m33_cst_store_registers_content, function)
    CST_TYPE(m33_cst_store_isr_registers_content, function)
m33_cst_store_registers_content:
    
    /* Save current content of SHCSR and CCR registers */
    LDR     R1,=m33_cst_scb_registers_dump    

    LDR     R3,=M33_SHCSR_REG
    LDR     R4,[R3]
    AND     R4,R4,#(7<<16)  /* USGFAULTENA, BUSFAULTENA, MEMFAULTENA */
    STR     R4,[R1,#0]      /* Dump SHCSR to the buffer */
    
    LDR     R3,=M33_CCR_REG
    LDR     R4,[R3]
    STR     R4,[R1,#4]      /* Dump CCR to the buffer */
    
    
m33_cst_store_isr_registers_content:
    /* Store VTOR register */
    LDR     R3,=M33_VTOR_REG
    LDR     R1,[R3]     /* Load current (user) content of VTOR to R1 */
    LDR     R4,=m33_cst_user_VTOR
    STR     R1,[R4]     /* Store R1 to m33_cst_user_VTOR variable */    
    
    MRS     R6,CONTROL      /* Store CONTROL register   */
    MRS     R7,PRIMASK      /* Store PRIMASK register   */
    MRS     R8,FAULTMASK    /* Store FAULTMASK register */
    MRS     R9,BASEPRI      /* Store BASEPRI register   */
    
    #if (M33_CST_DISABLE_EXTERNAL_INTERRUPTS)
    /* Store NVIC ISER register */
    LDR     R1,=m33_cst_nvic_registers_dump
    LDR     R3,=M33_NVIC_ISER_REG
    LDR     R4,[R3,#0]      /* IRQ   0 - 31  */
    STR     R4,[R1,#0]
    LDR     R4,[R3,#4]      /* IRQ  32 - 63  */
    STR     R4,[R1,#4]
    LDR     R4,[R3,#8]      /* IRQ  64 - 95  */
    STR     R4,[R1,#8]
    LDR     R4,[R3,#12]     /* IRQ  96 - 127 */
    STR     R4,[R1,#12]
    LDR     R4,[R3,#16]     /* IRQ 128 - 159 */
    STR     R4,[R1,#16]
    LDR     R4,[R3,#20]     /* IRQ 160 - 191 */
    STR     R4,[R1,#20]
    #endif
    
    BX      LR
    
    
    #if (CORTST_M33_FPU_ENABLE==1)
    CST_TYPE(m33_cst_store_fpu_registers_content, function)
m33_cst_store_fpu_registers_content:

    LDR     R1,=m33_cst_scb_registers_dump  
    
    /* Store FPCCR register content */
    LDR     R3,=M33_FPCCR_REG
    LDR     R4,[R3]
    STR     R4,[R1,#8]      /* Dump FPCCR to the buffer */
    
    BX      LR
    #endif
    
    
    CST_TYPE(m33_cst_set_user_interrupt_vector_table, function)
    CST_TYPE(m33_cst_restore_registers_content, function)
    CST_TYPE(m33_cst_restore_isr_registers_content, function)
m33_cst_set_user_interrupt_vector_table:
m33_cst_restore_registers_content:

    /* Restore SHCSR, CCR, BASEPRI registers */ 
    LDR     R3,=m33_cst_scb_registers_dump
    
    LDR     R1,=M33_SHCSR_REG
    LDR     R4,[R3,#0]
    STR     R4,[R1]     /* Restore SHCSR */
    
    LDR     R1,=M33_CCR_REG
    LDR     R4,[R3,#4]
    STR     R4,[R1]     /* Restore CCR */
   
    
m33_cst_restore_isr_registers_content:   
    /* Restore user interrupt vector table */
    LDR     R3,=m33_cst_user_VTOR  
    LDR     R4,[R3]                /* Load R4 with content of user_VTOR variable */
    LDR     R3,=M33_VTOR_REG        
    STR     R4,[R3]                /* Restore user content of VTOR from R4 */
    DSB     /* Ensures Vector table is replaced */
    
    #if (M33_CST_DISABLE_EXTERNAL_INTERRUPTS)
    /* Enable external interrupts */
    LDR     R3,=m33_cst_nvic_registers_dump
    LDR     R1,=M33_NVIC_ISER_REG
    LDR     R4,[R3,#0]      /* IRQ   0 - 31  */
    STR     R4,[R1,#0]      
    LDR     R4,[R3,#4]      /* IRQ  32 - 63  */
    STR     R4,[R1,#4]      
    LDR     R4,[R3,#8]      /* IRQ  64 - 95  */
    STR     R4,[R1,#8]      
    LDR     R4,[R3,#12]     /* IRQ  96 - 127 */
    STR     R4,[R1,#12]     
    LDR     R4,[R3,#16]     /* IRQ 128 - 159 */
    STR     R4,[R1,#16]     
    LDR     R4,[R3,#20]     /* IRQ 160 - 191 */
    STR     R4,[R1,#20]
    DSB
    #endif
    
    MSR     CONTROL,R6      /* Restore CONTROL register */
    ISB
    MSR     BASEPRI,R9      /* Restore BASEPRI register */
    MSR     PRIMASK,R7      /* Restore PRIMASK register */
    MSR     FAULTMASK,R8    /* Restore FAULTMASK register */
    
    BX      LR
    
    
    #if (CORTST_M33_FPU_ENABLE==1)
    CST_TYPE(m33_cst_restore_fpu_registers_content, function)
m33_cst_restore_fpu_registers_content:
    
    LDR     R3,=m33_cst_scb_registers_dump
    LDR     R4,[R3,#8]
    
    LDR     R3,=M33_FPCCR_REG
    STR     R4,[R3]     /* Restore FPCCR */
    
    BX      LR
    #endif

    CST_TYPE(m33_cst_exception_timeout, function)
    /**
     * m33_cst_exception_timeout is used to avoid while 1 in m33_cst, the fellowing register is used:
     * - R1, counter
     * - R10, flag
     * - R11, time out ret address
     */
m33_cst_exception_timeout:
    CMP     R1, #0
    BEQ     branch_to_r11
    SUB     R1, #1
    B       m33_cst_exception_timeout
branch_to_r11:
    BX      R11

    CST_TYPE(m33_cst_set_cst_interrupt_vector_table, function)
m33_cst_set_cst_interrupt_vector_table:

    #if (M33_CST_DISABLE_EXTERNAL_INTERRUPTS)
    /* Disable interrupts */
    LDR     R3,=M33_NVIC_ICER_REG
    MOV     R1,#0xFFFFFFFF
    /* Disable external interrupts in NVIC */
    STR     R1,[R3,#0]      /* IRQ   0 - 31  */
    STR     R1,[R3,#4]      /* IRQ  32 - 63  */
    STR     R1,[R3,#8]      /* IRQ  64 - 95  */
    STR     R1,[R3,#12]     /* IRQ  96 - 127 */
    STR     R1,[R3,#16]     /* IRQ 128 - 159 */
    STR     R1,[R3,#20]     /* IRQ 160 - 191 */
    DSB
    #endif
    
    /* Clear BASEPRI register */
    MOV     R1,#0
    MSR     BASEPRI,R1
    
    /* Switch stack to MSP */
    MSR     CONTROL,R1
    ISB
    
    /* Replace user interrupt vector table with the CST-specific one */
    LDR     R3,=M33_VTOR_REG
    LDR     R1,=m33_cst_VTABLE
    STR     R1,[R3]     /* Store m33_cst_VTABLE address to the VTOR register */
    DSB
    
    BX      LR


    CST_ALIGN_BYTES_4
    CST_LTORG    
    /* Marks the current location for dumping psuedoinstruction pools containing
       numeric values for used symbolic names used within LDR instruction. */
    CST_FILE_END

