# ProjectName: SafLib_Demo
---
## Function description

+ This demo integrates the SafLib with YUNTU MCAL modules into a single project. 
+ It is designed to demonstrate the Startup test and Runtime test support.
+ The startup test is only executed once at the system startup for the 1st chip POR reset, while the runtime test is executed periodically in the main loop.
+ The **ClkTst** is invoked before Mcu_Init() to ensure the clock functions properly.
+ The **WdgTst** is invoked at the end of the Startup test to ensure it can trigger a system reset to reset all the used peripherals and modules during the startup test.
+ The following modules are used in the demo:
  + **SafLib**: Integrated with the SafLib to provide the safety-related HW safety mechanism self-test or SW safety mechanism.
    + **IntTst**: Integrated with the **INTM** module and **pTMR** driver to test the interrupt monitor channels.
    + **WdgTst**: Integrated with the **WDG** and **EWDG** driver to test the watchdog timer functionalities.
    + **CorTst**: AUTOSAR standardized module, test the CPU core's ALU, load/store instruction, MPU, FPU and exception functionalities with several atomic test cases.
    + **FlsTst**: AUTOSAR standardized module,test the Flash memory data integrality.
    + **RamTst**: AUTOSAR standardized module, test the RAM memory health.
    + **ClkTst**: Self-test for the system clock monitor functionalities.
    + **EfmTst**: Self-test the EFM program/erase protection functionalities.
    + **CrcTst**: Self-test the CRC and HW register protection functionalities.
    + **PpuTst**: Self-test the peripheral configuration registers functionalities.
    + **StkTst**: Self-test of SW implementation of the specified system stack overflow detection and reporting.
    + **DmaTst**: Self-test of DMA data transfer and error detection & reporting functionalities.
    + **EccTst**: Self-test the ECC error detection and reporting functionalities of CAN, SRAM and FLASH.
  + **MCAL**: function peripheral drivers for user application.
    + **YT-LINK**: Used to configure the link file.
    + **Platform**: MPU and interrupt configuration. 
    + **Mcu**: system initialization and clock configuration.
    + **Wdg**: Watchdog timer module, used to trigger the watchdog test.
    + **Gpt**: One channel for user Dio LED toggle test and another channel for Wdg trigger service.
    + **Dio**: One channel for user LED toggle test.
    + **Port**: Port configuration for the user LED toggle test.
    + **CddUart**:  UART driver module, used to print the test result to the console.
    + **Fls**: provide Flash sector configurations for FlsTst, EccTst and EfmTst modules.
    + **Crc**: provide AUTOSAR standardized CRC driver for FlsTst.
  + **Stub Modules**:
    + **Rte**: Provide SchM protection for all the modules of the SafLib and MCAL modules.
    + **Det**: Function parameter check, module state check and error reporting.
    + **WdgIf**: Watchdog interface module, header file required by the WdgTst module.
    + **MemIf**: Memory interface module, header file required by the Fls modules.
---
## Setup

+ ***Step1***: Open the ***SafLib_Demo.yct*** with the YCT tool, config the toolchain per your required(by default, the VS code + GCC are used)
+ ***Step2***: Generate the codes, you can change the configurations if needed(to adapt to your own HW design), if so, please ensure all the modifications are OK with no any errors exist before generating the code.
+ ***Step3***: Open the generated project with VS code/IAR/Keil IDE per your selected.
+ ***Step4***: Compile the project, power on the EVB and download it to the EVB via the available debugger, such as a J-LINK debugger probe.
+ ***Step5***: Generate a '.hex' file with signatures in YT config tool. Enable 'FlsTstFwPath' in 'FlsTst/FlsTstConfigSet', load 'SafLib_Demo.hex' to YT Config Tool and generate 'SafLib_Demo_FlsTst.hex' with signature data as following:
![API](GenHex.jpg)
Power on the EVB and download **the '.hex' generated by YCT** to the EVB via the available debugger, such as a J-LINK debugger probe.
---
***Tips***: The input .hex file path is a relative path, which is based on the location of the YCT project file. The .hex file generated by YCT is located in the same directory as the source file.

---
+ ***Step6***: Click the **run**( quick key `F5`) button to run the program, you can see the console output as below:
![API](Start-to-run.jpg) 
Then from the console output, you can see the test results of the runtime test(The startup-test is skipped as it's not POR reset), such as:
![API](runtime-test-UART-console-output.jpg) 
The test of the configured SafLib modules with runtime-test supported are repeatedly executed in the main loop, so you can see the test results of each module in the console output.
At the same time, Wdg is feeded periodically, and the blue user LED(**LED5**) will be toggled every 1 second by the Gpt channel 0, which is used to indicate the program is running normally.
---
***Tips***: If any module test fails, the test result will be printed to the serial console as below:
```C
SafLib Test Error Notification Entered: ModuleId = <Module_Id>
The SafLib runtime test is running with at least one error!
```

***Tips***: To avoid continuous breakpoint hit during the SafLib runtime test, all the Vector Catch of the CPU core's exceptions should be disabled.

---

+ ***Step7***: if the EVB is powered off and power on again, the startup test will be executed, and the serial console output will be as below(The runtime test will be executed periodically as **Step6** after the startup test):
![API](startup-test-UART-console-output.jpg)

***Note***: The UART serial port should be configured to `115200` baud rate, `8` data bits, `no` parity, `1` stop bit, and `no` flow control.


## Hardware Requirements

- **Evaluation Board (EVB)**: YTM32B1ME0-Q144-EVB-Rev.B/C
- **Debugger**: J-Link HW v9.2 or later, with the YUNTU `YTM32B1ME0` patch (support package) installed.

**Note**: Please check the version number at the bottom of the EVB. If it is `YTM32B1ME0-EVB-Q144 Rev.C`, please use the example projects ending with `_RevC` for `YTMEVB_Demo`, `Icu_Demo`, and `Dio_Demo`.

---

## Software Requirements

- **Configuration & Code Generation Tool**:
  - **MCAL**: Yuntu Config Tool (YCT) v2.7.0 or later
- **Compiler Toolchain**:
  - **GCC**: GNU GCC v10.3 or later
  - **Keil/MDK**: ARM Keil/MDK v5.36 or later(`armclang v6.18.2` is recommended to be used as the compiler)
  - **IAR**: IAR v9.50 or later
  - **VS Code**: Microsoft Visual Studio Code IDE v1.76 or later (with C/C++ support, GNU toolchain, CMake v3.25, ninja, and Cortex-Debug extensions installed)
- **Debugger Driver**:
  - **J-Link**: SEGGER J-Link v7.82 or later, with the YUNTU `YTM32B1ME0` patch (support package) installed.
  - **Ozone Debugger Tool**: SEGGER Ozone v3.28 or later

  ***Note***: The **YTM32B1ME0** patch needs to be installed, which can be obtained through the **YCT** tool or by contacting the ***Yuntu Sales/FAE team***.


---