/*
* @file    SchM_CorTst.h
*==================================================================================================
*   Project              : YTMicro AUTOSAR 4.4.0 MCAL
*   Platform             : ARM
*   Peripheral           : SchM_CorTst
*   Dependencies         : none
*
*   Autosar Version      : V4.4.0
*   Autosar Revision     : ASR_REL_4_4_REV_0000
*   SW Version           : V2.0.0
*
*   (c) Copyright 2020-2025 Yuntu Microelectronics co.,ltd.
*   All Rights Reserved.
==================================================================================================*/

#ifndef SCHM_CORTST_H
#define SCHM_CORTST_H

#ifdef __cplusplus
extern "C" {
#endif

/*
* @page misra_violations MISRA-C:2012 violations list
* PRQA S 0777 Rule 5.1: External identifiers shall be distinct
* PRQA S 0779 Rule 5.2: Identifiers declared in the same scope and name space shall be distinct
* PRQA S 0787 Rule 5.5: Identifiers shall be distinct from macro names. it's required when "MCAL_SCHM_LITE" is defined
*/
/* MR12 RULE 5.1 VIOLATION: The naming of the functions SchM_Enter and SchM_Exit follows the AUTOSAR_SWS_RTE documentation
* standards but does not comply with M3CM Rule-5.1 (0777).
*/
/* MR12 RULE 5.2 VIOLATION: The naming of the functions SchM_Enter and SchM_Exit follows the AUTOSAR_SWS_RTE documentation
* standards but does not comply with M3CM Rule-5.2 (0779).
*/
/* MR12 RULE 5.5 VIOLATION: The naming of the functions SchM_Enter and SchM_Exit implemented
* with the macro define to reuse the code and reduce size, it's full tested and verified with no risks.
* standards but does not comply with M3CM Rule-5.5 (0787).
*/
/* PRQA S 0777,0779,0787 EOF */

/*==================================================================================================
                                                INCLUDE FILES
==================================================================================================*/

#include "CorTst_Cfg.h"

/*==================================================================================================
                                        HHEADER FILE VERSION INFORMATION
==================================================================================================*/
#define SCHM_CORTST_VENDOR_ID                      (180)
#define SCHM_CORTST_AR_RELEASE_MAJOR_VERSION       (4)
#define SCHM_CORTST_AR_RELEASE_MINOR_VERSION       (4)
#define SCHM_CORTST_AR_RELEASE_REVISION_VERSION    (0)
#define SCHM_CORTST_SW_MAJOR_VERSION               (2)
#define SCHM_CORTST_SW_MINOR_VERSION               (0)
#define SCHM_CORTST_SW_PATCH_VERSION               (0)
/*==================================================================================================
                                                DEFINES AND MACROS
==================================================================================================*/

/*==================================================================================================
                                                EXTERNAL CONSTANTS
==================================================================================================*/
/*==================================================================================================
                                                ENUMS
==================================================================================================*/
/*==================================================================================================
                                                FUNCTION PROTOTYPES
==================================================================================================*/

#if (STD_ON == CORTST_SCHM_SUPPORT)

#ifdef MCAL_SCHM_LITE

extern void SchM_Enter_CorTst_CORTST_EXCLUSIVE_AREA(void);
extern void SchM_Exit_CorTst_CORTST_EXCLUSIVE_AREA(void);

#define SchM_Enter_CorTst_CORTST_EXCLUSIVE_AREA_00() SchM_Enter_CorTst_CORTST_EXCLUSIVE_AREA()
#define SchM_Exit_CorTst_CORTST_EXCLUSIVE_AREA_00() SchM_Exit_CorTst_CORTST_EXCLUSIVE_AREA()

#define SchM_Enter_CorTst_CORTST_EXCLUSIVE_AREA_01() SchM_Enter_CorTst_CORTST_EXCLUSIVE_AREA()
#define SchM_Exit_CorTst_CORTST_EXCLUSIVE_AREA_01() SchM_Exit_CorTst_CORTST_EXCLUSIVE_AREA()

#define SchM_Enter_CorTst_CORTST_EXCLUSIVE_AREA_02() SchM_Enter_CorTst_CORTST_EXCLUSIVE_AREA()
#define SchM_Exit_CorTst_CORTST_EXCLUSIVE_AREA_02() SchM_Exit_CorTst_CORTST_EXCLUSIVE_AREA()

#else

extern void SchM_Enter_CorTst_CORTST_EXCLUSIVE_AREA_00(void);
extern void SchM_Exit_CorTst_CORTST_EXCLUSIVE_AREA_00(void);
extern void SchM_Enter_CorTst_CORTST_EXCLUSIVE_AREA_01(void);
extern void SchM_Exit_CorTst_CORTST_EXCLUSIVE_AREA_01(void);
extern void SchM_Enter_CorTst_CORTST_EXCLUSIVE_AREA_02(void);
extern void SchM_Exit_CorTst_CORTST_EXCLUSIVE_AREA_02(void);

#endif /* MCAL_SCHM_LITE */

#else
#define SchM_Enter_CorTst_CORTST_EXCLUSIVE_AREA_00()
#define SchM_Exit_CorTst_CORTST_EXCLUSIVE_AREA_00()
#define SchM_Enter_CorTst_CORTST_EXCLUSIVE_AREA_01()
#define SchM_Exit_CorTst_CORTST_EXCLUSIVE_AREA_01()
#define SchM_Enter_CorTst_CORTST_EXCLUSIVE_AREA_02()
#define SchM_Exit_CorTst_CORTST_EXCLUSIVE_AREA_02()
#endif /* STD_ON == CORTST_SCHM_SUPPORT */

#ifdef __cplusplus
}
#endif

#endif /* End of file SchM_CorTst.h */

