/*
* @file    Dem.h
*==================================================================================================
*   Project              : YTMicro AUTOSAR 4.4.0 MCAL
*   Platform             : ARM
*   Peripheral           : Dem
*   Dependencies         : none
*
*   Autosar Version      : V4.4.0
*   Autosar Revision     : ASR_REL_4_4_REV_0000
*   SW Version           : V2.3.0
*
*   (c) Copyright 2020-2025 Yuntu Microelectronics co.,ltd.
*   All Rights Reserved.
==================================================================================================*/

#ifndef DEM_H
#define DEM_H

#ifdef __cplusplus
extern "C" {
#endif

/*==================================================================================================
                                                        INCLUDE FILES                                          
==================================================================================================*/

#include "Std_Types.h"
#include "Rte_Dem_Type.h"
#include "Dem_Cfg.h"
 
/*==================================================================================================
                                              HEADER FILE VERSION INFORMATION                                
==================================================================================================*/
#define DEM_VENDOR_ID                      (180)
#define DEM_AR_RELEASE_MAJOR_VERSION       (4)
#define DEM_AR_RELEASE_MINOR_VERSION       (4)
#define DEM_AR_RELEASE_REVISION_VERSION    (0)
#define DEM_SW_MAJOR_VERSION               (2)
#define DEM_SW_MINOR_VERSION               (3)
#define DEM_SW_PATCH_VERSION               (0)
/*==================================================================================================
                                                         DEFINES AND MACROS                                       
==================================================================================================*/
#define DEM_EVENT_ID                            (uint8)(127U)

/* Length value of DEM enven status */
#define DEM_EVENT_STATUS                        (uint8)(127U)

/*==================================================================================================
                                                         EXTERNAL CONSTANTS                                        
==================================================================================================*/
/*==================================================================================================
                                                         ENUMS                                        
==================================================================================================*/
/*==================================================================================================
                                                         FUNCTION PROTOTYPES                                           
==================================================================================================*/
/**
 @brief Sets the status of a given event
 his function sets the status of the specified event (identified by its EventId)
 to the given status (EventStatus).
 @param[in] EventId The ID of the event whose status is to be set
 @param[in] EventStatus The status to be set for the given event
 @return Std_ReturnType The standard return type indicating if the operation was successful
 @note stub function, just for test
 */
Std_ReturnType Dem_SetEventStatus(Dem_EventIdType EventId,
                                  Dem_EventStatusType EventStatus);





#ifdef __cplusplus
}
#endif

#endif /* End of file Dem.h */

