#include "Can_Lld.h"
#include "Can_Drv.h"
#include "OsIf.h"
/*==================================================================================================
*                                     IRQ ENTRANCE PROTOTYPES
==================================================================================================*/
#define CAN_START_SEC_CODE
#include "Can_MemMap.h"

#ifdef FLEXCAN_0_MAP
#if (FLEXCAN_0_BUSOFF_PROCESS_HAS_INTERRUPT == STD_ON)
CAN_FUNC ISR(CAN0_ORed_IRQHandler);
#endif
#if (FLEXCAN_0_WAKEUP_ENABLE == STD_ON)
CAN_FUNC ISR(CAN0_Wake_Up_IRQHandler);
#endif
CAN_FUNC ISR(CAN0_Error_IRQHandler);
#if((FLEXCAN_0_RX_PROCESS_HAS_INTERRUPT==STD_ON) || (FLEXCAN_0_TX_PROCESS_HAS_INTERRUPT==STD_ON))
#if (FLEXCAN_0_RAM_REGION_NUM > 0U)
CAN_FUNC ISR(CAN0_ORed_0_15_MB_IRQHandler);
CAN_FUNC ISR(CAN0_ORed_16_31_MB_IRQHandler);
#endif
#if (FLEXCAN_0_RAM_REGION_NUM > 1U)
CAN_FUNC ISR(CAN0_ORed_32_47_MB_IRQHandler);
CAN_FUNC ISR(CAN0_ORed_48_63_MB_IRQHandler);
#endif
#if (FLEXCAN_0_RAM_REGION_NUM > 2U)
CAN_FUNC ISR(CAN0_ORed_64_79_MB_IRQHandler);
CAN_FUNC ISR(CAN0_ORed_80_95_MB_IRQHandler);
#endif
#if (FLEXCAN_0_RAM_REGION_NUM > 3U)
CAN_FUNC ISR(CAN0_ORed_96_111_MB_IRQHandler);
CAN_FUNC ISR(CAN0_ORed_112_127_MB_IRQHandler);
#endif /*#if (FLEXCAN_0_RAM_REGION_NUM > 3U)*/
#endif
#endif /* FLEXCAN_0_MAP */

#ifdef FLEXCAN_1_MAP
#if (FLEXCAN_1_BUSOFF_PROCESS_HAS_INTERRUPT == STD_ON)
CAN_FUNC ISR(CAN1_ORed_IRQHandler);
#endif
#if (FLEXCAN_1_WAKEUP_ENABLE == STD_ON)
CAN_FUNC ISR(CAN1_Wake_Up_IRQHandler);
#endif
CAN_FUNC ISR(CAN1_Error_IRQHandler);
#if((FLEXCAN_1_RX_PROCESS_HAS_INTERRUPT==STD_ON) || (FLEXCAN_1_TX_PROCESS_HAS_INTERRUPT==STD_ON))
#if (FLEXCAN_1_RAM_REGION_NUM > 0U)
CAN_FUNC ISR(CAN1_ORed_0_15_MB_IRQHandler);
CAN_FUNC ISR(CAN1_ORed_16_31_MB_IRQHandler);
#endif
#if (FLEXCAN_1_RAM_REGION_NUM > 1U)
CAN_FUNC ISR(CAN1_ORed_32_47_MB_IRQHandler);
CAN_FUNC ISR(CAN1_ORed_48_63_MB_IRQHandler);
#endif
#if (FLEXCAN_1_RAM_REGION_NUM > 2U)
CAN_FUNC ISR(CAN1_ORed_64_79_MB_IRQHandler);
CAN_FUNC ISR(CAN1_ORed_80_95_MB_IRQHandler);
#endif
#if (FLEXCAN_1_RAM_REGION_NUM > 3U)
CAN_FUNC ISR(CAN1_ORed_96_111_MB_IRQHandler);
CAN_FUNC ISR(CAN1_ORed_112_127_MB_IRQHandler);
#endif /*#if (FLEXCAN_1_RAM_REGION_NUM > 3U)*/
#endif
#endif /* FLEXCAN_1_MAP */

#ifdef FLEXCAN_2_MAP
#if (FLEXCAN_2_BUSOFF_PROCESS_HAS_INTERRUPT == STD_ON)
CAN_FUNC ISR(CAN2_ORed_IRQHandler);
#endif
#if (FLEXCAN_2_WAKEUP_ENABLE == STD_ON)
CAN_FUNC ISR(CAN2_Wake_Up_IRQHandler);
#endif
CAN_FUNC ISR(CAN2_Error_IRQHandler);
#if((FLEXCAN_2_RX_PROCESS_HAS_INTERRUPT==STD_ON) || (FLEXCAN_2_TX_PROCESS_HAS_INTERRUPT==STD_ON))
#if (FLEXCAN_2_RAM_REGION_NUM > 0U)
CAN_FUNC ISR(CAN2_ORed_0_15_MB_IRQHandler);
CAN_FUNC ISR(CAN2_ORed_16_31_MB_IRQHandler);
#endif
#if (FLEXCAN_2_RAM_REGION_NUM > 1U)
CAN_FUNC ISR(CAN2_ORed_32_47_MB_IRQHandler);
CAN_FUNC ISR(CAN2_ORed_48_63_MB_IRQHandler);
#endif
#if (FLEXCAN_2_RAM_REGION_NUM > 2U)
CAN_FUNC ISR(CAN2_ORed_64_79_MB_IRQHandler);
CAN_FUNC ISR(CAN2_ORed_80_95_MB_IRQHandler);
#endif
#if (FLEXCAN_2_RAM_REGION_NUM > 3U)
CAN_FUNC ISR(CAN2_ORed_96_111_MB_IRQHandler);
CAN_FUNC ISR(CAN2_ORed_112_127_MB_IRQHandler);
#endif /*#if (FLEXCAN_2_RAM_REGION_NUM > 3U)*/
#endif
#endif /* FLEXCAN_2_MAP */

#ifdef FLEXCAN_3_MAP
#if (FLEXCAN_3_BUSOFF_PROCESS_HAS_INTERRUPT == STD_ON)
CAN_FUNC ISR(CAN3_ORed_IRQHandler);
#endif
#if (FLEXCAN_3_WAKEUP_ENABLE == STD_ON)
CAN_FUNC ISR(CAN3_Wake_Up_IRQHandler);
#endif
CAN_FUNC ISR(CAN3_Error_IRQHandler);
#if((FLEXCAN_3_RX_PROCESS_HAS_INTERRUPT==STD_ON) || (FLEXCAN_3_TX_PROCESS_HAS_INTERRUPT==STD_ON))
#if (FLEXCAN_3_RAM_REGION_NUM > 0U)
CAN_FUNC ISR(CAN3_ORed_0_15_MB_IRQHandler);
CAN_FUNC ISR(CAN3_ORed_16_31_MB_IRQHandler);
#endif
#if (FLEXCAN_3_RAM_REGION_NUM > 1U)
CAN_FUNC ISR(CAN3_ORed_32_47_MB_IRQHandler);
CAN_FUNC ISR(CAN3_ORed_48_63_MB_IRQHandler);
#endif
#if (FLEXCAN_3_RAM_REGION_NUM > 2U)
CAN_FUNC ISR(CAN3_ORed_64_79_MB_IRQHandler);
CAN_FUNC ISR(CAN3_ORed_80_95_MB_IRQHandler);
#endif
#if (FLEXCAN_3_RAM_REGION_NUM > 3U)
CAN_FUNC ISR(CAN3_ORed_96_111_MB_IRQHandler);
CAN_FUNC ISR(CAN3_ORed_112_127_MB_IRQHandler);
#endif /*#if (FLEXCAN_3_RAM_REGION_NUM > 3U)*/
#endif
#endif /* FLEXCAN_3_MAP */

#ifdef FLEXCAN_4_MAP
#if (FLEXCAN_4_BUSOFF_PROCESS_HAS_INTERRUPT == STD_ON)
CAN_FUNC ISR(CAN4_ORed_IRQHandler);
#endif
#if (FLEXCAN_4_WAKEUP_ENABLE == STD_ON)
CAN_FUNC ISR(CAN4_Wake_Up_IRQHandler);
#endif
CAN_FUNC ISR(CAN4_Error_IRQHandler);
#if((FLEXCAN_4_RX_PROCESS_HAS_INTERRUPT==STD_ON) || (FLEXCAN_4_TX_PROCESS_HAS_INTERRUPT==STD_ON))
#if (FLEXCAN_4_RAM_REGION_NUM > 0U)
CAN_FUNC ISR(CAN4_ORed_0_15_MB_IRQHandler);
CAN_FUNC ISR(CAN4_ORed_16_31_MB_IRQHandler);
#endif
#if (FLEXCAN_4_RAM_REGION_NUM > 1U)
CAN_FUNC ISR(CAN4_ORed_32_47_MB_IRQHandler);
CAN_FUNC ISR(CAN4_ORed_48_63_MB_IRQHandler);
#endif
#if (FLEXCAN_4_RAM_REGION_NUM > 2U)
CAN_FUNC ISR(CAN4_ORed_64_79_MB_IRQHandler);
CAN_FUNC ISR(CAN4_ORed_80_95_MB_IRQHandler);
#endif
#if (FLEXCAN_4_RAM_REGION_NUM > 3U)
CAN_FUNC ISR(CAN4_ORed_96_111_MB_IRQHandler);
CAN_FUNC ISR(CAN4_ORed_112_127_MB_IRQHandler);
#endif /*#if (FLEXCAN_4_RAM_REGION_NUM > 3U)*/
#endif
#endif /* FLEXCAN_4_MAP */

#ifdef FLEXCAN_5_MAP
#if (FLEXCAN_5_BUSOFF_PROCESS_HAS_INTERRUPT == STD_ON)
CAN_FUNC ISR(CAN5_ORed_IRQHandler);
#endif
#if (FLEXCAN_5_WAKEUP_ENABLE == STD_ON)
CAN_FUNC ISR(CAN5_Wake_Up_IRQHandler);
#endif
CAN_FUNC ISR(CAN5_Error_IRQHandler);
#if((FLEXCAN_5_RX_PROCESS_HAS_INTERRUPT==STD_ON) || (FLEXCAN_5_TX_PROCESS_HAS_INTERRUPT==STD_ON))
#if (FLEXCAN_5_RAM_REGION_NUM > 0U)
CAN_FUNC ISR(CAN5_ORed_0_15_MB_IRQHandler);
CAN_FUNC ISR(CAN5_ORed_16_31_MB_IRQHandler);
#endif
#if (FLEXCAN_5_RAM_REGION_NUM > 1U)
CAN_FUNC ISR(CAN5_ORed_32_47_MB_IRQHandler);
CAN_FUNC ISR(CAN5_ORed_48_63_MB_IRQHandler);
#endif
#if (FLEXCAN_5_RAM_REGION_NUM > 2U)
CAN_FUNC ISR(CAN5_ORed_64_79_MB_IRQHandler);
CAN_FUNC ISR(CAN5_ORed_80_95_MB_IRQHandler);
#endif
#if (FLEXCAN_5_RAM_REGION_NUM > 3U)
CAN_FUNC ISR(CAN5_ORed_96_111_MB_IRQHandler);
CAN_FUNC ISR(CAN5_ORed_112_127_MB_IRQHandler);
#endif /*#if (FLEXCAN_5_RAM_REGION_NUM > 3U)*/
#endif
#endif /* FLEXCAN_5_MAP */

#ifdef FLEXCAN_6_MAP
#if (FLEXCAN_6_BUSOFF_PROCESS_HAS_INTERRUPT == STD_ON)
CAN_FUNC ISR(CAN6_ORed_IRQHandler);
#endif
#if (FLEXCAN_6_WAKEUP_ENABLE == STD_ON)
CAN_FUNC ISR(CAN6_Wake_Up_IRQHandler);
#endif
CAN_FUNC ISR(CAN6_Error_IRQHandler);
#if((FLEXCAN_6_RX_PROCESS_HAS_INTERRUPT==STD_ON) || (FLEXCAN_6_TX_PROCESS_HAS_INTERRUPT==STD_ON))
#if (FLEXCAN_6_RAM_REGION_NUM > 0U)
CAN_FUNC ISR(CAN6_ORed_0_15_MB_IRQHandler);
CAN_FUNC ISR(CAN6_ORed_16_31_MB_IRQHandler);
#endif
#if (FLEXCAN_6_RAM_REGION_NUM > 1U)
CAN_FUNC ISR(CAN6_ORed_32_47_MB_IRQHandler);
CAN_FUNC ISR(CAN6_ORed_48_63_MB_IRQHandler);
#endif
#if (FLEXCAN_6_RAM_REGION_NUM > 2U)
CAN_FUNC ISR(CAN6_ORed_64_79_MB_IRQHandler);
CAN_FUNC ISR(CAN6_ORed_80_95_MB_IRQHandler);
#endif
#if (FLEXCAN_6_RAM_REGION_NUM > 3U)
CAN_FUNC ISR(CAN6_ORed_96_111_MB_IRQHandler);
CAN_FUNC ISR(CAN6_ORed_112_127_MB_IRQHandler);
#endif /*#if (FLEXCAN_6_RAM_REGION_NUM > 3U)*/
#endif
#endif /* FLEXCAN_6_MAP */

#ifdef FLEXCAN_7_MAP
#if (FLEXCAN_7_BUSOFF_PROCESS_HAS_INTERRUPT == STD_ON)
CAN_FUNC ISR(CAN7_ORed_IRQHandler);
#endif
#if (FLEXCAN_7_WAKEUP_ENABLE == STD_ON)
CAN_FUNC ISR(CAN7_Wake_Up_IRQHandler);
#endif
CAN_FUNC ISR(CAN7_Error_IRQHandler);
#if((FLEXCAN_7_RX_PROCESS_HAS_INTERRUPT==STD_ON) || (FLEXCAN_7_TX_PROCESS_HAS_INTERRUPT==STD_ON))
#if (FLEXCAN_7_RAM_REGION_NUM > 0U)
CAN_FUNC ISR(CAN7_ORed_0_15_MB_IRQHandler);
CAN_FUNC ISR(CAN7_ORed_16_31_MB_IRQHandler);
#endif
#if (FLEXCAN_7_RAM_REGION_NUM > 1U)
CAN_FUNC ISR(CAN7_ORed_32_47_MB_IRQHandler);
CAN_FUNC ISR(CAN7_ORed_48_63_MB_IRQHandler);
#endif
#if (FLEXCAN_7_RAM_REGION_NUM > 2U)
CAN_FUNC ISR(CAN7_ORed_64_79_MB_IRQHandler);
CAN_FUNC ISR(CAN7_ORed_80_95_MB_IRQHandler);
#endif
#if (FLEXCAN_7_RAM_REGION_NUM > 3U)
CAN_FUNC ISR(CAN7_ORed_96_111_MB_IRQHandler);
CAN_FUNC ISR(CAN7_ORed_112_127_MB_IRQHandler);
#endif /*#if (FLEXCAN_7_RAM_REGION_NUM > 3U)*/
#endif
#endif /* FLEXCAN_7_MAP */



/*==================================================================================================
*                                       IRQ MACROS
==================================================================================================*/
/* GCOVR_EXCL_START */
#ifdef FLEXCAN_0_MAP
#if (FLEXCAN_0_BUSOFF_PROCESS_HAS_INTERRUPT == STD_ON)
CAN_FUNC ISR(CAN0_ORed_IRQHandler)
{
 Can_Lld_IntHwObjPrcsORedBusoff(FLEXCAN_0);
}
#endif
CAN_FUNC ISR(CAN0_Error_IRQHandler)
{
 Can_Lld_IntHwObjPrcsErr(FLEXCAN_0);
}
#if (FLEXCAN_0_WAKEUP_ENABLE == STD_ON)
CAN_FUNC ISR(CAN0_Wake_Up_IRQHandler)
{
 Can_Lld_IntHwObjProcess_Wakeup(FLEXCAN_0);
}
#endif
#if((FLEXCAN_0_RX_PROCESS_HAS_INTERRUPT==STD_ON) || (FLEXCAN_0_TX_PROCESS_HAS_INTERRUPT==STD_ON))
#if (FLEXCAN_0_RAM_REGION_NUM > 0U)
CAN_FUNC ISR(CAN0_ORed_0_15_MB_IRQHandler)
{
    Can_Lld_IntHwObjPrcsFrame(FLEXCAN_0, CAN_CONST_IRQ_ENTRANCE_0);
}
CAN_FUNC ISR(CAN0_ORed_16_31_MB_IRQHandler)
{
 Can_Lld_IntHwObjPrcsFrame(FLEXCAN_0, CAN_CONST_IRQ_ENTRANCE_1);
}
#endif
#if (FLEXCAN_0_RAM_REGION_NUM > 1U)
CAN_FUNC ISR(CAN0_ORed_32_47_MB_IRQHandler)
{
    Can_Lld_IntHwObjPrcsFrame(FLEXCAN_0, CAN_CONST_IRQ_ENTRANCE_2);
}
CAN_FUNC ISR(CAN0_ORed_48_63_MB_IRQHandler)
{
    Can_Lld_IntHwObjPrcsFrame(FLEXCAN_0, CAN_CONST_IRQ_ENTRANCE_3);
}
#endif
#if (FLEXCAN_0_RAM_REGION_NUM > 2U)
CAN_FUNC ISR(CAN0_ORed_64_79_MB_IRQHandler)
{
    Can_Lld_IntHwObjPrcsFrame(FLEXCAN_0, CAN_CONST_IRQ_ENTRANCE_4);
}
CAN_FUNC ISR(CAN0_ORed_80_95_MB_IRQHandler)
{
 Can_Lld_IntHwObjPrcsFrame(FLEXCAN_0, CAN_CONST_IRQ_ENTRANCE_5);
}
#endif
#if (FLEXCAN_0_RAM_REGION_NUM > 3U)
CAN_FUNC ISR(CAN0_ORed_96_111_MB_IRQHandler)
{
 Can_Lld_IntHwObjPrcsFrame(FLEXCAN_0, CAN_CONST_IRQ_ENTRANCE_6);
}
CAN_FUNC ISR(CAN0_ORed_112_127_MB_IRQHandler)
{
 Can_Lld_IntHwObjPrcsFrame(FLEXCAN_0, CAN_CONST_IRQ_ENTRANCE_7);
}
#endif /*#if (FLEXCAN_0_RAM_REGION_NUM > 3U)*/
#endif
#endif /* FLEXCAN_0_MAP */

#ifdef FLEXCAN_1_MAP
#if (FLEXCAN_1_BUSOFF_PROCESS_HAS_INTERRUPT == STD_ON)
CAN_FUNC ISR(CAN1_ORed_IRQHandler)
{
 Can_Lld_IntHwObjPrcsORedBusoff(FLEXCAN_1);
}
#endif
CAN_FUNC ISR(CAN1_Error_IRQHandler)
{
 Can_Lld_IntHwObjPrcsErr(FLEXCAN_1);
}
#if (FLEXCAN_1_WAKEUP_ENABLE == STD_ON)
CAN_FUNC ISR(CAN1_Wake_Up_IRQHandler)
{
 Can_Lld_IntHwObjProcess_Wakeup(FLEXCAN_1);
}
#endif
#if((FLEXCAN_1_RX_PROCESS_HAS_INTERRUPT==STD_ON) || (FLEXCAN_1_TX_PROCESS_HAS_INTERRUPT==STD_ON))
#if (FLEXCAN_1_RAM_REGION_NUM > 0U)
CAN_FUNC ISR(CAN1_ORed_0_15_MB_IRQHandler)
{
 Can_Lld_IntHwObjPrcsFrame(FLEXCAN_1, CAN_CONST_IRQ_ENTRANCE_0);
}
CAN_FUNC ISR(CAN1_ORed_16_31_MB_IRQHandler)
{
 Can_Lld_IntHwObjPrcsFrame(FLEXCAN_1, CAN_CONST_IRQ_ENTRANCE_1);
}
#endif
#if (FLEXCAN_1_RAM_REGION_NUM > 1U)
CAN_FUNC ISR(CAN1_ORed_32_47_MB_IRQHandler)
{
 Can_Lld_IntHwObjPrcsFrame(FLEXCAN_1, CAN_CONST_IRQ_ENTRANCE_2);
}
CAN_FUNC ISR(CAN1_ORed_48_63_MB_IRQHandler)
{
 Can_Lld_IntHwObjPrcsFrame(FLEXCAN_1, CAN_CONST_IRQ_ENTRANCE_3);
}
#endif
#if (FLEXCAN_1_RAM_REGION_NUM > 2U)
CAN_FUNC ISR(CAN1_ORed_64_79_MB_IRQHandler)
{
 Can_Lld_IntHwObjPrcsFrame(FLEXCAN_1, CAN_CONST_IRQ_ENTRANCE_4);
}
CAN_FUNC ISR(CAN1_ORed_80_95_MB_IRQHandler)
{
 Can_Lld_IntHwObjPrcsFrame(FLEXCAN_1, CAN_CONST_IRQ_ENTRANCE_5);
}
#endif
#if (FLEXCAN_1_RAM_REGION_NUM > 3U)
CAN_FUNC ISR(CAN1_ORed_96_111_MB_IRQHandler)
{
 Can_Lld_IntHwObjPrcsFrame(FLEXCAN_1, CAN_CONST_IRQ_ENTRANCE_6);
}
CAN_FUNC ISR(CAN1_ORed_112_127_MB_IRQHandler)
{
 Can_Lld_IntHwObjPrcsFrame(FLEXCAN_1, CAN_CONST_IRQ_ENTRANCE_7);
}
#endif /*#if (FLEXCAN_1_RAM_REGION_NUM > 3U)*/
#endif
#endif /* FLEXCAN_1_MAP */

#ifdef FLEXCAN_2_MAP
#if (FLEXCAN_2_BUSOFF_PROCESS_HAS_INTERRUPT == STD_ON)
CAN_FUNC ISR(CAN2_ORed_IRQHandler)
{
 Can_Lld_IntHwObjPrcsORedBusoff(FLEXCAN_2);
}
#endif
CAN_FUNC ISR(CAN2_Error_IRQHandler)
{
 Can_Lld_IntHwObjPrcsErr(FLEXCAN_2);
}
#if (FLEXCAN_2_WAKEUP_ENABLE == STD_ON)
CAN_FUNC ISR(CAN2_Wake_Up_IRQHandler)
{
 Can_Lld_IntHwObjProcess_Wakeup(FLEXCAN_2);
}
#endif
#if((FLEXCAN_2_RX_PROCESS_HAS_INTERRUPT==STD_ON) || (FLEXCAN_2_TX_PROCESS_HAS_INTERRUPT==STD_ON))
#if (FLEXCAN_2_RAM_REGION_NUM > 0U)
CAN_FUNC ISR(CAN2_ORed_0_15_MB_IRQHandler)
{
 Can_Lld_IntHwObjPrcsFrame(FLEXCAN_2, CAN_CONST_IRQ_ENTRANCE_0);
}
CAN_FUNC ISR(CAN2_ORed_16_31_MB_IRQHandler)
{
 Can_Lld_IntHwObjPrcsFrame(FLEXCAN_2, CAN_CONST_IRQ_ENTRANCE_1);
}
#endif
#if (FLEXCAN_2_RAM_REGION_NUM > 1U)
CAN_FUNC ISR(CAN2_ORed_32_47_MB_IRQHandler)
{
 Can_Lld_IntHwObjPrcsFrame(FLEXCAN_2, CAN_CONST_IRQ_ENTRANCE_2);
}
CAN_FUNC ISR(CAN2_ORed_48_63_MB_IRQHandler)
{
 Can_Lld_IntHwObjPrcsFrame(FLEXCAN_2, CAN_CONST_IRQ_ENTRANCE_3);
}
#endif
#if (FLEXCAN_2_RAM_REGION_NUM > 2U)
CAN_FUNC ISR(CAN2_ORed_64_79_MB_IRQHandler)
{
 Can_Lld_IntHwObjPrcsFrame(FLEXCAN_2, CAN_CONST_IRQ_ENTRANCE_4);
}
CAN_FUNC ISR(CAN2_ORed_80_95_MB_IRQHandler)
{
 Can_Lld_IntHwObjPrcsFrame(FLEXCAN_2, CAN_CONST_IRQ_ENTRANCE_5);
}
#endif
#if (FLEXCAN_2_RAM_REGION_NUM > 3U)
CAN_FUNC ISR(CAN2_ORed_96_111_MB_IRQHandler)
{
 Can_Lld_IntHwObjPrcsFrame(FLEXCAN_2, CAN_CONST_IRQ_ENTRANCE_6);
}
CAN_FUNC ISR(CAN2_ORed_112_127_MB_IRQHandler)
{
 Can_Lld_IntHwObjPrcsFrame(FLEXCAN_2, CAN_CONST_IRQ_ENTRANCE_7);
}
#endif /*#if (FLEXCAN_2_RAM_REGION_NUM > 3U)*/
#endif
#endif /* FLEXCAN_2_MAP */

#ifdef FLEXCAN_3_MAP
#if (FLEXCAN_3_BUSOFF_PROCESS_HAS_INTERRUPT == STD_ON)
CAN_FUNC ISR(CAN3_ORed_IRQHandler)
{
 Can_Lld_IntHwObjPrcsORedBusoff(FLEXCAN_3);
}
#endif
CAN_FUNC ISR(CAN3_Error_IRQHandler)
{
 Can_Lld_IntHwObjPrcsErr(FLEXCAN_3);
}
#if (FLEXCAN_3_WAKEUP_ENABLE == STD_ON)
CAN_FUNC ISR(CAN3_Wake_Up_IRQHandler)
{
 Can_Lld_IntHwObjProcess_Wakeup(FLEXCAN_3);
}
#endif
#if((FLEXCAN_3_RX_PROCESS_HAS_INTERRUPT==STD_ON) || (FLEXCAN_3_TX_PROCESS_HAS_INTERRUPT==STD_ON))
#if (FLEXCAN_3_RAM_REGION_NUM > 0U)
CAN_FUNC ISR(CAN3_ORed_0_15_MB_IRQHandler)
{
 Can_Lld_IntHwObjPrcsFrame(FLEXCAN_3, CAN_CONST_IRQ_ENTRANCE_0);
}
CAN_FUNC ISR(CAN3_ORed_16_31_MB_IRQHandler)
{
 Can_Lld_IntHwObjPrcsFrame(FLEXCAN_3, CAN_CONST_IRQ_ENTRANCE_1);
}
#endif
#if (FLEXCAN_3_RAM_REGION_NUM > 1U)
CAN_FUNC ISR(CAN3_ORed_32_47_MB_IRQHandler)
{
 Can_Lld_IntHwObjPrcsFrame(FLEXCAN_3, CAN_CONST_IRQ_ENTRANCE_2);
}
CAN_FUNC ISR(CAN3_ORed_48_63_MB_IRQHandler)
{
 Can_Lld_IntHwObjPrcsFrame(FLEXCAN_3, CAN_CONST_IRQ_ENTRANCE_3);
}
#endif
#if (FLEXCAN_3_RAM_REGION_NUM > 2U)
CAN_FUNC ISR(CAN3_ORed_64_79_MB_IRQHandler)
{
 Can_Lld_IntHwObjPrcsFrame(FLEXCAN_3, CAN_CONST_IRQ_ENTRANCE_4);
}
CAN_FUNC ISR(CAN3_ORed_80_95_MB_IRQHandler)
{
 Can_Lld_IntHwObjPrcsFrame(FLEXCAN_3, CAN_CONST_IRQ_ENTRANCE_5);
}
#endif
#if (FLEXCAN_3_RAM_REGION_NUM > 3U)
CAN_FUNC ISR(CAN3_ORed_96_111_MB_IRQHandler)
{
 Can_Lld_IntHwObjPrcsFrame(FLEXCAN_3, CAN_CONST_IRQ_ENTRANCE_6);
}
CAN_FUNC ISR(CAN3_ORed_112_127_MB_IRQHandler)
{
 Can_Lld_IntHwObjPrcsFrame(FLEXCAN_3, CAN_CONST_IRQ_ENTRANCE_7);
}
#endif /*#if (FLEXCAN_3_RAM_REGION_NUM > 3U)*/
#endif
#endif /* FLEXCAN_3_MAP */

#ifdef FLEXCAN_4_MAP
#if (FLEXCAN_4_BUSOFF_PROCESS_HAS_INTERRUPT == STD_ON)
CAN_FUNC ISR(CAN4_ORed_IRQHandler)
{
 Can_Lld_IntHwObjPrcsORedBusoff(FLEXCAN_4);
}
#endif
CAN_FUNC ISR(CAN4_Error_IRQHandler)
{
 Can_Lld_IntHwObjPrcsErr(FLEXCAN_4);
}
#if (FLEXCAN_4_WAKEUP_ENABLE == STD_ON)
CAN_FUNC ISR(CAN4_Wake_Up_IRQHandler)
{
 Can_Lld_IntHwObjProcess_Wakeup(FLEXCAN_4);
}
#endif
#if((FLEXCAN_4_RX_PROCESS_HAS_INTERRUPT==STD_ON) || (FLEXCAN_4_TX_PROCESS_HAS_INTERRUPT==STD_ON))
#if (FLEXCAN_4_RAM_REGION_NUM > 0U)
CAN_FUNC ISR(CAN4_ORed_0_15_MB_IRQHandler)
{
 Can_Lld_IntHwObjPrcsFrame(FLEXCAN_4, CAN_CONST_IRQ_ENTRANCE_0);
}
CAN_FUNC ISR(CAN4_ORed_16_31_MB_IRQHandler)
{
 Can_Lld_IntHwObjPrcsFrame(FLEXCAN_4, CAN_CONST_IRQ_ENTRANCE_1);
}
#endif
#if (FLEXCAN_4_RAM_REGION_NUM > 1U)
CAN_FUNC ISR(CAN4_ORed_32_47_MB_IRQHandler)
{
 Can_Lld_IntHwObjPrcsFrame(FLEXCAN_4, CAN_CONST_IRQ_ENTRANCE_2);
}
CAN_FUNC ISR(CAN4_ORed_48_63_MB_IRQHandler)
{
 Can_Lld_IntHwObjPrcsFrame(FLEXCAN_4, CAN_CONST_IRQ_ENTRANCE_3);
}
#endif
#if (FLEXCAN_4_RAM_REGION_NUM > 2U)
CAN_FUNC ISR(CAN4_ORed_64_79_MB_IRQHandler)
{
 Can_Lld_IntHwObjPrcsFrame(FLEXCAN_4, CAN_CONST_IRQ_ENTRANCE_4);
}
CAN_FUNC ISR(CAN4_ORed_80_95_MB_IRQHandler)
{
 Can_Lld_IntHwObjPrcsFrame(FLEXCAN_4, CAN_CONST_IRQ_ENTRANCE_5);
}
#endif
#if (FLEXCAN_4_RAM_REGION_NUM > 3U)
CAN_FUNC ISR(CAN4_ORed_96_111_MB_IRQHandler)
{
 Can_Lld_IntHwObjPrcsFrame(FLEXCAN_4, CAN_CONST_IRQ_ENTRANCE_6);
}
CAN_FUNC ISR(CAN4_ORed_112_127_MB_IRQHandler)
{
 Can_Lld_IntHwObjPrcsFrame(FLEXCAN_4, CAN_CONST_IRQ_ENTRANCE_7);
}
#endif /*#if (FLEXCAN_4_RAM_REGION_NUM > 3U)*/
#endif
#endif /* FLEXCAN_4_MAP */

#ifdef FLEXCAN_5_MAP
#if (FLEXCAN_5_BUSOFF_PROCESS_HAS_INTERRUPT == STD_ON)
CAN_FUNC ISR(CAN5_ORed_IRQHandler)
{
 Can_Lld_IntHwObjPrcsORedBusoff(FLEXCAN_5);
}
#endif
CAN_FUNC ISR(CAN5_Error_IRQHandler)
{
 Can_Lld_IntHwObjPrcsErr(FLEXCAN_5);
}
#if (FLEXCAN_5_WAKEUP_ENABLE == STD_ON)
CAN_FUNC ISR(CAN5_Wake_Up_IRQHandler)
{
 Can_Lld_IntHwObjProcess_Wakeup(FLEXCAN_5);
}
#endif
#if((FLEXCAN_5_RX_PROCESS_HAS_INTERRUPT==STD_ON) || (FLEXCAN_5_TX_PROCESS_HAS_INTERRUPT==STD_ON))
#if (FLEXCAN_5_RAM_REGION_NUM > 0U)
CAN_FUNC ISR(CAN5_ORed_0_15_MB_IRQHandler)
{
 Can_Lld_IntHwObjPrcsFrame(FLEXCAN_5, CAN_CONST_IRQ_ENTRANCE_0);
}
CAN_FUNC ISR(CAN5_ORed_16_31_MB_IRQHandler)
{
 Can_Lld_IntHwObjPrcsFrame(FLEXCAN_5, CAN_CONST_IRQ_ENTRANCE_1);
}
#endif
#if (FLEXCAN_5_RAM_REGION_NUM > 1U)
CAN_FUNC ISR(CAN5_ORed_32_47_MB_IRQHandler)
{
 Can_Lld_IntHwObjPrcsFrame(FLEXCAN_5, CAN_CONST_IRQ_ENTRANCE_2);
}
CAN_FUNC ISR(CAN5_ORed_48_63_MB_IRQHandler)
{
 Can_Lld_IntHwObjPrcsFrame(FLEXCAN_5, CAN_CONST_IRQ_ENTRANCE_3);
}
#endif
#if (FLEXCAN_5_RAM_REGION_NUM > 2U)
CAN_FUNC ISR(CAN5_ORed_64_79_MB_IRQHandler)
{
 Can_Lld_IntHwObjPrcsFrame(FLEXCAN_5, CAN_CONST_IRQ_ENTRANCE_4);
}
CAN_FUNC ISR(CAN5_ORed_80_95_MB_IRQHandler)
{
 Can_Lld_IntHwObjPrcsFrame(FLEXCAN_5, CAN_CONST_IRQ_ENTRANCE_5);
}
#endif
#if (FLEXCAN_5_RAM_REGION_NUM > 3U)
CAN_FUNC ISR(CAN5_ORed_96_111_MB_IRQHandler)
{
 Can_Lld_IntHwObjPrcsFrame(FLEXCAN_5, CAN_CONST_IRQ_ENTRANCE_6);
}
CAN_FUNC ISR(CAN5_ORed_112_127_MB_IRQHandler)
{
 Can_Lld_IntHwObjPrcsFrame(FLEXCAN_5, CAN_CONST_IRQ_ENTRANCE_7);
}
#endif /*#if (FLEXCAN_5_RAM_REGION_NUM > 3U)*/
#endif
#endif /* FLEXCAN_5_MAP */

#ifdef FLEXCAN_6_MAP
#if (FLEXCAN_6_BUSOFF_PROCESS_HAS_INTERRUPT == STD_ON)
CAN_FUNC ISR(CAN6_ORed_IRQHandler)
{
 Can_Lld_IntHwObjPrcsORedBusoff(FLEXCAN_6);
}
#endif
CAN_FUNC ISR(CAN6_Error_IRQHandler)
{
 Can_Lld_IntHwObjPrcsErr(FLEXCAN_6);
}
#if (FLEXCAN_6_WAKEUP_ENABLE == STD_ON)
CAN_FUNC ISR(CAN6_Wake_Up_IRQHandler)
{
 Can_Lld_IntHwObjProcess_Wakeup(FLEXCAN_6);
}
#endif
#if((FLEXCAN_6_RX_PROCESS_HAS_INTERRUPT==STD_ON) || (FLEXCAN_6_TX_PROCESS_HAS_INTERRUPT==STD_ON))
#if (FLEXCAN_6_RAM_REGION_NUM > 0U)
CAN_FUNC ISR(CAN6_ORed_0_15_MB_IRQHandler)
{
 Can_Lld_IntHwObjPrcsFrame(FLEXCAN_6, CAN_CONST_IRQ_ENTRANCE_0);
}
CAN_FUNC ISR(CAN6_ORed_16_31_MB_IRQHandler)
{
 Can_Lld_IntHwObjPrcsFrame(FLEXCAN_6, CAN_CONST_IRQ_ENTRANCE_1);
}
#endif
#if (FLEXCAN_6_RAM_REGION_NUM > 1U)
CAN_FUNC ISR(CAN6_ORed_32_47_MB_IRQHandler)
{
 Can_Lld_IntHwObjPrcsFrame(FLEXCAN_6, CAN_CONST_IRQ_ENTRANCE_2);
}
CAN_FUNC ISR(CAN6_ORed_48_63_MB_IRQHandler)
{
 Can_Lld_IntHwObjPrcsFrame(FLEXCAN_6, CAN_CONST_IRQ_ENTRANCE_3);
}
#endif
#if (FLEXCAN_6_RAM_REGION_NUM > 2U)
CAN_FUNC ISR(CAN6_ORed_64_79_MB_IRQHandler)
{
 Can_Lld_IntHwObjPrcsFrame(FLEXCAN_6, CAN_CONST_IRQ_ENTRANCE_4);
}
CAN_FUNC ISR(CAN6_ORed_80_95_MB_IRQHandler)
{
 Can_Lld_IntHwObjPrcsFrame(FLEXCAN_6, CAN_CONST_IRQ_ENTRANCE_5);
}
#endif
#if (FLEXCAN_6_RAM_REGION_NUM > 3U)
CAN_FUNC ISR(CAN6_ORed_96_111_MB_IRQHandler)
{
 Can_Lld_IntHwObjPrcsFrame(FLEXCAN_6, CAN_CONST_IRQ_ENTRANCE_6);
}
CAN_FUNC ISR(CAN6_ORed_112_127_MB_IRQHandler)
{
 Can_Lld_IntHwObjPrcsFrame(FLEXCAN_6, CAN_CONST_IRQ_ENTRANCE_7);
}
#endif /*#if (FLEXCAN_6_RAM_REGION_NUM > 3U)*/
#endif
#endif /* FLEXCAN_6_MAP */

#ifdef FLEXCAN_7_MAP
#if (FLEXCAN_7_BUSOFF_PROCESS_HAS_INTERRUPT == STD_ON)
CAN_FUNC ISR(CAN7_ORed_IRQHandler)
{
 Can_Lld_IntHwObjPrcsORedBusoff(FLEXCAN_7);
}
#endif
CAN_FUNC ISR(CAN7_Error_IRQHandler)
{
 Can_Lld_IntHwObjPrcsErr(FLEXCAN_7);
}
#if (FLEXCAN_7_WAKEUP_ENABLE == STD_ON)
CAN_FUNC ISR(CAN7_Wake_Up_IRQHandler)
{
 Can_Lld_IntHwObjProcess_Wakeup(FLEXCAN_7);
}
#endif
#if((FLEXCAN_7_RX_PROCESS_HAS_INTERRUPT==STD_ON) || (FLEXCAN_7_TX_PROCESS_HAS_INTERRUPT==STD_ON))
#if (FLEXCAN_7_RAM_REGION_NUM > 0U)
CAN_FUNC ISR(CAN7_ORed_0_15_MB_IRQHandler)
{
 Can_Lld_IntHwObjPrcsFrame(FLEXCAN_7, CAN_CONST_IRQ_ENTRANCE_0);
}
CAN_FUNC ISR(CAN7_ORed_16_31_MB_IRQHandler)
{
 Can_Lld_IntHwObjPrcsFrame(FLEXCAN_7, CAN_CONST_IRQ_ENTRANCE_1);
}
#endif
#if (FLEXCAN_7_RAM_REGION_NUM > 1U)
CAN_FUNC ISR(CAN7_ORed_32_47_MB_IRQHandler)
{
 Can_Lld_IntHwObjPrcsFrame(FLEXCAN_7, CAN_CONST_IRQ_ENTRANCE_2);
}
CAN_FUNC ISR(CAN7_ORed_48_63_MB_IRQHandler)
{
 Can_Lld_IntHwObjPrcsFrame(FLEXCAN_7, CAN_CONST_IRQ_ENTRANCE_3);
}
#endif
#if (FLEXCAN_7_RAM_REGION_NUM > 2U)
CAN_FUNC ISR(CAN7_ORed_64_79_MB_IRQHandler)
{
 Can_Lld_IntHwObjPrcsFrame(FLEXCAN_7, CAN_CONST_IRQ_ENTRANCE_4);
}
CAN_FUNC ISR(CAN7_ORed_80_95_MB_IRQHandler)
{
 Can_Lld_IntHwObjPrcsFrame(FLEXCAN_7, CAN_CONST_IRQ_ENTRANCE_5);
}
#endif
#if (FLEXCAN_7_RAM_REGION_NUM > 3U)
CAN_FUNC ISR(CAN7_ORed_96_111_MB_IRQHandler)
{
 Can_Lld_IntHwObjPrcsFrame(FLEXCAN_7, CAN_CONST_IRQ_ENTRANCE_6);
}
CAN_FUNC ISR(CAN7_ORed_112_127_MB_IRQHandler)
{
 Can_Lld_IntHwObjPrcsFrame(FLEXCAN_7, CAN_CONST_IRQ_ENTRANCE_7);
}
#endif /*#if (FLEXCAN_7_RAM_REGION_NUM > 3U)*/
#endif
#endif /* FLEXCAN_7_MAP */

#define CAN_STOP_SEC_CODE
#include "Can_MemMap.h"
/* GCOVR_EXCL_STOP */
