/*
 * Copyright 2020-2025 Yuntu Microelectronics Co., Ltd.
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 * 
 * @file interrupt_config.c
 * @brief 
 * 
 */


#include <stddef.h>
#include "interrupt_config.h"


void INT_SYS_ConfigInit(void)
{
    INT_SYS_DisableIRQGlobal();
    /* LINFlexD2_IRQn(35) LINFlexD2_IRQHandler*/
    INT_SYS_SetPriority(LINFlexD2_IRQn,0);
    INT_SYS_EnableIRQ(LINFlexD2_IRQn);
    /* ADC0_IRQn(39) ADC0_IRQHandler*/
    INT_SYS_SetPriority(ADC0_IRQn,0);
    INT_SYS_EnableIRQ(ADC0_IRQn);
    /* pTMR0_Ch0_IRQn(48) pTMR0_Ch0_IRQHandler*/
    INT_SYS_SetPriority(pTMR0_Ch0_IRQn,0);
    INT_SYS_EnableIRQ(pTMR0_Ch0_IRQn);
    /* CAN0_ORed_IRQn(78) CAN0_ORed_IRQHandler*/
    INT_SYS_SetPriority(CAN0_ORed_IRQn,0);
    INT_SYS_EnableIRQ(CAN0_ORed_IRQn);
    /* CAN0_Error_IRQn(79) CAN0_Error_IRQHandler*/
    INT_SYS_SetPriority(CAN0_Error_IRQn,0);
    INT_SYS_EnableIRQ(CAN0_Error_IRQn);
    /* CAN0_Wake_Up_IRQn(80) CAN0_Wake_Up_IRQHandler*/
    INT_SYS_SetPriority(CAN0_Wake_Up_IRQn,0);
    INT_SYS_EnableIRQ(CAN0_Wake_Up_IRQn);
    /* CAN0_ORed_0_15_MB_IRQn(81) CAN0_ORed_0_15_MB_IRQHandler*/
    INT_SYS_SetPriority(CAN0_ORed_0_15_MB_IRQn,0);
    INT_SYS_EnableIRQ(CAN0_ORed_0_15_MB_IRQn);
    /* CAN0_ORed_16_31_MB_IRQn(82) CAN0_ORed_16_31_MB_IRQHandler*/
    INT_SYS_SetPriority(CAN0_ORed_16_31_MB_IRQn,0);
    INT_SYS_EnableIRQ(CAN0_ORed_16_31_MB_IRQn);
    /* CAN0_ORed_32_47_MB_IRQn(83) CAN0_ORed_32_47_MB_IRQHandler*/
    INT_SYS_SetPriority(CAN0_ORed_32_47_MB_IRQn,0);
    INT_SYS_EnableIRQ(CAN0_ORed_32_47_MB_IRQn);
    /* CAN0_ORed_48_63_MB_IRQn(84) CAN0_ORed_48_63_MB_IRQHandler*/
    INT_SYS_SetPriority(CAN0_ORed_48_63_MB_IRQn,0);
    INT_SYS_EnableIRQ(CAN0_ORed_48_63_MB_IRQn);
    /* SPI4_IRQn(169) SPI4_IRQHandler*/
    INT_SYS_SetPriority(SPI4_IRQn,0);
    INT_SYS_EnableIRQ(SPI4_IRQn);
    INT_SYS_EnableIRQGlobal();
}

