
/* USER CODE BEGIN Header */
/* you can remove the copyright */

/*
 *  Copyright 2020-2023 Yuntu Microelectronics Co., Ltd.
 *  All rights reserved.
 * 
 *  SPDX-License-Identifier: BSD-3-Clause
 * 
 * @file main.c
 * @brief 
 * 
 */

/* USER CODE END Header */
#include "sdk_project_config.h"
/* Includes ------------------------------------------------------------------*/

/* Private includes ----------------------------------------------------------*/
/* USER CODE BEGIN Includes */
//#include "printf.h"
#include <stdint.h>
#include "saflib_tst.h"
#include "Mcu_Cfg.h"
#include "OsIf.h"
#include "Mcal.h"
/* USER CODE END Includes */

/* Private typedef -----------------------------------------------------------*/
/* USER CODE BEGIN PTD */
/* USER CODE END PTD */

/* Private define ------------------------------------------------------------*/
/* USER CODE BEGIN PD */

/* USER CODE END PD */

/* Private macro -------------------------------------------------------------*/
/* USER CODE BEGIN PM */
#define SafLib  1
#define UART_DEBUG_EN
#define ADC_INST    (0) /* ADC instance */
#define SEQ_LEN     (7) /* channel number */
#define CAN_INST       (0U)
#define RX_STD_MSG_ID  (0x02UL)
#define RX_STD_MAILBOX (0x00UL)
#define TX_MSG_ID      (0x03UL)
#define TX_MAILBOX     (0x01UL)
#ifdef UART_DEBUG_EN
#include "printf.h"
#endif
/* USER CODE END PM */

/* Private variables ---------------------------------------------------------*/
/* USER CODE BEGIN PV */
/* Define receive buffer */
flexcan_msgbuff_t rxStdMsg;
flexcan_msgbuff_t rxExtMsg;
/* Prepare message to be sent */
flexcan_msgbuff_t txMsg = {
    .cs = 0U,
    .msgId = TX_MSG_ID,
    .data[0] = 0x00,
    .dataLen = 1U,
};

const flexcan_data_info_t rxMbStdInfo = {
    .msg_id_type = FLEXCAN_MSG_ID_STD,
    .data_length = 8,
    .fd_enable = true,
    .fd_padding = 0,
    .enable_brs = true,
    .is_remote = false,
};
const flexcan_data_info_t txMbStdInfo = {
    .msg_id_type = FLEXCAN_MSG_ID_STD,
    .data_length = 8,
    .fd_enable = true,
    .fd_padding = 0,
    .enable_brs = true,
    .is_remote = false,
};
/* USER CODE END PV */

/* Private function declare --------------------------------------------------*/
/* USER CODE BEGIN PFDC */
extern uint32_t Test_FailedFlag_Ecc;
extern uint32_t Test_FailedFlag_Clk;
extern uint32_t Test_FailedFlag_Ram;
extern uint32_t Test_FailedFlag_Fls;
extern volatile boolean RuntimeTest_ErrorFlag;
extern uint32_t SafTstFail_Flag;
static uint32_t data[SEQ_LEN];
/* USER CODE END PFDC */
static void Board_Init(void);
static void Ecu_Init(void);

/* Private user code ---------------------------------------------------------*/
/* USER CODE BEGIN 0 */
//extern  uint32_t  __StackTop[];
//extern  void    Reset_Handler(void);
//const   uint32_t  __attribute__((section(".AppStart")))       AppStartCfg[2] = {
//    (uint32_t)0x20010000,
//    (const uint32_t)Reset_Handler,
//};

void Saflib_RunTimetst(void)
{
   RuntimeTest_Run();
}
void ADC0_IRQHandler(void)
{
    ADC_DRV_ClearEoseqFlagCmd(0);


         for (int i = 0; i < SEQ_LEN; i++)
        {
           data[i] = ADC_DRV_ReadFIFO(ADC_INST);
          /* Note: Debug output inserted into interrupt routine for demo clarity. Might introduce delay. */
           PRINTF("channel value %d=%d\n", i, data);
       }

  
}

void Ecu_Init(void)
{
     ADC_DRV_ConfigConverter(0, &adc_config0);
     ADC_DRV_Start(0);
     FLEXCAN_DRV_Init(CAN_INST, &flexcanInitConfig0_State, &flexcanInitConfig0);
     FLEXCAN_DRV_ConfigRxMb(CAN_INST, RX_STD_MAILBOX, &rxMbStdInfo, RX_STD_MSG_ID);
    /* Start receiving data in RX_STD_MAILBOX. */
     FLEXCAN_DRV_Receive(CAN_INST, RX_STD_MAILBOX, &rxStdMsg);
}

/* USER CODE END 0 */


/**
 * @brief  The application entry point.
 * @retval int
 */
int main(void)
{
    /* USER CODE BEGIN 1 */
      uint32 runtime_test_ctrl_cnt = 0U;
      status_t status = STATUS_SUCCESS;
#if SafLib
    __enable_irq();//due to CPSID in startup.s

     ClkTst_StartupTest();
    /* USER CODE END 1 */ 
//    Board_Init();   //put here for printf ;it should be delete it in project 
    /* USER CODE BEGIN 2 */


     Saflib_StarUptst();
     Board_Init();
     PRINTF("ClkTst Startup Test Passed!\r\n");  
    if((Test_FailedFlag_Ecc == 1U) || (Test_FailedFlag_Clk == 1U) || (Test_FailedFlag_Ram == 1U) || (Test_FailedFlag_Fls == 1U))
    {
        SafTstFail_Flag = 1;
    }
    if(SafTstFail_Flag==1)
    {
      PRINTF("Startup Test failed!\r\n");  
    }
    else if(SafTstFail_Flag==2)
    {
      PRINTF("Startup Test jumped!\r\n");  
    }
    else
    {
        PRINTF("Startup Test Passed!\r\n");  
    }

    RuntimeTest_Init();
#endif


     Ecu_Init();
     INT_SYS_ConfigInit();
    /* USER CODE END 2 */

    /* Infinite loop */
    /* USER CODE BEGIN WHILE */
    while (1)
    {
         txMsg.data[0]++;
        /* USER CODE END WHILE */
        /* USER CODE BEGIN 3 */

        if (0U == runtime_test_ctrl_cnt % 20)
        {
            /* Run the SafLib runtime tests cyclically */
            ADC_DRV_Start(ADC_INST);
            Saflib_RunTimetst();            
            if (TRUE == RuntimeTest_ErrorFlag)
            {
                /* If any runtime test error occurs, set the error flag and stop the tests */
                RuntimeTest_ErrorFlag = FALSE; /* Reset the error flag */
#ifdef UART_DEBUG_EN
                PRINTF("The SafLib runtime test is running with at least one error!\r\n");
#endif
            }
            else
            {
#ifdef UART_DEBUG_EN
                PRINTF("The SafLib runtime test is running with no error!\r\n");
#endif
            }
                    /* Send the information via CAN */
            if (FLEXCAN_DRV_GetTransferStatus(CAN_INST, TX_MAILBOX) != STATUS_BUSY)
            {
              status |= FLEXCAN_DRV_Send(CAN_INST, TX_MAILBOX, &txMbStdInfo, TX_MSG_ID, txMsg.data);
            }
            if (FLEXCAN_DRV_GetTransferStatus(CAN_INST, RX_STD_MAILBOX) != STATUS_BUSY)
            {
              
              PRINTF("Received MSG ID = %x, data[0] = %x\n", rxStdMsg.msgId, rxStdMsg.data[0]);
              /* Start receiving data in RX_STD_MAILBOX. */
              status |= FLEXCAN_DRV_Receive(CAN_INST, RX_STD_MAILBOX, &rxStdMsg);
            }
            
            
        }

        /* do something else here, for example the application tasks */
//        Delay_10ms(1); /* delay 1ms */
        runtime_test_ctrl_cnt++;
        if (runtime_test_ctrl_cnt >= 1000U)
        {
            runtime_test_ctrl_cnt = 0U;
        }
        
    }
    
    /* USER CODE END 3 */
}

static void Board_Init(void)
{
    CLOCK_SYS_Init(g_clockManConfigsArr,CLOCK_MANAGER_CONFIG_CNT,g_clockManCallbacksArr,CLOCK_MANAGER_CALLBACK_CNT);
    if(STATUS_SUCCESS != CLOCK_SYS_UpdateConfiguration(CLOCK_MANAGER_ACTIVE_INDEX,CLOCK_MANAGER_POLICY_AGREEMENT))
    {
        /* USER CODE BEGIN ERROR_HANDLER 1 */
        SystemSoftwareReset();        
        /* USER CODE END ERROR_HANDLER 1 */
    }
    PINS_DRV_Init(NUM_OF_CONFIGURED_PINS0,g_pin_mux_InitConfigArr0);
    UTILITY_PRINT_Init();
}

/* USER CODE BEGIN 4 */

/* USER CODE END 4 */
