
#include "YTM32B1Mx_CM33_DSP_FP.h"
#include "Mpu_Lld_Cfg.h"
#include "Mpu_Lld_M33.h"
#include "Platform.h"


extern void INT_SYS_EnableIRQ(IRQn_Type irqNumber);
extern void INT_SYS_DisableIRQ(IRQn_Type irqNumber);
extern void INT_SYS_InstallHandler(IRQn_Type irqNumber,
                            Platform_IrqHandlerType newHandler,
                            Platform_IrqHandlerType *oldHandler);
extern uint8 INT_SYS_GetPriority(IRQn_Type irqNumber);
extern void INT_SYS_SetPriority(IRQn_Type irqNumber, uint8 priority);

void Mcal_SystemInit(void)
{
  
    /* Enable the MPU */
    Mpu_Lld_M33_Init(&MpuConfig);
}



Std_ReturnType Platform_SetIrq(IRQn_Type IrqNumber, boolean Enable)
{
    Std_ReturnType ret = E_OK;

    if (Enable)
    {
        INT_SYS_EnableIRQ(IrqNumber);
    }
    else
    {
        INT_SYS_DisableIRQ(IrqNumber);
    }
    return ret;

}


Std_ReturnType Platform_InstallIrqHandler(IRQn_Type IrqNumber,
        const Platform_IrqHandlerType NewHandler,
        Platform_IrqHandlerType* const OldHandler)
{
    Std_ReturnType ret = E_OK;

    INT_SYS_InstallHandler(IrqNumber, NewHandler, OldHandler);
    
    return ret;

}




Std_ReturnType Platform_GetIrqPriority(IRQn_Type IrqNumber, uint8 * Priority)
{

    Std_ReturnType ret = E_OK;
    if (Priority == NULL_PTR)
    {
        ret = E_NOT_OK;
    }
    else
    {
        *Priority = INT_SYS_GetPriority(IrqNumber);
    }

    return ret;
}



Std_ReturnType Platform_SetIrqPriority(IRQn_Type IrqNumber, uint8 Priority){
    Std_ReturnType ret = E_OK;  

    INT_SYS_SetPriority(IrqNumber, Priority);

    return ret;
}

