/*
 * Copyright 2020-2025 Yuntu Microelectronics Co., Ltd.
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 * 
 * @file WdgTst_Cfg.c
 * @brief 
 * 
 */


#ifdef __cplusplus
extern "C" {
#endif

/*==================================================================================================
 *                                        INCLUDE FILES
==================================================================================================*/
#include "WdgTst_Cfg.h"
#include "WdgTst_Types.h"

/*==================================================================================================
 *                              SOURCE FILE VERSION INFORMATION
==================================================================================================*/
#define WDGTST_VENDOR_ID_CFG_C                      (180)
#define WDGTST_AR_RELEASE_MAJOR_VERSION_CFG_C       (4)
#define WDGTST_AR_RELEASE_MINOR_VERSION_CFG_C       (4)
#define WDGTST_AR_RELEASE_REVISION_VERSION_CFG_C    (0)
#define WDGTST_SW_MAJOR_VERSION_CFG_C               (2)
#define WDGTST_SW_MINOR_VERSION_CFG_C               (0)
#define WDGTST_SW_PATCH_VERSION_CFG_C               (0)

/*==================================================================================================
                                            FILE VERSION CHECKS
==================================================================================================*/
/* Check if source file and WDGTST Configure header file are of the same vendor */
#if (WDGTST_VENDOR_ID_CFG_C != WDGTST_VENDOR_ID_CFG)
#error "WdgTst_Cfg.c and WdgTst_Cfg.h have different vendor ids"
#endif

/* Check if source file and WDGTST Configure header file are of the same Autosar version */
#if (( WDGTST_AR_RELEASE_MAJOR_VERSION_CFG_C != WDGTST_AR_RELEASE_MAJOR_VERSION_CFG) || \
     ( WDGTST_AR_RELEASE_MINOR_VERSION_CFG_C != WDGTST_AR_RELEASE_MINOR_VERSION_CFG) || \
     ( WDGTST_AR_RELEASE_REVISION_VERSION_CFG_C != WDGTST_AR_RELEASE_REVISION_VERSION_CFG))
#error "AutoSar Version Numbers of WdgTst_Cfg.c and WdgTst_Cfg.h are different"
#endif

/* Check if source file and WDGTST Configure header file are of the same Software version */
#if (( WDGTST_SW_MAJOR_VERSION_CFG_C != WDGTST_SW_MAJOR_VERSION_CFG) || \
     ( WDGTST_SW_MINOR_VERSION_CFG_C != WDGTST_SW_MINOR_VERSION_CFG) || \
     ( WDGTST_SW_PATCH_VERSION_CFG_C != WDGTST_SW_PATCH_VERSION_CFG))
#error "Software Version Numbers of WdgTst_Cfg.c and WdgTst_Cfg.h are different"
#endif

/*==================================================================================================
 *                                       FUNCTION PROTOTYPES
==================================================================================================*/

extern void SafLib_TestError_Notification(uint16 ModuleId);

/*==================================================================================================
 *                                      GLOBAL CONSTANTS
==================================================================================================*/
#define WDGTST_START_SEC_CONFIG_DATA_UNSPECIFIED
#include "WdgTst_MemMap.h"

/**
 * @brief   WdgTst Configuration
 */
WDGTST_CONST const WdgTst_ConfigType WdgTst_Config =
{
  .ErrNotification = SafLib_TestError_Notification,
};


#define WDGTST_STOP_SEC_CONFIG_DATA_UNSPECIFIED
#include "WdgTst_MemMap.h"

#ifdef __cplusplus
}
#endif

/** @} */

