/*
* @file    RamTst_Cfg.h
*==================================================================================================
*   Project              : YTMicro AUTOSAR 4.4.0 MCAL
*   Platform             : ARM
*   Peripheral           : RamTst_Cfg
*   Dependencies         : none
*
*   Autosar Version      : V4.4.0
*   Autosar Revision     : ASR_REL_4_4_REV_0000
*   SW Version           : V2.0.0
*
*   (c) Copyright 2020-2025 Yuntu Microelectronics co.,ltd.
*   All Rights Reserved.
==================================================================================================*/

#ifndef RAMTST_CFG_H
#define RAMTST_CFG_H

#ifdef __cplusplus
extern "C" {
#endif

/*==================================================================================================
                                              INCLUDE FILES
==================================================================================================*/
#include "Dem.h"

/*==================================================================================================
                                      HEADER FILE VERSION INFORMATION
==================================================================================================*/
#define RAMTST_VENDOR_ID_CFG                      (180U)
#define RAMTST_AR_REL_MAJOR_VER_CFG               (4U)
#define RAMTST_AR_REL_MINOR_VER_CFG               (4U)
#define RAMTST_AR_REL_REVISION_VER_CFG            (0U)
#define RAMTST_SW_MAJOR_VER_CFG                   (2U)
#define RAMTST_SW_MINOR_VER_CFG                   (0U)
#define RAMTST_SW_PATCH_VER_CFG                   (0U)
/*==================================================================================================
                                                DEFINES AND MACROS
==================================================================================================*/
/**
 * @brief          Enable/disable the development error detection.
 */
#define RAMTST_DEV_ERROR_DETECT                  (STD_ON)

/**
 * @brief          Enable/disable the service RamTst_SchM support
 */
#define RAMTST_SCHM_SUPPORT                      (STD_ON)

/**
 * @brief          Add/remove the service RamTst_Allow API from the code.
 */
#define RAMTST_ALLOW_API                         (STD_ON)

/**
 * @brief          Add/remove the service RamTst_Stop API from the code.
 */
#define RAMTST_STOP_API                          (STD_ON)

/**
 * @brief          Add/remove the service RamTst_GetVersionInfo API from the code.
 */
#define RAMTST_VERSION_INFO_API                  (STD_OFF)

/**
 * @brief          Add/remove the service RamTst_Suspend API from the code.
 */
#define RAMTST_SUPSPEND_API                      (STD_ON)

/**
 * @brief          Add/remove the service RamTst_Resume API from the code.
 */
#define RAMTST_RESUME_API                        (STD_ON)

/**
 * @brief          Add/remove the service RamTst_GetExecutionStatus API from the code.
 */
#define RAMTST_GET_EXECUTION_STATUS_API          (STD_ON)

/**
 * @brief          Add/remove the service RamTst_GetTestResult API from the code.
 */
#define RAMTST_GET_TEST_RESULT_API               (STD_ON)

/**
 * @brief          Add/remove the service RamTst_GetTestResultPerBlock API from the code.
 */
#define RAMTST_GET_TEST_RESULT_PER_BLOCK_API     (STD_ON)

/**
 * @brief          Add/remove the service RamTst_GetAlgParams API from the code.
 */
#define RAMTST_GET_ALG_PARAMS_API                (STD_ON)

/**
 * @brief          Add/remove the service RamTst_GetTestAlgorithm API from the code.
 */
#define RAMTST_GET_TEST_ALGORITHM_API            (STD_ON)

/**
 * @brief          Add/remove the service RamTst_GetNumberOfTestedCells API from the code.
 */
#define RAMTST_GET_NUMBER_OF_TESTED_CELLS_API    (STD_ON)

/**
 * @brief          Add/remove the service RamTst_SelectAlgParams API from the code.
 */
#define RAMTST_SELECT_ALG_PARAMS_API             (STD_ON)

/**
 * @brief          Add/remove the service RamTst_ChangeNumOfTestedCells API from the code.
 */
#define RAMTST_CHANGE_NUM_OF_TESTED_CELLS_API    (STD_ON)

/**
 * @brief          Add/remove the service RamTst_RunFullTest API from the code.
 */
#define RAMTST_RUN_FULL_TEST_API                 (STD_ON)

/**
 * @brief          Add/remove the service RamTst_RunPartialTest API from the code.
 */
#define RAMTST_RUN_PARTIAL_TEST_API              (STD_ON)

/**
 * @brief          Add/remove the RamTst Completed Notification
 */
#define RAMTST_COMPLETED_NOTIFICATION            (STD_ON)

/**
 * @brief          Add/remove the RamTst Error Notification
 */
#define RAMTST_ERROR_NOTIFICATION                (STD_ON)


#ifdef RAMTST_ENABLE_USER_MODE_SUPPORT
#ifndef MCAL_ENABLE_USER_MODE_SUPPORT
#error "Must define MCAL_ENABLE_USER_MODE_SUPPORT if RAMTST_ENABLE_USER_MODE_SUPPORT is defined"
#endif
#endif

/**
 * @brief Algorithms that RamTst supported
 */
#define RAMTST_ABRAHAM_TEST_SELECTED             (STD_OFF)
#define RAMTST_CHECKERBOARD_TEST_SELECTED        (STD_ON)
#define RAMTST_GALPAT_TEST_SELECTED              (STD_ON)
#define RAMTST_MARCH_TEST_SELECTED               (STD_ON)
#define RAMTST_TRANSP_GALPAT_TEST_SELECTED       (STD_OFF)
#define RAMTST_WALK_PATH_TEST_SELECTED           (STD_ON)

/**
 * @brief Dem event status for RamTst
 */
#define RAMTST_ENABLE_DEM_RUNFL_ERROR_STATUS     (STD_ON)
#define RAMTST_ENABLE_DEM_PART_ERROR_STATUS      (STD_ON)
#define RAMTST_ENABLE_DEM_MAIN_ERROR_STATUS      (STD_ON)
#define RAMTST_RUNFL_RAM_FAILURE                 DemConf_DemEventParameter_RAMTST_RUNFL_RAM_FAILURE
#define RAMTST_PART_RAM_FAILURE                  DemConf_DemEventParameter_RAMTST_PART_RAM_FAILURE
#define RAMTST_MAIN_RAM_FAILURE                  DemConf_DemEventParameter_RAMTST_MAIN_RAM_FAILURE

/**
 * @brief The max number of blocks which configured in the AlgParams
 */
#define RAMTST_MAX_BLOCK                         (4U)

/**
 * @brief Definition of Block ID
 */
#define RamTstConf_RamTstBlockId_1               (1U)
#define RamTstConf_RamTstBlockId_2               (2U)
#define RamTstConf_RamTstBlockId_3               (3U)
#define RamTstConf_RamTstBlockId_4               (4U)

/**
 * @brief Definition of AlgParams ID
 */
#define RamTstConf_RamTstAlgParamsId_1           (1U)
#define RamTstConf_RamTstAlgParamsId_2           (2U)
#define RamTstConf_RamTstAlgParamsId_3           (3U)
#define RamTstConf_RamTstAlgParamsId_4           (4U)

/*==================================================================================================
                                                EXTERNAL CONSTANTS
==================================================================================================*/
/*==================================================================================================
                                                ENUMS
==================================================================================================*/
/*==================================================================================================
                                                FUNCTION PROTOTYPES
==================================================================================================*/
#ifdef __cplusplus
}
#endif

#endif /* End of file RamTst_Cfg.h */

