/*
 * Copyright 2020-2025 Yuntu Microelectronics Co., Ltd.
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 * 
 * @file PpuTst_Cfg.c
 * @brief 
 * 
 */


#ifdef __cplusplus
extern "C"
{
#endif

/*==================================================================================================
                                              INCLUDE FILES
==================================================================================================*/
#include "PpuTst.h"

/*==================================================================================================
*                              SOURCE FILE VERSION INFORMATION
==================================================================================================*/
#define PPUTST_VENDOR_ID_CFG_C                      (180)
#define PPUTST_AR_RELEASE_MAJOR_VERSION_CFG_C       (4)
#define PPUTST_AR_RELEASE_MINOR_VERSION_CFG_C       (4)
#define PPUTST_AR_RELEASE_REVISION_VERSION_CFG_C    (0)
#define PPUTST_SW_MAJOR_VERSION_CFG_C               (2)
#define PPUTST_SW_MINOR_VERSION_CFG_C               (0)
#define PPUTST_SW_PATCH_VERSION_CFG_C               (0)
/*==================================================================================================
                                            FILE VERSION CHECKS
==================================================================================================*/
/* Check if source file and PPUTST header file are of the same vendor */
#if (PPUTST_VENDOR_ID_CFG_C != PPUTST_VENDOR_ID)
#error "PpuTst_Cfg.c and PpuTst.h have different vendor ids"
#endif

/* Check if source file and PPUTST header file are of the same Autosar version */
#if (( PPUTST_AR_RELEASE_MAJOR_VERSION_CFG_C != PPUTST_AR_RELEASE_MAJOR_VERSION) || \
     ( PPUTST_AR_RELEASE_MINOR_VERSION_CFG_C != PPUTST_AR_RELEASE_MINOR_VERSION) || \
     ( PPUTST_AR_RELEASE_REVISION_VERSION_CFG_C != PPUTST_AR_RELEASE_REVISION_VERSION))
#error "AutoSar Version Numbers of PpuTst_Cfg.c and PpuTst.h are different"
#endif

/* Check if source file and PPUTST header file are of the same Software version */
#if (( PPUTST_SW_MAJOR_VERSION_CFG_C != PPUTST_SW_MAJOR_VERSION) || \
     ( PPUTST_SW_MINOR_VERSION_CFG_C != PPUTST_SW_MINOR_VERSION) || \
     ( PPUTST_SW_PATCH_VERSION_CFG_C != PPUTST_SW_PATCH_VERSION))
#error "Software Version Numbers of PpuTst_Cfg.c and PpuTst.h are different"
#endif

/*==================================================================================================*/
#define PPUTST_START_SEC_CODE
#include "PpuTst_MemMap.h"
PPUTST_FUNC extern void SafLib_TestError_Notification(uint16 ModuleId); /*Error Notification for PpuTst*/
#define PPUTST_STOP_SEC_CODE
#include "PpuTst_MemMap.h"

#define PPUTST_START_SEC_CONFIG_DATA_UNSPECIFIED
#include "PpuTst_MemMap.h"

/** @brief Soft lock configuration for PPU groups*/
PPUTST_CONST static const PpuTst_GroupSLockConfigType GroupConfig[PPUTST_GROUP_COUNT] =
{
    /**< Soft lock configuration for group TMR*/
    {
        .GroupId = PPUTST_GROUP_TMR,
        .Enable = TRUE,
        .GroupPathOffset = 0x0U,
    },
    /**< Soft lock configuration for group SCU*/
    {
        .GroupId = PPUTST_GROUP_SCU,
        .Enable = TRUE,
        .GroupPathOffset = 0x0U,
    },
    /**< Soft lock configuration for group PCU*/
    {
        .GroupId = PPUTST_GROUP_PCU,
        .Enable = TRUE,
        .GroupPathOffset = 0x008U,
    },
    /**< Soft lock configuration for group RCU*/
    {
        .GroupId = PPUTST_GROUP_RCU,
        .Enable = TRUE,
        .GroupPathOffset = 0x004U,
    },
    /**< Soft lock configuration for group EFM*/
    {
        .GroupId = PPUTST_GROUP_EFM,
        .Enable = TRUE,
        .GroupPathOffset = 0x0U,
    },
    /**< Soft lock configuration for group IPC*/
    {
        .GroupId = PPUTST_GROUP_IPC,
        .Enable = TRUE,
        .GroupPathOffset = 0x020U,
    },
};

/** @brief Soft lock function Error Inject configuration*/
PPUTST_CONST static const PpuTst_ErrorInjectType PpuTst_SLockErrorCheckConfig=
{
    .InjectType =
    {
        .PpuTmrProtectionError = TRUE,  /**< Enable/Disable TMR protection path error check*/
        .PpuScuProtectionError = TRUE,  /**< Enable/Disable SCU protection path error check*/
        .PpuPcuProtectionError = TRUE,  /**< Enable/Disable PCU protection path error check*/
        .PpuRcuProtectionError = TRUE,  /**< Enable/Disable RCU protection path error check*/
        .PpuEfmProtectionError = TRUE,  /**< Enable/Disable EFM protection path error check*/
        .PpuIpcProtectionError = TRUE,  /**< Enable/Disable IPC protection path error check*/
    },
};

/** @brief Hard lock function Error Inject configuration*/
PPUTST_CONST static const PpuTst_ErrorInjectType PpuTst_HLockErrorCheckConfig=
{
    .InjectType =
    {
        .PpuTmrProtectionError = TRUE,  /**< Enable/Disable TMR protection path error check*/
        .PpuScuProtectionError = TRUE,  /**< Enable/Disable SCU protection path error check*/
        .PpuPcuProtectionError = TRUE,  /**< Enable/Disable PCU protection path error check*/
        .PpuRcuProtectionError = TRUE,  /**< Enable/Disable RCU protection path error check*/
        .PpuEfmProtectionError = TRUE,  /**< Enable/Disable EFM protection path error check*/
        .PpuIpcProtectionError = TRUE,  /**< Enable/Disable IPC protection path error check*/
    },
};

/** @brief Configuraion for PPU test error injection*/
PPUTST_CONST const PpuTst_ConfigType PpuTst_PreCompileConfig =
{
    .GroupConfigPtr = GroupConfig,
    .SLockErrorInjectConfigPtr = &PpuTst_SLockErrorCheckConfig,
    .HLockErrorInjectConfigPtr = &PpuTst_HLockErrorCheckConfig,
    .PpuTstErrorNotification = SafLib_TestError_Notification,
};

#define PPUTST_STOP_SEC_CONFIG_DATA_UNSPECIFIED
#include "PpuTst_MemMap.h"

#ifdef __cplusplus
}
#endif

/* End of file PpuTst_Cfg.c*/
