/*
 * Copyright 2020-2025 Yuntu Microelectronics Co., Ltd.
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 * 
 * @file undefined
 * @brief 
 * 
 */
#ifndef FLSTST_CFG_H
#define FLSTST_CFG_H

#ifdef __cplusplus
extern "C" {
#endif

/*==================================================================================================
*                                        INCLUDE FILES
==================================================================================================*/
#include "Std_Types.h"
#include "FlsTst_PBcfg.h"

/*==================================================================================================
*                              SOURCE FILE VERSION INFORMATION
==================================================================================================*/
#define FLSTST_VENDOR_ID_CFG                      (180)
#define FLSTST_AR_RELEASE_MAJOR_VERSION_CFG       (4)
#define FLSTST_AR_RELEASE_MINOR_VERSION_CFG       (4)
#define FLSTST_AR_RELEASE_REVISION_VERSION_CFG    (0)
#define FLSTST_SW_MAJOR_VERSION_CFG               (2)
#define FLSTST_SW_MINOR_VERSION_CFG               (0)
#define FLSTST_SW_PATCH_VERSION_CFG               (0)

/*==================================================================================================
*                                      FILE VERSION CHECKS
==================================================================================================*/
/* Check if the file and FlsTst PBcfg header file are of the same vendor */
#if (FLSTST_VENDOR_ID_CFG != FLSTST_VENDOR_ID_PBCFG)
#error "FlsTst_Cfg.h and FlsTst_PBcfg.h have different vendor ids"
#endif

/* Check if the file and FlsTst PBcfg header file are of the same Autosar version */
#if ((FLSTST_AR_RELEASE_MAJOR_VERSION_CFG != FLSTST_AR_RELEASE_MAJOR_VERSION_PBCFG) || \
     (FLSTST_AR_RELEASE_MINOR_VERSION_CFG != FLSTST_AR_RELEASE_MINOR_VERSION_PBCFG) || \
     (FLSTST_AR_RELEASE_REVISION_VERSION_CFG != FLSTST_AR_RELEASE_REVISION_VERSION_PBCFG))
#error "AutoSar Version Numbers of FlsTst_Cfg.h and FlsTst_PBcfg.h are different"
#endif

/* Check if the file and FlsTst PBcfg header file are of the same software version */
#if ((FLSTST_SW_MAJOR_VERSION_CFG != FLSTST_SW_MAJOR_VERSION_PBCFG) || \
     (FLSTST_SW_MINOR_VERSION_CFG != FLSTST_SW_MINOR_VERSION_PBCFG) || \
     (FLSTST_SW_PATCH_VERSION_CFG != FLSTST_SW_PATCH_VERSION_PBCFG))
#error "Software Version Numbers of FlsTst_Cfg.h and FlsTst_PBcfg.h are different"
#endif

/*==================================================================================================
*                                       LOCAL MACROS
==================================================================================================*/
/**
 * @brief Pre-compile support
 */
#define FLSTST_PRECOMPILE_SUPPORT  (STD_OFF)
/**
 * @brief        Adds / removes the service FlsTst_GetCurrentState() from the code.
 * @details       
 * @ref          ECUC_FlsTst_00092
 */
#define FLSTST_GET_CURRENT_STATE_API                 (STD_ON)
/**
 * @brief        Adds / removes the service FlsTst_GetErrorDetails() from the code.
 * @details       
 * @ref          ECUC_FlsTst_00098
 */
#define FLSTST_GET_ERROR_DETAILS_API                 (STD_ON)
/**
 * @brief        Adds / removes the service FlsTst_GetTestResultBgnd() from the code.
 * @details       
 * @ref          ECUC_FlsTst_00094
 */
#define FLSTST_GET_TEST_RESULT_BGND_API               (STD_ON)
/**
 * @brief        Adds / removes the service FlsTst_GetTestResultFgnd() from the code.
 * @details       
 * @ref          ECUC_FlsTst_00150
 */
#define FLSTST_GET_TEST_RESULT_FGND_API               (STD_ON)
/**
 * @brief        Adds / removes the service FlsTst_GetTestSignatureBgnd() from the code.
 * @details       
 * @ref          ECUC_FlsTst_00096
 */
#define FLSTST_GET_TEST_SIGNATURE_BGND_API            (STD_ON)
/**
 * @brief        Adds / removes the service FlsTst_GetTestSignatureFgnd() from the code.
 * @details       
 * @ref          ECUC_FlsTst_00097
 */
#define FLSTST_GET_TEST_SIGNATURE_FGND_API            (STD_ON)
/**
 * @brief        Adds / removes the service FlsTst_StartFgnd() from the code.
 * @details       
 * @ref          ECUC_FlsTst_00086
 */
#define FLSTST_START_FGND_API                       (STD_ON)
/**
 * @brief        Adds / removes the services FlsTst_Suspend() and FlsTst_Resume() from the code.
 * @details       
 * @ref          ECUC_FlsTst_00087
 */
#define FLSTST_SUSPEND_RESUME_API                   (STD_ON)
/**
 * @brief        Adds / removes the service FlsTst_TestEcc() from the code.
 * @details       
 * @ref          ECUC_FlsTst_00099
 */
#define FLSTST_TEST_ECC_API                         (STD_OFF)
/**
 * @brief        Adds / removes the service FlsTst_GetVersionInfo() from the code.
 * @details       
 * @ref          ECUC_FlsTst_00095
 */
#define FLSTST_VERSION_INFO_API                     (STD_ON)

/**
 * @brief        Switches the development error detection and notification on or off.
 * @details      * true: detection and notification is enabled.
              * false: detection and notification is disabled. 
 * @ref          ECUC_FlsTst_00083
 */
#define FLSTST_DEV_ERROR_DETECT                     (STD_ON)
/**
 * @brief        Switch to indicate that the notification is supported.
 * @details       
 * @ref          ECUC_FlsTst_00084
 */
#define FLSTST_TEST_COMPLETED_NOTIFICATION_SUPPORTED (STD_ON)
/**
 * @brief        Configures the result of the test in background mode:
 * @details      True: Test Result is a signature (see SWS_FlsTst_00155, SWS_FlsTst_00054) 
                 False: Test Result is ok/not ok (see SWS_FlsTst_00153, SWS_FlsTst_00042) 
 * @ref          ECUC_FlsTst_00160
 */
#define FLSTST_TEST_RESULT_SIGNATURE                (STD_ON)

/**
* @brief Support for SchM: sync/atomic operations, global interrupt disable/enable.
*        If this parameter has been configured to 'STD_ON', the MCAL driver code supports sync/atomic operations for key resource protection.
*        If it is enabled, all the SchM codes in MCAL FlsTst driver codes will work and support sync/atomic operation with CPU global interrupt enable/disable for key resource protection. 
*        Disable it can reduce code size, but may cause potential risks when access to some critical resource!
*/
#define FLSTST_SCHM_SUPPORT  (STD_ON) 

/**
 * @brief       Switches the test failed notification on or off.
*/
#define FLSTST_TEST_FAILED_NOTIFICATION            (STD_ON)

/**
 * @brief        Configures the Number of cells to be tested in background mode during one scheduled task (FlsTst_MainFunction() call).
 * @details       
 * @ref          ECUC_FlsTst_00161
 */
#define FLSTST_NUMBER_OF_TESTED_CELLS                (1024U)
/**
 * @brief        Configures the Number of cells to be tested in background mode without checking user requests (Abort, Suspend).
 * @details       
 * @ref          ECUC_FlsTst_00120
 */
#define FLSTST_NUMBER_OF_TESTED_CELLS_ATOMIC          (200U)
/**
 * @brief        Defines the end value of the Test Interval Id.
 * @details       
 * @ref          ECUC_FlsTst_00158
 */
#define FLSTST_TEST_INTERVAL_ID_END_VALUE             (5U)


/**
 * @brief        Determines the frequency at which the FlsTstMainFunction is called in [s].
 * @details       
 * @ref          ECUC_FlsTst_00172
 */
#define FLSTST_MAIN_FUNCTION_PERIOD                 (0.005F)

/**
 * @brief       The Dem event ID for background flash test.
 * 
 */
#define FLSTST_E_FLSTST_FAILURE                    DemConf_DemEventParameter_FLSTST_E_FAILURE

/**
 * @brief       The max number of background test blocks .
 * 
 */
#define FLSTST_MAX_NUMBER_OF_BGND_BLOCKS              (5U)

/**
 * @brief   Symbolic names of configured background test blocks.
 */
#define FlsTstConf_FlsTstConfigSet_BgndCRC8Block   (0U)

#define FlsTstConf_FlsTstConfigSet_BgndCRC16Block   (1U)

#define FlsTstConf_FlsTstConfigSet_BgndCRC32Block   (2U)

#define FlsTstConf_FlsTstConfigSet_BgndLessCellBlock   (3U)

#define FlsTstConf_FlsTstConfigSet_BgndEqCellBlock   (4U)

/**
 * @brief   Symbolic names of configured foreground test blocks.
 */
#define FlsTstConf_FlsTstConfigSet_FgndCRC8Block   (0U)

#define FlsTstConf_FlsTstConfigSet_FgndCRC16Block   (1U)

#define FlsTstConf_FlsTstConfigSet_FgndCRC32Block   (2U)


#ifdef __cplusplus
}
#endif

#endif /* FLSTST_CFG_H */

