
/*
 * Copyright 2020-2025 Yuntu Microelectronics Co., Ltd.
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 * 
 * @file EfmTst_Cfg.c
 * @brief 
 * 
 */


#ifdef __cplusplus
extern "C"
{
#endif

/*==================================================================================================
                                              INCLUDE FILES
==================================================================================================*/
#include "EfmTst.h"

/*==================================================================================================
*                              SOURCE FILE VERSION INFORMATION
==================================================================================================*/
#define EFMTST_VENDOR_ID_CFG_C                       (180)
#define EFMTST_AR_RELEASE_MAJOR_VERSION_CFG_C        (4)
#define EFMTST_AR_RELEASE_MINOR_VERSION_CFG_C        (4)
#define EFMTST_AR_RELEASE_REVISION_VERSION_CFG_C     (0)
#define EFMTST_SW_MAJOR_VERSION_CFG_C                (2)
#define EFMTST_SW_MINOR_VERSION_CFG_C                (0)
#define EFMTST_SW_PATCH_VERSION_CFG_C                (0)

/*==================================================================================================
 *                                     FILE VERSION CHECKS
==================================================================================================*/
/* Check if source file and EFMTST header file are of the same vendor */
#if (EFMTST_VENDOR_ID_CFG_C != EFMTST_VENDOR_ID)
#error "EfmTst_Cfg.c and EfmTst.h have different vendor ids"
#endif

/* Check if source file and EFMTST header file are of the same Autosar version */
#if ((EFMTST_AR_RELEASE_MAJOR_VERSION_CFG_C != EFMTST_AR_RELEASE_MAJOR_VERSION) || \
     (EFMTST_AR_RELEASE_MINOR_VERSION_CFG_C != EFMTST_AR_RELEASE_MINOR_VERSION) || \
     (EFMTST_AR_RELEASE_REVISION_VERSION_CFG_C != EFMTST_AR_RELEASE_REVISION_VERSION) \
    )
#error "AutoSar Version Numbers of EfmTst_Cfg.c and EfmTst.h are different"
#endif

/* Check if source file and EFMTST header file are of the same Software version */
#if ((EFMTST_SW_MAJOR_VERSION_CFG_C != EFMTST_SW_MAJOR_VERSION) || \
     (EFMTST_SW_MINOR_VERSION_CFG_C != EFMTST_SW_MINOR_VERSION) || \
     (EFMTST_SW_PATCH_VERSION_CFG_C != EFMTST_SW_PATCH_VERSION) \
    )
#error "Software Version Numbers of EfmTst_Cfg.c and EfmTst.h are different"
#endif

/*==================================================================================================
*                                        GLOBAL VARIABLES
==================================================================================================*/
/**************************EccTst Test Failed Callback declaration********************************************/
extern void SafLib_TestError_Notification(uint16 ModuleId);



#define EFMTST_START_SEC_CONFIG_DATA_UNSPECIFIED
#include "EfmTst_MemMap.h"
/*The protected sector data*/
EFMTST_CONST const EfmTst_SectorType EfmTst_ProtectedSectorCfg = 
{
    .StartAddr = 0x4000U,
    .Length = 0x400U,
    .HwStartAddr = 0x104000U,
};

/*The sector protected configuration data*/
EFMTST_CONST const EfmTst_SectorProtCfgType EfmTst_SectorProtCfg[EFMTST_INTERNAL_BLOCK_NUM] = 
{
    0x0U,
    0x0U,
    0x4U,
};

/*The EfmTst config data*/
EFMTST_CONST const EfmTst_ConfigType EfmTst_PreCompileConfig =
{
    .ProtectSectorPtr = &EfmTst_ProtectedSectorCfg,
    .SectorProtCfgPtr = EfmTst_SectorProtCfg,
    .EfmTstErrorNotification = SafLib_TestError_Notification,
    .NoneProtectSectorAddr = 0x100000U,
};
#define EFMTST_STOP_SEC_CONFIG_DATA_UNSPECIFIED
#include "EfmTst_MemMap.h"

#ifdef __cplusplus
}
#endif

/* End of file EfmTst_Cfg.c*/
