/*
 * Copyright 2020-2025 Yuntu Microelectronics Co., Ltd.
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 * 
 * @file DmaTst_Cfg.c
 * @brief 
 * 
 */

#ifdef __cplusplus
extern "C"
{
#endif
/*==================================================================================================
*                                        INCLUDE FILES
==================================================================================================*/
#include "DmaTst.h"
#if (DMATST_ENABLE_DEM_REPORT_ERROR_STATUS == STD_ON)
#include "Dem.h"
#endif
/*==================================================================================================
*                              SOURCE FILE VERSION INFORMATION
==================================================================================================*/
#define DMATST_VENDOR_ID_CFG_C                      (180)
#define DMATST_AR_RELEASE_MAJOR_VERSION_CFG_C       (4)
#define DMATST_AR_RELEASE_MINOR_VERSION_CFG_C       (4)
#define DMATST_AR_RELEASE_REVISION_VERSION_CFG_C    (0)
#define DMATST_SW_MAJOR_VERSION_CFG_C               (2)
#define DMATST_SW_MINOR_VERSION_CFG_C               (0)
#define DMATST_SW_PATCH_VERSION_CFG_C               (0)

/*==================================================================================================
                                            FILE VERSION CHECKS
==================================================================================================*/
#if (DMATST_VENDOR_ID_CFG_C != DMATST_VENDOR_ID)
#error "DmaTst.c and DmaTst.h have different vendor ids"
#endif

#if (( DMATST_AR_RELEASE_MAJOR_VERSION_CFG_C != DMATST_AR_RELEASE_MAJOR_VERSION) || \
     ( DMATST_AR_RELEASE_MINOR_VERSION_CFG_C != DMATST_AR_RELEASE_MINOR_VERSION) || \
     ( DMATST_AR_RELEASE_REVISION_VERSION_CFG_C != DMATST_AR_RELEASE_REVISION_VERSION))
#error "AutoSar Version Numbers of DmaTst_Cfg.c and DmaTst.h are different"
#endif

#if (( DMATST_SW_MAJOR_VERSION_CFG_C != DMATST_SW_MAJOR_VERSION) || \
     ( DMATST_SW_MINOR_VERSION_CFG_C != DMATST_SW_MINOR_VERSION) || \
     ( DMATST_SW_PATCH_VERSION_CFG_C != DMATST_SW_PATCH_VERSION))
#error "Software Version Numbers of DmaTst_Cfg.c and DmaTst.h are different"
#endif

/*==================================================================================================
                                                FUNCTION PROTOTYPES
==================================================================================================*/
extern void SafLib_TestError_Notification(uint16 ModuleId); /**< Failed callback Notifaction */

/*==================================================================================================
 *                                          VARIATES
==================================================================================================*/
#define DMATST_START_SEC_CONFIG_DATA_UNSPECIFIED
#include "DmaTst_MemMap.h"

DMATST_CONST const DmaTst_ErrorInjectType DmaTst_ChannelErrorCheckConfig[DMATST_CHANNEL_ERROR_TST_COUNT] =
{
    {
        /**<Channel_0 Error Inject configuration*/
        .InjectType =
        {
            .TransferCancelError =  TRUE ,  /**<  Enable/Disable Transfer cancel error check */
            .SourceAddressError =  TRUE ,   /**<  Enable/Disable Source address error check */
            .SourceOffsetError =  TRUE ,    /**<  Enable/Disable Source offset error check */
            .DestinationAddressError =  TRUE , /**<  Enable/Disable Destination address error check */
            .DestinationOffsetError =  TRUE , /**<  Enable/Disable Destination offset error check */
            .TransferCountError =  TRUE ,   /**<  Enable/Disable Transfer count error check */
            .RamReloadError =  TRUE ,       /**<  Enable/Disable Ram reload error check */
            .SourceBusError =  TRUE ,       /**<  Enable/Disable Source bus error check */
            .DestinationBusError =  TRUE ,  /**<  Enable/Disable Destination bus error check */
        }

    },
};


DMATST_CONST const DmaTst_RuntimeConfigType DmaTst_RuntimeConfig[1] = 
{
    {
        .NormalTransferCheck =  TRUE , /**<  Enable/Disable NormalTransfer check */
        .ChannelLinkCheck =  TRUE , /**<  Enable/Disable ChannelLink check */
        .RamReloadCheck =  TRUE , /**<  Enable/Disable RamReload check */
        .TestChannel = DMA_CHANNEL_14,
#if ( TRUE )
        .LinkNextChannel = DMA_CHANNEL_15
#endif
    },
    

};

DMATST_CONST const DmaTst_ConfigType DmaTst_InstanceConfig =
{
    .ChannelCount = DMATST_CHANNEL_ERROR_TST_COUNT,  /**< Channel error test count */
    .ErrorTypeConfigPtr = (DmaTst_ErrorInjectType *)DmaTst_ChannelErrorCheckConfig,  /**< Error type configuration pointer */
    .FailedNotification = SafLib_TestError_Notification,  /**< Failed callback function */
    .RuntimeConfigPtr =(DmaTst_RuntimeConfigType*) DmaTst_RuntimeConfig,
#if (DMATST_ENABLE_DEM_REPORT_ERROR_STATUS == STD_ON)
    .DmaTstErrorHardwareCfg.Id =  0 , /* DMATST_E_HARDWARE_ERROR parameters ID of DEM error */
    .DmaTstErrorHardwareCfg.State = STD_OFF,  /* DMATST_E_HARDWARE_ERROR parameters enabling the DEM error */
#endif
};

#define DMATST_STOP_SEC_CONFIG_DATA_UNSPECIFIED
#include "DmaTst_MemMap.h"
#ifdef __cplusplus
}
#endif
/* End of file DmaTst.c */
