/*
 * Copyright 2020-2025 Yuntu Microelectronics Co., Ltd.
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 * 
 * @file undefined
 * @brief 
 * 
 */


#ifndef CRC_CFG_H
#define CRC_CFG_H


#ifdef __cplusplus
extern "C"{
#endif

/*==================================================================================================
*                                        INCLUDE FILES
==================================================================================================*/
#include "Std_Types.h"
/*==================================================================================================
*                              SOURCE FILE VERSION INFORMATION
==================================================================================================*/
#define CRC_VENDOR_ID_CFG                      (180)
#define CRC_AR_RELEASE_MAJOR_VERSION_CFG       (4)
#define CRC_AR_RELEASE_MINOR_VERSION_CFG       (4)
#define CRC_AR_RELEASE_REVISION_VERSION_CFG    (0)
#define CRC_SW_MAJOR_VERSION_CFG               (2)
#define CRC_SW_MINOR_VERSION_CFG               (3)
#define CRC_SW_PATCH_VERSION_CFG               (0)



/*==================================================================================================
*                                       LOCAL MACROS
==================================================================================================*/
#define CRC_DEV_ERROR_DETECT                        (STD_ON)
/**
 * @brief        Switches the Crc_GetVersionInfo function ON or OFF.
 * @details       
 *
 * @ref          
 */
#define CRC_VERSION_INFO_API                        (STD_OFF)

#define CRC8_HW_DATA_BLOCK_SIZE   1024
#define CRC16_HW_DATA_BLOCK_SIZE   2048
#define CRC32_HW_DATA_BLOCK_SIZE   4096

/**
 * @brief Switch to select one of the available CRC 8-bit (SAE J1850) calculation methods.
 * @trace ECUC_Crc_00030
 * @option CRC_8_HARDWARE, CRC_8_RUNTIME, CRC_8_TABLE
 */
#define CRC_8_HARDWARE (0x01) 
#define CRC_8_RUNTIME  (0x02)
#define CRC_8_TABLE    (0x04) 
#define CRC_8_NONE     (0xFF) 
#define CRC_8_MODE (CRC_8_TABLE)
/**
 * @brief Switch to select one of the available CRC 8-bit (2Fh polynomial) calculation methods.
 * @trace ECUC_Crc_00031
 * @option CRC_8H2F_HARDWARE, CRC_8H2F_RUNTIME, CRC_8H2F_TABLE
 */
#define CRC_8H2F_HARDWARE (0x01) 
#define CRC_8H2F_RUNTIME  (0x02)
#define CRC_8H2F_TABLE    (0x04) 
#define CRC_8H2F_NONE     (0xFF) 
#define CRC_8H2F_MODE (CRC_8H2F_NONE)
/**
 * @brief Switch to select one of the available CRC 16-bit (CCITT) calculation methods.
 * @trace ECUC_Crc_00025
 * @option CRC_16_HARDWARE, CRC_16_RUNTIME, CRC_16_TABLE
 */
#define CRC_16_HARDWARE (0x01)
#define CRC_16_RUNTIME  (0x02)
#define CRC_16_TABLE    (0x04) /* Default value */
#define CRC_16_NONE     (0xFF) 
#define CRC_16_MODE (CRC_16_HARDWARE)
/**
 * @brief Switch to select one of the available CRC-16/ARC (polynomial 8005) calculation methods.
 * @trace ECUC_Crc_00035
 * @option CRC_16_ARC_HARDWARE, CRC_16_ARC_RUNTIME, CRC_16_ARC_TABLE
 */
#define CRC_16ARC_HARDWARE (0x01) 
#define CRC_16ARC_RUNTIME  (0x02)
#define CRC_16ARC_TABLE    (0x04) 
#define CRC_16ARC_NONE     (0xFF)
#define CRC_16ARC_MODE (CRC_16ARC_NONE)
/**
 * @brief Switch to select one of the available CRC 32-bit (IEEE-802.3 CRC32 Ethernet Standard) calculation methods.
 * @trace ECUC_Crc_00026
 * @option CRC_32_HARDWARE, CRC_32_RUNTIME, CRC_32_TABLE
 */
#define CRC_32_HARDWARE (0x01)
#define CRC_32_RUNTIME  (0x02)
#define CRC_32_TABLE    (0x04) /* Default value */
#define CRC_32_NONE     (0xFF)
#define CRC_32_MODE (CRC_32_HARDWARE)
/**
 * @brief Switch to select one of the available CRC 32-bit E2E Profile 4 calculation methods.
 * @trace ECUC_Crc_00032
 * @option CRC_32P4_HARDWARE, CRC_32P4_RUNTIME, CRC_32P4_TABLE
 */
#define CRC_32P4_HARDWARE (0x01) /* Not supported */
#define CRC_32P4_RUNTIME  (0x02)
#define CRC_32P4_TABLE    (0x04) /* Default value */
#define CRC_32P4_NONE     (0xFF)
#define CRC_32P4_MODE (CRC_32P4_NONE)
/**
 * @brief Switch to select one of the available CRC 64-bit calculation methods.
 * @trace ECUC_Crc_00034
 * @option CRC_64_HARDWARE, CRC_64_RUNTIME, CRC_64_TABLE
 */
#define CRC_64_HARDWARE (0x01) /* Not supported */
#define CRC_64_RUNTIME  (0x02)
#define CRC_64_TABLE    (0x04) /* Default value */
#define CRC_64_NONE     (0xFF)
#define CRC_64_MODE (CRC_64_NONE)

#define CRC_SCHM_SUPPORT                         (STD_ON) 


#ifdef CRC_ENABLE_USER_MODE_SUPPORT
#ifndef MCAL_ENABLE_USER_MODE_SUPPORT
#error "Must define MCAL_ENABLE_USER_MODE_SUPPORT if CRC_ENABLE_USER_MODE_SUPPORT is defined"
#endif
#endif







#ifdef __cplusplus
}
#endif

#endif /* Crc_CFG_H */

/** @} */

