/*
 * Copyright 2020-2025 Yuntu Microelectronics Co., Ltd.
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 * 
 * @file CrcTst_Cfg.h
 * @brief 
 * 
 */


#ifndef CRCTST_CFG_H
#define CRCTST_CFG_H

#ifdef __cplusplus
extern "C"{
#endif

/*==================================================================================================
*                                        INCLUDE FILES
==================================================================================================*/

/*==================================================================================================
*                              SOURCE FILE VERSION INFORMATION
==================================================================================================*/
#define CRCTST_VENDOR_ID_CFG                      (180)
#define CRCTST_AR_RELEASE_MAJOR_VERSION_CFG       (4)
#define CRCTST_AR_RELEASE_MINOR_VERSION_CFG       (4)
#define CRCTST_AR_RELEASE_REVISION_VERSION_CFG    (0)
#define CRCTST_SW_MAJOR_VERSION_CFG               (2)
#define CRCTST_SW_MINOR_VERSION_CFG               (0)
#define CRCTST_SW_PATCH_VERSION_CFG               (0)

/*==================================================================================================
*                              external function declarations
==================================================================================================*/
extern void TestCRC_Complete(void);/**< Pointer to the Crc Test completion callback function */

extern void SafLib_TestError_Notification(uint16 ModuleId);/**< Pointer to the Crc Test completion callback function */
/*==================================================================================================
*                                       DEFINITIONS AND MACROS
==================================================================================================*/

#define CRCTST_CRC_FUNCTION_TEST_ENABLE            (STD_ON)

#define CRCTST_CRC8_TEST_ENABLE             (STD_OFF)

#define CRCTST_CRC16_TEST_ENABLE            (STD_ON)

#define CRCTST_CRC32_TEST_ENABLE            (STD_ON)


#define CRCTST_REGISTER_INTEGRITY_TEST_ENABLE      (STD_ON)

#define CRCTST_REGISTER_INTEGRITY_TEST_NUM  (2U)

/**
* @brief   Define precompile support.
* @details Define precompile support if VARIANT-PRE-COMPILE or VARIANT-LINK-TIME is selected and number of variant <=1.
*/
#define CRCTST_PRECOMPILE_SUPPORT                  (STD_ON)
/**
* @brief   Define register signature in flash support.
* @details If support,the register signature will be store in flash or in ram.
*/
#define CRCTST_SIGNATURE_IN_FLASH_SUPPORT                  (STD_OFF)

/**
 * @brief        Support for foreground test error notification. 
 */
#define CRCTST_FGND_ERROR_NOTIFICATION                (STD_ON)

/**
 * @brief        Support for background test complete callback.
 */
#define CRCTST_BKND_COMPLETE_CALLBACK_ENABLE         (STD_ON) 

/**
 * @brief        Switches the Production Error Detection and Notification ON. 
 */
/**
 * @brief   Switch to enable the extended production error report.
 */
#define CRCTST_DEM_EVENT_REPORT                    (STD_OFF)

#define CRCTST_DEV_ERROR_DETECT                    (STD_ON)

#define CRCTST_VERSION_INFO_API                    (STD_OFF)

/**
* @brief Support for SchM: sync/atomic operations, global interrupt disable/enable.
*        If this parameter has been configured to 'STD_ON', the MCAL driver code supports sync/atomic operations for key resource protection.
*        If it is enabled, all the SchM codes in MCAL CrcTst driver codes will work and support sync/atomic operation with CPU global interrupt enable/disable for key resource protection. 
*        Disable it can reduce code size, but may cause potential risks when access to some critical resource!
*/
#define CRCTST_SCHM_SUPPORT                        (STD_ON) 


#ifdef CRCTST_ENABLE_USER_MODE_SUPPORT
#ifndef MCAL_ENABLE_USER_MODE_SUPPORT
#error "Must define MCAL_ENABLE_USER_MODE_SUPPORT if CRCTST_ENABLE_USER_MODE_SUPPORT is defined"
#endif
#endif



#ifdef __cplusplus
}
#endif

#endif /* CRCTST_CFG_H */
